/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.MixedGraph;
import org.gephi.graph.api.Node;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.NodeLayoutData;

public class GraphSource {
    private final MixedGraph graph;

    public GraphSource(MixedGraph graph) {
        this.graph = graph;
    }

    public Node findTopParent(Node node) {
        Node topParent = node;
        Set<Node> parents = this.getParents(node);
        if (parents.size() == 1) {
            topParent = this.findTopParent(parents.iterator().next());
        }
        return topParent;
    }

    public Set<Node> getNeighbours(Node node) {
        HashSet<Node> neighbours = new HashSet<Node>();
        Set<Node> children = this.getChildren(node);
        for (Node child : children) {
            Node otherParent = this.getOtherParent(child, node);
            if (otherParent == null) continue;
            neighbours.add(otherParent);
        }
        return neighbours;
    }

    public Set<Node> getChildren(Node node) {
        EdgeIterable edgesIterable = this.graph.getEdges(node);
        HashSet<Node> list = new HashSet<Node>();
        for (Edge edge : edgesIterable) {
            if (!edge.isDirected() || !edge.getSource().equals(node)) continue;
            list.add(edge.getTarget());
        }
        return list;
    }

    public Set<Node> getRedChildren(Node node) {
        EdgeIterable edgesIterable = this.graph.getEdges(node);
        HashSet<Node> list = new HashSet<Node>();
        for (Edge edge : edgesIterable) {
            if (!edge.isDirected() || !edge.getSource().equals(node) || !NodeLayoutData.isColored(node, NodeLayoutData.Color.RED)) continue;
            list.add(edge.getTarget());
        }
        return list;
    }

    public Node getOtherParent(Node node, Node parent) {
        Iterator<Node> iterator;
        Set<Node> parents = this.getParents(node);
        if (parents.size() > 1) {
            parents.remove(parent);
        }
        return (iterator = parents.iterator()).hasNext() ? iterator.next() : null;
    }

    public Set<Node> getParents(Node node) {
        EdgeIterable edgesIterable = this.graph.getEdges(node);
        HashSet<Node> list = new HashSet<Node>();
        for (Edge edge : edgesIterable) {
            if (!edge.isDirected() || !edge.getTarget().equals(node)) continue;
            list.add(edge.getSource());
        }
        return list;
    }

    public Collection<Edge> getNeighbourEdges(Node node) {
        LinkedList<Edge> list = new LinkedList<Edge>();
        EdgeIterable edgesIterable = this.graph.getEdges(node);
        for (Edge edge : edgesIterable) {
            if (!edge.isDirected()) continue;
            list.add(edge);
        }
        return list;
    }
}

