/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences.workers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphComparatorByArcCount;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individualizable;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationEnvironment;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.sequences.EgoSequence;
import org.tip.puck.sequences.Sequenceable;
import org.tip.puck.sequences.workers.SequenceCriteria;
import org.tip.puck.sequences.workers.SequenceMaker;
import org.tip.puck.sequences.workers.SequenceWorker;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class SequenceNetworkMaker {
    public static <S extends Sequenceable<E>, E> HashMap<String, GraphProfile<?>> createNetworkProfiles(S sequence, SequenceCriteria criteria) throws PuckException {
        HashMap result = new HashMap();
        RelationEnvironment egoEnvironment = null;
        if (sequence instanceof Individualizable) {
            egoEnvironment = new RelationEnvironment(sequence.getStations().values(), ((Individualizable)((Object)sequence)).getEgo(), criteria.getEgoRoleName(), (List<String>)criteria.getRoleNames(), criteria.getRelationModelNames());
            egoEnvironment.setAlterRelations(sequence.getStations().values(), ((EgoSequence)sequence).getEgo(), criteria.getEgoRoleName(), "ALL", criteria.getRelationModelNames(), criteria.getPattern(), criteria.getChainClassification());
        }
        for (String networkTitle : criteria.getNetworkTitles()) {
            SequenceCriteria.ValueSequenceLabel type = null;
            String subLabel = ToolBox.splitLastPart(networkTitle, "#")[1];
            if (subLabel != null) {
                type = SequenceCriteria.ValueSequenceLabel.valueOf(subLabel);
            }
            if (type != null && type.equals((Object)SequenceCriteria.ValueSequenceLabel.TREES)) {
                for (E station : sequence.getStations().values()) {
                    ((Relation)station).updateReferents(criteria.getDefaultReferentRoleName());
                }
            }
            Graph<?> network = SequenceNetworkMaker.createNetwork(networkTitle, sequence, egoEnvironment, criteria.getRelationModelName(), type, criteria.getValueSequenceLabels(), criteria.getPattern(), criteria.getChainClassification(), criteria.getAlterFilterAttributeLabel(), criteria.getAlterFilterAttributeValue());
            SequenceNetworkMaker.createNetworkProfile(result, network, networkTitle, egoEnvironment, criteria.getPartitionLabels().get(networkTitle));
        }
        return result;
    }

    private static <S extends Sequenceable<Relation>> Graph<?> createNetwork(String title, S sequence, RelationEnvironment egoEnvironment, String relationModelName, SequenceCriteria.ValueSequenceLabel type, List<SequenceCriteria.ValueSequenceLabel> types, String pattern, String chainClassification, String alterAttributeLabel, String alterAttributeValue) throws PuckException {
        Graph<Object> result = title.equals("Ego Network") ? SequenceNetworkMaker.getEgoNetwork(relationModelName, egoEnvironment, pattern, chainClassification) : (title.equals("Nonmediated Ego Network") ? SequenceNetworkMaker.getNonMediatedEgoNetwork(relationModelName, egoEnvironment, pattern, chainClassification) : (title.equals("Parcours Network#" + (Object)((Object)type)) ? SequenceNetworkMaker.getParcoursNetwork(sequence, egoEnvironment, type) : (title.equals("Parcours") ? SequenceNetworkMaker.getParcoursGraph(sequence, egoEnvironment.getEgo()) : (title.equals("Extended Parcours") ? SequenceNetworkMaker.getExtendedParcoursGraph(sequence, egoEnvironment, types) : (title.equals("Multiple Parcours") ? SequenceNetworkMaker.getMultipleParcoursGraph(sequence, relationModelName, egoEnvironment) : (title.equals("Parcours Intersection Network") ? SequenceNetworkMaker.getParcoursIntersectionNetwork(relationModelName, egoEnvironment, alterAttributeLabel, alterAttributeValue) : (title.equals("Parcours Similarity Network") ? SequenceNetworkMaker.getParcoursSimilarityNetwork(type, egoEnvironment, relationModelName, pattern, alterAttributeLabel, alterAttributeValue) : null)))))));
        return result;
    }

    private static <S extends Sequenceable<Relation>> void createNetworkProfile(HashMap<String, GraphProfile<?>> networkProfiles, Graph<?> network, String title, RelationEnvironment egoEnvironment, List<String> partitionLabels) throws PuckException {
        GraphProfile<Individual> networkProfile = null;
        if (title.contains("Ego Network")) {
            networkProfile = new GraphProfile<Individual>(network, egoEnvironment.getEgo(), partitionLabels);
            if (title.equals("Ego Network")) {
                networkProfile.setSpecificDensities();
            }
        } else if (network != null) {
            networkProfile = new GraphProfile(network, partitionLabels);
        }
        if (partitionLabels.contains("COMPONENT")) {
            Partition<Node<Individual>> nonEgoComponents = networkProfile.getNonEgoComponents();
            SequenceNetworkMaker.setComponentTypes(title, egoEnvironment, nonEgoComponents);
        }
        if (networkProfile != null) {
            networkProfiles.put(title, networkProfile);
        }
    }

    private static String getComponentType(Cluster<Node<Individual>> component, RelationEnvironment egoEnvironment) {
        String result = null;
        ArrayList<String> relations = new ArrayList<String>();
        for (Node<Individual> node : component.getItems()) {
            Individual referent = node.getReferent();
            relations.addAll((Collection<String>)egoEnvironment.getRelationsByAlter().get(referent));
        }
        if (PuckUtils.containsStrings(relations, "FATHER;PATERNAL_HOME") && PuckUtils.containsStrings(relations, "MOTHER")) {
            result = "PARENT";
        } else if (PuckUtils.containsStrings(relations, "FATHER;PATERNAL_HOME")) {
            result = "FATHER";
        } else if (PuckUtils.containsStrings(relations, "MOTHER;MATERNAL_HOME")) {
            result = "MOTHER";
        } else if (PuckUtils.containsStrings(relations, "SPOUSE;MARITAL_HOME")) {
            result = "SPOUSE";
        } else if (PuckUtils.containsStrings(relations, "RELATIVE;RELATIVE_AGNATIC;RELATIVE_UTERINE;RELATIVE_COGNATIC")) {
            result = "RELATIVE";
        } else if (PuckUtils.containsStrings(relations, "AFFINE")) {
            result = "AFFINE";
        } else if (PuckUtils.containsStrings(relations, "EMPLOYER")) {
            result = "EMPLOYER";
        }
        if (result == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String relationModelName : egoEnvironment.getRelationModelNames()) {
                Relations egoRelations = egoEnvironment.getEgo().relations().getByModelName(relationModelName);
                if (egoRelations.size() <= 0) continue;
                RelationModel model = ((Relation)egoRelations.getFirst()).getModel();
                for (Role role : model.roles()) {
                    if (!relations.contains(role.getName()) || list.contains(role.getName())) continue;
                    list.add(role.getName());
                }
            }
            Collections.sort(list);
            if (list.size() > 0) {
                result = "";
                for (String item : list) {
                    if (result.length() > 0) {
                        result = String.valueOf(result) + "-";
                    }
                    result = String.valueOf(result) + item;
                }
            }
        }
        if (result == null) {
            result = relations.size() > 0 ? "OTHER" : "UNKNOWN";
        }
        return result;
    }

    private static <E> void makeAlterRelationPartition(Graph<E> network, Individual ego, Map<Individual, List<String>> relationsByAlter) {
        for (Node<E> node : network.getNodes()) {
            E referent = node.getReferent();
            Individual alter = null;
            if (referent instanceof Individual) {
                alter = (Individual)referent;
            } else if (referent instanceof Set && ((Set)referent).size() == 1) {
                Iterator iterator = ((Set)referent).iterator();
                while (iterator.hasNext()) {
                    Individual element;
                    alter = element = (Individual)iterator.next();
                }
            }
            if (alter == null) continue;
            List<String> relations = relationsByAlter.get(alter);
            if (alter == ego) {
                node.setAttribute("EGO-RELATION", "EGO");
                continue;
            }
            if (relations == null) continue;
            node.setAttribute("EGO-RELATION", relations.toString());
        }
    }

    private static <S extends Sequenceable<Relation>> Graph<Numberable> getExtendedParcoursGraph(S sequence, RelationEnvironment egoEnvironment, List<SequenceCriteria.ValueSequenceLabel> types) {
        Individual ego = egoEnvironment.getEgo();
        Graph<Numberable> result = new Graph<Numberable>();
        result.setLabel("Extended Parcours " + ego);
        Relation lastEvent = null;
        for (Relation event : sequence.getStations().values()) {
            if (lastEvent != null) {
                Link<Relation> eventLink = result.addArc(lastEvent, event, 2.0);
                eventLink.setTag(String.valueOf(ego.getId()));
                for (String label : egoEnvironment.getRoleNames()) {
                    for (Individual alter : event.getIndividuals(label)) {
                        if (label == egoEnvironment.getEgoRoleName() && alter == ego) continue;
                        Link<Numberable> alterLink = result.addArc(event, alter, 1.0);
                        alterLink.setTag(label);
                    }
                }
            }
            lastEvent = event;
        }
        if (sequence.getStations().size() == 1) {
            result.addNode(lastEvent);
        }
        for (String label : egoEnvironment.getRoleNames()) {
            Set<Individual> cluster = egoEnvironment.getAltersByRole(label);
            if (cluster == null) continue;
            for (Individual alter : cluster) {
                for (Relation event : alter.relations().getByModel(lastEvent.getModel())) {
                    if (sequence.getStations().containsValue(event) || RelationValuator.isBirth(event) || RelationValuator.isDeath(event) || RelationValuator.getYear(event) == null || RelationValuator.getYear(lastEvent) == null || RelationValuator.getYear(event) > RelationValuator.getYear(lastEvent)) continue;
                    for (Individual tertius : event.getIndividuals()) {
                        if (tertius.getId() <= alter.getId() || result.getNode(tertius) == null) continue;
                        Link<Numberable> link1 = result.addArc(event, tertius, 1.0);
                        link1.setTag(event.getRoleNamesAsString(tertius));
                        Link<Numberable> link2 = result.addArc(event, alter, 1.0);
                        link2.setTag(event.getRoleNamesAsString(alter));
                    }
                }
            }
        }
        types.add(SequenceCriteria.ValueSequenceLabel.DATE);
        types.add(SequenceCriteria.ValueSequenceLabel.AGE);
        int order = 1;
        for (Node obj : result.getNodes()) {
            Node node = obj;
            if (node.getReferent() instanceof Individual) {
                node.setAttribute("TYPE", "INDIVIDUAL");
                for (SequenceCriteria.ValueSequenceLabel type : types) {
                    List<String> list = null;
                    list = type == SequenceCriteria.ValueSequenceLabel.HOST || type == SequenceCriteria.ValueSequenceLabel.MIG || type == SequenceCriteria.ValueSequenceLabel.HOSTMIG ? egoEnvironment.getRelationsByAlter((Individual)node.getReferent()) : egoEnvironment.getRolessByAlter((Individual)node.getReferent());
                    if (list == null) continue;
                    node.setAttribute(type.toString(), list.toString());
                }
                node.setAttribute("ORDER", "0");
                continue;
            }
            if (!(node.getReferent() instanceof Relation)) continue;
            node.setAttribute("TYPE", "EVENT");
            for (SequenceCriteria.ValueSequenceLabel type : types) {
                Value value = RelationValuator.get((Relation)node.getReferent(), type.toString());
                if (value == null) continue;
                node.setAttribute(type.toString(), value.toString());
            }
            node.setAttribute("ORDER", String.valueOf(order));
            ++order;
        }
        return result;
    }

    private static void setComponentTypes(String networkTitle, RelationEnvironment egoEnvironment, Partition<Node<Individual>> nonEgoComponents) {
        if (nonEgoComponents.size() > 0) {
            for (Cluster<Node<Individual>> component : nonEgoComponents.getClusters().toList()) {
                String type = SequenceNetworkMaker.getComponentType(component, egoEnvironment);
                Value value = new Value(type);
                if (nonEgoComponents.getValues().contains(value)) {
                    int i = 1;
                    while (nonEgoComponents.getValues().contains(value)) {
                        value = new Value(String.valueOf(type) + " " + ++i);
                    }
                }
                nonEgoComponents.changeClusterValue(component, value);
            }
        }
    }

    private static Graph<Individual> getEgoNetwork(String relationModelName, RelationEnvironment egoEnvironment, String pattern, String chainClassification) {
        Graph<Individual> result = new Graph<Individual>("Ego network " + egoEnvironment.getEgo() + " " + relationModelName + " " + egoEnvironment.getEgoRoleName() + "-" + SequenceNetworkMaker.getSelectedRolesAsString(egoEnvironment.getRoleNames()));
        HashMap<String, Integer> tagMap = new HashMap<String, Integer>();
        result.addNode(egoEnvironment.getEgo());
        for (Individual alter : egoEnvironment.getAltersByRole("SELECTED")) {
            result.addNode(alter);
        }
        List referents = result.getReferents();
        int i = 0;
        while (i < referents.size()) {
            Individual ego = (Individual)referents.get(i);
            int j = 0;
            while (j < i) {
                Individual alter = (Individual)referents.get(j);
                for (String tag : NetUtils.getAlterRoles(ego, alter, ToolBox.stringsToInts(pattern), egoEnvironment.getRelationModelNames(), chainClassification)) {
                    Link<Individual> link = result.addArc(ego, alter, 1.0);
                    Integer tagNumber = (Integer)tagMap.get(tag);
                    if (tagNumber == null) {
                        tagNumber = tagMap.size() + 1;
                        tagMap.put(tag, tagNumber);
                    }
                    link.setTag(":" + tagNumber + " '" + tag + "'");
                }
                ++j;
            }
            ++i;
        }
        NetUtils.setGenderShapes(result);
        SequenceNetworkMaker.makeAlterRelationPartition(result, egoEnvironment.getEgo(), egoEnvironment.getRelationsByAlter());
        GraphUtils.addNodeLabelsFromPartition(result, "EGO-RELATION");
        return result;
    }

    private static <S extends Sequenceable<Relation>> Graph<Relation> getParcoursGraph(S sequence, Individual ego) {
        Graph<Relation> result = new Graph<Relation>();
        result.setLabel("Parcours " + ego);
        Relation previousEvent = null;
        for (Relation event : sequence.getStations().values()) {
            if (previousEvent != null) {
                Link<Relation> link = result.addArc(previousEvent, event, 1.0);
                link.setTag(String.valueOf(ego.getId()));
            }
            previousEvent = event;
        }
        if (sequence.getStations().size() == 1) {
            result.addNode(previousEvent);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static <S extends Sequenceable<Relation>> Graph<Cluster<Relation>> getParcoursNetwork(S sequence, RelationEnvironment egoEnvironment, SequenceCriteria.ValueSequenceLabel relationClassificationType) throws PuckException {
        Individual ego = egoEnvironment.getEgo();
        Graph<Cluster<Relation>> result = new Graph<Cluster<Relation>>();
        result.setLabel("Parcours Network_" + (Object)((Object)relationClassificationType) + " " + ego);
        Partition<Relation> partition = new Partition<Relation>();
        HashMap<String, Individuals> hostsMap = new HashMap<String, Individuals>();
        hostsMap.put("SPOUSE", new Individuals());
        for (Relation event : sequence.getStations().values()) {
            void var9_10;
            Individuals viaHosts;
            void var9_13;
            Individuals hosts;
            String string = "";
            Value value = RelationValuator.get(event, ego, relationClassificationType.toString(), egoEnvironment);
            if (value != null) {
                String string2 = value.toString();
            }
            if ((hosts = (Individuals)hostsMap.get(var9_13)) != null) {
                for (Individual host : event.getIndividuals("HOST")) {
                    if (var9_13.equals("SPOUSE") && !host.spouses().contains(ego)) {
                        System.err.println("Non-spouse as spouse for " + ego + ": " + host + " " + event);
                        continue;
                    }
                    hosts.put(host);
                }
                if (hosts.size() > 1) {
                    String string3 = String.valueOf(var9_13) + "_" + hosts.size();
                }
            } else if (var9_13.contains("via ") && (viaHosts = (Individuals)hostsMap.get(var9_13.replace("via ", ""))) != null && viaHosts.size() > 1) {
                String string4 = String.valueOf(var9_13) + viaHosts.size();
            }
            partition.put(event, new Value((String)var9_10));
        }
        Relation previousEvent = null;
        int t = 1;
        for (Relation relation : sequence.getStations().values()) {
            if (previousEvent != null) {
                if (egoEnvironment.impersonalRelation(previousEvent) != null && egoEnvironment.impersonalRelation(previousEvent).equals("TRANSITION")) {
                    if (partition.getCluster(previousEvent).getValue().toString().equals("TRANSITION")) {
                        partition.getCluster(relation).put(previousEvent);
                        result.addNode(partition.getCluster(relation));
                        result.transferLinks(result.getNode(partition.getCluster(previousEvent)), result.getNode(partition.getCluster(relation)));
                    } else {
                        System.err.println("Ambiguous transition " + ego + " " + t + " " + previousEvent + " " + previousEvent.getIndividuals("HOST") + " *" + partition.getCluster(previousEvent).getValue() + "*");
                    }
                } else {
                    Link<Cluster<Relation>> link = result.getArc(partition.getCluster(previousEvent), partition.getCluster(relation));
                    if (link == null) {
                        link = result.addArc(partition.getCluster(previousEvent), partition.getCluster(relation), (double)t);
                        link.setTag(String.valueOf(ego.getId()) + " " + t);
                    } else {
                        String tag = link.getTag();
                        double weight = link.getWeight();
                        link.setTag(String.valueOf(tag) + " " + t);
                        link.setWeight(weight * 0.1 + (double)t);
                    }
                }
            }
            previousEvent = relation;
            ++t;
        }
        if (sequence.getStations().size() == 1) {
            result.addNode(partition.getCluster(previousEvent));
        }
        for (Node node : result.getNodes().toList()) {
            if (!((Cluster)node.getReferent()).getValue().toString().equals("TRANSITION")) continue;
            result.removeNode(node);
            break;
        }
        result.renumberNodes();
        if (result.getNodesByLabel("PARENTS").size() == 0) {
            System.err.println("No parents: " + result);
        }
        return result;
    }

    private static <S extends Sequenceable<Relation>> Graph<Relation> getMultipleParcoursGraph(S sequence, String relationModelName, RelationEnvironment egoEnvironment) throws PuckException {
        ArrayList<Graph<Graph<Relation>>> graphs = new ArrayList<Graph<Graph<Relation>>>();
        SequenceCriteria criteria = new SequenceCriteria();
        criteria.setMaxAge(1000);
        criteria.setRelationModelNames(egoEnvironment.getRelationModelNames());
        criteria.setRelationModelName(relationModelName);
        for (Individual alter : egoEnvironment.getAltersByRole("SELECTED")) {
            EgoSequence fullBiography = SequenceMaker.createPersonalEventSequence(alter, criteria);
            EgoSequence sortedBiography = (EgoSequence)SequenceWorker.split(fullBiography).getById(1);
            if (sortedBiography.getNrStations() <= 0) continue;
            Graph<Relation> alterGraph = SequenceNetworkMaker.getParcoursGraph(sequence, egoEnvironment.getEgo());
            graphs.add(alterGraph);
        }
        Graph<Relation> result = GraphUtils.fuse(graphs);
        result.setLabel("Multiple parcours " + egoEnvironment.getEgo());
        return result;
    }

    public static Graph<String> getFlatParcoursNetworkNoLoops(Graph<Cluster<Relation>> parcoursNetwork) {
        Graph<String> result = new Graph<String>(parcoursNetwork.getLabel());
        for (Link link : parcoursNetwork.getLinks()) {
            if (link.isLoop()) continue;
            result.addArc(((Cluster)link.getSourceNode().getReferent()).getLabel(), ((Cluster)link.getTargetNode().getReferent()).getLabel());
        }
        return result;
    }

    private static Relations getEvents(Individual indi, String relationModelName) {
        Relations result = new Relations();
        for (Relation event : indi.relations().getByModelName(relationModelName)) {
            if (RelationValuator.isBirth(event)) continue;
            result.add(event);
        }
        return result;
    }

    private static <S extends Sequenceable<Relation>> Graph<Individual> getParcoursSimilarityNetwork(SequenceCriteria.ValueSequenceLabel relationClassificationType, RelationEnvironment egoEnvironment, String relationModelName, String pattern, String alterAttributeLabel, String alterAttributeValue) throws PuckException {
        Individual ego = egoEnvironment.getEgo();
        Graph<Individual> result = new Graph<Individual>("Parcours Similarity Network_" + (Object)((Object)relationClassificationType) + " " + ego + " " + relationModelName + " " + egoEnvironment.getEgoRoleName() + "-" + SequenceNetworkMaker.getSelectedRolesAsString(egoEnvironment.getRoleNames()));
        result.addNode(ego);
        for (Individual alter : egoEnvironment.getAltersByRole("SELECTED")) {
            if (!alter.hasAttributeValue(alterAttributeLabel, alterAttributeValue)) continue;
            result.addNode(alter);
        }
        ArrayList<Graph<Graph<String>>> flatParcoursNetworksNoLoops = new ArrayList<Graph<Graph<String>>>();
        HashMap<Graph<String>, Individual> index = new HashMap<Graph<String>, Individual>();
        HashSet<Value> clusterValues = new HashSet<Value>();
        for (Node node : result.getNodes().toListSortedById()) {
            Individual referent = (Individual)node.getReferent();
            SequenceCriteria criteria = new SequenceCriteria();
            criteria.getValueSequenceLabels().add(relationClassificationType);
            criteria.setEgoRoleName(egoEnvironment.getEgoRoleName());
            criteria.setRoleNames(egoEnvironment.getRoleNames());
            criteria.setRelationModelName(relationModelName);
            criteria.setRelationModelNames(egoEnvironment.getRelationModelNames());
            criteria.setPattern(pattern);
            EgoSequence sequence = SequenceMaker.createPersonalEventSequence(referent, criteria);
            Graph<Cluster<Relation>> parcoursNetwork = SequenceNetworkMaker.getParcoursNetwork(sequence, egoEnvironment, relationClassificationType);
            node.setAttribute("NRTRANSITIONS", String.valueOf(parcoursNetwork.arcCount()));
            Graph<String> flatParcoursNetworkNoLoops = SequenceNetworkMaker.getFlatParcoursNetworkNoLoops(parcoursNetwork);
            flatParcoursNetworksNoLoops.add(flatParcoursNetworkNoLoops);
            index.put(flatParcoursNetworkNoLoops, referent);
            for (Node<Cluster<Relation>> node2 : parcoursNetwork.getNodes()) {
                clusterValues.add(node2.getReferent().getValue());
            }
        }
        Collections.sort(flatParcoursNetworksNoLoops, new GraphComparatorByArcCount());
        Graph distanceGraph = GraphUtils.createDistanceGraph(flatParcoursNetworksNoLoops);
        for (Link link : distanceGraph.getEdges()) {
            Link<Individual> edge = result.addEdge((Individual)index.get(link.getSourceNode().getReferent()), (Individual)index.get(link.getTargetNode().getReferent()));
            ArrayList<Graph<Graph>> pair = new ArrayList<Graph<Graph>>();
            pair.add((Graph)link.getSourceNode().getReferent());
            pair.add((Graph)link.getTargetNode().getReferent());
            double maxArcs = new Double(GraphUtils.fuse(pair).arcCount());
            double d = (maxArcs - link.getWeight()) / maxArcs;
            edge.setWeight(100.0 * d);
            edge.setTag(String.valueOf(d));
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    private static Graph<Individual> getParcoursIntersectionNetwork(String relationModelName, RelationEnvironment egoEnvironment, String alterAttributeLabel, String alterAttributeValue) {
        Individual ego = egoEnvironment.getEgo();
        Graph<Individual> result = new Graph<Individual>("Parcours Intersection Network " + ego + " " + relationModelName + " " + egoEnvironment.getEgoRoleName() + "-" + SequenceNetworkMaker.getSelectedRolesAsString(egoEnvironment.getRoleNames()));
        HashMap eventMap = new HashMap();
        result.addNode(ego);
        result.getNode(ego).setAttribute("NREVENTS", String.valueOf(SequenceNetworkMaker.getEvents(ego, relationModelName).size()));
        HashSet<Relation> egoEvents = new HashSet<Relation>();
        eventMap.put(ego, egoEvents);
        for (Relation event : SequenceNetworkMaker.getEvents(ego, relationModelName)) {
            egoEvents.add(event);
        }
        for (Individual alter : egoEnvironment.getAltersByRole("SELECTED")) {
            if (!alter.hasAttributeValue(alterAttributeLabel, alterAttributeValue)) continue;
            result.addNode(alter);
            result.getNode(alter).setAttribute("NREVENTS", String.valueOf(SequenceNetworkMaker.getEvents(alter, relationModelName).size()));
            HashSet<Relation> alterEvents = new HashSet<Relation>();
            eventMap.put(alter, alterEvents);
            for (Relation event : SequenceNetworkMaker.getEvents(alter, relationModelName)) {
                alterEvents.add(event);
            }
        }
        List referents = result.getReferents();
        int i = 0;
        while (i < referents.size()) {
            Individual first = (Individual)referents.get(i);
            int j = 0;
            while (j < i) {
                Link<Individual> link;
                Individual second = (Individual)referents.get(j);
                double[] shares = MathUtils.intersectionRates((Collection)eventMap.get(first), (Collection)eventMap.get(second));
                if (shares[0] > 0.0) {
                    link = result.addArc(first, second, shares[0]);
                }
                if (shares[1] > 0.0) {
                    link = result.addArc(second, first, shares[1]);
                }
                ++j;
            }
            ++i;
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    private static String getSelectedRolesAsString(List<String> roleNames) {
        String result = "";
        for (String roleName : roleNames) {
            if (result.length() > 0) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + roleName;
        }
        return result;
    }

    private static Graph<Individual> getNonMediatedEgoNetwork(String relationModelName, RelationEnvironment egoEnvironment, String pattern, String chainClassification) {
        Integer tagNumber;
        Link<Individual> link;
        List<String> alterRoles;
        Individual alter;
        int j;
        Individual ego;
        Graph<Individual> result = new Graph<Individual>("Nonmediated Ego Network " + egoEnvironment.getEgo() + " " + relationModelName + " " + egoEnvironment.getEgoRoleName() + "-" + SequenceNetworkMaker.getSelectedRolesAsString(egoEnvironment.getRoleNames()));
        HashMap<String, Integer> tagMap = new HashMap<String, Integer>();
        Set<Individual> selectedAlters = egoEnvironment.getAltersByRole("SELECTED");
        Set<Individual> allAlters = egoEnvironment.getAltersByRole("ALL");
        result.addNode(egoEnvironment.getEgo());
        for (Individual alter2 : selectedAlters) {
            result.addNode(alter2);
        }
        HashSet<Individual> others = new HashSet<Individual>();
        for (Individual medius : allAlters) {
            if (selectedAlters.contains(medius)) continue;
            others.add(medius);
        }
        List<Individual> referents = result.getReferents();
        Graph<Individual> barredEdges = new Graph<Individual>();
        int[] maxDepths = ToolBox.stringsToInts(pattern);
        int i = 0;
        while (i < referents.size()) {
            ego = (Individual)referents.get(i);
            j = 0;
            while (j < i) {
                alter = (Individual)referents.get(j);
                alterRoles = NetUtils.getAlterRoles(ego, alter, maxDepths, egoEnvironment.getRelationModelNames(), chainClassification, referents, barredEdges);
                for (String tag : alterRoles) {
                    link = result.addEdge(ego, alter, 1.0);
                    tagNumber = (Integer)tagMap.get(tag);
                    if (tagNumber == null) {
                        tagNumber = tagMap.size() + 1;
                        tagMap.put(tag, tagNumber);
                    }
                    link.setTag(":" + tagNumber + " '" + tag + "'");
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < referents.size()) {
            ego = (Individual)referents.get(i);
            j = 0;
            while (j < i) {
                alter = (Individual)referents.get(j);
                if (result.getEdge(ego, alter) == null && barredEdges.getEdge(ego, alter) == null) {
                    alterRoles = new ArrayList<String>();
                    for (Individual medius : others) {
                        List<String> firstRoles;
                        if (medius == ego || (firstRoles = NetUtils.getAlterRoles(ego, medius, maxDepths, egoEnvironment.getRelationModelNames(), chainClassification, referents, barredEdges)).size() <= 0) continue;
                        List<String> secondRoles = NetUtils.getAlterRoles(medius, alter, maxDepths, egoEnvironment.getRelationModelNames(), chainClassification, referents, barredEdges);
                        for (String firstRole : firstRoles) {
                            for (String secondRole : secondRoles) {
                                if (firstRole.equals("CHILD") && secondRole.contains("RELATIVE")) continue;
                                String role = String.valueOf(firstRole) + "S_" + secondRole;
                                String reducedRole = NetUtils.reduced(role);
                                while (!reducedRole.equals(role)) {
                                    role = reducedRole;
                                    reducedRole = NetUtils.reduced(role);
                                }
                                alterRoles.add(reducedRole);
                            }
                        }
                    }
                    for (String tag : alterRoles) {
                        link = result.addEdge(ego, alter, 1.0);
                        tagNumber = (Integer)tagMap.get(tag);
                        if (tagNumber == null) {
                            tagNumber = tagMap.size() + 1;
                            tagMap.put(tag, tagNumber);
                        }
                        link.setTag(":" + tagNumber + " '" + tag + "'");
                    }
                }
                ++j;
            }
            ++i;
        }
        NetUtils.setGenderShapes(result);
        SequenceNetworkMaker.makeAlterRelationPartition(result, egoEnvironment.getEgo(), egoEnvironment.getRelationsByAlter());
        GraphUtils.addNodeLabelsFromPartition(result, "EGO-RELATION");
        return result;
    }
}

