/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles.io;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.bar.BARODSFile;
import org.tip.puck.io.bar.BARTXTFile;
import org.tip.puck.io.bar.BARXLSFile;
import org.tip.puck.io.iur.IURODSFile;
import org.tip.puck.io.iur.IURTXTFile;
import org.tip.puck.io.iur.IURXLSFile;
import org.tip.puck.io.puc.PUCFile;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.report.Report;

public class TermGenealogyFile {
    public static RelationModel load(File source, Report report) throws PuckException {
        RelationModel result;
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + source + "].", new Object[0]);
        }
        if (!source.exists()) {
            throw PuckExceptions.FILE_NOT_FOUND.create("File=[" + source + "].", new Object[0]);
        }
        if (!source.isFile()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + source + "].", new Object[0]);
        }
        String name = StringUtils.lowerCase((String)source.getName());
        if (name.endsWith(".term.puc")) {
            result = TermGenealogyFile.loadFromPUCFile(source, report);
        } else if (name.endsWith(".term.iur.txt")) {
            result = TermGenealogyFile.loadFromIURTXTFile(source, report);
        } else if (name.endsWith(".term.iur.ods")) {
            result = TermGenealogyFile.loadFromIURODSFile(source, report);
        } else if (name.endsWith(".term.iur.xls")) {
            result = TermGenealogyFile.loadFromIURXLSFile(source, report);
        } else if (name.endsWith(".term.bar.txt")) {
            result = TermGenealogyFile.loadFromBARTXTFile(source, report);
        } else if (name.endsWith(".term.bar.ods")) {
            result = TermGenealogyFile.loadFromBARODSFile(source, report);
        } else if (name.endsWith(".term.bar.xls")) {
            result = TermGenealogyFile.loadFromBARXLSFile(source, report);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + source + "].", new Object[0]);
        }
        return result;
    }

    public static RelationModel loadFromBARODSFile(File file, Report report) throws PuckException {
        Net net = BARODSFile.load(file);
        RelationModel result = RoleRelationMaker.create(net, report);
        return result;
    }

    public static RelationModel loadFromBARTXTFile(File file, Report report) throws PuckException {
        Net net = BARTXTFile.load(file);
        RelationModel result = RoleRelationMaker.create(net, report);
        return result;
    }

    public static RelationModel loadFromBARXLSFile(File file, Report report) throws PuckException {
        Net net = BARXLSFile.load(file);
        RelationModel result = RoleRelationMaker.create(net, report);
        return result;
    }

    public static RelationModel loadFromIURODSFile(File file, Report report) throws PuckException {
        Net net = IURODSFile.load(file);
        RelationModel result = RoleRelationMaker.create(net, report);
        return result;
    }

    public static RelationModel loadFromIURTXTFile(File file, Report report) throws PuckException {
        Net net = IURTXTFile.load(file);
        RelationModel result = RoleRelationMaker.create(net, report);
        return result;
    }

    public static RelationModel loadFromIURXLSFile(File file, Report report) throws PuckException {
        Net net = IURXLSFile.load(file);
        RelationModel result = RoleRelationMaker.create(net, report);
        return result;
    }

    public static RelationModel loadFromPUCFile(File file, Report report) throws PuckException {
        Net net = PUCFile.load(file);
        RelationModel result = RoleRelationMaker.create(net, report);
        return result;
    }
}

