/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import org.tip.puck.net.AlterAge;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleActorComparator;
import org.tip.puck.net.relations.roles.RoleActorPair;
import org.tip.puck.net.relations.roles.RoleRelations;

public class RoleDefinition
implements Comparable<RoleDefinition> {
    Role self;
    RoleActor actor;
    String letters;

    public RoleDefinition(Role self, RoleActor actor) {
        this.self = self;
        this.actor = actor;
    }

    public RoleDefinition(String selfName, String alterName, String roleName, Gender egoGender, Gender alterGender, AlterAge alterAge, String egoName) {
        this.self = new Role(selfName);
        this.actor = new RoleActor(new Role(alterName), new MetaRole(roleName, egoGender, alterGender, alterAge), egoName);
    }

    public RoleDefinition clone() {
        return new RoleDefinition(this.self, this.actor.clone());
    }

    public String toString() {
        String name = this.self.getName();
        if (this.self.hasSelfName()) {
            name = "";
        }
        return this.actor.getIndividual() + "\t" + name + "\t" + this.actor.getRole().getName() + "\t" + this.actor.getRole().getEgoGender().toStringNoUnknown() + "\t" + this.actor.getRole().getAlterGender().toStringNoUnknown() + "\t" + this.actor.getRole().getAlterAge().toStringNoUnknown();
    }

    public Role getAlterTerm() {
        return this.actor.getIndividual();
    }

    public Role getSelfTerm() {
        return this.self;
    }

    public RoleActor getAlter() {
        return this.actor;
    }

    public RoleActor getSelf() {
        RoleActor result = new RoleActor(this.getSelfTerm(), new MetaRole(MetaRole.invertName(this.getRoleName()), this.getEgoGender(), this.getEgoGender(), this.getAlterAge().invert()), this.actor.selfName);
        return result;
    }

    public MetaRole getRole() {
        return this.actor.getRole();
    }

    public String getRoleName() {
        return this.actor.getRole().getName();
    }

    public Gender getAlterGender() {
        return this.actor.getRole().getAlterGender();
    }

    public AlterAge getAlterAge() {
        return this.actor.getRole().getAlterAge();
    }

    public Gender getEgoGender() {
        return this.actor.getRole().getEgoGender();
    }

    @Override
    public int compareTo(RoleDefinition other) {
        int result;
        RoleActor self = this.getSelf();
        RoleActor otherSelf = other.getSelf();
        if (self.hasSelfName() && !otherSelf.hasSelfName()) {
            result = -1;
        } else if (!self.hasSelfName() && otherSelf.hasSelfName()) {
            result = 1;
        } else {
            result = new RoleActorComparator().compare(this.getSelf(), other.getSelf());
            if (result == 0) {
                result = this.getAlter().compareTo(other.getAlter());
            }
        }
        return result;
    }

    public int compareTo(RoleDefinition other, RoleRelations relations) {
        int result;
        if (other == null) {
            result = -1;
        } else {
            result = new RoleActorComparator(relations).compare(this.getAlter(), other.getAlter());
            if (result == 0) {
                result = this.getSelfTerm().compareTo(other.getSelfTerm());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == null) {
            result = false;
        } else {
            RoleDefinition other = (RoleDefinition)obj;
            result = this.self.equals(other.self) && this.actor.equals(other.actor);
        }
        return result;
    }

    public RoleActor getSelfActor() {
        RoleActor result = new RoleActor(this.self, new MetaRole(null, this.actor.getEgoGender(), null, AlterAge.UNKNOWN), this.actor.selfName);
        return result;
    }

    public RoleActorPair getPair(RoleRelations relations, RoleActorPair.Adjustable adjustable) {
        RoleActorPair result = new RoleActorPair(relations, this.getSelfActor(), this.actor, adjustable);
        return result;
    }

    public RoleDefinition standard(RoleRelations relations) {
        return this.getPair(relations, RoleActorPair.Adjustable.NONE).getStandardRoleDefinition(relations);
    }

    public RoleDefinition inverse(RoleRelations relations) {
        RoleDefinition result = this.getPair(relations, RoleActorPair.Adjustable.NONE).reciprocal(relations).getRoleDefinition();
        return result;
    }

    public String getLetters() {
        return this.letters;
    }

    public void setLetters(String letters) {
        this.letters = letters;
    }

    public boolean specifies(RoleDefinition definition) {
        boolean result = this.getSelfTerm().equals(definition.getSelfTerm()) && this.getAlter().specifies(definition.getAlter());
        return result;
    }

    public RoleDefinition cloneWithEgoGender(Gender egoGender) {
        RoleDefinition result = this.clone();
        result.getAlter().setEgoGender(egoGender);
        return result;
    }

    public RoleDefinition cloneWithAlterGender(Gender alterGender) {
        RoleDefinition result = this.clone();
        result.getAlter().setAlterGender(alterGender);
        return result;
    }

    public RoleDefinition cloneWithAlterAge(AlterAge alterAge) {
        RoleDefinition result = this.clone();
        result.getAlter().setAlterAge(alterAge);
        return result;
    }

    public boolean isEgoGenderComplement(RoleDefinition definition) {
        boolean result = definition.cloneWithEgoGender(this.getEgoGender()).equals(this);
        return result;
    }

    public boolean isAlterGenderComplement(RoleDefinition definition) {
        boolean result = definition.cloneWithAlterGender(this.getAlterGender()).equals(this);
        return result;
    }

    public boolean isAlterAgeComplement(RoleDefinition definition) {
        boolean result = definition.cloneWithAlterAge(this.getAlterAge()).equals(this);
        return result;
    }
}

