/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.workers.IndividualValuator;

public class EventTriangle {
    Individual[] individuals;
    String[][] roleNamePairs;
    Relation[] events;
    int n;

    public EventTriangle(int n) {
        this.individuals = new Individual[n];
        this.roleNamePairs = new String[n][2];
        this.events = new Relation[n];
        this.n = n;
    }

    public EventTriangle(Individual[] individuals, String[][] roleNamePairs, Relation[] events) {
        this.individuals = individuals;
        this.roleNamePairs = roleNamePairs;
        this.events = events;
        this.n = events.length;
    }

    public String[][] inverseRoleNamePairs() {
        String[][] result = new String[this.n][2];
        int i = 0;
        while (i < this.n) {
            result[i][0] = this.roleNamePairs[i][1];
            result[i][1] = this.roleNamePairs[i][0];
            ++i;
        }
        return result;
    }

    public EventTriangle sortByYear() {
        boolean invert;
        EventTriangle result = new EventTriangle(this.n);
        TreeMap<String, Integer> permutation = new TreeMap<String, Integer>();
        int i = 0;
        Relation[] relationArray = this.events;
        int n = this.events.length;
        int n2 = 0;
        while (n2 < n) {
            Relation event = relationArray[n2];
            String year = IndividualValuator.extractYear(event.getAttributeValue("DATE"));
            if (year == null) {
                year = "";
            }
            permutation.put(String.valueOf(year) + " " + event.getId() + " " + i, i);
            ++i;
            ++n2;
        }
        try {
            invert = (this.n + (Integer)permutation.get(permutation.higherKey((String)permutation.firstKey())) - (Integer)permutation.get(permutation.firstKey())) % this.n != 1;
        }
        catch (NullPointerException npe) {
            invert = false;
        }
        i = 0;
        Iterator iterator = permutation.values().iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            if (invert) {
                result.roleNamePairs[i] = this.inverseRoleNamePairs()[j];
                result.individuals[(i + 1) % this.n] = this.individuals[j];
            } else {
                result.roleNamePairs[i] = this.roleNamePairs[j];
                result.individuals[i] = this.individuals[j];
            }
            result.events[i] = this.events[j];
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = obj != null && Arrays.deepEquals(this.individuals, ((EventTriangle)obj).individuals) && Arrays.deepEquals((Object[])this.roleNamePairs, (Object[])((EventTriangle)obj).roleNamePairs) && Arrays.deepEquals(this.events, ((EventTriangle)obj).events);
        return result;
    }

    public String getRolePattern() {
        String result = "";
        int i = 0;
        while (i < this.n) {
            result = String.valueOf(result) + this.roleNamePairs[i][0] + this.roleNamePairs[i][1];
            if (i < this.n - 1) {
                result = String.valueOf(result) + " - ";
            }
            ++i;
        }
        return result;
    }

    public String getEventPattern() {
        String result = "";
        int i = 0;
        while (i < this.n) {
            result = String.valueOf(result) + this.individuals[i] + " - " + IndividualValuator.extractYear(this.events[i].getAttributeValue("DATE")) + " " + this.events[i].getAttributeValue("END_PLACE");
            if (i < this.n - 1) {
                result = String.valueOf(result) + " - ";
            }
            ++i;
        }
        return result;
    }
}

