/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.report;

import fr.devinsy.otridi.BarBoardChart;
import fr.devinsy.otridi.SurfaceChart;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.report.ReportChart;

public class ReportChartMaker {
    private static final Logger logger = LoggerFactory.getLogger(ReportChartMaker.class);

    public static BufferedImage createBufferedImage(ReportChart reportChart, int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 2);
        if (reportChart.getType() == ReportChart.GraphType.SURFACE) {
            double[][] matrix = new double[reportChart.getRowCount()][reportChart.getColumnCount()];
            int rowIndex = 0;
            while (rowIndex < reportChart.getRowCount()) {
                int columnIndex = 0;
                while (columnIndex < reportChart.getColumnCount(rowIndex)) {
                    Double value = reportChart.getYValue(rowIndex, columnIndex);
                    matrix[rowIndex][columnIndex] = value == null ? 0.0 : value;
                    System.out.println(String.valueOf(rowIndex) + " " + columnIndex + " " + value);
                    ++columnIndex;
                }
                ++rowIndex;
            }
            SurfaceChart.draw((Graphics)result.getGraphics(), (double[][])matrix, (int)width, (int)height);
        } else if (reportChart.getType() == ReportChart.GraphType.BAR_BOARD) {
            double[][] matrix = new double[reportChart.getRowCount()][reportChart.getColumnCount()];
            int rowIndex = 0;
            while (rowIndex < reportChart.getRowCount()) {
                int columnIndex = 0;
                while (columnIndex < reportChart.getColumnCount(rowIndex)) {
                    Double value = reportChart.getYValue(rowIndex, columnIndex);
                    matrix[rowIndex][columnIndex] = value == null ? 0.0 : value;
                    System.out.println(String.valueOf(rowIndex) + " " + columnIndex + " " + value);
                    ++columnIndex;
                }
                ++rowIndex;
            }
            BarBoardChart.draw((Graphics)result.getGraphics(), (double[][])matrix, (int)width, (int)height);
        } else {
            JFreeChart chart = ReportChartMaker.createJFreeChart(reportChart);
            chart.draw((Graphics2D)result.getGraphics(), (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
        }
        return result;
    }

    public static JFreeChart createJFreeChart(ReportChart reportChart) {
        JFreeChart result;
        switch (reportChart.getType()) {
            case STACKED_BARS: {
                DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                int rowIndex = 0;
                while (rowIndex < reportChart.getRowCount()) {
                    int columnIndex = 0;
                    while (columnIndex < reportChart.getColumnCount()) {
                        String category = reportChart.getLineTitle(rowIndex);
                        if (category == null) {
                            category = reportChart.getHeader(columnIndex);
                        }
                        Double value = reportChart.getYValue(rowIndex, columnIndex);
                        dataset.addValue((Number)value, (Comparable)((Object)category), (Comparable)((Object)reportChart.getHeader(columnIndex)));
                        ++columnIndex;
                    }
                    ++rowIndex;
                }
                boolean showLegend = reportChart.getColumnCount() <= 30;
                result = ChartFactory.createStackedBarChart(null, (String)reportChart.getHeadersLegend(), (String)reportChart.getLinesLegend(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)true, (boolean)false);
                result.setBackgroundPaint((Paint)new Color(237, 236, 235));
                CategoryPlot plot = (CategoryPlot)result.getPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                CategoryItemRenderer renderer = plot.getRenderer();
                renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                renderer.setBaseItemLabelsVisible(true);
                BarRenderer barRenderer = (BarRenderer)plot.getRenderer();
                barRenderer.setBarPainter((BarPainter)new StandardBarPainter());
                barRenderer.setDrawBarOutline(true);
                barRenderer.setShadowVisible(false);
                break;
            }
            case LINES: {
                XYSeriesCollection dataset = new XYSeriesCollection();
                int rowIndex = 0;
                while (rowIndex < reportChart.getRowCount()) {
                    XYSeries series = new XYSeries((Comparable)((Object)reportChart.getLineTitle(rowIndex)));
                    int columnIndex = 0;
                    while (columnIndex < reportChart.getColumnCount(rowIndex)) {
                        Double x = reportChart.getXValue(rowIndex, columnIndex);
                        if (x == null) {
                            x = columnIndex + 1;
                        }
                        if (reportChart.getLogarithmType() == ReportChart.LogarithmType.NONE || x > 0.0) {
                            series.add((Number)x, (Number)reportChart.getYValue(rowIndex, columnIndex));
                        }
                        ++columnIndex;
                    }
                    dataset.addSeries(series);
                    ++rowIndex;
                }
                result = ChartFactory.createXYLineChart(null, (String)reportChart.getHeadersLegend(), (String)reportChart.getLinesLegend(), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                result.setBackgroundPaint((Paint)new Color(237, 236, 235));
                XYPlot plot = result.getXYPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                switch (reportChart.getLogarithmType()) {
                    case NONE: {
                        Range rangeRange;
                        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                        if (reportChart.getVerticalMax() != null && (rangeRange = rangeAxis.getRange()).getUpperBound() > reportChart.getVerticalMax()) {
                            rangeAxis.setRange(rangeRange.getLowerBound(), reportChart.getVerticalMax().doubleValue());
                        }
                        if (reportChart.isIntegerHorizontalUnit()) {
                            NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
                            domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                        }
                        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
                        break;
                    }
                    case HORIZONTAL: {
                        LogarithmicAxis domainAxis = new LogarithmicAxis(reportChart.getHeadersLegend());
                        plot.setDomainAxis((ValueAxis)domainAxis);
                        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
                        break;
                    }
                    case VERTICAL: {
                        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                        NumberAxis rangeAxis = new LogarithmicAxis(reportChart.getLinesLegend());
                        plot.setRangeAxis((ValueAxis)rangeAxis);
                        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
                        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                    }
                }
                break;
            }
            case SCATTER: {
                XYSeriesCollection dataset = new XYSeriesCollection();
                int rowIndex = 0;
                while (rowIndex < reportChart.getRowCount()) {
                    XYSeries series = new XYSeries((Comparable)((Object)reportChart.getLineTitle(rowIndex)));
                    int columnIndex = 0;
                    while (columnIndex < reportChart.getColumnCount(rowIndex)) {
                        Double x = reportChart.getXValue(rowIndex, columnIndex);
                        if (x == null) {
                            x = columnIndex + 1;
                        }
                        series.add((Number)x, (Number)reportChart.getYValue(rowIndex, columnIndex));
                        ++columnIndex;
                    }
                    dataset.addSeries(series);
                    ++rowIndex;
                }
                result = ChartFactory.createScatterPlot(null, (String)reportChart.getHeadersLegend(), (String)reportChart.getLinesLegend(), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                result.setBackgroundPaint((Paint)new Color(237, 236, 235));
                XYPlot plot = result.getXYPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

