/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainFinder;
import org.tip.puck.census.chains.Couple;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.AttributeToRelationCriteria;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.TransmitAttributeValueCriteria;
import org.tip.puck.net.workers.UpdateWorker;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segment;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.Value;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);

    public static long anonymizeByFirstName(Individuals source) {
        return AttributeWorker.anonymizeByFirstName(source);
    }

    public static long anonymizeByFirstName(Net source) {
        return AttributeWorker.anonymizeByFirstName(source);
    }

    public static long anonymizeByGenderAndId(Individuals source) {
        return AttributeWorker.anonymizeByGenderAndId(source);
    }

    public static long anonymizeByGenderAndId(Net source) {
        return AttributeWorker.anonymizeByGenderAndId(source);
    }

    public static long anonymizeByLastName(Individuals source) {
        return AttributeWorker.anonymizeByLastName(source);
    }

    public static long anonymizeByLastName(Net source) {
        return AttributeWorker.anonymizeByLastName(source);
    }

    public static Net buildCleanedNet(Net source) throws PuckException {
        Net result = new Net();
        result.setLabel(source.getLabel());
        for (Attribute attribute : source.attributes().toSortedList()) {
            result.attributes().put(attribute.getLabel(), attribute.getValue());
        }
        for (Individual sourceIndividual : source.individuals()) {
            Individual targetIndividual = new Individual(sourceIndividual.getId());
            targetIndividual.setGender(sourceIndividual.getGender());
            targetIndividual.setName(sourceIndividual.getName());
            targetIndividual.setOriginFamily(sourceIndividual.getOriginFamily());
            targetIndividual.attributes().addAll(sourceIndividual.attributes());
            result.individuals().add(targetIndividual);
        }
        for (Family sourceFamily : source.families()) {
            Individual targetParent;
            Individual targetChild;
            int fatherId = sourceFamily.getHusband() == null ? 0 : sourceFamily.getHusband().getId();
            int motherId = sourceFamily.getWife() == null ? 0 : sourceFamily.getWife().getId();
            Family targetFamily = fatherId == 0 || motherId == 0 ? null : result.families().getBySpouses(fatherId, motherId);
            if (targetFamily == null) {
                targetFamily = new Family(result.families().size() + 1);
                result.families().add(targetFamily);
                if (sourceFamily.getHusband() != null) {
                    targetFamily.setHusband((Individual)result.individuals().getById(sourceFamily.getHusband().getId()));
                }
                if (sourceFamily.getWife() != null) {
                    targetFamily.setWife((Individual)result.individuals().getById(sourceFamily.getWife().getId()));
                }
                targetFamily.setUnionStatus(sourceFamily.getUnionStatus());
                for (Individual sourceChild : sourceFamily.getChildren()) {
                    targetChild = (Individual)result.individuals().getById(sourceChild.getId());
                    targetFamily.getChildren().add(targetChild);
                    targetChild.setOriginFamily(targetFamily);
                }
                targetFamily.attributes().addAll(sourceFamily.attributes());
            } else {
                for (Individual sourceChild : sourceFamily.getChildren()) {
                    if (targetFamily.getChildren().getById(sourceChild.getId()) != null) continue;
                    targetChild = (Individual)result.individuals().getById(sourceChild.getId());
                    targetFamily.getChildren().add(targetChild);
                    targetChild.setOriginFamily(targetFamily);
                }
                if (sourceFamily.hasMarried()) {
                    targetFamily.setMarried(true);
                }
                targetFamily.attributes().addAll(sourceFamily.attributes());
            }
            if (sourceFamily.getHusband() != null) {
                targetParent = (Individual)result.individuals().getById(sourceFamily.getHusband().getId());
                targetParent.getPersonalFamilies().add(targetFamily);
            }
            if (sourceFamily.getWife() == null) continue;
            targetParent = (Individual)result.individuals().getById(sourceFamily.getWife().getId());
            targetParent.getPersonalFamilies().add(targetFamily);
        }
        for (RelationModel model : source.relationModels()) {
            result.relationModels().add(new RelationModel(model));
        }
        for (Relation sourceRelation : source.relations()) {
            Relation targetRelation = new Relation(sourceRelation.getId(), sourceRelation.getTypedId(), result.relationModels().getByName(sourceRelation.getModel().getName()), sourceRelation.getName(), new Actor[0]);
            result.relations().add(targetRelation);
            for (Actor sourceActor : sourceRelation.actors()) {
                result.createRelationActor(targetRelation, sourceActor.getId(), sourceActor.getRole().getName());
            }
        }
        return result;
    }

    private static void actorsToChildren(Net net, Relation relation, String roleName, Individual husband, Individual wife, boolean married, Report report, StringList errorReport) {
        Actors actors = relation.actors().getByRole(roleName);
        if (!actors.isEmpty()) {
            for (Actor childActor : actors.toSortedList()) {
                Individual child = childActor.getIndividual();
                Individual father = child.getFather();
                Individual mother = child.getMother();
                if (father != null && !father.equals(husband) || mother != null && !mother.equals(wife)) {
                    errorReport.appendln("Contradictory parents for " + child + ": " + husband + "+" + wife + " vs " + mother + "+" + father + " (" + relation + ")");
                    continue;
                }
                Family family = NetUtils.createFamily(net, relation, husband, wife, married, report);
                if (family == null || family.getChildren().contains(child)) continue;
                if (child.getOriginFamily() != null) {
                    report.outputs().appendln("\tMoved child " + child + " from family " + child.getOriginFamily() + " to family " + family);
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    if (child.getOriginFamily().attributes().isEmpty() && child.getOriginFamily().getChildren().isEmpty()) {
                        net.families().removeById(family.getId());
                        report.outputs().appendln("Family " + child.getOriginFamily() + " merged with family " + family);
                    }
                } else {
                    report.outputs().appendln("\tAdded child " + child + " to family " + family);
                }
                child.setOriginFamily(family);
                family.getChildren().put(child);
                relation.removeActor(childActor);
            }
        }
    }

    private static Family createFamily(Net net, Relation relation, Individual husband, Individual wife, boolean married, Report report) {
        Family result = null;
        if (husband != null || wife != null) {
            result = net.families().getBySpouses(husband, wife);
            if (result == null) {
                if (husband != null && wife == null && husband.getPersonalFamilies().size() == 1 && husband.spouses().isEmpty()) {
                    result = (Family)husband.getPersonalFamilies().getFirst();
                } else if (wife != null && husband == null && wife.getPersonalFamilies().size() == 1 && wife.spouses().isEmpty()) {
                    result = (Family)wife.getPersonalFamilies().getFirst();
                } else {
                    result = net.createFamily(husband, wife, new Individuals());
                    if (married) {
                        result.setMarried();
                    }
                    report.outputs().appendln("Created family " + result + " from " + relation);
                }
            }
            result.attributes().addAll(relation.attributes());
            String sourceRelation = relation.getModel() + " " + relation.getId();
            String sourceRelations = result.getAttributeValue("SOURCE");
            if (sourceRelations == null) {
                result.setAttribute("SOURCE", sourceRelation);
            } else {
                result.setAttribute("SOURCE", String.valueOf(sourceRelations) + ";" + sourceRelation);
            }
        }
        return result;
    }

    public static Net createFamiliesFromRelations(Net source, String relationLabel, String alternativeLabel, Map<String, String> labels, Report report) {
        Net result = new Net(source);
        result.setDefaultIdStrategy(NumberablesHashMap.IdStrategy.APPEND);
        String husbandLabel = labels.get("husband");
        String wifeLabel = labels.get("wife");
        String sonLabel = labels.get("son");
        String daughterLabel = labels.get("daughter");
        String otherWifeLabel = labels.get("otherWife");
        String otherHusbandLabel = labels.get("otherHusband");
        String husbandsOtherSonLabel = labels.get("husbandsOtherSon");
        String husbandsOtherDaughterLabel = labels.get("husbandsOtherDaughter");
        String husbandsNaturalSonLabel = labels.get("husbandsNaturalSon");
        String husbandsNaturalDaughterLabel = labels.get("husbandsNaturalDaughter");
        String husbandMotherLabel = labels.get("husbandMother");
        String husbandFatherLabel = labels.get("husbandFather");
        String wifesOtherSonLabel = labels.get("wifesOtherSon");
        String wifesOtherDaughterLabel = labels.get("wifesOtherDaughter");
        String wifesNaturalSonLabel = labels.get("wifesNaturalSon");
        String wifesNaturalDaughterLabel = labels.get("wifesNaturalDaughter");
        String wifeMotherLabel = labels.get("wifeMother");
        String wifeFatherLabel = labels.get("wifeFather");
        String brotherLabel = labels.get("brother");
        String sisterLabel = labels.get("sister");
        RelationModel alternativeModel = result.relationModels().getByName(alternativeLabel);
        if (alternativeModel == null) {
            alternativeModel = new RelationModel(alternativeLabel);
        }
        StringList errors = new StringList();
        for (Relation relation : result.relations().getByPartialModelName(relationLabel)) {
            Actors otherHusbandActors;
            Actors otherWifeActors;
            Actors wifeActors;
            Individual husband = null;
            Individual wife = null;
            Actors husbandActors = relation.actors().getByRole(husbandLabel);
            if (!husbandActors.isEmpty()) {
                if (husbandActors.size() == 1) {
                    husband = ((Actor)husbandActors.get(0)).getIndividual();
                    relation.removeActor((Actor)husbandActors.get(0));
                } else {
                    errors.appendln("Multiple " + husbandLabel + "s for relation " + relation + ": " + husbandActors.toSortedList());
                }
            }
            if (!(wifeActors = relation.actors().getByRole(wifeLabel)).isEmpty()) {
                if (wifeActors.size() == 1) {
                    wife = ((Actor)wifeActors.get(0)).getIndividual();
                    relation.removeActor((Actor)wifeActors.get(0));
                } else {
                    errors.appendln("Multiple " + wifeLabel + "s for relation " + relation + ": " + husbandActors.toSortedList());
                }
            }
            NetUtils.createFamily(result, relation, husband, wife, true, report);
            NetUtils.actorsToChildren(result, relation, sonLabel, husband, wife, true, report, errors);
            if (daughterLabel != null && !daughterLabel.equals(sonLabel)) {
                NetUtils.actorsToChildren(result, relation, daughterLabel, husband, wife, true, report, errors);
            }
            if (!(otherWifeActors = relation.actors().getByRole(otherWifeLabel)).isEmpty()) {
                for (Actor otherWifeActor : otherWifeActors.toSortedList()) {
                    Family family = result.createFamily(husband, otherWifeActor.getIndividual(), new Individual[0]);
                    family.setMarried();
                    report.outputs().appendln("Created family " + family + " from " + relation);
                    relation.removeActor(otherWifeActor);
                }
            }
            if (!(otherHusbandActors = relation.actors().getByRole(otherHusbandLabel)).isEmpty()) {
                for (Actor otherHusbandActor : otherHusbandActors.toSortedList()) {
                    Family family = result.createFamily(otherHusbandActor.getIndividual(), wife, new Individual[0]);
                    family.setMarried();
                    report.outputs().appendln("Created family " + family + " from " + relation);
                    relation.removeActor(otherHusbandActor);
                }
            }
            NetUtils.actorsToChildren(result, relation, husbandsOtherSonLabel, husband, null, true, report, errors);
            NetUtils.actorsToChildren(result, relation, husbandsOtherDaughterLabel, husband, null, true, report, errors);
            NetUtils.actorsToChildren(result, relation, husbandsNaturalSonLabel, husband, null, false, report, errors);
            NetUtils.actorsToChildren(result, relation, husbandsNaturalDaughterLabel, husband, null, false, report, errors);
            NetUtils.actorsToChildren(result, relation, wifesOtherSonLabel, null, husband, true, report, errors);
            NetUtils.actorsToChildren(result, relation, wifesOtherDaughterLabel, null, husband, true, report, errors);
            NetUtils.actorsToChildren(result, relation, wifesNaturalSonLabel, null, husband, false, report, errors);
            NetUtils.actorsToChildren(result, relation, wifesNaturalDaughterLabel, null, husband, false, report, errors);
        }
        for (Individual husband : result.individuals()) {
            for (Relation relation : husband.relations().getByPartialModelName(relationLabel)) {
                Family husbandOriginFamily;
                Actors sisterActors;
                Actors brotherActors;
                Actors husbandMotherActors;
                if (!relation.getIndividuals(husbandLabel).contains(husband) || !relation.hasActors(brotherLabel, sisterLabel, husbandMotherLabel)) continue;
                Individual husbandFather = null;
                Individual husbandMother = null;
                Individuals husbandSiblings = new Individuals();
                husbandSiblings.add(husband);
                Actors husbandFatherActors = relation.actors().getByRole(husbandFatherLabel);
                if (!husbandFatherActors.isEmpty()) {
                    if (husbandFatherActors.size() == 1) {
                        husbandFather = ((Actor)husbandFatherActors.get(0)).getIndividual();
                        relation.removeActor((Actor)husbandFatherActors.get(0));
                    } else {
                        report.outputs().appendln("Multiple husbandFathers for role " + husbandFatherLabel);
                    }
                }
                if (!(husbandMotherActors = relation.actors().getByRole(husbandMotherLabel)).isEmpty()) {
                    if (husbandMotherActors.size() == 1) {
                        husbandMother = ((Actor)husbandMotherActors.get(0)).getIndividual();
                        relation.removeActor((Actor)husbandMotherActors.get(0));
                    } else {
                        report.outputs().appendln("Multiple husbandMothers for role " + husbandMotherLabel);
                    }
                }
                if (!(brotherActors = relation.actors().getByRole(brotherLabel)).isEmpty()) {
                    for (Actor childActor : brotherActors.toSortedList()) {
                        husbandSiblings.add(childActor.getIndividual());
                        relation.removeActor(childActor);
                    }
                }
                if (!(sisterActors = relation.actors().getByRole(sisterLabel)).isEmpty()) {
                    for (Actor childActor : sisterActors.toSortedList()) {
                        husbandSiblings.add(childActor.getIndividual());
                        relation.removeActor(childActor);
                    }
                }
                if ((husbandOriginFamily = husband.getOriginFamily()) == null) {
                    husbandOriginFamily = result.createFamily(husbandFather, husbandMother, husbandSiblings);
                }
                if (husbandOriginFamily.getFather() == null) {
                    husbandOriginFamily.setFather(husbandFather);
                } else if (husbandOriginFamily.getFather().equals(husbandFather)) {
                    report.outputs().appendln("Multiple husbandFathers for role " + husbandFatherLabel);
                }
                if (husbandOriginFamily.getMother() == null) {
                    husbandOriginFamily.setMother(husbandMother);
                } else if (husbandOriginFamily.getMother().equals(husbandMother)) {
                    report.outputs().appendln("Multiple husbandMothers for role " + husbandMotherLabel);
                }
                for (Individual husbandSibling : husbandSiblings) {
                    husbandOriginFamily.getChildren().add(husbandSibling);
                    husbandSibling.setOriginFamily(husbandOriginFamily);
                }
            }
        }
        if (!errors.isEmpty()) {
            report.outputs().appendln();
            report.outputs().appendln(String.valueOf(errors.size()) + " errors found:");
            report.outputs().append(errors);
        }
        int alternativeId = result.relations().getByModel(alternativeModel).size() + 1;
        for (Relation relation : result.relations().toSortedList()) {
            if (!StringUtils.containsIgnoreCase((CharSequence)relation.getModel().getName(), (CharSequence)relationLabel)) continue;
            if (relation.actors().isEmpty()) {
                result.remove(relation);
                continue;
            }
            relation.setAttribute("SOURCE", "" + relation);
            relation.setName(String.valueOf(relation.getName()) + " (" + relation.getModel() + " " + relation.getId() + ")");
            relation.setTypedId(alternativeId);
            relation.setModel(alternativeModel);
            ++alternativeId;
        }
        for (RelationModel model : new ArrayList<RelationModel>(source.relationModels())) {
            if (!StringUtils.containsIgnoreCase((CharSequence)model.getName(), (CharSequence)relationLabel)) continue;
            result.remove(model);
        }
        return result;
    }

    public static void createIndividualsFromFamilyAttributes(Net net, Family family, String husbandFirstNameLabel, String husbandLastNameLabel, String wifeFirstNameLabel, String wifeLastNameLabel, Map<String, String> husbandLabels, Map<String, String> wifeLabels) throws PuckException {
        Family family2;
        Individual husband = family.getHusband();
        Individual wife = family.getWife();
        if (husband != null) {
            String wife2LastName2;
            String wife2LastName;
            String wife2FirstName = family.getAttributeValue("HUSB_esanpr");
            if (wife2FirstName == null) {
                wife2FirstName = "";
            }
            if ((wife2LastName = family.getAttributeValue("HUSB_esanno")) == null) {
                wife2LastName = "";
            }
            if ((wife2LastName2 = family.getAttributeValue("HUSB_esanbi")) == null) {
                wife2LastName2 = "";
            }
            if (StringUtils.isNotBlank((CharSequence)(String.valueOf(wife2FirstName) + wife2LastName + wife2LastName2))) {
                Individual wife2 = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), String.valueOf(wife2FirstName) + " / " + wife2LastName + " / " + wife2LastName2, Gender.FEMALE);
                if (StringUtils.isNotBlank((CharSequence)wife2LastName2) || wife2LastName.contains(",")) {
                    wife2.setAttribute("CHECK", "Noms et Parents");
                }
                net.individuals().add(wife2);
                family2 = net.createFamily(net.families().nextFreeId(net.getDefaultIdStrategy()), husband, wife2, UnionStatus.MARRIED);
                if (husband.spouses().size() < 3) {
                    family.setHusbandOrder(2);
                    family2.setHusbandOrder(1);
                } else {
                    System.err.println("Check spouse order for W of " + husband + ": " + husband.spouses());
                }
            }
        }
        if (wife != null) {
            String husband2LastName2;
            String husband2LastName;
            String husband2FirstName = family.getAttributeValue("WIFE_esanpr");
            if (husband2FirstName == null) {
                husband2FirstName = "";
            }
            if ((husband2LastName = family.getAttributeValue("WIFE_esanno")) == null) {
                husband2LastName = "";
            }
            if ((husband2LastName2 = family.getAttributeValue("WIFE_esanbi")) == null) {
                husband2LastName2 = "";
            }
            if (StringUtils.isNotBlank((CharSequence)(String.valueOf(husband2FirstName) + husband2LastName + husband2LastName2))) {
                Individual husband2 = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), String.valueOf(husband2FirstName) + " / " + husband2LastName + " / " + husband2LastName2, Gender.MALE);
                if (StringUtils.isNotBlank((CharSequence)husband2LastName2) || husband2LastName.contains(",")) {
                    husband2.setAttribute("CHECK", "Noms et Parents");
                }
                net.individuals().add(husband2);
                family2 = net.createFamily(net.families().nextFreeId(net.getDefaultIdStrategy()), husband2, wife, UnionStatus.MARRIED);
                if (wife.spouses().size() < 3) {
                    family.setWifeOrder(2);
                    family2.setWifeOrder(1);
                } else {
                    System.err.println("Check spouse order for H of " + wife + ": " + wife.spouses());
                }
            }
        }
    }

    public static RelationModel createLifeEvents(Net net) throws PuckException {
        String place;
        Relation relation;
        String label;
        RelationModel model = net.createRelationModel("BIO");
        model.roles().add(new Role("EGO"));
        model.roles().add(new Role("SPOUSE"));
        model.roles().add(new Role("PARENT"));
        model.roles().add(new Role("CHILD"));
        for (Individual individual : net.individuals()) {
            for (Attribute attribute : individual.attributes()) {
                if (!attribute.getLabel().contains("DATE") || attribute.getLabel().indexOf("_") <= -1 || attribute.getValue().equals("0")) continue;
                label = attribute.getLabel().substring(0, attribute.getLabel().indexOf("_"));
                relation = net.createRelation(net.relations().getFirstFreeId(), String.valueOf(label) + " " + individual.toString(), model);
                relation.setAttribute("DATE", attribute.getValue());
                place = individual.getAttributeValue(String.valueOf(label) + "_PLAC");
                if (place != null) {
                    relation.setAttribute("PLAC", place);
                }
                if (label.equals("BIRT")) {
                    net.createRelationActor(relation, individual.getId(), "CHILD");
                    if (individual.getFather() != null) {
                        net.createRelationActor(relation, individual.getFather().getId(), "PARENT");
                    }
                    if (individual.getMother() == null) continue;
                    net.createRelationActor(relation, individual.getMother().getId(), "PARENT");
                    continue;
                }
                net.createRelationActor(relation, individual.getId(), "EGO");
            }
        }
        for (Family family : net.families()) {
            for (Attribute attribute : family.attributes()) {
                if (!attribute.getLabel().contains("DATE") || attribute.getLabel().indexOf("_") <= -1 || attribute.getValue().equals("0")) continue;
                label = attribute.getLabel().substring(0, attribute.getLabel().indexOf("_"));
                relation = net.createRelation(net.relations().getFirstFreeId(), String.valueOf(label) + " " + family.toString(), model);
                relation.setAttribute("DATE", attribute.getValue());
                place = family.getAttributeValue(String.valueOf(label) + "_PLAC");
                if (place != null) {
                    relation.setAttribute("PLAC", place);
                }
                if (family.getHusband() != null) {
                    net.createRelationActor(relation, family.getHusband().getId(), "SPOUSE");
                }
                if (family.getWife() == null) continue;
                net.createRelationActor(relation, family.getWife().getId(), "SPOUSE");
            }
        }
        RelationModel result = model;
        return result;
    }

    public static Graph<Individual> createOreGraph(Segmentation source) {
        Graph<Individual> result = new Graph<Individual>("Ore graph " + source.getLabel());
        for (Individual individual : source.getCurrentIndividuals().toSortedList()) {
            result.addNode(individual);
        }
        for (Family family : source.getCurrentFamilies()) {
            Individual father = family.getHusband();
            Individual mother = family.getWife();
            if (father != null && mother != null && family.hasMarried()) {
                result.addEdge(father, mother, 1.0);
            }
            if (family.isSterile()) continue;
            for (Individual child : family.getChildren()) {
                if (father != null) {
                    result.addArc(father, child, 1.0);
                }
                if (mother == null) continue;
                result.addArc(mother, child, 1.0);
            }
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    public static void createOriginFamilyFromIndividualAttributes(Net net, Individual ego, String fatherFirstNameLabel, String fatherLastNameLabel, String motherFirstNameLabel, String motherLastNameLabel) {
        String motherLastName;
        String motherFirstName;
        String fatherLastName;
        String fatherFirstName = ego.getAttributeValue(fatherFirstNameLabel);
        if (fatherFirstName == null) {
            fatherFirstName = "";
        }
        if ((fatherLastName = ego.getAttributeValue(fatherLastNameLabel)) == null) {
            fatherLastName = "";
        }
        if ((motherFirstName = ego.getAttributeValue(motherFirstNameLabel)) == null) {
            motherFirstName = "";
        }
        if ((motherLastName = ego.getAttributeValue(motherLastNameLabel)) == null) {
            motherLastName = "";
        }
        Individual father = null;
        Individual mother = null;
        if (!StringUtils.isBlank((CharSequence)(String.valueOf(fatherFirstName) + fatherLastName))) {
            father = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), String.valueOf(fatherFirstName) + " / " + fatherLastName, Gender.MALE);
            net.individuals().put(father);
        }
        if (!StringUtils.isBlank((CharSequence)(String.valueOf(motherFirstName) + motherLastName))) {
            mother = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), String.valueOf(motherFirstName) + " / " + motherLastName, Gender.FEMALE);
            net.individuals().put(mother);
        }
        if (father != null || mother != null) {
            net.createFamily(father, mother, ego);
        }
    }

    public static void createGrandParentsFromIndividualAttributes(Net net, Individual ego, String FFFirstNameLabel, String FFLastNameLabel, String FMFirstNameLabel, String FMLastNameLabel, String MFFirstNameLabel, String MFLastNameLabel, String MMFirstNameLabel, String MMLastNameLabel) {
        String MMLastName;
        String MMFirstName;
        String MFLastName;
        String MFFirstName;
        String FMLastName;
        String FMFirstName;
        String FFLastName;
        String FFFirstName = ego.getAttributeValue(FFFirstNameLabel);
        if (FFFirstName == null) {
            FFFirstName = "";
        }
        if ((FFLastName = ego.getAttributeValue(FFLastNameLabel)) == null) {
            FFLastName = "";
        }
        if ((FMFirstName = ego.getAttributeValue(FMFirstNameLabel)) == null) {
            FMFirstName = "";
        }
        if ((FMLastName = ego.getAttributeValue(FMLastNameLabel)) == null) {
            FMLastName = "";
        }
        if ((MFFirstName = ego.getAttributeValue(MFFirstNameLabel)) == null) {
            MFFirstName = "";
        }
        if ((MFLastName = ego.getAttributeValue(MFLastNameLabel)) == null) {
            MFLastName = "";
        }
        if ((MMFirstName = ego.getAttributeValue(MMFirstNameLabel)) == null) {
            MMFirstName = "";
        }
        if ((MMLastName = ego.getAttributeValue(MMLastNameLabel)) == null) {
            MMLastName = "";
        }
        Individual FF = null;
        Individual FM = null;
        Individual MF = null;
        Individual MM = null;
        Individual orFF = null;
        Individual orFM = null;
        Individual orMF = null;
        Individual orMM = null;
        Individual father = ego.getFather();
        Individual mother = ego.getMother();
        if (father != null) {
            orFF = father.getFather();
            orFM = father.getMother();
        }
        if (mother != null) {
            orMF = mother.getFather();
            orMM = mother.getMother();
        }
        if (!StringUtils.isBlank((CharSequence)(String.valueOf(FFFirstName) + FFLastName))) {
            if (orFF == null) {
                FF = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), String.valueOf(FFFirstName) + " / " + FFLastName, Gender.MALE);
                net.individuals().put(FF);
            } else if (!orFF.hasNameConsistentWith(FFFirstName, FFLastName)) {
                System.err.println("Name inconsistency for FF of " + ego + ": " + FFFirstName + " / " + FFLastName + " blocked by " + orFF.getName());
            }
        }
        if (!StringUtils.isBlank((CharSequence)(String.valueOf(FMFirstName) + FMLastName))) {
            if (orFM == null) {
                FM = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), String.valueOf(FMFirstName) + " / " + FMLastName, Gender.FEMALE);
                net.individuals().put(FM);
            } else if (!orFM.hasNameConsistentWith(FMFirstName, FMLastName)) {
                System.err.println("Name inconsistency for FM of " + ego + ": " + FMFirstName + " / " + FMLastName + " blocked by " + orFM.getName());
            }
        }
        if (FF != null || FM != null) {
            if (father == null) {
                father = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), "[father of " + ego.getName() + "]", Gender.MALE);
                net.individuals().put(father);
                System.err.println("Missing father for " + ego);
            }
            net.createFamily(FF, FM, father);
        }
        if (!StringUtils.isBlank((CharSequence)(String.valueOf(MFFirstName) + MFLastName))) {
            if (orMF == null) {
                MF = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), String.valueOf(MFFirstName) + " / " + MFLastName, Gender.MALE);
                net.individuals().put(MF);
            } else if (!orMF.hasNameConsistentWith(MFFirstName, MFLastName)) {
                System.err.println("Name inconsistency for MF of " + ego + ": " + MFFirstName + " / " + MFLastName + " blocked by " + orMF.getName());
            }
        }
        if (!StringUtils.isBlank((CharSequence)(String.valueOf(MMFirstName) + MMLastName))) {
            if (orMM == null) {
                MM = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), String.valueOf(MMFirstName) + " / " + MMLastName, Gender.FEMALE);
                net.individuals().put(MM);
            } else if (!orMM.hasNameConsistentWith(MMFirstName, MMLastName)) {
                System.err.println("Name inconsistency for MM of " + ego + ": " + MMFirstName + " / " + MMLastName + " blocked by " + orMM.getName());
            }
        }
        if (MF != null || MM != null) {
            if (mother == null) {
                mother = new Individual(net.individuals().nextFreeId(net.getDefaultIdStrategy()), "[mother of " + ego.getName() + "]", Gender.FEMALE);
                net.individuals().put(mother);
                System.err.println("Missing mother for " + ego);
            }
            net.createFamily(MF, MM, mother);
        }
    }

    public static Graph<Family> createPGraph(Segmentation source) throws PuckException {
        Graph<Family> result = new Graph<Family>("Pgraph " + source.getLabel());
        int familyCount = source.getCurrentFamilies().getLastId();
        for (Individual individual : source.getCurrentIndividuals()) {
            Families personalFamilies;
            Family originFamily = individual.getOriginFamily();
            if (originFamily == null) {
                originFamily = new Family(++familyCount);
                originFamily.getChildren().add(individual);
            }
            if ((personalFamilies = individual.getPersonalFamilies()).size() == 0) {
                Family personalFamily = new Family(++familyCount);
                if (individual.isMale()) {
                    personalFamily.setHusband(individual);
                } else if (individual.isFemale()) {
                    personalFamily.setWife(individual);
                }
            }
            for (Family personalFamily : personalFamilies) {
                int weight = 1 - 2 * (individual.getGender().toInt() % 2);
                result.addArc(originFamily, personalFamily, (double)weight);
            }
        }
        return result;
    }

    public static Graph<Individual> createRelationGraph(Individual source, String relationModelName, String egoRoleName, String alterRoleName) {
        Graph<Individual> result = new Graph<Individual>("Ego network " + source + " " + relationModelName + " " + egoRoleName + "-" + alterRoleName);
        HashMap<String, Integer> tagMap = new HashMap<String, Integer>();
        result.addNode(source);
        for (Relation relation : source.relations()) {
            if (!relation.getRoleNames(source).contains(egoRoleName)) continue;
            Individuals alters = alterRoleName.equals("ALL") ? relation.getIndividuals() : relation.getIndividuals(alterRoleName);
            for (Individual alter : alters) {
                result.addNode(alter);
            }
        }
        for (Individual ego : result.getReferents()) {
            for (Relation relation : ego.relations().getByModelName(relationModelName)) {
                for (Individual alter : relation.getIndividuals()) {
                    if (!result.getReferents().contains(alter)) continue;
                    for (String egoRole : relation.getRoleNames(ego)) {
                        for (String alterRole : relation.getRoleNames(alter)) {
                            Link<Individual> link = null;
                            if (egoRole.equals(alterRole)) {
                                if (ego.getId() < alter.getId()) {
                                    link = result.addEdge(ego, alter, 1.0);
                                }
                            } else if (egoRole.compareTo(alterRole) < 0) {
                                link = result.addArc(ego, alter, 1.0);
                            }
                            if (link == null) continue;
                            String tag = String.valueOf(egoRole) + "-" + alterRole;
                            Integer tagNumber = (Integer)tagMap.get(tag);
                            if (tagNumber == null) {
                                tagNumber = tagMap.size() + 1;
                                tagMap.put(tag, tagNumber);
                            }
                            link.setTag(":" + tagNumber + " '" + tag + "'");
                        }
                    }
                }
            }
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    public static Graph<Individual> createRelationGraph(Segmentation source, String relationName) {
        Graph<Individual> result = new Graph<Individual>("Relation graph " + relationName + " " + source.getLabel());
        for (Individual individual : source.getCurrentIndividuals().toSortedList()) {
            result.addNode(individual);
        }
        HashMap<String, Integer> tagMap = new HashMap<String, Integer>();
        for (Relation relation : source.getCurrentRelations().getByModelName(relationName)) {
            for (Actor egoActor : relation.actors()) {
                String egoRole = egoActor.getRole().getName();
                Individual ego = egoActor.getIndividual();
                for (Actor alterActor : relation.actors()) {
                    String alterRole = alterActor.getRole().getName();
                    Individual alter = alterActor.getIndividual();
                    Link<Individual> link = null;
                    if (egoRole.equals(alterRole)) {
                        if (ego.getId() < alter.getId()) {
                            link = result.addEdge(ego, alter, 1.0);
                        }
                    } else if (egoRole.compareTo(alterRole) < 0) {
                        link = result.addArc(ego, alter, 1.0);
                    }
                    if (link == null) continue;
                    String tag = String.valueOf(egoRole) + "-" + alterRole;
                    Integer tagNumber = (Integer)tagMap.get(tag);
                    if (tagNumber == null) {
                        tagNumber = tagMap.size() + 1;
                        tagMap.put(tag, tagNumber);
                    }
                    link.setTag(":" + tagNumber + " '" + tag + "'");
                }
            }
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    public static RelationModel createRelationsFromAttributes(Net net, String relationLabel, String roleLabel) throws PuckException {
        RelationModel result = net.createRelationModel(relationLabel);
        for (Individual individual : net.individuals()) {
            String relationValue = null;
            String roleValue = null;
            for (Attribute attribute : individual.attributes()) {
                if (attribute.getLabel().equals(relationLabel)) {
                    relationValue = attribute.getValue();
                }
                if (!attribute.getLabel().equals(roleLabel)) continue;
                roleValue = attribute.getValue();
            }
            if (relationValue != null && roleValue == null) {
                roleValue = "OTHER";
            }
            int typedId = Integer.parseInt(relationValue);
            Relation relation = net.relations().getByTypedId(typedId, result);
            if (relation == null) {
                relation = net.createRelation(typedId, String.valueOf(relationLabel) + " " + relationValue, result);
            }
            net.createRelationRole(result, roleValue);
            net.createRelationActor(relation, individual.getId(), roleValue);
        }
        return result;
    }

    public static RelationModel createRelationsFromCircuits(Net net, CircuitFinder finder, RelationModel model) throws PuckException {
        model.roles().add(new Role("PIVOT"));
        model.roles().add(new Role("INTERMEDIARY"));
        int i = 1;
        for (Cluster<Chain> cluster : finder.getCircuits().getClusters().toListSortedByValue()) {
            for (Chain r : cluster.getItems()) {
                Relation relation = net.createRelation(i, r.signature(Notation.NUMBERS), model);
                int j = 0;
                while (j < 2 * r.dim()) {
                    Individual pivot = r.getPivot(j);
                    if (!relation.hasActor(pivot)) {
                        net.createRelationActor(relation, pivot.getId(), "PIVOT");
                    }
                    ++j;
                }
                relation.attributes().add(new Attribute("TYPE", cluster.getValue().toString()));
                relation.attributes().add(new Attribute("CLASSIC", r.signature(Notation.CLASSIC_GENDERED)));
                for (Individual indi : r) {
                    if (relation.hasActor(indi)) continue;
                    if (indi instanceof Couple) {
                        if (((Couple)indi).getFirstId() > 0) {
                            net.createRelationActor(relation, ((Couple)indi).getFirstId(), "INTERMEDIARY");
                        }
                        if (((Couple)indi).getSecondId() <= 0) continue;
                        net.createRelationActor(relation, ((Couple)indi).getSecondId(), "INTERMEDIARY");
                        continue;
                    }
                    net.createRelationActor(relation, indi.getId(), "INTERMEDIARY");
                }
                ++i;
            }
        }
        RelationModel result = model;
        return result;
    }

    public static RelationModel createRelationsFromFamilies(Net net) throws PuckException {
        RelationModel model = net.createRelationModel("FamiliesPlus");
        model.roles().add(new Role("HUSBAND"));
        model.roles().add(new Role("WIFE"));
        model.roles().add(new Role("CHILD"));
        for (Family family : net.families()) {
            Relation relation = net.createRelation(family.getId(), family.hashKey(), model);
            if (family.getHusband() != null) {
                Actor husband = net.createRelationActor(relation, family.getHusband().getId(), "HUSBAND");
                husband.setRelationOrder(family.getHusbandOrder());
            }
            if (family.getWife() != null) {
                Actor wife = net.createRelationActor(relation, family.getWife().getId(), "WIFE");
                wife.setRelationOrder(family.getWifeOrder());
            }
            for (Individual child : family.getChildren()) {
                Actor actor = net.createRelationActor(relation, child.getId(), "CHILD");
                actor.setRelationOrder(child.getBirthOrder());
            }
            relation.attributes().addAll(family.attributes());
        }
        RelationModel result = model;
        return result;
    }

    public static Graph<Individual> createTipGraph(Segmentation source) throws PuckException {
        Graph<Individual> result = new Graph<Individual>("Tip graph " + source.getLabel());
        for (Individual individual : source.getCurrentIndividuals().toSortedList()) {
            result.addNode(individual);
        }
        for (Family family : source.getCurrentFamilies()) {
            Individual father = family.getHusband();
            Individual mother = family.getWife();
            if (father != null && mother != null && family.hasMarried()) {
                Link<Individual> link = result.addArc(mother, father, 1.0);
                link.setTag("1 'H.F'");
            }
            if (family.isSterile()) continue;
            for (Individual child : family.getChildren()) {
                Link<Individual> link;
                String relationPattern;
                int relationCode;
                if (father != null) {
                    switch (child.getGender()) {
                        case FEMALE: {
                            relationCode = 4;
                            relationPattern = "'F(H)'";
                            break;
                        }
                        case MALE: {
                            relationCode = 5;
                            relationPattern = "'H(H)'";
                            break;
                        }
                        default: {
                            relationCode = 7;
                            relationPattern = "'X(H)'";
                        }
                    }
                    link = result.addArc(father, child, (double)relationCode);
                    link.setTag(String.valueOf(relationCode) + " " + relationPattern);
                }
                if (mother == null) continue;
                switch (child.getGender()) {
                    case FEMALE: {
                        relationCode = 2;
                        relationPattern = "'F(F)'";
                        break;
                    }
                    case MALE: {
                        relationCode = 3;
                        relationPattern = "'M(F)'";
                        break;
                    }
                    default: {
                        relationCode = 6;
                        relationPattern = "'X(F)'";
                    }
                }
                link = result.addArc(mother, child, (double)relationCode);
                link.setTag(String.valueOf(relationCode) + " " + relationPattern);
            }
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    public static boolean isAnonymous(Individual individual) {
        boolean result = NumberUtils.isNumber((String)individual.getFirstName()) || StringUtils.isBlank((CharSequence)individual.getName()) || individual.getName().equals("?") || individual.getName().charAt(0) == '#';
        return result;
    }

    public static void eliminateDoubleIndividuals(Net source, Individuals sample, Report report) {
        Iterator iterator;
        List individuals = sample.toList();
        HashMap<Integer, Integer> originalIds = new HashMap<Integer, Integer>();
        ArrayList<Integer> inexistentOriginalIds = new ArrayList<Integer>();
        ArrayList<Integer> selfReferentialOriginals = new ArrayList<Integer>();
        ArrayList<Integer> unreplacedIds = new ArrayList<Integer>();
        StringList conflictingParents = new StringList();
        StringList individualReplacements = new StringList();
        StringList familyReplacements = new StringList();
        StringList conflictingUnionStatus = new StringList();
        Report attributeErrorReport = new Report();
        int indiCount = 0;
        int familyCount = 0;
        for (Individual sourceIndividual : individuals) {
            if (!NumberUtils.isNumber((String)sourceIndividual.getFirstName())) continue;
            int originalId = Integer.parseInt(sourceIndividual.getFirstName());
            if (originalId == sourceIndividual.getId()) {
                selfReferentialOriginals.add(originalId);
                continue;
            }
            Individual targetIndividual = (Individual)source.individuals().getById(originalId);
            while (targetIndividual == null) {
                if (originalIds.get(originalId) == null) {
                    inexistentOriginalIds.add(originalId);
                    break;
                }
                originalId = (Integer)originalIds.get(originalId);
                targetIndividual = (Individual)source.individuals().getById(originalId);
            }
            if (targetIndividual == null) {
                unreplacedIds.add(sourceIndividual.getId());
                continue;
            }
            originalIds.put(sourceIndividual.getId(), originalId);
            String track = targetIndividual.getAttributeValue("DOUBLE");
            track = track == null ? String.valueOf(sourceIndividual.getId()) : String.valueOf(track) + ";" + String.valueOf(sourceIndividual.getId());
            targetIndividual.setAttribute("DOUBLE", track);
            UpdateWorker.update("I\t" + targetIndividual.toString(), targetIndividual.attributes(), sourceIndividual.attributes(), attributeErrorReport, UpdateWorker.UpdateMode.APPEND);
            if (targetIndividual.getFather() == null && sourceIndividual.getFather() != null) {
                NetUtils.setFatherRelation(source, sourceIndividual.getFather().getId(), targetIndividual.getId());
            } else if (!(targetIndividual.getFather() == null || sourceIndividual.getFather() == null || targetIndividual.getFather() == sourceIndividual.getFather() || NumberUtils.isNumber((String)sourceIndividual.getFather().getFirstName()) && Integer.parseInt(sourceIndividual.getFather().getFirstName()) == targetIndividual.getFather().getId() || NumberUtils.isNumber((String)targetIndividual.getFather().getFirstName()) && Integer.parseInt(targetIndividual.getFather().getFirstName()) == sourceIndividual.getFather().getId() || NumberUtils.isNumber((String)sourceIndividual.getFather().getFirstName()) && NumberUtils.isNumber((String)targetIndividual.getFather().getFirstName()) && Integer.parseInt(sourceIndividual.getFather().getFirstName()) == Integer.parseInt(targetIndividual.getFather().getFirstName()))) {
                conflictingParents.appendln("Father conflict for " + targetIndividual + ":\t" + sourceIndividual.getFather() + " vs " + targetIndividual.getFather());
                targetIndividual.setAttribute("F_ALT", "" + sourceIndividual.getFather());
            }
            if (targetIndividual.getMother() == null && sourceIndividual.getMother() != null) {
                NetUtils.setMotherRelation(source, sourceIndividual.getMother().getId(), targetIndividual.getId());
            } else if (!(targetIndividual.getMother() == null || sourceIndividual.getMother() == null || targetIndividual.getMother() == sourceIndividual.getMother() || NumberUtils.isNumber((String)sourceIndividual.getMother().getFirstName()) && Integer.parseInt(sourceIndividual.getMother().getFirstName()) == targetIndividual.getMother().getId() || NumberUtils.isNumber((String)targetIndividual.getMother().getFirstName()) && Integer.parseInt(targetIndividual.getMother().getFirstName()) == sourceIndividual.getMother().getId() || NumberUtils.isNumber((String)sourceIndividual.getMother().getFirstName()) && NumberUtils.isNumber((String)targetIndividual.getMother().getFirstName()) && Integer.parseInt(sourceIndividual.getMother().getFirstName()) == Integer.parseInt(targetIndividual.getMother().getFirstName()))) {
                conflictingParents.appendln("Mother conflict for " + targetIndividual + ":\t" + sourceIndividual.getMother() + " vs " + targetIndividual.getMother());
                targetIndividual.setAttribute("M_ALT", "" + sourceIndividual.getMother());
            }
            for (Family sourceIndividualFamily : sourceIndividual.getPersonalFamilies().toSortedList()) {
                Family targetIndividualFamily = null;
                if (sourceIndividual == sourceIndividualFamily.getHusband()) {
                    targetIndividualFamily = source.families().getBySpouses(targetIndividual, sourceIndividualFamily.getWife());
                    sourceIndividualFamily.setHusband(targetIndividual);
                } else if (sourceIndividual == sourceIndividualFamily.getWife()) {
                    targetIndividualFamily = source.families().getBySpouses(sourceIndividualFamily.getHusband(), targetIndividual);
                    sourceIndividualFamily.setWife(targetIndividual);
                }
                targetIndividual.addPersonalFamily(sourceIndividualFamily);
                if (targetIndividualFamily == null) continue;
                Family sourceFamily = null;
                Family targetFamily = null;
                if (targetIndividualFamily.getId() > sourceIndividualFamily.getId()) {
                    targetFamily = sourceIndividualFamily;
                    sourceFamily = targetIndividualFamily;
                } else {
                    targetFamily = targetIndividualFamily;
                    sourceFamily = sourceIndividualFamily;
                }
                targetFamily.getChildren().add(sourceFamily.getChildren());
                for (Individual child : sourceFamily.getChildren()) {
                    child.setOriginFamily(targetFamily);
                }
                UpdateWorker.update("F\t" + targetFamily.toString(), targetFamily.attributes(), sourceFamily.attributes(), attributeErrorReport, UpdateWorker.UpdateMode.APPEND);
                if (targetFamily.getUnionStatus() != sourceFamily.getUnionStatus()) {
                    if (targetFamily.getUnionStatus().isUnmarried()) {
                        conflictingUnionStatus.appendln(String.valueOf(targetFamily.getId()) + ": changed status\t" + (Object)((Object)targetFamily.getUnionStatus()) + "\t->\t" + (Object)((Object)sourceFamily.getUnionStatus()));
                        targetFamily.setUnionStatus(sourceFamily.getUnionStatus());
                    } else {
                        conflictingUnionStatus.appendln(String.valueOf(targetFamily.getId()) + ": not changed status\t" + (Object)((Object)targetFamily.getUnionStatus()) + "\t->|\t" + (Object)((Object)sourceFamily.getUnionStatus()));
                    }
                }
                sourceFamily.getHusband().getPersonalFamilies().removeById(sourceFamily.getId());
                sourceFamily.getWife().getPersonalFamilies().removeById(sourceFamily.getId());
                source.families().removeById(sourceFamily.getId());
                String famTrack = targetFamily.getAttributeValue("DOUBLE");
                famTrack = famTrack == null ? String.valueOf(sourceFamily.getId()) : String.valueOf(famTrack) + ";" + String.valueOf(sourceFamily.getId());
                targetFamily.setAttribute("DOUBLE", famTrack);
                ++familyCount;
                familyReplacements.appendln(String.valueOf(sourceFamily.getId()) + " > " + targetFamily.getId());
            }
            source.remove(sourceIndividual);
            individualReplacements.appendln(String.valueOf(sourceIndividual.getId()) + " > " + targetIndividual);
            ++indiCount;
        }
        Families targetFamilies = new Families();
        for (Family sourceFamily : source.families().toSortedList()) {
            Family targetFamily = targetFamilies.getBySpouses(sourceFamily.getFather(), sourceFamily.getMother());
            if (targetFamily == null) {
                targetFamilies.add(sourceFamily);
                continue;
            }
            targetFamily.getChildren().add(sourceFamily.getChildren());
            for (Individual child : sourceFamily.getChildren()) {
                child.setOriginFamily(targetFamily);
            }
            UpdateWorker.update("F\t" + targetFamily.toString(), targetFamily.attributes(), sourceFamily.attributes(), attributeErrorReport, UpdateWorker.UpdateMode.APPEND);
            if (targetFamily.getUnionStatus() != sourceFamily.getUnionStatus()) {
                if (targetFamily.getUnionStatus().isUnmarried()) {
                    conflictingUnionStatus.appendln(String.valueOf(targetFamily.getId()) + ": changed status\t" + (Object)((Object)targetFamily.getUnionStatus()) + "\t->\t" + (Object)((Object)sourceFamily.getUnionStatus()));
                    targetFamily.setUnionStatus(sourceFamily.getUnionStatus());
                } else {
                    conflictingUnionStatus.appendln(String.valueOf(targetFamily.getId()) + ": not changed status\t" + (Object)((Object)targetFamily.getUnionStatus()) + "\t->|\t" + (Object)((Object)sourceFamily.getUnionStatus()));
                }
            }
            sourceFamily.getHusband().getPersonalFamilies().removeById(sourceFamily.getId());
            sourceFamily.getWife().getPersonalFamilies().removeById(sourceFamily.getId());
            source.families().removeById(sourceFamily.getId());
            String famTrack = targetFamily.getAttributeValue("DOUBLE");
            famTrack = famTrack == null ? String.valueOf(sourceFamily.getId()) : String.valueOf(famTrack) + ";" + String.valueOf(sourceFamily.getId());
            targetFamily.setAttribute("DOUBLE", famTrack);
            ++familyCount;
            familyReplacements.appendln(String.valueOf(sourceFamily.getId()) + " > " + targetFamily.getId());
        }
        StringList reportList = new StringList();
        if (inexistentOriginalIds.size() > 0) {
            reportList.append("Inexistent original individuals: ");
            iterator = inexistentOriginalIds.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                reportList.append(String.valueOf(id) + " ");
            }
            reportList.appendln();
        }
        if (selfReferentialOriginals.size() > 0) {
            reportList.append("Selfreferential original individuals: ");
            iterator = selfReferentialOriginals.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                reportList.append(String.valueOf(id) + " ");
            }
            reportList.appendln();
        }
        if (unreplacedIds.size() > 0) {
            reportList.append("Unreplaced individual ids: ");
            iterator = unreplacedIds.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                reportList.append(String.valueOf(id) + " ");
            }
            reportList.appendln();
        }
        reportList.appendln();
        if (conflictingParents.size() > 0) {
            reportList.appendln("Conflicting parents: ");
            reportList.append(conflictingParents);
            reportList.appendln();
        }
        report.outputs().append(reportList);
        if (attributeErrorReport.outputs().isNotEmpty()) {
            report.outputs().appendln("Conflicting attributes: ");
            report.outputs().append(attributeErrorReport.outputs());
            report.outputs().appendln();
        }
        if (conflictingUnionStatus.size() > 0) {
            report.outputs().appendln("Conflicting union Status: ");
            report.outputs().append(conflictingUnionStatus);
            report.outputs().appendln();
        }
        if (individualReplacements.size() > 0) {
            report.outputs().appendln("Replaced individuals: " + indiCount);
            report.outputs().appendln(individualReplacements);
            report.outputs().appendln();
        }
        if (familyReplacements.size() > 0) {
            report.outputs().appendln("Replaced families: " + familyCount);
            report.outputs().appendln(familyReplacements);
            report.outputs().appendln();
        }
    }

    public static void eliminateDoubleRelations(Net source, Relations sample, Report report) {
        List relations = sample.toSortedList();
        HashMap<Integer, Integer> originalIds = new HashMap<Integer, Integer>();
        ArrayList<Integer> inexistentOriginals = new ArrayList<Integer>();
        ArrayList<Integer> selfReferentialOriginals = new ArrayList<Integer>();
        ArrayList<Integer> unreplacedIds = new ArrayList<Integer>();
        StringList replacements = new StringList();
        Report attributeErrorReport = new Report();
        int count = 0;
        for (Relation sourceRelation : relations) {
            if (!NumberUtils.isNumber((String)sourceRelation.getName())) continue;
            int originalTypedId = Integer.parseInt(sourceRelation.getName());
            RelationModel model = sourceRelation.getModel();
            if (originalTypedId == sourceRelation.getTypedId()) {
                selfReferentialOriginals.add(originalTypedId);
                continue;
            }
            Relation targetRelation = source.relations().getByTypedId(originalTypedId, model);
            while (targetRelation == null) {
                if (originalIds.get(originalTypedId) == null) {
                    inexistentOriginals.add(originalTypedId);
                    break;
                }
                originalTypedId = (Integer)originalIds.get(originalTypedId);
                targetRelation = source.relations().getByTypedId(originalTypedId, model);
            }
            if (targetRelation == null) {
                unreplacedIds.add(sourceRelation.getTypedId());
                continue;
            }
            originalIds.put(sourceRelation.getTypedId(), originalTypedId);
            String track = targetRelation.getAttributeValue("DOUBLE");
            track = track == null ? String.valueOf(sourceRelation.getTypedId()) : String.valueOf(track) + ";" + String.valueOf(sourceRelation.getTypedId());
            targetRelation.setAttribute("DOUBLE", track);
            UpdateWorker.update(targetRelation.toString(), targetRelation.attributes(), sourceRelation.attributes(), attributeErrorReport, UpdateWorker.UpdateMode.APPEND);
            for (Actor sourceActor : sourceRelation.actors().toList()) {
                Individual individual = sourceActor.getIndividual();
                if (!targetRelation.actors().contains(sourceActor)) {
                    targetRelation.actors().add(sourceActor);
                    individual.relations().add(targetRelation);
                } else {
                    Actor targetActor = targetRelation.getActor(sourceActor);
                    UpdateWorker.update("A\t" + targetActor.toString(), targetActor.attributes(), sourceActor.attributes(), attributeErrorReport, UpdateWorker.UpdateMode.APPEND);
                }
                sourceRelation.removeActor(sourceActor);
                individual.relations().remove(sourceRelation);
            }
            source.remove(sourceRelation);
            replacements.appendln(String.valueOf(sourceRelation.getId()) + " > " + targetRelation);
            ++count;
        }
        StringList reportList = new StringList();
        reportList.appendln("Relations replaced: " + count);
        reportList.appendln();
        if (inexistentOriginals.size() > 0) {
            reportList.append("Inexistent original relations: ");
            Iterator iterator = inexistentOriginals.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                reportList.append(String.valueOf(id) + " ");
            }
            reportList.appendln();
        }
        if (selfReferentialOriginals.size() > 0) {
            reportList.append("Selfreferential original relations: ");
            Iterator iterator = selfReferentialOriginals.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                reportList.append(String.valueOf(id) + " ");
            }
            reportList.appendln();
        }
        if (unreplacedIds.size() > 0) {
            reportList.append("Unreplaced relation ids: ");
            Iterator iterator = unreplacedIds.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                reportList.append(String.valueOf(id) + " ");
            }
            reportList.appendln();
        }
        report.outputs().append(reportList);
        if (attributeErrorReport.outputs().isNotEmpty()) {
            report.outputs().appendln("Conflicting attributes: ");
            report.outputs().append(attributeErrorReport.outputs());
            report.outputs().appendln();
        }
        if (replacements.size() > 0) {
            report.outputs().appendln("Replacements: ");
            report.outputs().appendln(replacements);
            report.outputs().appendln();
        }
    }

    public static int eliminateSingles(Net source, Report report) {
        int result = NetUtils.eliminateSingles(source, source.individuals(), report);
        return result;
    }

    public static int eliminateSingles(Net source, Individuals sample, Report report) {
        StringList list = new StringList();
        int result = 0;
        for (Individual individual : sample.toSortedList()) {
            if (!individual.isSingle()) continue;
            source.remove(individual);
            list.appendln(individual.toString());
            ++result;
        }
        report.outputs().appendln(String.valueOf(result) + " Individuals removed:");
        report.outputs().appendln();
        report.outputs().append(list);
        return result;
    }

    public static int eliminateStructuralChildren(Net source, Report report) {
        int result = NetUtils.eliminateStructuralChildren(source, source.individuals(), report);
        return result;
    }

    public static int eliminateStructuralChildren(Net source, Individuals sample, Report report) {
        StringList list = new StringList();
        int result = 0;
        for (Individual individual : sample.toSortedList()) {
            if (!individual.isSingle() || !individual.isSterile()) continue;
            source.remove(individual);
            list.appendln(individual.toString());
            ++result;
        }
        report.outputs().appendln(String.valueOf(result) + " Individuals removed:");
        report.outputs().appendln();
        report.outputs().append(list);
        return result;
    }

    public static int eliminateVirtuals(Net source, Report report) {
        int result = NetUtils.eliminateVirtualParents(source, source.individuals(), report);
        return result;
    }

    public static int eliminateVirtualParents(Net source, Individuals sample, Report report) {
        StringList list = new StringList();
        int result = 0;
        for (Individual individual : sample.toSortedList()) {
            if (!StringUtils.isBlank((CharSequence)individual.getName()) && !individual.getName().equals("?") && individual.getName().charAt(0) != '#' || !individual.isOrphan() || !individual.attributes().isEmpty() || !individual.relations().isEmpty() || individual.getPersonalFamilies().size() >= 2) continue;
            source.remove(individual);
            list.appendln(String.valueOf(individual.toString()) + "\tchildren: " + individual.children());
            ++result;
        }
        report.outputs().appendln(String.valueOf(result) + " Individuals removed: ");
        report.outputs().appendln();
        report.outputs().append(list);
        return result;
    }

    public static void enlargeNetFromAttributes(Net net, String fatherFirstNameLabel, String fatherLastNameLabel, String motherFirstNameLabel, String motherLastNameLabel, String husbandFirstNameLabel, String husbandLastNameLabel, String wifeFirstNameLabel, String wifeLastNameLabel, Map<String, String> husbandLabels, Map<String, String> wifeLabels, String FFFirstNameLabel, String FFLastNameLabel, String FMFirstNameLabel, String FMLastNameLabel, String MFFirstNameLabel, String MFLastNameLabel, String MMFirstNameLabel, String MMLastNameLabel) throws PuckException {
        for (Family family : net.families().toSortedList()) {
            NetUtils.createIndividualsFromFamilyAttributes(net, family, husbandFirstNameLabel, husbandLastNameLabel, wifeFirstNameLabel, wifeLastNameLabel, husbandLabels, wifeLabels);
        }
        for (Individual ego : net.individuals().toSortedList()) {
            NetUtils.createOriginFamilyFromIndividualAttributes(net, ego, fatherFirstNameLabel, fatherLastNameLabel, motherFirstNameLabel, motherLastNameLabel);
        }
        for (Individual ego : net.individuals().toSortedList()) {
            NetUtils.createGrandParentsFromIndividualAttributes(net, ego, FFFirstNameLabel, FFLastNameLabel, FMFirstNameLabel, FMLastNameLabel, MFFirstNameLabel, MFLastNameLabel, MMFirstNameLabel, MMLastNameLabel);
        }
    }

    public static Individuals neighbors(Individual ego, ExpansionMode expansionMode, FiliationType filiationType) {
        Individuals result = new Individuals();
        switch (expansionMode) {
            case ALL: {
                result = ego.getRelated();
                result.add(ego.getKin());
                result.add(ego.getPartners());
                break;
            }
            case CHILD: {
                result = ego.getKin(KinType.CHILD, filiationType);
                break;
            }
            case KIN: {
                result = ego.getKin();
                break;
            }
            case PARENT: {
                result = ego.getKin(KinType.PARENT, filiationType);
                break;
            }
            case RELATED: {
                result = ego.getRelated();
                break;
            }
            case SPOUSE: {
                result = ego.getKin(KinType.SPOUSE, filiationType);
                break;
            }
            default: {
                KinType kinType = KinType.valueOf(expansionMode.toString());
                result = ego.getKin(kinType, filiationType);
            }
        }
        return result;
    }

    public static Individuals expand(Individuals seeds, ExpansionMode expansionMode, FiliationType filiationType, String seedLabel, int maxStep) {
        Individuals result = new Individuals();
        String label = "STEP_" + seedLabel.replaceAll(" ", "_") + "_" + (Object)((Object)expansionMode);
        if (filiationType != FiliationType.COGNATIC) {
            label = String.valueOf(label) + "_" + (Object)((Object)filiationType);
        }
        LinkedList<Individual> queue = new LinkedList<Individual>();
        for (Individual seed : seeds) {
            queue.add(seed);
            result.add(seed);
            seed.setAttribute(label, "0");
        }
        while (!queue.isEmpty()) {
            Individual ego = (Individual)queue.remove();
            int step = Integer.parseInt(ego.getAttributeValue(label)) + 1;
            if (maxStep > 0 && step > maxStep) continue;
            Individuals neighbors = NetUtils.neighbors(ego, expansionMode, filiationType);
            for (Individual neighbor : neighbors) {
                if (result.contains(neighbor)) continue;
                queue.add(neighbor);
                result.add(neighbor);
                neighbor.setAttribute(label, String.valueOf(step));
            }
        }
        return result;
    }

    public static Net expand(Net source, Individuals seeds, String seedLabel, ExpansionMode expansionMode, FiliationType filiationType, int maxStep) {
        Individuals individuals = NetUtils.expand(seeds, expansionMode, filiationType, seedLabel, maxStep);
        Net result = NetUtils.extract(source, individuals);
        String title = String.valueOf(result.getLabel()) + "_" + seedLabel + "_" + (Object)((Object)expansionMode);
        result.setLabel(title);
        return result;
    }

    public static Net extract(Net source, Families sourceFamilies) {
        Net result = new Net();
        result.setLabel(source.getLabel());
        result.attributes().addAll(source.attributes());
        for (Family sourceFamily : sourceFamilies) {
            Family targetFamily = new Family(sourceFamily.getId());
            targetFamily.setMarried(sourceFamily.hasMarried());
            targetFamily.setHusbandOrder(sourceFamily.getHusbandOrder());
            targetFamily.setWifeOrder(sourceFamily.getWifeOrder());
            targetFamily.attributes().addAll(sourceFamily.attributes());
            result.families().add(targetFamily);
        }
        for (Individual sourceIndividual : source.individuals()) {
            Family targetOriginFamily;
            Individual targetIndividual = new Individual(sourceIndividual.getId());
            targetIndividual.setName(sourceIndividual.getName());
            targetIndividual.setGender(sourceIndividual.getGender());
            targetIndividual.setBirthOrder(sourceIndividual.getBirthOrder());
            targetIndividual.attributes().addAll(sourceIndividual.attributes());
            if (sourceIndividual.getOriginFamily() != null && (targetOriginFamily = (Family)result.families().getById(sourceIndividual.getOriginFamily().getId())) != null) {
                targetIndividual.setOriginFamily(targetOriginFamily);
                targetOriginFamily.getChildren().add(targetIndividual);
            }
            for (Family sourcePersonalFamily : sourceIndividual.getPersonalFamilies()) {
                Family targetPersonalFamily = (Family)result.families().getById(sourcePersonalFamily.getId());
                if (targetPersonalFamily == null) continue;
                targetIndividual.getPersonalFamilies().add(targetPersonalFamily);
                if (sourcePersonalFamily.isFather(sourceIndividual)) {
                    targetPersonalFamily.setFather(targetIndividual);
                }
                if (!sourcePersonalFamily.isMother(sourceIndividual)) continue;
                targetPersonalFamily.setMother(targetIndividual);
            }
            if (targetIndividual.getOriginFamily() == null && targetIndividual.getPersonalFamilies().isEmpty()) continue;
            result.individuals().add(targetIndividual);
        }
        result.relationModels().addAll(source.relationModels());
        for (Relation sourceRelation : source.relations()) {
            RelationModel targetModel = result.relationModels().getByName(sourceRelation.getModel().getName());
            Relation targetRelation = new Relation(sourceRelation.getId(), sourceRelation.getTypedId(), targetModel, sourceRelation.getName(), new Actor[0]);
            targetRelation.attributes().addAll(sourceRelation.attributes());
            for (Actor sourceActor : sourceRelation.actors()) {
                Individual targetIndividual = (Individual)result.individuals().getById(sourceActor.getId());
                if (targetIndividual == null) continue;
                Actor targetActor = new Actor(targetIndividual, targetModel.roles().getByName(sourceActor.getRole().getName()));
                targetActor.setRelationOrder(sourceActor.getRelationOrder());
                targetRelation.actors().add(targetActor);
                targetIndividual.relations().add(targetRelation);
            }
            if (targetRelation.actors().isEmpty()) continue;
            result.relations().add(targetRelation);
        }
        return result;
    }

    public static Net extract(Net source, Individuals sourceIndividuals) {
        Net result = new Net();
        result.setLabel(source.getLabel());
        result.attributes().addAll(source.attributes());
        for (Individual sourceIndividual : sourceIndividuals) {
            Individual targetIndividual = new Individual(sourceIndividual.getId());
            targetIndividual.setName(sourceIndividual.getName());
            targetIndividual.setGender(sourceIndividual.getGender());
            targetIndividual.setBirthOrder(sourceIndividual.getBirthOrder());
            targetIndividual.attributes().addAll(sourceIndividual.attributes());
            result.individuals().add(targetIndividual);
        }
        for (Family sourceFamily : source.families()) {
            Individual targetMother;
            Individual sourceMother;
            Individual targetFather;
            Family targetFamily = new Family(sourceFamily.getId());
            targetFamily.setMarried(sourceFamily.hasMarried());
            targetFamily.setHusbandOrder(sourceFamily.getHusbandOrder());
            targetFamily.setWifeOrder(sourceFamily.getWifeOrder());
            targetFamily.attributes().addAll(sourceFamily.attributes());
            Individual sourceFather = sourceFamily.getFather();
            if (sourceFather != null && (targetFather = (Individual)result.individuals().getById(sourceFather.getId())) != null) {
                targetFamily.setFather(targetFather);
            }
            if ((sourceMother = sourceFamily.getMother()) != null && (targetMother = (Individual)result.individuals().getById(sourceMother.getId())) != null) {
                targetFamily.setMother(targetMother);
            }
            for (Individual sourceChild : sourceFamily.getChildren()) {
                Individual targetChild = (Individual)result.individuals().getById(sourceChild.getId());
                if (targetChild == null) continue;
                targetFamily.getChildren().add(targetChild);
            }
            if (!(targetFamily.getFather() != null && targetFamily.getMother() != null || targetFamily.getFather() != null && !targetFamily.getChildren().isEmpty()) && (targetFamily.getMother() == null || targetFamily.getChildren().isEmpty())) continue;
            if (targetFamily.getFather() != null) {
                targetFamily.getFather().getPersonalFamilies().add(targetFamily);
            }
            if (targetFamily.getMother() != null) {
                targetFamily.getMother().getPersonalFamilies().add(targetFamily);
            }
            for (Individual targetChild : targetFamily.getChildren()) {
                targetChild.setOriginFamily(targetFamily);
            }
            result.families().add(targetFamily);
        }
        result.relationModels().addAll(source.relationModels());
        for (Relation sourceRelation : source.relations()) {
            RelationModel targetModel = result.relationModels().getByName(sourceRelation.getModel().getName());
            Relation targetRelation = new Relation(sourceRelation.getId(), sourceRelation.getTypedId(), targetModel, sourceRelation.getName(), new Actor[0]);
            targetRelation.attributes().addAll(sourceRelation.attributes());
            for (Actor sourceActor : sourceRelation.actors()) {
                Individual targetIndividual = (Individual)result.individuals().getById(sourceActor.getId());
                if (targetIndividual == null) continue;
                Actor targetActor = new Actor(targetIndividual, targetModel.roles().getByName(sourceActor.getRole().getName()));
                targetActor.setRelationOrder(sourceActor.getRelationOrder());
                targetActor.attributes().addAll(sourceActor.attributes());
                targetRelation.actors().add(targetActor);
                targetIndividual.relations().add(targetRelation);
            }
            if (targetRelation.actors().isEmpty()) continue;
            result.relations().add(targetRelation);
        }
        return result;
    }

    public static Net extract(Net source, Relations sourceRelations) {
        Net result = new Net();
        result.setLabel(source.getLabel());
        result.attributes().addAll(source.attributes());
        result.relationModels().addAll(source.relationModels());
        for (Relation sourceRelation : sourceRelations) {
            RelationModel targetModel = result.relationModels().getByName(sourceRelation.getModel().getName());
            Relation targetRelation = new Relation(sourceRelation.getId(), sourceRelation.getTypedId(), targetModel, sourceRelation.getName(), new Actor[0]);
            targetRelation.attributes().addAll(sourceRelation.attributes());
            result.relations().add(targetRelation);
        }
        for (Individual sourceIndividual : source.individuals()) {
            Individual targetIndividual = new Individual(sourceIndividual.getId());
            targetIndividual.setName(sourceIndividual.getName());
            targetIndividual.setGender(sourceIndividual.getGender());
            targetIndividual.setBirthOrder(sourceIndividual.getBirthOrder());
            targetIndividual.attributes().addAll(sourceIndividual.attributes());
            for (Relation sourceRelation : sourceIndividual.relations()) {
                RelationModel targetModel = result.relationModels().getByName(sourceRelation.getModel().getName());
                Relation targetRelation = (Relation)result.relations().getById(sourceRelation.getId());
                if (targetRelation == null) continue;
                targetIndividual.relations().add(targetRelation);
                for (Actor sourceActor : sourceRelation.actors()) {
                    if (sourceActor.getIndividual() != sourceIndividual) continue;
                    Actor targetActor = new Actor(targetIndividual, targetModel.roles().getByName(sourceActor.getRole().getName()));
                    targetActor.setRelationOrder(sourceActor.getRelationOrder());
                    targetRelation.actors().add(targetActor);
                }
            }
            if (!targetIndividual.relations().isEmpty()) continue;
            result.individuals().add(targetIndividual);
        }
        for (Family sourceFamily : source.families()) {
            Individual targetMother;
            Individual sourceMother;
            Individual targetFather;
            Family targetFamily = new Family(sourceFamily.getId());
            targetFamily.setMarried(sourceFamily.hasMarried());
            targetFamily.setHusbandOrder(sourceFamily.getHusbandOrder());
            targetFamily.setWifeOrder(sourceFamily.getWifeOrder());
            targetFamily.attributes().addAll(sourceFamily.attributes());
            Individual sourceFather = sourceFamily.getFather();
            if (sourceFather != null && (targetFather = (Individual)result.individuals().getById(sourceFather.getId())) != null) {
                targetFamily.setFather(targetFather);
                targetFather.getPersonalFamilies().add(targetFamily);
            }
            if ((sourceMother = sourceFamily.getMother()) != null && (targetMother = (Individual)result.individuals().getById(sourceMother.getId())) != null) {
                targetFamily.setMother(targetMother);
                targetMother.getPersonalFamilies().add(targetFamily);
            }
            for (Individual sourceChild : sourceFamily.getChildren()) {
                Individual targetChild = (Individual)result.individuals().getById(sourceChild.getId());
                if (targetChild == null) continue;
                targetFamily.getChildren().add(targetChild);
                targetChild.setOriginFamily(targetFamily);
            }
            if (targetFamily.getFather() == null && targetFamily.getMother() == null && targetFamily.getChildren().isEmpty()) continue;
            result.families().add(targetFamily);
        }
        return result;
    }

    public static Net extract(Net source, Segment segment, String segmentLabel) {
        Net result;
        if (source == null || segment == null) {
            result = null;
        } else {
            PartitionCriteria criteria = segment.getCriteria();
            if (criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.INDIVIDUAL.toString())) {
                Partition<?> partition = segment.getPartition();
                Individuals individuals = new Individuals();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull()) continue;
                    individuals.add(cluster.getItems());
                }
                result = NetUtils.extract(source, individuals);
            } else if (criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.FAMILY.toString())) {
                Partition<?> partition = segment.getPartition();
                Families families = new Families();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull()) continue;
                    families.add(cluster.getItems());
                }
                result = NetUtils.extract(source, families);
            } else {
                Partition<?> partition = segment.getPartition();
                Relations relations = new Relations();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull()) continue;
                    relations.add(cluster.getItems());
                }
                result = NetUtils.extract(source, relations);
            }
            result.setLabel(segmentLabel);
        }
        return result;
    }

    public static Net extractByClusterSize(Net source, Segment segment, String segmentLabel, int minimalNumberOfMembers) throws PuckException {
        Net result;
        if (source == null || segment == null) {
            result = null;
        } else {
            PartitionCriteria criteria = segment.getCriteria();
            if (criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.INDIVIDUAL.toString())) {
                Partition<?> partition = segment.getPartition();
                Individuals individuals = new Individuals();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull() || cluster.count() < minimalNumberOfMembers) continue;
                    individuals.add(cluster.getItems());
                }
                result = NetUtils.extract(source, individuals);
            } else if (criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.FAMILY.toString())) {
                Partition<?> partition = segment.getPartition();
                Families families = new Families();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull() || cluster.count() < minimalNumberOfMembers) continue;
                    families.add(cluster.getItems());
                }
                result = NetUtils.extract(source, families);
            } else {
                Partition<?> partition = segment.getPartition();
                Relations relations = new Relations();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull() || cluster.count() < minimalNumberOfMembers) continue;
                    relations.add(cluster.getItems());
                }
                result = NetUtils.extract(source, relations);
            }
            result.setLabel(segmentLabel);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Net extractByClusterSize(Net source, String label, String labelParameter, int minimalNumberOfMembers) throws PuckException {
        void var7_10;
        Partition<Individual> partition = PartitionMaker.createRaw(source, label, labelParameter);
        Individuals individuals = new Individuals();
        for (Cluster<Individual> cluster : partition.getClusters()) {
            if (cluster.isNull() || cluster.count() < minimalNumberOfMembers) continue;
            individuals.add(cluster.getItems());
        }
        Net result = NetUtils.extract(source, individuals);
        if (StringUtils.isBlank((CharSequence)labelParameter)) {
            String string = String.valueOf(result.getLabel()) + "_" + label + "_min_" + minimalNumberOfMembers;
        } else {
            String string = String.valueOf(result.getLabel()) + "_" + label + " " + labelParameter + "_min_" + minimalNumberOfMembers;
        }
        result.setLabel((String)var7_10);
        return result;
    }

    public static Net extractByClusterValue(Net source, Segment segment, String segmentLabel, int minimalValue) throws PuckException {
        Net result;
        if (source == null || segment == null) {
            result = null;
        } else {
            PartitionCriteria criteria = segment.getCriteria();
            if (criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.INDIVIDUAL.toString())) {
                Partition<?> partition = segment.getPartition();
                Individuals individuals = new Individuals();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull() || !(cluster.getValue().doubleValue() >= (double)minimalValue)) continue;
                    individuals.add(cluster.getItems());
                }
                result = NetUtils.extract(source, individuals);
            } else if (criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.FAMILY.toString())) {
                Partition<?> partition = segment.getPartition();
                Families families = new Families();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull() || !(cluster.getValue().doubleValue() >= (double)minimalValue)) continue;
                    families.add(cluster.getItems());
                }
                result = null;
            } else {
                Partition<?> partition = segment.getPartition();
                Relations relations = new Relations();
                for (Cluster<?> cluster : partition.getClusters()) {
                    if (cluster.isNull() || !(cluster.getValue().doubleValue() >= (double)minimalValue)) continue;
                    relations.add(cluster.getItems());
                }
                result = null;
            }
            result.setLabel(segmentLabel);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Net extractByClusterValue(Net source, String label, String labelParameter, int minimalValue) throws PuckException {
        void var7_10;
        Partition<Individual> partition = PartitionMaker.createRaw(source, label, labelParameter);
        Individuals individuals = new Individuals();
        for (Cluster<Individual> cluster : partition.getClusters()) {
            if (cluster.isNull() || !(cluster.getValue().doubleValue() >= (double)minimalValue)) continue;
            individuals.add(cluster.getItems());
        }
        Net result = NetUtils.extract(source, individuals);
        if (StringUtils.isBlank((CharSequence)labelParameter)) {
            String string = String.valueOf(result.getLabel()) + "_" + label + "_min_" + minimalValue;
        } else {
            String string = String.valueOf(result.getLabel()) + "_" + label + " " + labelParameter + "_min_" + minimalValue;
        }
        result.setLabel((String)var7_10);
        return result;
    }

    public static Net extractMaxComponent(Net source, Segmentation segmentation) {
        Net result;
        if (source == null || segmentation == null) {
            result = null;
        } else {
            Cluster<Individual> maxComponent = StatisticsWorker.components(segmentation.getCurrentIndividuals()).maxCluster();
            result = NetUtils.extract(source, new Individuals(maxComponent.getItems()));
        }
        return result;
    }

    public static Net extractCurrentCluster(Net source, Segmentation segmentation) {
        Net result;
        if (source == null || segmentation == null) {
            result = null;
        } else if (segmentation.isAtTheTop()) {
            result = new Net(source);
        } else {
            PartitionCriteria criteria = segmentation.getCurrentSegment().getCriteria();
            result = criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.INDIVIDUAL.toString()) ? NetUtils.extract(source, segmentation.getCurrentIndividuals()) : (criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.FAMILY.toString()) ? NetUtils.extract(source, segmentation.getCurrentFamilies()) : NetUtils.extract(source, segmentation.getCurrentRelations()));
            result.setLabel("Extact current cluster");
        }
        return result;
    }

    public static Individual fixFatherByGender(Individual ego, Individual alter) {
        Individual result = ego == null && alter == null ? null : (ego == null ? (alter.isFemale() ? ego : alter) : (alter == null ? (ego.isMale() ? ego : alter) : (ego.isMale() || alter.isFemale() && ego.isUnknown() ? ego : alter)));
        return result;
    }

    public static Individual fixMotherByGender(Individual ego, Individual alter) {
        Individual newHusband = NetUtils.fixFatherByGender(ego, alter);
        Individual result = newHusband == ego ? alter : ego;
        return result;
    }

    public static void fixSpouseRolesByGender(Family family) {
        Individual newHusband;
        if (family != null && (newHusband = NetUtils.fixFatherByGender(family.getHusband(), family.getWife())) != family.getHusband()) {
            NetUtils.swapParents(family);
        }
    }

    public static void fixSpouseRolesByGender2(Family family) {
        if (family != null) {
            Individual wife;
            Individual husband;
            Individual ego = family.getHusband();
            Individual alter = family.getWife();
            if (ego.isMale() || alter.isFemale() && ego.isUnknown()) {
                husband = ego;
                wife = alter;
            } else {
                husband = alter;
                wife = ego;
            }
            family.setHusband(husband);
            family.setWife(wife);
        }
    }

    public static void fuseIndividuals(Net source, Individual sourceIndividual, Individual targetIndividual) throws PuckException {
        String track = targetIndividual.getAttributeValue("DOUBLE");
        track = track == null ? String.valueOf(sourceIndividual.getId()) : String.valueOf(track) + ";" + String.valueOf(sourceIndividual.getId());
        targetIndividual.setAttribute("DOUBLE", track);
        UpdateWorker.update(targetIndividual.toString(), targetIndividual.attributes(), sourceIndividual.attributes(), new Report(), UpdateWorker.UpdateMode.APPEND);
        if (targetIndividual.getFather() == null && sourceIndividual.getFather() != null) {
            NetUtils.setFatherRelation(source, sourceIndividual.getFather().getId(), targetIndividual.getId());
        }
        if (targetIndividual.getMother() == null && sourceIndividual.getMother() != null) {
            NetUtils.setMotherRelation(source, sourceIndividual.getMother().getId(), targetIndividual.getId());
        }
        for (Family sourceFamily : sourceIndividual.getPersonalFamilies()) {
            Family targetFamily;
            if (sourceIndividual == sourceFamily.getHusband()) {
                targetFamily = source.families().getBySpouses(targetIndividual, sourceFamily.getWife());
                if (targetFamily == null) {
                    sourceFamily.setHusband(targetIndividual);
                    targetIndividual.addPersonalFamily(sourceFamily);
                    continue;
                }
                targetFamily.getChildren().add(sourceFamily.getChildren());
                for (Individual child : sourceFamily.getChildren()) {
                    child.setOriginFamily(targetFamily);
                }
                if (sourceFamily.getHusband() != null) {
                    sourceFamily.getHusband().getPersonalFamilies().removeById(sourceFamily.getId());
                }
                if (sourceFamily.getWife() != null) {
                    sourceFamily.getWife().getPersonalFamilies().removeById(sourceFamily.getId());
                }
                source.families().removeById(sourceFamily.getId());
                continue;
            }
            if (sourceIndividual != sourceFamily.getWife()) continue;
            targetFamily = source.families().getBySpouses(sourceFamily.getHusband(), targetIndividual);
            if (targetFamily == null) {
                sourceFamily.setWife(targetIndividual);
                targetIndividual.addPersonalFamily(sourceFamily);
                continue;
            }
            targetFamily.getChildren().add(sourceFamily.getChildren());
            for (Individual child : sourceFamily.getChildren()) {
                child.setOriginFamily(targetFamily);
            }
            if (sourceFamily.getHusband() != null) {
                sourceFamily.getHusband().getPersonalFamilies().removeById(sourceFamily.getId());
            }
            if (sourceFamily.getWife() != null) {
                sourceFamily.getWife().getPersonalFamilies().removeById(sourceFamily.getId());
            }
            source.families().removeById(sourceFamily.getId());
        }
        source.remove(sourceIndividual);
    }

    public static Map<Individual, String> getAlterRelations(Individual ego, List<Individual> alters, int[] maxDegrees, List<String> relationModelNames) {
        HashMap<Individual, String> result = new HashMap<Individual, String>();
        for (Individual alter : alters) {
            result.put(alter, NetUtils.getAlterRole(ego, alter, maxDegrees, relationModelNames));
        }
        return result;
    }

    public static Map<Individual, List<String>> getAlterRelations1(Individual ego, Set<Individual> altersSet, int[] maxDegrees, List<String> relationModelNames, String chainClassification, List<Individual> excludedIntermediaries, Graph<Individual> barredEdges) {
        HashMap<Individual, List<String>> result = new HashMap<Individual, List<String>>();
        ArrayList<Individual> alters = new ArrayList<Individual>(altersSet);
        Collections.sort(alters);
        ArrayList<Individual> unrelatedAlters = new ArrayList<Individual>();
        ArrayList<Individual> relatedAlters = new ArrayList<Individual>();
        for (Individual alter : alters) {
            Iterator roles = NetUtils.getAlterRoles(ego, alter, maxDegrees, relationModelNames, chainClassification, excludedIntermediaries, barredEdges);
            result.put(alter, (List<String>)((Object)roles));
            if (roles.size() == 0) {
                unrelatedAlters.add(alter);
                continue;
            }
            relatedAlters.add(alter);
        }
        while (relatedAlters.size() > 0 && unrelatedAlters.size() > 0) {
            HashMap newresult = new HashMap();
            for (Individual alter : unrelatedAlters) {
                newresult.put(alter, new ArrayList());
                for (Individual medius : relatedAlters) {
                    List firstRoles;
                    if (medius == ego || (firstRoles = (List)result.get(medius)).size() <= 0) continue;
                    List<String> secondRoles = NetUtils.getAlterRoles(medius, alter, maxDegrees, relationModelNames, chainClassification, excludedIntermediaries, barredEdges);
                    for (String firstRole : firstRoles) {
                        for (String secondRole : secondRoles) {
                            if (firstRole.equals("CHILD") && secondRole.contains("RELATIVE")) continue;
                            String role = String.valueOf(firstRole) + "S_" + secondRole;
                            String reducedRole = NetUtils.reduced(role);
                            while (!reducedRole.equals(role)) {
                                role = reducedRole;
                                reducedRole = NetUtils.reduced(role);
                            }
                            if (((List)newresult.get(alter)).contains(reducedRole)) continue;
                            ((List)newresult.get(alter)).add(reducedRole);
                        }
                    }
                }
            }
            relatedAlters = new ArrayList();
            for (Individual alter : newresult.keySet()) {
                if (((List)newresult.get(alter)).size() <= 0) continue;
                result.put(alter, (List)newresult.get(alter));
                unrelatedAlters.remove(alter);
                relatedAlters.add(alter);
            }
        }
        for (Individual alter : result.keySet()) {
            List list = (List)result.get(alter);
            if (!PuckUtils.containsStrings(list, "RELATIVE;RELATIVE_AGNATIC;RELATIVE_UTERINE;RELATIVE_COGNATIC;RELATIVE_OR_AFFINE")) continue;
            list.add("KIN");
        }
        return result;
    }

    public static String reduced(String relation) {
        String result = relation;
        result = result.replaceAll("FATHERS_RELATIVE_AGNATIC", "RELATIVE_AGNATIC");
        result = result.replaceAll("MOTHERS_RELATIVE_UTERINE", "RELATIVE_UTERINE");
        result = result.replaceAll("RELATIVES_CHILD", "RELATIVE");
        result = result.replaceAll("RELATIVE_COGNATICS_CHILD", "RELATIVE_COGNATIC");
        result = result.replaceAll("RELATIVE_AGNATICS_CHILD", "RELATIVE");
        if ((result = result.replaceAll("RELATIVE_UTERINES_CHILD", "RELATIVE")).replaceAll("FATHER", "").replaceAll("MOTHER", "").replaceAll("SIBLING", "").replaceAll("CHILD", "").replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").equals("S_RELATIVE")) {
            result = "RELATIVE_OR_AFFINE";
        }
        if (result.replaceAll("FATHER", "").replaceAll("MOTHER", "").replaceAll("SIBLING", "").replaceAll("CHILD", "").replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").equals("RELATIVES_")) {
            result = "RELATIVE_OR_AFFINE";
        }
        if (result.replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").equals("RELATIVES_RELATIVE")) {
            result = "RELATIVE_OR_AFFINE";
        }
        if (result.replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").equals("RELATIVES_OR_AFFINES_RELATIVE")) {
            result = "RELATIVE_OR_AFFINE";
        }
        if (result.replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").equals("AFFINES_RELATIVE")) {
            result = "AFFINE";
        }
        if (result.replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").equals("RELATIVES_AFFINE")) {
            result = "AFFINE";
        }
        if (result.replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").equals("SPOUSES_RELATIVE")) {
            result = "AFFINE";
        }
        if (result.replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").equals("RELATIVES_SPOUSE")) {
            result = "AFFINE";
        }
        result = result.replaceAll("AFFINES_AFFINE", "AFFINE");
        result = result.replaceAll("SPOUSES_SPOUSE", "AFFINE");
        result = result.replaceAll("SPOUSES_AFFINE", "AFFINE");
        result = result.replaceAll("FATHERS_AFFINE", "AFFINE");
        result = result.replaceAll("MOTHERS_AFFINE", "AFFINE");
        result = result.replaceAll("SIBLINGS_AFFINE", "AFFINE");
        result = result.replaceAll("CHILDS_AFFINE", "AFFINE");
        result = result.replaceAll("AFFINES_SPOUSE", "AFFINE");
        result = result.replaceAll("AFFINES_FATHER", "AFFINE");
        result = result.replaceAll("AFFINES_MOTHER", "AFFINE");
        result = result.replaceAll("AFFINES_SIBLING", "AFFINE");
        result = result.replaceAll("AFFINES_CHILD", "AFFINE");
        return result;
    }

    public static String getAlterRole(Individual ego, Individual alter, int[] maxDegrees, List<String> relationModelNames) {
        String result = "UNRELATED";
        if (ego == alter) {
            result = "IDENTITY";
        } else if (ego.spouses().contains(alter)) {
            result = "SPOUSE";
        } else if (ego.getFather() != null && ego.getFather().equals(alter)) {
            result = "FATHER";
        } else if (ego.getMother() != null && ego.getMother().equals(alter)) {
            result = "MOTHER";
        } else if (ego.children().contains(alter)) {
            result = "CHILD";
        } else if (ego.siblings().contains(alter)) {
            result = "SIBLING";
        } else {
            Chain chain = ChainFinder.findShortestChain(ego, alter, maxDegrees);
            if (chain != null) {
                if (chain.dim() > 1) {
                    result = "AFFINE";
                } else {
                    String chainType = "";
                    chain.getSubchains();
                    Value chainValue = ChainValuator.get(chain, "LINE");
                    if (chainValue != null) {
                        chainType = "_" + chainValue.toString();
                    }
                    result = "RELATIVE" + chainType;
                }
            } else if (relationModelNames != null) {
                for (Relation relation : ego.relations()) {
                    if (!relationModelNames.contains(relation.getModel().getName()) || !relation.getIndividuals().contains(alter)) continue;
                    result = relation.getRoleNames(alter).get(0).toString();
                    break;
                }
            }
        }
        return result;
    }

    public static List<String> getAlterRoles(Individual ego, Individual alter, int[] maxDegrees, List<String> relationModelNames, String chainClassification) {
        return NetUtils.getAlterRoles(ego, alter, maxDegrees, relationModelNames, chainClassification, null, null);
    }

    public static List<String> getAlterRoles(Individual ego, Individual alter, int[] maxDegrees, List<String> relationModelNames, String chainClassification, List<Individual> excludedIntermediaries, Graph<Individual> barredEdges) {
        ArrayList<String> result = new ArrayList<String>();
        if (ego == alter) {
            result.add("EGO");
        } else if (ego.getFather() != null && ego.getFather().equals(alter)) {
            result.add("FATHER");
        } else if (ego.getMother() != null && ego.getMother().equals(alter)) {
            result.add("MOTHER");
        } else if (ego.spouses().contains(alter)) {
            result.add("SPOUSE");
        } else if (ego.children().contains(alter)) {
            result.add("CHILD");
        } else {
            Chain chain;
            if (ego.siblings().contains(alter)) {
                if (excludedIntermediaries == null) {
                    result.add("SIBLING");
                } else {
                    boolean noExcludedIntermediaries = true;
                    for (Individual parent : ego.getParents()) {
                        if (!alter.getParents().contains(parent) || !excludedIntermediaries.contains(parent)) continue;
                        noExcludedIntermediaries = false;
                        barredEdges.addEdge(ego, alter);
                        break;
                    }
                    if (noExcludedIntermediaries) {
                        result.add("SIBLING");
                    }
                }
            }
            if (!result.contains("SIBLING") && (chain = ChainFinder.findShortestChain(ego, alter, maxDegrees)) != null) {
                boolean noExcludedIntermediaries = true;
                if (excludedIntermediaries != null && chain.size() > 2) {
                    for (Individual intermediary : excludedIntermediaries) {
                        int i = 1;
                        while (i < chain.size() - 1) {
                            if (chain.get(i) instanceof Couple) {
                                for (Individual apex : ((Couple)chain.get(i)).individuals()) {
                                    if (!apex.equals(intermediary)) continue;
                                    noExcludedIntermediaries = false;
                                    break;
                                }
                            }
                            if (((Individual)chain.get(i)).equals(intermediary)) {
                                noExcludedIntermediaries = false;
                                break;
                            }
                            ++i;
                        }
                        if (!noExcludedIntermediaries) break;
                    }
                }
                if (noExcludedIntermediaries) {
                    if (chain.dim() > 1) {
                        result.add("AFFINE");
                    } else {
                        String chainType = "";
                        if (chainClassification != null) {
                            chain.getSubchains();
                            Value chainValue = ChainValuator.get(chain, chainClassification);
                            if (chainValue != null) {
                                chainType = "_" + chainValue.toString();
                            }
                        }
                        result.add("RELATIVE" + chainType);
                    }
                }
            }
        }
        if (ego != alter) {
            for (Relation relation : ego.relations()) {
                if (!relationModelNames.contains(relation.getModel().getName()) || !relation.getIndividuals().contains(alter)) continue;
                for (String roleName : relation.getRoleNames(alter)) {
                    if (result.contains(roleName)) continue;
                    result.add(roleName);
                }
            }
        }
        return result;
    }

    public static boolean isBirthOrderUsed(Individuals source) {
        boolean result;
        if (source == null) {
            result = false;
        } else {
            result = true;
            boolean ended = false;
            Iterator iterator = source.iterator();
            while (!ended) {
                if (iterator.hasNext()) {
                    Individual current = (Individual)iterator.next();
                    if (current.getBirthOrder() == null) continue;
                    ended = true;
                    result = true;
                    continue;
                }
                ended = true;
                result = false;
            }
        }
        return result;
    }

    public static boolean isFemaleFatherOrMaleMother(Individual father, Individual mother) {
        boolean result = father == null || mother == null ? false : father.isFemale() || mother.isMale();
        return result;
    }

    public static boolean isParentChildMarriage(Family family, Individual children) {
        Individuals partners;
        boolean result = family == null || children == null ? false : (partners = children.spouses()).contains(family.getFather()) || partners.contains(family.getMother());
        return result;
    }

    public static boolean isParentChildMarriage(Individual parent, Individual children) {
        boolean result = parent == null || children == null ? false : children.spouses().contains(parent);
        return result;
    }

    public static boolean isParentChildMarriage(Individual parent, Individual ... children) {
        boolean result;
        if (parent == null) {
            result = false;
        } else {
            boolean ended = false;
            result = false;
            int childIndex = 0;
            while (!ended) {
                if (childIndex < children.length) {
                    if (NetUtils.isParentChildMarriage(parent, children[childIndex])) {
                        ended = true;
                        result = true;
                        continue;
                    }
                    ++childIndex;
                    continue;
                }
                ended = true;
                result = false;
            }
        }
        return result;
    }

    public static boolean isParentChildMarriage(Individual father, Individual mother, Individual ... children) {
        boolean result = NetUtils.isParentChildMarriage(father, children) || NetUtils.isParentChildMarriage(mother, children);
        return result;
    }

    public static boolean isRolesFixedByGender(Individual ego, Individual alter) {
        Individual newHusband = NetUtils.fixFatherByGender(ego, alter);
        boolean result = newHusband == ego;
        return result;
    }

    public static boolean isSame(Individual ego, Individual alter) {
        boolean result = ego == null || alter == null ? false : ego == alter;
        return result;
    }

    public static boolean isSameSex(Individual ego, Individual alter) {
        boolean result = ego == null || alter == null || ego.isUnknown() || alter.isUnknown() ? false : ego.getGender() == alter.getGender();
        return result;
    }

    public static int adjustParentGender(Net source, Report report) {
        int result = 0;
        StringList list = new StringList();
        for (Family family : source.families().toSortedList()) {
            Individual father = family.getFather();
            Individual mother = family.getMother();
            if (father != null && mother != null && father.isFemale() && mother.isMale()) {
                family.setFather(mother);
                family.setMother(father);
                list.appendln(String.valueOf(family.toNameString()) + "\tswapped parents");
                ++result;
                continue;
            }
            if (father != null && mother != null && father.isUnknown() && mother.isUnknown()) {
                father.setGender(Gender.MALE);
                mother.setGender(Gender.FEMALE);
                list.appendln(String.valueOf(family.toNameString()) + "\tset father and mother gender to male and female");
                ++result;
                continue;
            }
            if (father != null && father.isFemale() && (mother == null || mother.isUnknown())) {
                family.setFather(mother);
                family.setMother(father);
                list.appendln(String.valueOf(family.toNameString()) + "\tswapped parents");
                ++result;
                continue;
            }
            if (mother != null && mother.isMale() && (father == null || father.isUnknown())) {
                family.setFather(mother);
                family.setMother(father);
                list.appendln(String.valueOf(family.toNameString()) + "\tswapped parents");
                ++result;
                continue;
            }
            if (father != null && father.isUnknown()) {
                father.setGender(Gender.MALE);
                list.appendln(String.valueOf(family.toNameString()) + "\tset father gender to male");
                ++result;
                continue;
            }
            if (mother == null || !mother.isUnknown()) continue;
            mother.setGender(Gender.FEMALE);
            list.appendln(String.valueOf(family.toNameString()) + "\tset mother gender to female");
            ++result;
        }
        report.outputs().appendln(String.valueOf(result) + " adjusted parent gender:");
        report.outputs().appendln();
        report.outputs().append(list);
        return result;
    }

    public static int marryCoparents(Net source, Report report) {
        int result = 0;
        StringList list = new StringList();
        for (Family family : source.families().toSortedList()) {
            if (family.isSterile() || family.isSingleParent() || family.hasMarried()) continue;
            family.setMarried();
            list.appendln(family.toNameString());
            ++result;
        }
        report.outputs().appendln(String.valueOf(result) + " unmarried couples married:");
        report.outputs().appendln();
        report.outputs().append(list);
        return result;
    }

    public static void numberNames(Individuals source) {
        if (source != null) {
            for (Individual individual : source) {
                individual.setName(String.valueOf(individual.getTrimmedName()) + " (" + individual.getId() + ")");
            }
        }
    }

    public static void namesToAttributes(Individuals source) {
        if (source != null) {
            for (Individual individual : source) {
                individual.setAttribute("FIRSTN", individual.getFirstName());
                individual.setAttribute("LASTTN", individual.getLastName());
            }
        }
    }

    public static void numberNames(Net source) {
        if (source != null) {
            NetUtils.numberNames(source.individuals());
        }
    }

    public static void removeFather(Family family) {
        if (family != null) {
            family.getFather().getPersonalFamilies().removeById(family.getId());
            family.setFather(null);
        }
    }

    public static void removeMother(Family family) {
        if (family != null && family.getMother() != null) {
            family.getMother().getPersonalFamilies().removeById(family.getId());
            family.setMother(null);
        }
    }

    public static void removeSpouse(Family family, Individual spouse) {
        if (family != null && spouse != null) {
            if (family.getFather() == spouse) {
                NetUtils.removeFather(family);
            } else if (family.getMother() == spouse) {
                NetUtils.removeMother(family);
            }
        }
    }

    public static void renumberIndividuals(Net source) {
        if (source != null) {
            List individuals = source.individuals().toSortedList();
            source.individuals().clear();
            int index = 1;
            for (Individual individual : individuals) {
                individual.setId(index);
                ++index;
                source.individuals().add(individual);
            }
        }
    }

    public static void renumberFamilies(Net source) {
        if (source != null) {
            List families = source.families().toSortedList();
            source.families().clear();
            int index = 1;
            for (Family family : families) {
                family.setId(index);
                ++index;
                source.families().add(family);
            }
        }
    }

    public static int renumberFromAttribute(Net source, String attributeLabel) {
        int result = 0;
        if (source != null && attributeLabel != null) {
            Individuals candidates = source.individuals().searchByAttribute(attributeLabel, "^I?\\d+$");
            Individuals unchanged = source.individuals().getIndividuals().remove(candidates);
            logger.debug("candidates: " + candidates.size());
            logger.debug("unchanged:  " + unchanged.size());
            HashSet<Integer> newIds = new HashSet<Integer>(source.size());
            for (Individual individual : unchanged) {
                newIds.add(individual.getId());
            }
            for (Individual individual : candidates) {
                String value = individual.getAttributeValue(attributeLabel);
                int id = value.startsWith("I") ? Integer.parseInt(value.substring(1)) : Integer.parseInt(value);
                if (newIds.contains(id)) {
                    throw new IllegalArgumentException(String.format("value (%d) is already set.", id));
                }
                newIds.add(id);
            }
            Individuals targets = new Individuals(source.individuals().size());
            targets.add(unchanged);
            for (Individual individual : candidates) {
                String value = individual.getAttributeValue(attributeLabel);
                int id = value.startsWith("I") ? Integer.parseInt(value.substring(1)) : Integer.parseInt(value);
                individual.setAttribute(attributeLabel, String.valueOf(individual.getId()));
                individual.setId(id);
                targets.add(individual);
                ++result;
            }
            source.individuals().clear();
            source.individuals().add(targets);
        }
        return result;
    }

    public static void setAttribute(Net net, int individualId, String label, String value) throws PuckException {
        if (net != null && individualId != 0 && StringUtils.isNotBlank((CharSequence)label) && StringUtils.isNotBlank((CharSequence)value)) {
            Individual individual = (Individual)net.individuals().getById(individualId);
            if (individual == null) {
                individual = new Individual(individualId);
                net.individuals().add(individual);
            }
            individual.attributes().put(label, value);
        }
    }

    public static void setFatherRelation(Net net, int fatherId, int childId) {
        if (net != null && fatherId != 0 && childId != 0) {
            Family childSourceFamily;
            Individual child;
            Individual parent = (Individual)net.individuals().getById(fatherId);
            if (parent == null) {
                parent = new Individual(fatherId);
                net.individuals().add(parent);
            }
            if ((child = (Individual)net.individuals().getById(childId)) == null) {
                child = new Individual(childId);
                net.individuals().add(child);
            }
            if (child.getOriginFamily() == null) {
                childSourceFamily = new Family(net.families().getLastId() + 1);
                net.families().add(childSourceFamily);
                child.setOriginFamily(childSourceFamily);
                childSourceFamily.getChildren().add(child);
            } else {
                childSourceFamily = child.getOriginFamily();
                if (childSourceFamily.getFather() != null) {
                    childSourceFamily.getFather().getPersonalFamilies().removeById(childSourceFamily.getId());
                }
            }
            childSourceFamily.setFather(parent);
            Family parentPersonalFamily = (Family)parent.getPersonalFamilies().getById(childSourceFamily.getId());
            if (parentPersonalFamily == null) {
                parent.getPersonalFamilies().add(childSourceFamily);
            }
        }
    }

    public static void setGenderShapes(Graph<Individual> graph) {
        for (Node<Individual> node : graph.getNodes()) {
            node.setTag(node.getReferent().getGender().toShapeString());
        }
    }

    public static void setKin(Net net, Individual ego, Individual alter, KinType type) throws PuckException {
        if (ego == null || alter == null || type == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        switch (type) {
            case PARENT: {
                NetUtils.setKinParent(net, ego, alter);
                break;
            }
            case CHILD: {
                NetUtils.setKinParent(net, alter, ego);
                break;
            }
            case SPOUSE: {
                NetUtils.setKinSpouse(net, ego, alter);
                break;
            }
            case SIBLING: {
                Relation relation = new Relation(net.relations().size() + 1, net.relations().size() + 1, net.relationModels().getByName("SIBLING"), String.valueOf(ego.getName()) + "+" + alter.getName(), new Actor(ego, new Role("sibling")), new Actor(alter, new Role("sibling")));
                net.relations().add(relation);
                ego.relations().add(relation);
                alter.relations().add(relation);
            }
        }
    }

    public static void setKinFather(Family family, Individual newFather) {
        if (family != null) {
            if (family.getFather() != null) {
                NetUtils.removeFather(family);
            }
            if (newFather != null && (family.getMother() == null || newFather.getId() != family.getMother().getId())) {
                family.setFather(newFather);
                newFather.getPersonalFamilies().add(family);
            }
        }
    }

    public static void setKinFather(Net net, Individual father, Individual child) {
        NetUtils.setKinParent(net, father, KinType.FATHER, child);
    }

    public static void setKinMother(Family family, Individual newMother) {
        if (family != null) {
            if (family.getMother() != null) {
                NetUtils.removeMother(family);
            }
            if (newMother != null && (family.getFather() == null || newMother.getId() != family.getFather().getId())) {
                family.setMother(newMother);
                newMother.getPersonalFamilies().add(family);
            }
        }
    }

    public static void setKinMother(Net net, Individual mother, Individual child) {
        NetUtils.setKinParent(net, mother, KinType.MOTHER, child);
    }

    public static void setKinParent(Net net, Individual parent, Individual child) {
        switch (parent.getGender()) {
            case FEMALE: {
                NetUtils.setKinParent(net, parent, KinType.MOTHER, child);
                break;
            }
            case MALE: {
                NetUtils.setKinParent(net, parent, KinType.FATHER, child);
            }
        }
    }

    public static void setKinParent(Net net, Individual newParent, KinType parentRole, Individual child) {
        if (child != null && parentRole != null && (parentRole == KinType.FATHER || parentRole == KinType.MOTHER)) {
            if (parentRole == KinType.FATHER) {
                if (child.getFather() != null && child.getFather() != newParent) {
                    Family previousFamily = child.getOriginFamily();
                    previousFamily.getChildren().removeById(child.getId());
                    child.setOriginFamily(null);
                    if (previousFamily.getMother() != null) {
                        net.createFamily(null, previousFamily.getMother(), child);
                    }
                    if (previousFamily.isSterile() && previousFamily.isSingleParent() && previousFamily.attributes().size() == 0) {
                        net.remove(previousFamily);
                    }
                }
                if (newParent != null) {
                    if (child.getOriginFamily() == null) {
                        net.createFamily(newParent, null, child);
                    } else if (child.getFather() == null && child.getMother() == null) {
                        child.getOriginFamily().setFather(newParent);
                    } else if (child.getFather() == null && child.getMother() != null) {
                        Family newOriginFamily = net.families().getBySpouses(newParent, child.getOriginFamily().getMother());
                        if (newOriginFamily == null) {
                            child.getOriginFamily().setFather(newParent);
                            child.getFather().getPersonalFamilies().add(child.getOriginFamily());
                        } else {
                            Family previousFamily = child.getOriginFamily();
                            previousFamily.getChildren().removeById(child.getId());
                            if (previousFamily.isEmpty()) {
                                net.remove(previousFamily);
                            }
                            child.setOriginFamily(newOriginFamily);
                            newOriginFamily.getChildren().add(child);
                            if (previousFamily.isSterile() && previousFamily.isSingleParent() && previousFamily.attributes().size() == 0) {
                                net.remove(previousFamily);
                            }
                        }
                    }
                }
            } else if (parentRole == KinType.MOTHER) {
                if (child.getMother() != null && child.getMother() != newParent) {
                    Family previousFamily = child.getOriginFamily();
                    previousFamily.getChildren().removeById(child.getId());
                    child.setOriginFamily(null);
                    if (previousFamily.getFather() != null) {
                        net.createFamily(previousFamily.getFather(), null, child);
                    }
                    if (previousFamily.isSterile() && previousFamily.isSingleParent() && previousFamily.attributes().size() == 0) {
                        net.remove(previousFamily);
                    }
                }
                if (newParent != null) {
                    if (child.getOriginFamily() == null) {
                        net.createFamily(null, newParent, child);
                    } else if (child.getFather() == null && child.getMother() == null) {
                        child.getOriginFamily().setMother(newParent);
                    } else if (child.getFather() != null && child.getMother() == null) {
                        Family newOriginFamily = net.families().getBySpouses(child.getOriginFamily().getFather(), newParent);
                        if (newOriginFamily == null) {
                            child.getOriginFamily().setMother(newParent);
                            child.getMother().getPersonalFamilies().add(child.getOriginFamily());
                        } else {
                            Family previousFamily = child.getOriginFamily();
                            previousFamily.getChildren().removeById(child.getId());
                            if (previousFamily.isEmpty()) {
                                net.remove(previousFamily);
                            }
                            child.setOriginFamily(newOriginFamily);
                            newOriginFamily.getChildren().add(child);
                            if (previousFamily.isSterile() && previousFamily.isSingleParent() && previousFamily.attributes().size() == 0) {
                                net.remove(previousFamily);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void setKinParent2(Net net, Individual newParent, KinType parentRole, Individual child) {
        if (parentRole != null && (parentRole == KinType.FATHER || parentRole == KinType.MOTHER)) {
            if (child.isOrphan()) {
                if (child.getOriginFamily() == null) {
                    if (parentRole == KinType.MOTHER) {
                        child.getOriginFamily().setMother(newParent);
                    } else {
                        child.getOriginFamily().setFather(newParent);
                    }
                } else if (parentRole == KinType.MOTHER) {
                    net.createFamily(null, newParent, child);
                } else {
                    net.createFamily(newParent, null, child);
                }
                newParent.getPersonalFamilies().add(child.getOriginFamily());
            } else if (child.isOrphanOfMother() && parentRole == KinType.FATHER) {
                if (child.getOriginFamily().getFather() != newParent) {
                    if (child.getOriginFamily().getChildren().size() == 1) {
                        Individual previousFather = child.getOriginFamily().getFather();
                        previousFather.getPersonalFamilies().removeById(child.getOriginFamily().getId());
                        child.getOriginFamily().setFather(newParent);
                    } else {
                        child.getOriginFamily().getChildren().removeById(child.getId());
                        net.createFamily(newParent, null, child);
                    }
                }
            } else if (child.isOrphanOfFather() && parentRole == KinType.MOTHER) {
                if (child.getOriginFamily().getMother() != newParent) {
                    if (child.getOriginFamily().getChildren().size() == 1) {
                        child.getOriginFamily().getMother().getPersonalFamilies().removeById(child.getOriginFamily().getId());
                        child.getOriginFamily().setMother(newParent);
                    } else {
                        child.getOriginFamily().getChildren().removeById(child.getId());
                        net.createFamily(child.getFather(), newParent, child);
                    }
                }
            } else if (child.isOrphanOfMother() && parentRole == KinType.MOTHER) {
                Family newChildOriginFamily = net.families().getBySpouses(child.getOriginFamily().getFather(), newParent);
                if (newChildOriginFamily == null) {
                    if (child.getOriginFamily().getChildren().size() == 1) {
                        child.getOriginFamily().setMother(newParent);
                        newParent.getPersonalFamilies().add(child.getOriginFamily());
                    } else {
                        child.getOriginFamily().getChildren().removeById(child.getId());
                        net.createFamily(child.getFather(), newParent, child);
                    }
                } else if (child.getOriginFamily().getChildren().size() == 1) {
                    child.getFather().getPersonalFamilies().removeById(child.getOriginFamily().getId());
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    net.families().removeById(child.getOriginFamily().getId());
                    child.setOriginFamily(newChildOriginFamily);
                } else {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    child.setOriginFamily(newChildOriginFamily);
                    child.getOriginFamily().getChildren().add(child);
                }
            } else if (child.isOrphanOfFather() && parentRole == KinType.FATHER) {
                Family newChildOriginFamily = net.families().getBySpouses(newParent, child.getOriginFamily().getMother());
                if (newChildOriginFamily == null) {
                    if (child.getOriginFamily().getChildren().size() == 1) {
                        child.getOriginFamily().setFather(newParent);
                        newParent.getPersonalFamilies().add(child.getOriginFamily());
                    } else {
                        child.getOriginFamily().getChildren().removeById(child.getId());
                        net.createFamily(child.getFather(), newParent, child);
                    }
                } else if (child.getOriginFamily().getChildren().size() == 1) {
                    child.getMother().getPersonalFamilies().removeById(child.getOriginFamily().getId());
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    net.families().removeById(child.getOriginFamily().getId());
                    child.setOriginFamily(newChildOriginFamily);
                } else {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    child.setOriginFamily(newChildOriginFamily);
                    child.getOriginFamily().getChildren().add(child);
                }
            } else if (parentRole == KinType.FATHER && child.getFather() != newParent) {
                Family newChildOriginFamily = net.families().getBySpouses(newParent, child.getOriginFamily().getMother());
                if (newChildOriginFamily == null) {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    net.createFamily(newParent, child.getMother(), child);
                } else {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    child.setOriginFamily(newChildOriginFamily);
                    child.getOriginFamily().getChildren().put(child);
                }
            } else if (parentRole == KinType.MOTHER && child.getMother() != newParent) {
                Family newChildOriginFamily = net.families().getBySpouses(child.getOriginFamily().getFather(), newParent);
                if (newChildOriginFamily == null) {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    net.createFamily(child.getFather(), newParent, child);
                } else {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    child.setOriginFamily(newChildOriginFamily);
                    child.getOriginFamily().getChildren().put(child);
                }
            }
        }
    }

    public static void setKinRelation(Net net, Individual ego, Individual alter, KinType kinType) throws PuckException {
        int egoId = ego.getId();
        int alterId = alter.getId();
        block0 : switch (kinType) {
            case PARENT: {
                switch (alter.getGender()) {
                    case MALE: {
                        NetUtils.setFatherRelation(net, alterId, egoId);
                        break;
                    }
                    case FEMALE: {
                        NetUtils.setMotherRelation(net, alterId, egoId);
                    }
                }
                break;
            }
            case CHILD: {
                switch (ego.getGender()) {
                    case MALE: {
                        NetUtils.setFatherRelation(net, egoId, alterId);
                        break;
                    }
                    case FEMALE: {
                        NetUtils.setMotherRelation(net, egoId, alterId);
                    }
                }
                break;
            }
            case SPOUSE: {
                switch (ego.getGender()) {
                    case MALE: {
                        NetUtils.setSpouseRelation(net, egoId, alterId);
                        break block0;
                    }
                    case FEMALE: {
                        NetUtils.setSpouseRelation(net, alterId, egoId);
                    }
                }
            }
        }
    }

    public static void setKinSpouse(Net net, Individual ego, Individual alter) {
        Individual wife;
        Individual husband;
        if (ego.isMale() || alter.isFemale() && ego.isUnknown()) {
            husband = ego;
            wife = alter;
        } else {
            wife = ego;
            husband = alter;
        }
        NetUtils.setKinSpouseByRole(net, husband, wife);
    }

    public static void setKinSpouseByRole(Net net, Individual husband, Individual wife) {
        Family family = net.families().getBySpouses(husband, wife);
        if (family == null) {
            family = new Family(net.families().getFirstFreeId());
            net.families().add(family);
            husband.getPersonalFamilies().add(family);
            wife.getPersonalFamilies().add(family);
        }
        family.setHusband(husband);
        family.setWife(wife);
        family.setMarried(true);
    }

    public static void setMotherRelation(Net net, int motherId, int childId) {
        if (net != null && motherId != 0 && childId != 0) {
            Family childSourceFamily;
            Individual child;
            Individual parent = (Individual)net.individuals().getById(motherId);
            if (parent == null) {
                parent = new Individual(motherId);
                net.individuals().add(parent);
            }
            if ((child = (Individual)net.individuals().getById(childId)) == null) {
                child = new Individual(childId);
                net.individuals().add(child);
            }
            if (child.getOriginFamily() == null) {
                childSourceFamily = new Family(net.families().getLastId() + 1);
                net.families().add(childSourceFamily);
                child.setOriginFamily(childSourceFamily);
                childSourceFamily.getChildren().add(child);
            } else {
                childSourceFamily = child.getOriginFamily();
                if (childSourceFamily.getMother() != null) {
                    childSourceFamily.getMother().getPersonalFamilies().removeById(childSourceFamily.getId());
                }
            }
            childSourceFamily.setMother(parent);
            Family parentPersonalFamily = (Family)parent.getPersonalFamilies().getById(childSourceFamily.getId());
            if (parentPersonalFamily == null) {
                parent.getPersonalFamilies().add(childSourceFamily);
            }
        }
    }

    public static void setParentRelation(Net net, int parentId, int childId) throws PuckException {
        if (net != null && parentId != 0 && childId != 0) {
            Family childSourceFamily;
            Individual child;
            Individual parent = (Individual)net.individuals().getById(parentId);
            if (parent == null) {
                parent = new Individual(parentId);
                net.individuals().add(parent);
            }
            if ((child = (Individual)net.individuals().getById(childId)) == null) {
                child = new Individual(childId);
                net.individuals().add(child);
            }
            if (child.getOriginFamily() == null) {
                childSourceFamily = new Family(net.families().getLastId() + 1);
                net.families().add(childSourceFamily);
                child.setOriginFamily(childSourceFamily);
                childSourceFamily.getChildren().add(child);
            } else {
                childSourceFamily = child.getOriginFamily();
            }
            switch (parent.getGender()) {
                case FEMALE: {
                    childSourceFamily.setMother(parent);
                    break;
                }
                case MALE: 
                case UNKNOWN: {
                    childSourceFamily.setFather(parent);
                }
            }
            Family parentPersonalFamily = (Family)parent.getPersonalFamilies().getById(childSourceFamily.getId());
            if (parentPersonalFamily == null) {
                parent.getPersonalFamilies().add(childSourceFamily);
            }
        }
    }

    public static Family setSpouseRelation(Net net, int husbandId, int wifeId) throws PuckException {
        Family result;
        if (net == null || husbandId == 0 || wifeId == 0) {
            result = null;
        } else {
            Family family;
            Individual wife;
            boolean isNewFamily = false;
            Individual husband = (Individual)net.individuals().getById(husbandId);
            if (husband == null) {
                husband = new Individual(husbandId);
                net.individuals().add(husband);
                isNewFamily = true;
            }
            if ((wife = (Individual)net.individuals().getById(wifeId)) == null) {
                wife = new Individual(wifeId);
                net.individuals().add(wife);
                isNewFamily = true;
            }
            if ((family = isNewFamily ? null : net.families().getBySpouses(husband, wife)) == null) {
                family = new Family(net.families().getLastId() + 1);
                net.families().add(family);
                family.setHusband(husband);
                family.setWife(wife);
                family.setMarried(true);
                husband.getPersonalFamilies().add(family);
                wife.getPersonalFamilies().add(family);
            }
            result = family;
        }
        return result;
    }

    public static void setSpouseRelationAndFixRoles(Net net, int husbandId, int wifeId) throws PuckException {
        Family family = NetUtils.setSpouseRelation(net, husbandId, wifeId);
        if (family != null) {
            NetUtils.fixSpouseRolesByGender(family);
        }
    }

    public static void swapParents(Family source) {
        if (source != null) {
            Individual pivot = source.getFather();
            source.setFather(source.getMother());
            source.setMother(pivot);
        }
    }

    public static int transmitAttributeValue(Individuals seeds, String label, FiliationType filiationType, Integer maxGenerations) {
        Individuals target = new Individuals();
        int result = 0;
        Stack<Individual> stack = new Stack<Individual>();
        for (Individual seed : seeds) {
            Value seedValue = IndividualValuator.get(seed, label);
            if (seedValue == null) continue;
            String value = seedValue.stringValue();
            stack.push(seed);
            target.add(seed);
            while (!stack.isEmpty()) {
                Individual ego = (Individual)stack.pop();
                for (Individual neighbor : ego.getKin(KinType.CHILD, filiationType)) {
                    if (target.contains(neighbor)) continue;
                    stack.push(neighbor);
                    target.add(neighbor);
                    neighbor.setAttribute(label, value);
                    ++result;
                }
            }
        }
        return result;
    }

    public static int transmitAttributeValue(Individuals seeds, TransmitAttributeValueCriteria criteria) {
        if (TransmitAttributeValueCriteria.isNotValid(criteria)) {
            throw new IllegalArgumentException("Invalid criteria.");
        }
        int result = NetUtils.transmitAttributeValue(seeds, criteria.getAttributeLabel(), criteria.getFiliationType(), criteria.getMaxGenerations());
        return result;
    }

    public static RelationModel createTransitiveRelations(Net net, RelationModel model) throws PuckException {
        RelationModel result = net.createRelationModel(String.valueOf(model.getName()) + "+");
        for (Role role : model.roles()) {
            result.roles().add(role);
        }
        net.relations().add(net.relations().getByModel(model).getTransitiveClosure(result));
        return result;
    }

    public static void transformRelationsToAttributes(Net net, Report report) {
        int transformed = 0;
        for (RelationModel model : net.relationModels()) {
            report.outputs().append(String.valueOf(model.getName()) + ": ");
            if (model.roles().size() == 1) {
                Partition<Individual> values = new Partition<Individual>();
                for (Relation relation : net.relations().getByModel(model)) {
                    if (relation.attributes() == null || relation.attributes().isEmpty()) {
                        for (Individual individual : relation.getIndividuals()) {
                            if (values.getValue(individual) == null) {
                                values.put(individual, new Value(relation.getName()));
                                continue;
                            }
                            report.outputs().appendln("No unique relations");
                            values = null;
                            break;
                        }
                        if (values != null) continue;
                        break;
                    }
                    report.outputs().appendln("Relation attributes " + relation.attributes().labels().toStringWithCommas());
                    values = null;
                    break;
                }
                if (values == null) continue;
                for (Individual individual : values.getItems()) {
                    individual.setAttribute(model.getName(), values.getValue(individual).toString());
                }
                report.outputs().appendln(String.valueOf(values.nonNullClusterCount()) + " distinct values attributed to " + values.itemsCount() + " individuals");
                ++transformed;
                continue;
            }
            report.outputs().appendln("No single role");
        }
        report.outputs().appendln();
        report.outputs().appendln(String.valueOf(transformed) + " relations transformed to attributes");
    }

    public static long transformAttributeToRelation(Net net, Segmentation segmentation, AttributeToRelationCriteria criteria) {
        long result = 0L;
        AttributeWorker.Scope scope = criteria.getScope();
        String label = criteria.getLabel();
        Role role = new Role(criteria.getRoleName());
        RelationModel model = new RelationModel(label);
        model.roles().add(role);
        net.relationModels().add(model);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            for (Attribute attribute : individual.attributes()) {
                if (!attribute.getLabel().equals(label)) continue;
                Relation valuedRelation = (Relation)net.relations().getByModel(model).getByName(attribute.getValue()).getFirst();
                if (valuedRelation == null) {
                    valuedRelation = net.createRelation(attribute.getValue(), model, new Actor(individual, role));
                } else {
                    valuedRelation.addActor(individual, role);
                }
                ++result;
            }
        }
        return result;
    }
}

