/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.Comparator;
import org.tip.puck.net.workers.AttributeType;
import org.tip.puck.util.MathUtils;

public class AttributeTypeComparator
implements Comparator<AttributeType> {
    private Sorting sorting;

    public AttributeTypeComparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(AttributeType alpha, AttributeType bravo) {
        int result = AttributeTypeComparator.compare(alpha, bravo, this.sorting);
        return result;
    }

    public static int compare(AttributeType alpha, AttributeType bravo, Sorting sorting) {
        int result;
        switch (sorting) {
            default: {
                result = AttributeTypeComparator.compare(alpha, bravo, Sorting.SCOPE);
                if (result != 0) break;
                result = AttributeTypeComparator.compare(alpha, bravo, Sorting.RELATION_MODEL_NAME);
                break;
            }
            case SCOPE: {
                result = MathUtils.compare(AttributeTypeComparator.getScopeOrder(alpha), AttributeTypeComparator.getScopeOrder(bravo));
                break;
            }
            case RELATION_MODEL_NAME: {
                result = AttributeTypeComparator.compare(AttributeTypeComparator.getRelationModelname(alpha), AttributeTypeComparator.getRelationModelname(bravo));
            }
        }
        return result;
    }

    public static int compare(String alpha, String bravo) {
        int result = alpha == null ? -1 : alpha.compareTo(bravo);
        return result;
    }

    public static String getRelationModelname(AttributeType source) {
        String result = source == null ? null : source.getRelationModelName();
        return result;
    }

    public static Integer getScopeOrder(AttributeType source) {
        Integer result = source == null ? null : Integer.valueOf(source.getScope().ordinal());
        return result;
    }

    public static enum Sorting {
        DEFAULT,
        SCOPE,
        RELATION_MODEL_NAME;

    }
}

