/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import fr.devinsy.util.xml.XMLBadFormatException;
import fr.devinsy.util.xml.XMLReader;
import fr.devinsy.util.xml.XMLTag;
import fr.devinsy.util.xml.XMLWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.AlterAge;
import org.tip.puck.net.Gender;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleActorPair;
import org.tip.puck.net.relations.roles.RoleActors;
import org.tip.puck.net.relations.roles.RoleDefinitions;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.net.relations.roles.RoleRelationWorker;
import org.tip.puck.net.relations.roles.RoleRelations;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.Report;
import org.tip.puck.util.Value;
import org.tip.puckgui.PuckGUI;

public class RoleRelationsXMLFile {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 1024;
    public static final String XSD_FILE = "/org/tip/puck/io/puc/puck-1.3.xsd";
    public static final String PUCK_FORMAT_VERSION = "1.3";
    private static final Logger logger = LoggerFactory.getLogger(RoleRelationsXMLFile.class);

    public static Report save(File file, RelationModel source) throws PuckException, IOException {
        Report result = new Report("Export log");
        RoleDefinitions definitions = RoleRelationMaker.createRoleDefinitions(source.getRoleRelations(), source.getRules(), result);
        RoleRelationMaker.compareDefinitions(source.getRoleRelations().getOriginalDefinitions(), definitions, source.getRoleRelations(), result);
        for (Gender egoGender : Gender.valuesNotUnknown()) {
            File genderedFile = new File(String.valueOf(file.getCanonicalPath().substring(0, file.getCanonicalPath().indexOf(".term.xml"))) + "_" + egoGender.toGedChar() + ".term.xml");
            XMLWriter out = null;
            try {
                try {
                    out = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(genderedFile), DEFAULT_CHARSET_NAME));
                    RoleRelationsXMLFile.write(out, source, genderedFile.getName(), egoGender);
                }
                catch (UnsupportedEncodingException exception) {
                    throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + genderedFile + "]", new Object[0]);
                }
                catch (FileNotFoundException exception) {
                    throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + genderedFile + "]", new Object[0]);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        return result;
    }

    public static String load(File file, String charsetName, List<RoleActorPair> list) throws PuckException, XMLBadFormatException {
        String result = null;
        XMLReader in = null;
        try {
            try {
                in = new XMLReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = RoleRelationsXMLFile.read(in, list);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                if (in != null) {
                    in.close();
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result;
    }

    public static String read(XMLReader in, List<RoleActorPair> list) throws PuckException, XMLStreamException, XMLBadFormatException {
        in.readXMLHeader();
        in.readStartTag("KintermMap");
        in.readContentTag("Name").getContent();
        Map<String, List<String>> variables = RoleRelationsXMLFile.readVariables(in);
        String result = RoleRelationsXMLFile.readKinTerms(variables, in, list);
        return result;
    }

    public static Map<String, List<String>> readVariables(XMLReader in) throws XMLStreamException, XMLBadFormatException, PuckException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        in.readStartTag("VariablesFactory");
        XMLTag variables = in.readListTag("Variables");
        if (variables.getType() != XMLTag.TagType.EMPTY) {
            while (in.hasNextStartTag("Variable")) {
                XMLTag variableValues;
                XMLTag variable = in.readStartTag("Variable");
                ArrayList<String> list = new ArrayList<String>();
                result.put(variable.attributes().getByLabel("Name").getValue(), list);
                XMLTag variableValueProtos = in.readListTag("VariableValueProtos");
                if (variableValueProtos.getType() != XMLTag.TagType.EMPTY) {
                    XMLTag tag = in.readTag();
                    while (tag.getLabel().equals("VariableValueProto")) {
                        list.add(tag.attributes().getByLabel("Value").getValue());
                        tag = in.readTag();
                    }
                }
                if ((variableValues = in.readListTag("VariableValues")).getType() != XMLTag.TagType.EMPTY) {
                    XMLTag tag = in.readTag();
                    while (tag.getLabel().equals("VariableValue")) {
                        list.add(tag.attributes().getByLabel("Value").getValue());
                        tag = in.readTag();
                    }
                }
                in.readEndTag("Variable");
            }
        }
        in.readEndTag("Variables");
        in.readEndTag("VariablesFactory");
        return result;
    }

    private static String getMetaRoleName(String idx) {
        String result = null;
        if (idx.equals("-1")) {
            result = "SIBLING";
        } else if (idx.equals("0")) {
            result = "PARENT";
        } else if (idx.equals("1")) {
            result = "CHILD";
        } else if (idx.equals("4")) {
            result = "SPOUSE";
        }
        return result;
    }

    private static Integer getOrientation(KinType kinType) {
        Integer result = null;
        if (kinType != null) {
            switch (kinType) {
                case SIBLING: {
                    result = -1;
                    break;
                }
                case PARENT: {
                    result = 0;
                    break;
                }
                case CHILD: {
                    result = 1;
                    break;
                }
                case SPOUSE: {
                    result = 4;
                }
            }
        }
        return result;
    }

    private static RoleActor updateRoleActor(RoleActor actor, Map<String, MetaRole> metaRoles, String selfName, Gender egoGender, Gender alterGender) {
        RoleActor result = actor.clone();
        MetaRole metaRole = metaRoles.get(actor.getRole().toString());
        if (metaRole != null) {
            result.setRole(metaRole);
        }
        result = result.withEgoGender(egoGender);
        if (alterGender != null && !alterGender.isUnknown()) {
            result = result.withAlterGender(alterGender);
        }
        result.setSelfName(selfName);
        return result;
    }

    public static String readKinTerms(Map<String, List<String>> variables, XMLReader in, List<RoleActorPair> result) throws XMLStreamException, XMLBadFormatException, PuckException {
        XMLTag list = in.readStartTag("Kinterms");
        HashMap<String, MetaRole> metaRoles = new HashMap<String, MetaRole>();
        List<String> genderTokens = variables.get("Sex");
        String selfName = null;
        Gender egoGender = null;
        HashMap<String, Gender> genderByTerm = new HashMap<String, Gender>();
        if (list.getType() != XMLTag.TagType.EMPTY) {
            XMLTag kinTerm = in.readTag();
            while (kinTerm.getLabel().equals("Kinterm")) {
                Gender gender;
                String name = in.readNullableContentTag("Term").getContent();
                if (name == null) {
                    name = "";
                }
                if (selfName == null) {
                    selfName = name;
                }
                Role selfTerm = new Role(name);
                String genderToken = in.readContentTag("Sex").getContent();
                if (StringUtils.equals((CharSequence)genderToken, (CharSequence)genderTokens.get(0))) {
                    gender = Gender.MALE;
                } else if (StringUtils.equals((CharSequence)genderToken, (CharSequence)genderTokens.get(1))) {
                    gender = Gender.FEMALE;
                } else if (StringUtils.equals((CharSequence)genderToken, (CharSequence)genderTokens.get(2))) {
                    gender = Gender.UNKNOWN;
                } else if (StringUtils.equals((CharSequence)genderToken, (CharSequence)"N") || StringUtils.equals((CharSequence)genderToken, (CharSequence)"X")) {
                    gender = Gender.UNKNOWN;
                } else if (StringUtils.equals((CharSequence)genderToken, (CharSequence)"#")) {
                    gender = Gender.UNKNOWN;
                } else {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown gender [" + genderToken + "]", new Object[0]);
                }
                genderByTerm.put(name, gender);
                if (egoGender == null) {
                    egoGender = gender;
                }
                RoleActor self = new RoleActor(selfTerm, new MetaRole("SELF", Gender.UNKNOWN, gender, AlterAge.UNKNOWN), selfName);
                if (StringUtils.equals((CharSequence)genderToken, (CharSequence)"#")) {
                    self.getRole().setCross(true);
                }
                String isGen = in.readContentTag("IsGen").getContent();
                String orientation = in.readContentTag("Orientation").getContent();
                if (isGen.equals("true")) {
                    metaRoles.put(name, new MetaRole(RoleRelationsXMLFile.getMetaRoleName(orientation), Gender.UNKNOWN, gender, AlterAge.UNKNOWN));
                }
                in.readStartTag("Origin");
                in.readContentTag("x");
                in.readContentTag("y");
                in.readEndTag("Origin");
                in.readContentTag("Covered");
                in.readContentTag("Etc");
                in.readContentTag("CoveringTerm");
                in.readContentTag("CoveredTerms");
                XMLTag variablesList = in.readListTag("Variables");
                if (variablesList.getType() != XMLTag.TagType.EMPTY) {
                    while (in.hasNextStartTag("Variable")) {
                        in.readStartTag("Variable");
                        XMLTag variableValues = in.readListTag("VariableValues");
                        if (variableValues.getType() != XMLTag.TagType.EMPTY) {
                            while (in.readTag().getLabel().equals("VariableValue")) {
                            }
                        }
                        in.readEndTag("Variable");
                    }
                }
                in.readEndTag("Variables");
                XMLTag products = in.readListTag("Products");
                if (products.getType() != XMLTag.TagType.EMPTY) {
                    XMLTag generator = in.readTag();
                    while (generator.getLabel().equals("Generator")) {
                        if (generator.getType() == XMLTag.TagType.START) {
                            XMLTag product = in.readTag();
                            while (product.getLabel().equals("Product")) {
                                Role alterTerm = new Role(product.getContent());
                                RoleActor alter = new RoleActor(alterTerm, new MetaRole(generator.attributes().getByLabel("Name").getValue(), Gender.UNKNOWN, null, AlterAge.UNKNOWN), selfName);
                                result.add(new RoleActorPair(self, alter));
                                if (selfName == name && !alterTerm.getName().equals(alter.getRole().getName())) {
                                    selfName = null;
                                    egoGender = null;
                                }
                                product = in.readTag();
                            }
                        }
                        generator = in.readTag();
                    }
                }
                in.readEndTag("Kinterm");
                kinTerm = in.readTag();
            }
        }
        for (RoleActorPair pair : result) {
            RoleActor self = pair.getSelf();
            Gender alterGender = null;
            if (self.getRole().isCross() && self.getAlterGender().isUnknown()) {
                alterGender = egoGender.invert();
                genderByTerm.put(self.getName(), alterGender);
            }
            pair.setSelf(RoleRelationsXMLFile.updateRoleActor(self, metaRoles, selfName, egoGender, alterGender));
        }
        for (RoleActorPair pair : result) {
            RoleActor alter = pair.getAlter();
            pair.setAlter(RoleRelationsXMLFile.updateRoleActor(alter, metaRoles, selfName, egoGender, (Gender)((Object)genderByTerm.get(alter.getName()))));
        }
        return selfName;
    }

    public static void write(XMLWriter out, RelationModel source, String sourceFileName, Gender egoGender) {
        out.writeXMLHeader(new String[0]);
        out.writeStartTag("KintermMap", new String[]{"xmlns", "urn:schema:PUCK/1.3", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "version", "PUCK-1.3", "generator", "PUCK", "date", DatatypeConverter.printDateTime((Calendar)new GregorianCalendar()), "filename", sourceFileName});
        out.writeTag("Name", source.getName(), new String[0]);
        out.writeStartTag("VariablesFactory", new String[0]);
        out.writeStartTag("Variables", new String[0]);
        out.writeStartTag("Variable", new String[]{"Name", "Sex"});
        out.writeStartTag("VariableValueProtos", new String[0]);
        for (Gender gender : Gender.valuesNotUnknown()) {
            out.writeEmptyTag("VariableValueProto", new String[]{"Value", String.valueOf(gender.toGedChar())});
        }
        out.writeEndTag("VariableValueProtos");
        out.writeStartTag("VariableValues", new String[0]);
        out.writeEmptyTag("VariableValue", new String[]{"Value", "*"});
        out.writeEndTag("VariableValues");
        out.writeEndTag("Variable");
        out.writeEndTag("Variables");
        out.writeEndTag("VariablesFactory");
        RoleRelationsXMLFile.writeRoleRelations(out, source, egoGender);
        out.writeEndTag("KintermMap");
    }

    public static void writeRoleRelations(XMLWriter out, RelationModel model, Gender egoGender) {
        RoleRelations relations = model.getRoleRelations();
        if (relations == null || relations.isEmpty()) {
            out.writeEmptyTag("Kinterms", new String[0]);
        } else {
            out.writeStartTag("Kinterms", new String[0]);
            Map<RoleActor, RoleActors> kinTermMap = new RoleRelationWorker(model, PuckGUI.instance().getPreferences().getTerminologyMaxIterations()).getRoleRelationMap(egoGender);
            for (RoleActor self : kinTermMap.keySet()) {
                self = self.withEgoGender(egoGender);
                out.writeStartTag("Kinterm", new String[0]);
                out.writeTag("Term", self.getName(), new String[0]);
                if (self.getRole().cross) {
                    out.writeTag("Sex", "#", new String[0]);
                } else {
                    out.writeTag("Sex", String.valueOf(self.getAlterGender().toGedChar()), new String[0]);
                }
                out.writeTag("IsGen", relations.getGeneratorTerms(self) != null, new String[0]);
                out.writeTag("Orientation", "" + RoleRelationsXMLFile.getOrientation(relations.getElementaryKinType(self)), new String[0]);
                out.writeStartTag("Origin", new String[0]);
                out.writeTag("x", " ", new String[0]);
                out.writeTag("y", " ", new String[0]);
                out.writeEndTag("Origin");
                out.writeTag("Covered", false, new String[0]);
                out.writeTag("Etc", false, new String[0]);
                out.writeTag("CoveringTerm", "null", new String[0]);
                out.writeTag("CoveredTerms", "null", new String[0]);
                out.writeStartTag("Variables", new String[0]);
                out.writeStartTag("Variable", new String[]{"Name", "Sex"});
                out.writeStartTag("VariableValues", new String[0]);
                for (Gender gender : Gender.valuesNotUnknown()) {
                    if (!gender.specifies(self.getAlterGender())) continue;
                    out.writeEmptyTag("VariableValue", new String[]{"Value", String.valueOf(gender.toGedChar())});
                }
                out.writeEndTag("VariableValues");
                out.writeEndTag("Variable");
                out.writeEndTag("Variables");
                out.writeStartTag("Products", new String[0]);
                Partition<RoleActor> byGenerators = new Partition<RoleActor>();
                for (RoleActor roleActor : kinTermMap.get(self)) {
                    for (Role generatorTerm : relations.getGeneratorTerms(roleActor)) {
                        byGenerators.put(roleActor, new Value(generatorTerm.toString()));
                    }
                }
                for (Cluster cluster : byGenerators.getClusters()) {
                    out.writeStartTag("Generator", new String[]{"Name", cluster.getValue().stringValue()});
                    for (RoleActor product : cluster.getItems()) {
                        out.writeTag("Product", product.getName(), new String[0]);
                    }
                    out.writeEndTag("Generator");
                }
                out.writeEndTag("Products");
                out.writeEndTag("Kinterm");
            }
            out.writeEndTag("Kinterms");
        }
    }
}

