/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo2.workers;

import fr.devinsy.util.StringSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.net.workers.AttributeValueDescriptor;
import org.tip.puck.net.workers.AttributeValueDescriptors;

public class GeocodingWorker {
    private GeocodingWorker() {
    }

    public static Graph<Place2> geocodeAttributeValueDescriptors(Geography2 geography, AttributeValueDescriptors valueDescriptors, double weightFactor) {
        Graph<Place2> result = new Graph<Place2>();
        if (geography != null && valueDescriptors != null) {
            for (AttributeValueDescriptor valueDescriptor : valueDescriptors) {
                Place2 place = geography.get(valueDescriptor.getValue());
                if (place == null || !place.isGeocoded()) continue;
                Node<Place2> node = result.addNode(place);
                node.incWeight((double)valueDescriptor.getCount() * weightFactor);
            }
        }
        return result;
    }

    public static <E> Graph<Place2> geocodeGraph(Geography2 geography, Graph<E> source) {
        Graph<Place2> result;
        if (source == null) {
            result = null;
        } else {
            result = new Graph<Place2>();
            result.setLabel(source.getLabel());
            if (geography != null) {
                for (Node<E> node : source.getNodes()) {
                    Place2 place2;
                    String sourceNodeLabel = node.getLabel();
                    if (!StringUtils.isNotBlank((CharSequence)sourceNodeLabel) || (place2 = geography.get(sourceNodeLabel)) == null || !place2.isGeocoded()) continue;
                    result.addNode(node.getId(), place2);
                }
                for (Node<Object> node : result.getNodes()) {
                    Node<E> sourceNode = source.getNodes().get(node.getId());
                    for (Link link : sourceNode.getLinks()) {
                        if (result.getNodes().get(link.getTargetId()) == null || result.getNodes().get(link.getSourceId()) == null) continue;
                        if (link.isArc()) {
                            result.addArc(link.getSourceId(), link.getTargetId(), link.getWeight());
                            continue;
                        }
                        result.addEdge(link.getSourceId(), link.getTargetId(), link.getWeight());
                    }
                }
            }
        }
        return result;
    }

    public static Graph<Place2> geocodeToponyms(Geography2 geography, StringSet toponyms) {
        Graph<Place2> result = new Graph<Place2>();
        if (geography != null && toponyms != null) {
            for (String toponym : toponyms) {
                Place2 place = geography.get(toponym);
                if (place == null || !place.isGeocoded()) continue;
                result.addNode(place);
            }
        }
        return result;
    }

    @Deprecated
    public static Graph<Place2> geocodeToponymStrings(Geography2 geography, StringSet toponyms, double weightStep) {
        Graph<Place2> result = new Graph<Place2>();
        if (geography != null && toponyms != null) {
            for (String toponym : toponyms) {
                List<Node<Place2>> nodes = result.getNodesByLabel(toponym).toList();
                if (nodes.isEmpty()) {
                    Place2 place = geography.get(toponym);
                    if (place == null || !place.isGeocoded()) continue;
                    Node<Place2> node = result.addNode(place);
                    node.incWeight(weightStep);
                    continue;
                }
                Node<Place2> node = nodes.get(0);
                node.incWeight(weightStep);
            }
        }
        return result;
    }
}

