/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.statistics;

import java.util.ArrayList;
import org.tip.puck.statistics.BIASCount;

public class BIASCounts
extends ArrayList<BIASCount> {
    private static final long serialVersionUID = 3076624104856435334L;

    public BIASCounts() {
    }

    public BIASCounts(int capacity) {
        super(capacity);
    }

    public BIASCounts(int capacity, int filledCapacity) {
        super(capacity);
        while (capacity >= this.size()) {
            this.add(new BIASCount());
        }
    }

    public void add(BIASCounts counts) {
        int i = 0;
        while (i < this.size()) {
            this.get(i).add(counts.get(i));
            ++i;
        }
    }

    public void divide(double factor) {
        for (BIASCount count : this) {
            count.setAgnatic(count.getAgnatic() / factor);
            count.setUterine(count.getUterine() / factor);
            count.setCognatic(count.getCognatic() / factor);
            count.setCoo(count.getCoo() / factor);
        }
    }

    public int agnaticSum() {
        int result = 0;
        for (BIASCount count : this) {
            result = (int)((double)result + count.getAgnatic());
        }
        return result;
    }

    public int cognaticSum() {
        int result = 0;
        for (BIASCount count : this) {
            result = (int)((double)result + count.getCognatic());
        }
        return result;
    }

    @Override
    public BIASCount get(int index) {
        while (index >= this.size()) {
            this.add(new BIASCount());
        }
        BIASCount result = (BIASCount)super.get(index);
        return result;
    }

    @Override
    public BIASCount set(int index, BIASCount value) {
        while (index >= this.size()) {
            this.add(new BIASCount());
        }
        BIASCount result = super.set(index, value);
        return result;
    }

    public BIASCount sum() {
        BIASCount result = new BIASCount();
        for (BIASCount count : this) {
            result.addCoo(count.getCoo());
            result.addAgnatic(count.getAgnatic());
            result.addCognatic(count.getCognatic());
            result.addUterine(count.getUterine());
        }
        return result;
    }

    public int uterineSum() {
        int result = 0;
        for (BIASCount count : this) {
            result = (int)((double)result + count.getUterine());
        }
        return result;
    }
}

