/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.net.Attributable;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Populatable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequenceable;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberablesHashMap;

public class Sequence<E>
implements Comparable<Sequence<E>>,
Numberable,
Sequenceable<E>,
Populatable {
    int id;
    Map<Ordinal, E> stations = new TreeMap<Ordinal, E>();
    String idLabel;
    private Map<E, String> stationTypes;

    public Sequence() {
    }

    public Sequence(String idLabel, int id) {
        this.idLabel = idLabel;
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String idLabel() {
        return this.idLabel;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.idLabel) + "_" + this.id;
    }

    @Override
    public E getStation(Ordinal time) {
        E result = time != null ? (E)this.stations.get(time) : null;
        return result;
    }

    @Override
    public String hashKey() {
        return String.valueOf(this.id);
    }

    @Override
    public int compareTo(Sequence<E> sequence) {
        return Integer.valueOf(this.id).compareTo(sequence.id);
    }

    @Override
    public Ordinal getFirstTime() {
        Ordinal result = (Ordinal)((TreeMap)this.stations).firstKey();
        return result;
    }

    public Ordinal getFirstTimeNonNull() {
        Ordinal result = null;
        for (Ordinal time : this.getTimes()) {
            if (this.stations.get(time) == null) continue;
            result = time;
            break;
        }
        return result;
    }

    public Ordinal getFirstTime(E station) {
        Ordinal result = null;
        if (station != null) {
            for (Ordinal time : this.getTimes()) {
                if (!station.equals(this.stations.get(time))) continue;
                result = time;
                break;
            }
        }
        return result;
    }

    public Ordinal getNextTime(Ordinal key) {
        Ordinal result = key != null ? ((TreeMap)this.stations).higherKey(key) : null;
        return result;
    }

    public Ordinal getNextFreeTime(Ordinal key, Set<Ordinal> filter) {
        Ordinal result;
        if (key != null) {
            result = ((TreeMap)this.stations).higherKey(key);
            if (result != null && filter.contains(result)) {
                result = this.getNextFreeTime(result, filter);
            }
        } else {
            result = null;
        }
        return result;
    }

    public List<String> getStationTypesAsSortedList() {
        ArrayList<String> result = new ArrayList<String>();
        for (String type : this.getStationTypes().values()) {
            if (result.contains(type)) continue;
            result.add(type);
        }
        Collections.sort(result);
        return result;
    }

    public String getStationTypesAsString() {
        String result = "";
        boolean first = true;
        List<String> list = this.getStationTypesAsSortedList();
        if (this.getStationTypes() != null) {
            for (String type : list) {
                if (first) {
                    result = String.valueOf(result) + type;
                    first = false;
                    continue;
                }
                result = String.valueOf(result) + ";" + type;
            }
        }
        return result;
    }

    public int getNrStations() {
        return this.stations.size();
    }

    public int getNrStationTypes() {
        int result = this.getStationTypes() != null ? this.getStationTypesAsSortedList().size() : 0;
        return result;
    }

    public String getStationType(E station) {
        String result = this.getStationTypes().get(station);
        return result;
    }

    @Override
    public Map<Ordinal, E> getStations() {
        return this.stations;
    }

    public void put(Ordinal ordinal, E station) {
        this.stations.put(ordinal, station);
    }

    public List<E> toList() {
        ArrayList<E> result = new ArrayList<E>(this.stations.values());
        return result;
    }

    public String toValueString() {
        String result = "";
        for (E value : this.toList()) {
            result = value != null ? String.valueOf(result) + value + ";" : String.valueOf(result) + ";;";
        }
        return result;
    }

    @Override
    public List<Ordinal> getTimes() {
        ArrayList<Ordinal> result = new ArrayList<Ordinal>(this.stations.keySet());
        Collections.sort(result);
        return result;
    }

    public E firstStation() {
        E result = this.getStation(this.getTimes().get(0));
        return result;
    }

    @Override
    public E getPreviousStation(Ordinal time) {
        int idx = this.getTimes().indexOf(time);
        E result = idx == 0 ? null : (E)this.getStation(this.getTimes().get(idx - 1));
        return result;
    }

    public List<Integer> getYears() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Ordinal time : this.getTimes()) {
            if (result.contains(time.getYear())) {
                result.add(time.getYear());
                continue;
            }
            System.err.println("Warning: multiple occurence of year " + time.getYear());
        }
        return result;
    }

    public String toString() {
        return this.getLabel();
    }

    public Map<E, String> getStationTypes() {
        return this.stationTypes;
    }

    public void setStationTypes(Map<E, String> stationTypes) {
        this.stationTypes = stationTypes;
    }

    @Override
    public Individuals getIndividuals() throws PuckException {
        Individuals result = new Individuals();
        for (E station : this.stations.values()) {
            if (!(station instanceof Populatable)) continue;
            result.add(((Populatable)station).getIndividuals());
        }
        return result;
    }

    public <V extends Numberable> List<String> idValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (E station : this.stations.values()) {
            if (!(station instanceof NumberablesHashMap)) continue;
            for (Numberable stationItem : (NumberablesHashMap)station) {
                String idValue;
                if (!(stationItem instanceof Attributable) || result.contains(idValue = ((Attributable)((Object)stationItem)).getAttributeValue(this.idLabel))) continue;
                result.add(idValue);
            }
        }
        Collections.sort(result);
        return result;
    }

    public <V extends Numberable> Map<String, Individuals> membersByRelationId() throws PuckException {
        TreeMap<String, Individuals> result = new TreeMap<String, Individuals>();
        for (E station : this.stations.values()) {
            if (!(station instanceof NumberablesHashMap)) continue;
            for (Numberable stationItem : (NumberablesHashMap)station) {
                String idValue;
                if (!(stationItem instanceof Populatable & stationItem instanceof Attributable) || (idValue = ((Attributable)((Object)stationItem)).getAttributeValue(this.idLabel)) == null) continue;
                Individuals members = (Individuals)result.get(idValue);
                if (members == null) {
                    members = new Individuals();
                    result.put(idValue, members);
                }
                members.add(((Populatable)((Object)stationItem)).getIndividuals());
            }
        }
        return result;
    }

    @Override
    public Individuals getIndividuals(Segmentation segmentation) throws PuckException {
        Individuals result = new Individuals();
        for (Individual individual : this.getIndividuals()) {
            if (!segmentation.getCurrentIndividuals().contains(individual)) continue;
            result.add(individual);
        }
        return result;
    }
}

