/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.KinLink;
import org.tip.puck.net.workers.NetUtils;

public class BicomponentWorker {
    private Individuals individuals;
    private int step = 0;
    private Stack<KinLink> bicomax = new Stack();
    private Map<Integer, Integer> bicomponents = new TreeMap<Integer, Integer>();
    private int volume;
    private int number;

    public BicomponentWorker(Net net) {
        this.individuals = net.individuals();
    }

    static void add(Map<Integer, Integer> bicomponents, int i, int threshold) {
        if (bicomponents.get(i) == null || bicomponents.get(i) > threshold) {
            bicomponents.put(i, threshold);
        }
    }

    static void addAll(Map<Integer, Integer> bicomponents, Map<Integer, Integer> map) {
        for (int i : map.keySet()) {
            BicomponentWorker.add(bicomponents, i, map.get(i));
        }
    }

    public static Net getCore(Net net) {
        BicomponentWorker worker = new BicomponentWorker(net);
        Net result = worker.getMaximalBicomponent(true, true);
        return result;
    }

    private Net getMaximalBicomponent(boolean matrimonial, boolean all) {
        Stack<KinLink> stack = new Stack<KinLink>();
        HashMap<Individual, Integer> colors = new HashMap<Individual, Integer>();
        HashMap<Individual, Integer> discovery = new HashMap<Individual, Integer>();
        for (Individual individual : this.individuals) {
            if (colors.get(individual) != null) continue;
            this.bicomp(individual, null, stack, 0, KinType.CHILD, colors, discovery, matrimonial, all);
        }
        this.getBicomponent(stack, null, all);
        BicomponentWorker.report(this.bicomponents, this.volume);
        Net result = this.fromEdges(this.bicomax);
        return result;
    }

    public int bicomp(Individual ego, Individual p, Stack<KinLink> stack, int back, KinType egoKinType, Map<Individual, Integer> colors, Map<Individual, Integer> discovery, boolean matrimonial, boolean all) {
        ++this.step;
        colors.put(ego, 1);
        discovery.put(ego, this.step);
        back = discovery.get(ego);
        KinType[] kinTypeArray = KinType.values();
        int n = kinTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KinType alterKinType = kinTypeArray[n2];
            if (!(matrimonial && alterKinType == KinType.PARENT && egoKinType == KinType.CHILD || ego.getKin(alterKinType) == null)) {
                for (Individual alter : ego.getKin(alterKinType)) {
                    if (alter == null || p != null && alter.equals(p) || colors.get(alter) != null && colors.get(alter) >= 2) continue;
                    back = this.bicomp1(ego, alter, stack, back, alterKinType, colors, discovery, matrimonial, all);
                }
            }
            ++n2;
        }
        if (matrimonial && back < discovery.get(ego) && egoKinType == KinType.CHILD) {
            for (Individual alter : ego.getParents()) {
                if (alter == null || p != null && alter.equals(p) || colors.get(alter) != null && colors.get(alter) >= 2) continue;
                back = this.bicomp1(ego, alter, stack, back, KinType.PARENT, colors, discovery, matrimonial, all);
            }
        }
        colors.put(ego, 2);
        return back;
    }

    public int bicomp1(Individual ego, Individual a, Stack<KinLink> stack, int back, KinType type, Map<Individual, Integer> colors, Map<Individual, Integer> discovery, boolean matrimonial, boolean all) {
        KinLink e = new KinLink(ego, a, type, true);
        stack.push(e);
        if (colors.get(a) == null) {
            int cback = this.bicomp(a, ego, stack, back, type, colors, discovery, matrimonial, all);
            if (cback > discovery.get(ego)) {
                BicomponentWorker.clear(stack, e);
            } else if (cback == discovery.get(ego)) {
                if (matrimonial && e.inverse(ego).getType() == KinType.PARENT && stack.peek().inverse(ego).getType() == KinType.PARENT) {
                    BicomponentWorker.clear(stack, e);
                } else {
                    this.getBicomponent(stack, e, all);
                }
            }
            back = Math.min(back, cback);
        } else {
            back = Math.min(back, discovery.get(a));
        }
        return back;
    }

    void count(Map<Integer, Integer> bicomponents, int i) {
        try {
            bicomponents.put(i, bicomponents.get(i) + 1);
        }
        catch (NullPointerException npe) {
            bicomponents.put(i, 1);
        }
        ++this.number;
        this.volume += i;
    }

    static void report(Map<Integer, Integer> bicomponents, int volume) {
        for (int i : bicomponents.keySet()) {
            System.out.println(String.valueOf(i) + "\t" + bicomponents.get(i));
        }
        System.out.println(String.valueOf(bicomponents.size()) + " " + volume);
    }

    public static Net getMaximalBicomponent(Net net) {
        BicomponentWorker worker = new BicomponentWorker(net);
        Net result = worker.getMaximalBicomponent(false, false);
        return result;
    }

    public static Net getKernel(Net net) {
        BicomponentWorker worker = new BicomponentWorker(net);
        Net result = worker.getMaximalBicomponent(true, false);
        return result;
    }

    public Net fromEdges(Stack<KinLink> edges) {
        Net result = new Net();
        while (!edges.isEmpty()) {
            KinLink edge = edges.pop();
            Individual ego = result.getCloneWithAttributes(edge.getSource());
            Individual alter = result.getCloneWithAttributes(edge.getTarget());
            try {
                NetUtils.setKin(result, ego, alter, edge.getType().inverse());
            }
            catch (PuckException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void getBicomponent(Stack<KinLink> stack, KinLink e, boolean all) {
        Stack<Object> bico = new Stack<KinLink>();
        if (e == null) {
            bico = stack;
        } else {
            bico.push(stack.pop());
            while (bico.peek() != e) {
                bico.push(stack.pop());
            }
        }
        if (!bico.isEmpty()) {
            this.count(this.bicomponents, bico.size());
        }
        if (!all && bico.size() <= this.bicomax.size()) {
            return;
        }
        if (!all) {
            this.bicomax.clear();
        }
        while (!bico.isEmpty()) {
            this.bicomax.push((KinLink)bico.pop());
        }
    }

    private static <E> void clear(Stack<E> stack, E e) {
        while (stack.pop() != e) {
        }
    }
}

