/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.AlterAge;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.roles.ExtendedActor;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleActorPair;
import org.tip.puck.net.relations.roles.RoleActors;
import org.tip.puck.net.relations.roles.RoleDefinition;
import org.tip.puck.net.relations.roles.RoleDefinitions;
import org.tip.puck.net.relations.roles.RoleRelation;
import org.tip.puck.net.relations.roles.RoleRelations;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.statistics.StatisticsWorker;

public class RoleRelationMaker {
    private static final Logger logger = LoggerFactory.getLogger(RoleRelationMaker.class);

    public static String getName(String fileName) {
        int idx = fileName.indexOf(".term");
        String result = idx < 0 ? fileName : fileName.substring(0, idx);
        return result;
    }

    public static List<RoleRelationRule> getDefaultRules() {
        ArrayList<RoleRelationRule> result = new ArrayList<RoleRelationRule>();
        RoleRelationRule[] roleRelationRuleArray = RoleRelationRule.values();
        int n = roleRelationRuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoleRelationRule rule = roleRelationRuleArray[n2];
            if (rule != RoleRelationRule.SIBLING_PARENT_CHILD) {
                result.add(rule);
            }
            ++n2;
        }
        return result;
    }

    private static void compose(RoleDefinitions definitions, Individual self, Queue<Individual> queue, List<String> egoNeutral, Individuals visited, String egoName) {
        Gender egoGender = Gender.valueOf(self.getAttributeValue("EGOGENDER"));
        for (KinType kinType : KinType.basicTypesWithSiblings()) {
            for (Individual alter : self.getKin(kinType)) {
                AlterAge alterAge = alter.getRelativeAge(self);
                alter.setAttribute("EGOGENDER", egoGender.toString());
                definitions.add(new RoleDefinition(self.getName(), alter.getName(), kinType.toString(), egoGender, alter.getGender(), alterAge, egoName));
                if (visited.contains(alter)) continue;
                queue.add(alter);
            }
        }
        visited.add(self);
    }

    public static RelationModel create(Net net, Report report) throws PuckException {
        RelationModel result = new RelationModel(net.getLabel());
        RoleRelationMaker.createRoleRelationsFromGenealogy(result, net, report);
        return result;
    }

    public static RelationModel createEtic(String name, String selfName, StringList roleDefinitionsList, List<RoleRelationRule> rules, Report report) throws PuckException {
        RelationModel result = new RelationModel(RoleRelationMaker.getName(name), rules);
        RoleRelationMaker.createRoleRelationsEticFormat(result, selfName, roleDefinitionsList, report);
        return result;
    }

    public static RelationModel createFromMap(String name, List<RoleActorPair> actorPairs, Report report) throws PuckException {
        RelationModel result = new RelationModel(RoleRelationMaker.getName(name));
        RoleRelationMaker.createRoleRelationsMapFormat(result, actorPairs, report);
        return result;
    }

    public static RelationModel createStandard(String name, String selfName, StringList roleDefinitionsList, List<RoleRelationRule> rules, Report report) throws PuckException {
        RelationModel result = new RelationModel(RoleRelationMaker.getName(name), rules);
        RoleRelationMaker.createRoleRelationsStandardFormat(result, selfName, roleDefinitionsList, report);
        return result;
    }

    public static RelationModel createEmic(String name, String selfName, StringList roleDefinitionsList, List<RoleRelationRule> rules, Report report) throws PuckException {
        RelationModel result = new RelationModel(RoleRelationMaker.getName(name), rules);
        RoleRelationMaker.createRoleRelationsEmicFormat(result, selfName, roleDefinitionsList, report);
        return result;
    }

    public static RoleRelations createRoleRelationsFromGenealogy(RelationModel model, Net net, Report report) throws PuckException {
        RoleRelations result = new RoleRelations();
        String selfName = ((Individual)net.individuals().getFirst()).getName();
        result.setSelfName(selfName);
        model.setRoleRelations(result);
        LinkedList<Individual> queue = new LinkedList<Individual>();
        Individual maleEgo = null;
        Individual femaleEgo = null;
        for (Individual indi : net.individuals()) {
            if (!indi.getName().equalsIgnoreCase(result.getSelfName())) continue;
            indi.setAttribute("EGOGENDER", indi.getGender().toString());
            indi.setAttribute("GENERATION", "0");
            queue.add(indi);
            if (indi.isMale()) {
                maleEgo = indi;
            } else if (indi.isFemale()) {
                femaleEgo = indi;
            }
            if (maleEgo == null || femaleEgo == null) continue;
            result.setEgoGenderDistinction(true);
            break;
        }
        ArrayList<String> egoNeutral = new ArrayList<String>();
        if (maleEgo != null && maleEgo.isSterile() || femaleEgo != null && femaleEgo.isSterile() || !result.isEgoGenderDistinction()) {
            egoNeutral.add("PARENT");
        }
        if (maleEgo != null && maleEgo.isOrphan() || femaleEgo != null && femaleEgo.isOrphan() || !result.isEgoGenderDistinction()) {
            egoNeutral.add("CHILD");
        }
        if (maleEgo != null && maleEgo.isSingle() || femaleEgo != null && femaleEgo.isSingle() || !result.isEgoGenderDistinction()) {
            egoNeutral.add("SPOUSE");
        }
        if (maleEgo != null && maleEgo.isUnique() || femaleEgo != null && femaleEgo.isUnique() || !result.isEgoGenderDistinction()) {
            egoNeutral.add("SIBLING");
        }
        RoleDefinitions definitions = new RoleDefinitions();
        Individuals visited = new Individuals();
        while (!queue.isEmpty()) {
            Individual self = (Individual)queue.poll();
            RoleRelationMaker.compose(definitions, self, queue, egoNeutral, visited, selfName);
        }
        result.updateGenderConfigs();
        result.heteroMarriage = StatisticsWorker.hasSameGenderMarriages(net);
        result = RoleRelationMaker.createRoleRelations(definitions, selfName, model.getRules(), report);
        model.setRoleRelations(result);
        for (RoleActor roleActor : result.getSortedSelfs()) {
        }
        return result;
    }

    private static String[] splitLastValid(String item) {
        String[] result = new String[2];
        int idx = item.length() - 1;
        while (idx > -1) {
            String lastItem = item.substring(idx);
            if (KinType.valueOfLetter(lastItem) != null) {
                if (idx > 0 && AlterAge.valueOfLetter(item.charAt(idx - 1)) != null) {
                    --idx;
                }
                result[0] = item.substring(0, idx);
                result[1] = item.substring(idx);
                break;
            }
            --idx;
        }
        return result;
    }

    private static MetaRole getMetaRoleFromString(String item) {
        KinType type;
        MetaRole result = new MetaRole(null);
        if (item.charAt(0) == 'e' || item.charAt(0) == 'y') {
            result.setAlterAge(AlterAge.valueOfLetter(item.charAt(0)));
            item = item.substring(1);
        }
        if (item != null && (type = KinType.valueOfLetter(item)) != null) {
            result.setName("" + (Object)((Object)type.ungendered()));
            result.setAlterGender(type.getGender());
        }
        return result;
    }

    public static RoleRelations createRoleRelationsEticFormat(RelationModel model, String selfName, StringList rolePositionList, Report report) throws PuckException {
        int maxIterations = 5;
        RoleRelations result = new RoleRelations();
        result.selfName = selfName;
        RoleDefinitions definitions = new RoleDefinitions();
        LinkedList<RoleDefinition> queue = new LinkedList<RoleDefinition>();
        for (String rolePositionLine : rolePositionList) {
            String[] items = rolePositionLine.split("\t");
            Role alterTerm = null;
            Role selfTerm = null;
            MetaRole metaRole = null;
            int idx = 0;
            while (idx < items.length) {
                String item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            alterTerm = new Role(item);
                            break;
                        }
                        case 1: {
                            String[] terms = RoleRelationMaker.splitLastValid(item);
                            selfTerm = !StringUtils.isBlank((CharSequence)terms[0]) ? new Role(terms[0]) : new Role(selfName);
                            metaRole = RoleRelationMaker.getMetaRoleFromString(terms[1]);
                            break;
                        }
                        case 2: {
                            metaRole.setEgoGender(Gender.valueOf(item.charAt(0)));
                        }
                    }
                }
                ++idx;
            }
            RoleActor alter = new RoleActor(alterTerm, metaRole, selfName);
            RoleDefinition definition = new RoleDefinition(selfTerm, alter);
            definition.setLetters(items[1]);
            if (selfTerm.hasName(selfName)) {
                definitions.add(definition);
                continue;
            }
            queue.add(definition);
        }
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (RoleDefinition definition : queue) {
            count.put(definition.getSelfTerm().getName(), 0);
        }
        while (!queue.isEmpty()) {
            RoleDefinition definition;
            definition = (RoleDefinition)queue.poll();
            for (RoleDefinition selfDefinition : definitions.get(definition.getSelfTerm().getName(), definition.getEgoGender())) {
                if (selfDefinition != null) {
                    definition.getSelfTerm().setName(selfDefinition.getAlterTerm().getName());
                    definitions.add(definition);
                    continue;
                }
                if ((Integer)count.get(definition.getSelfTerm().getName()) <= maxIterations) {
                    count.put(definition.getSelfTerm().getName(), (Integer)count.get(definition.getSelfTerm().getName()) + 1);
                    queue.add(definition);
                    continue;
                }
                logger.warn("No medius term defined for " + definition);
            }
        }
        result = RoleRelationMaker.createRoleRelations(definitions, selfName, model.getRules(), report);
        model.setRoleRelations(result);
        logger.debug("Model " + model + " created");
        return result;
    }

    public static RoleRelations createRoleRelationsEmicFormat1(RelationModel model, String selfName, StringList roleRelationsList, Report report) throws PuckException {
        RoleActor alter;
        String item;
        AlterAge alterAge;
        Gender alterGender;
        Gender egoGender;
        String metaRoleName;
        Role selfTerm;
        Role alterTerm;
        String[] items;
        RoleDefinitions definitions = new RoleDefinitions();
        HashMap<String, RoleActor> elementaryTerms = new HashMap<String, RoleActor>();
        for (String roleRelationLine : roleRelationsList) {
            items = roleRelationLine.split("\t");
            if (StringUtils.isEmpty((CharSequence)items[1])) continue;
            alterTerm = null;
            selfTerm = new Role(selfName);
            metaRoleName = KinType.SELF.toString();
            egoGender = Gender.UNKNOWN;
            alterGender = Gender.UNKNOWN;
            alterAge = AlterAge.UNKNOWN;
            int idx = 0;
            while (idx < items.length) {
                item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            alterTerm = model.role(item);
                            break;
                        }
                        case 1: {
                            metaRoleName = item;
                            break;
                        }
                        case 5: {
                            alterGender = Gender.valueOf(item);
                            break;
                        }
                        case 6: {
                            alterAge = AlterAge.valueOf(item);
                            break;
                        }
                        case 7: {
                            egoGender = Gender.valueOf(item);
                        }
                    }
                }
                ++idx;
            }
            alter = new RoleActor(alterTerm, new MetaRole(metaRoleName, egoGender, alterGender, alterAge), selfName);
            definitions.add(new RoleDefinition(selfTerm, alter));
            elementaryTerms.put(alterTerm.toString(), alter);
        }
        for (String roleRelationLine : roleRelationsList) {
            items = roleRelationLine.split("\t");
            if (StringUtils.isEmpty((CharSequence)items[2])) continue;
            alterTerm = null;
            selfTerm = new Role(selfName);
            metaRoleName = KinType.SELF.toString();
            egoGender = Gender.UNKNOWN;
            alterGender = Gender.UNKNOWN;
            alterAge = AlterAge.UNKNOWN;
            int idx = 0;
            while (idx < items.length) {
                item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            alterTerm = model.role(item);
                            break;
                        }
                        case 2: {
                            RoleActor inverseAlter = (RoleActor)elementaryTerms.get(item);
                            if (inverseAlter != null) {
                                metaRoleName = MetaRole.invertName(inverseAlter.getRole().getName());
                                egoGender = inverseAlter.getEgoGender();
                                break;
                            }
                            throw PuckExceptions.INVALID_PARAMETER.create(null, "Non-elementary reference term: " + item, new Object[0]);
                        }
                        case 5: {
                            alterGender = Gender.valueOf(item);
                            break;
                        }
                        case 6: {
                            alterAge = AlterAge.valueOf(item);
                            break;
                        }
                        case 7: {
                            egoGender = Gender.valueOf(item);
                        }
                    }
                }
                ++idx;
            }
            alter = new RoleActor(alterTerm, new MetaRole(metaRoleName, egoGender, alterGender, alterAge), selfName);
            definitions.add(new RoleDefinition(selfTerm, alter));
            elementaryTerms.put(alterTerm.toString(), alter);
        }
        for (String roleRelationLine : roleRelationsList) {
            items = roleRelationLine.split("\t");
            if (!StringUtils.isEmpty((CharSequence)items[1]) || !StringUtils.isEmpty((CharSequence)items[2])) continue;
            alterTerm = null;
            selfTerm = new Role(selfName);
            metaRoleName = KinType.SELF.toString();
            egoGender = Gender.UNKNOWN;
            alterGender = Gender.UNKNOWN;
            alterAge = AlterAge.UNKNOWN;
            int idx = 0;
            while (idx < items.length) {
                item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            alterTerm = model.role(item);
                            break;
                        }
                        case 3: {
                            selfTerm = model.role(item);
                            break;
                        }
                        case 4: {
                            RoleActor generator = (RoleActor)elementaryTerms.get(item);
                            if (generator != null) {
                                metaRoleName = generator.getRole().getName();
                                alterGender = generator.getAlterGender();
                                egoGender = generator.getEgoGender();
                                alterAge = generator.getAlterAge();
                                break;
                            }
                            throw PuckExceptions.INVALID_PARAMETER.create(null, "Non-elementary generator term: " + item, new Object[0]);
                        }
                        case 5: {
                            alterGender = Gender.valueOf(item);
                            break;
                        }
                        case 6: {
                            alterAge = AlterAge.valueOf(item);
                            break;
                        }
                        case 7: {
                            egoGender = Gender.valueOf(item);
                        }
                    }
                }
                ++idx;
            }
            alter = new RoleActor(alterTerm, new MetaRole(metaRoleName, egoGender, alterGender, alterAge), selfName);
            definitions.add(new RoleDefinition(selfTerm, alter));
        }
        RoleRelations result = RoleRelationMaker.createRoleRelations(definitions, selfName, model.getRules(), report);
        model.setRoleRelations(result);
        logger.debug("Model " + model + " created");
        return result;
    }

    public static RoleRelations createRoleRelationsEmicFormat(RelationModel model, String selfName, StringList roleRelationsList, Report report) throws PuckException {
        RoleDefinition definition;
        StringList subReport;
        RoleActor alter;
        String item;
        AlterAge alterAge;
        Gender alterGender;
        Gender egoGender;
        String metaRoleName;
        Role selfTerm;
        Role alterTerm;
        String[] items;
        RoleDefinitions definitions = new RoleDefinitions();
        RoleDefinitions composedDefinitions = new RoleDefinitions();
        RoleDefinitions inverseDefinitions = new RoleDefinitions();
        HashMap<String, RoleActor> elementaryTerms = new HashMap<String, RoleActor>();
        for (String roleRelationLine : roleRelationsList) {
            items = roleRelationLine.split("\t");
            if (StringUtils.isEmpty((CharSequence)items[1])) continue;
            alterTerm = null;
            selfTerm = new Role(selfName);
            metaRoleName = KinType.SELF.toString();
            egoGender = Gender.UNKNOWN;
            alterGender = Gender.UNKNOWN;
            alterAge = AlterAge.UNKNOWN;
            int idx = 0;
            while (idx < items.length) {
                String item2 = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item2)) {
                    switch (idx) {
                        case 0: {
                            alterTerm = model.role(item2);
                            break;
                        }
                        case 1: {
                            metaRoleName = item2;
                            break;
                        }
                        case 5: {
                            alterGender = Gender.valueOf(item2);
                            break;
                        }
                        case 6: {
                            alterAge = AlterAge.valueOf(item2);
                            break;
                        }
                        case 7: {
                            egoGender = Gender.valueOf(item2);
                        }
                    }
                }
                ++idx;
            }
            RoleActor alter2 = new RoleActor(alterTerm, new MetaRole(metaRoleName, egoGender, alterGender, alterAge), selfName);
            definitions.add(new RoleDefinition(selfTerm, alter2));
            elementaryTerms.put(alterTerm.toString(), alter2);
        }
        for (String roleRelationLine : roleRelationsList) {
            items = roleRelationLine.split("\t");
            if (StringUtils.isEmpty((CharSequence)items[2])) continue;
            alterTerm = null;
            selfTerm = new Role(selfName);
            metaRoleName = KinType.SELF.toString();
            egoGender = Gender.UNKNOWN;
            alterGender = Gender.UNKNOWN;
            alterAge = AlterAge.UNKNOWN;
            String inverseTerm = null;
            int idx = 0;
            while (idx < items.length) {
                item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            alterTerm = model.role(item);
                            break;
                        }
                        case 2: {
                            RoleActor inverseAlter = (RoleActor)elementaryTerms.get(item);
                            if (inverseAlter != null) {
                                metaRoleName = MetaRole.invertName(inverseAlter.getRole().getName());
                                egoGender = inverseAlter.getEgoGender();
                                break;
                            }
                            metaRoleName = null;
                            inverseTerm = item;
                            break;
                        }
                        case 5: {
                            alterGender = Gender.valueOf(item);
                            break;
                        }
                        case 6: {
                            alterAge = AlterAge.valueOf(item);
                            break;
                        }
                        case 7: {
                            egoGender = Gender.valueOf(item);
                        }
                    }
                }
                ++idx;
            }
            alter = new RoleActor(alterTerm, new MetaRole(metaRoleName, egoGender, alterGender, alterAge), selfName);
            if (metaRoleName != null) {
                definitions.add(new RoleDefinition(selfTerm, alter));
                elementaryTerms.put(alterTerm.toString(), alter);
                continue;
            }
            alter.setAttribute("INVERSE", inverseTerm);
            inverseDefinitions.add(new RoleDefinition(selfTerm, alter));
        }
        for (String roleRelationLine : roleRelationsList) {
            items = roleRelationLine.split("\t");
            if (!StringUtils.isEmpty((CharSequence)items[1]) || !StringUtils.isEmpty((CharSequence)items[2])) continue;
            alterTerm = null;
            selfTerm = new Role(selfName);
            metaRoleName = KinType.SELF.toString();
            egoGender = Gender.UNKNOWN;
            alterGender = Gender.UNKNOWN;
            alterAge = AlterAge.UNKNOWN;
            String generatorTerm = null;
            int idx = 0;
            while (idx < items.length) {
                item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            alterTerm = model.role(item);
                            break;
                        }
                        case 3: {
                            selfTerm = model.role(item);
                            break;
                        }
                        case 4: {
                            RoleActor generator = (RoleActor)elementaryTerms.get(item);
                            if (generator != null) {
                                metaRoleName = generator.getRole().getName();
                                alterGender = generator.getAlterGender();
                                egoGender = generator.getEgoGender();
                                alterAge = generator.getAlterAge();
                                break;
                            }
                            metaRoleName = null;
                            generatorTerm = item;
                            break;
                        }
                        case 5: {
                            alterGender = Gender.valueOf(item);
                            break;
                        }
                        case 6: {
                            alterAge = AlterAge.valueOf(item);
                            break;
                        }
                        case 7: {
                            egoGender = Gender.valueOf(item);
                        }
                    }
                }
                ++idx;
            }
            alter = new RoleActor(alterTerm, new MetaRole(metaRoleName, egoGender, alterGender, alterAge), selfName);
            if (metaRoleName != null) {
                definitions.add(new RoleDefinition(selfTerm, alter));
                continue;
            }
            alter.setAttribute("GENERATOR", generatorTerm);
            composedDefinitions.add(new RoleDefinition(selfTerm, alter));
        }
        StringList resolved = new StringList();
        StringList unresolved = new StringList();
        int resolvedCount = 0;
        int unresolvedCount = 0;
        for (RoleDefinition protoDefinition : inverseDefinitions) {
            Role inverseTerm = new Role(protoDefinition.getAlter().getAttributeValue("INVERSE"));
            subReport = new StringList();
            definition = definitions.reinvert(protoDefinition.getAlter(), inverseTerm, elementaryTerms, subReport);
            if (definition != null) {
                definitions.add(definition);
                resolved.appendln("Resolved definition: " + protoDefinition.getAlterTerm() + " as inverse of " + inverseTerm);
                resolved.appendln(subReport);
                ++resolvedCount;
                continue;
            }
            resolved.appendln("Unresolved definition: " + protoDefinition.getAlterTerm() + " as inverse of " + inverseTerm);
            unresolved.appendln(subReport);
            ++unresolvedCount;
        }
        for (RoleDefinition protoDefinition : composedDefinitions) {
            Role generatorTerm = new Role(protoDefinition.getAlter().getAttributeValue("GENERATOR"));
            subReport = new StringList();
            definition = definitions.recompose(protoDefinition.getSelfTerm(), protoDefinition.getAlterTerm(), generatorTerm, elementaryTerms, subReport);
            if (definition != null) {
                definitions.add(definition);
                resolved.appendln("Resolved definition: " + protoDefinition.getAlterTerm() + " as " + generatorTerm + " of  " + protoDefinition.getSelfTerm());
                resolved.appendln(subReport);
                ++resolvedCount;
                continue;
            }
            unresolved.appendln("Unresolved definition: " + protoDefinition.getAlterTerm() + " as " + generatorTerm + " of  " + protoDefinition.getSelfTerm());
            unresolved.appendln(subReport);
            ++unresolvedCount;
        }
        if (resolvedCount > 0) {
            report.outputs().appendln(String.valueOf(resolvedCount) + " resolved definitions");
            report.outputs().appendln();
            report.outputs().appendln(resolved);
        }
        if (unresolvedCount > 0) {
            report.outputs().appendln(String.valueOf(unresolvedCount) + " unresolved definitions");
            report.outputs().appendln();
            report.outputs().appendln(unresolved);
        }
        RoleRelations result = RoleRelationMaker.createRoleRelations(definitions, selfName, model.getRules(), report);
        model.setRoleRelations(result);
        logger.debug("Model " + model + " created");
        return result;
    }

    public static RoleRelations createRoleRelationsMapFormat(RelationModel model, List<RoleActorPair> actorPairs, Report report) throws PuckException {
        String selfName = actorPairs.get(0).getSelf().getSelfName();
        RoleRelations result = RoleRelationMaker.createRoleRelations(actorPairs, selfName, report);
        model.setRoleRelations(result);
        for (RoleActor roleActor : result.getSortedSelfs()) {
        }
        logger.debug("Model " + model + " created");
        return result;
    }

    public static RoleRelations createRoleRelationsStandardFormat(RelationModel model, String selfName, StringList roleRelationsList, Report report) throws PuckException {
        RoleDefinitions definitions = new RoleDefinitions();
        RoleDefinitions firstDefinitions = new RoleDefinitions();
        RoleDefinitions secondDefinitions = new RoleDefinitions();
        for (String roleRelationLine : roleRelationsList) {
            String[] items = roleRelationLine.split("\t");
            Role alterTerm = null;
            Role selfTerm = new Role(selfName);
            String metaRoleName = KinType.SELF.toString();
            Gender egoGender = Gender.UNKNOWN;
            Gender alterGender = Gender.UNKNOWN;
            AlterAge alterAge = AlterAge.UNKNOWN;
            int idx = 0;
            while (idx < items.length) {
                String item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            alterTerm = model.role(item);
                            break;
                        }
                        case 1: {
                            selfTerm = model.role(item);
                            break;
                        }
                        case 2: {
                            metaRoleName = item;
                            break;
                        }
                        case 3: {
                            egoGender = Gender.valueOf(item);
                            break;
                        }
                        case 4: {
                            alterGender = Gender.valueOf(item);
                            break;
                        }
                        case 5: {
                            alterAge = AlterAge.valueOf(item);
                        }
                    }
                }
                ++idx;
            }
            RoleActor alter = new RoleActor(alterTerm, new MetaRole(metaRoleName, egoGender, alterGender, alterAge), selfName);
            RoleDefinition definition = new RoleDefinition(selfTerm, alter);
            if (selfTerm.hasName(selfName) || alter.hasName(selfName)) {
                firstDefinitions.add(definition);
                continue;
            }
            secondDefinitions.add(definition);
        }
        definitions.addAll(firstDefinitions);
        definitions.addAll(secondDefinitions);
        RoleRelations result = RoleRelationMaker.createRoleRelations(definitions, selfName, model.getRules(), report);
        model.setRoleRelations(result);
        for (RoleActor roleActor : result.getSortedSelfs()) {
        }
        logger.debug("Model " + model + " created");
        return result;
    }

    private static RoleRelations createRoleRelations(List<RoleActorPair> actorPairs, String selfName, Report report) throws PuckException {
        RoleRelations result = new RoleRelations();
        result.selfName = selfName;
        result.heteroMarriage = true;
        for (RoleActorPair pair : actorPairs) {
            result.updateGenderConfigs(pair.getSelf());
            result.updateGenderConfigs(pair.getAlter());
            if (!result.heteroMarriage() || !pair.getAlter().isSpouse() || pair.getSelf().getAlterGender() != pair.getAlter().getAlterGender()) continue;
            result.heteroMarriage = false;
        }
        StringList subReport = new StringList();
        subReport.appendln("Read role definitions");
        subReport.appendln();
        for (RoleActorPair pair : actorPairs) {
            RoleRelationMaker.putRoleRelation(result, new RoleActorPair(result, pair.getSelf(), pair.getAlter(), RoleActorPair.Adjustable.SELF), false, subReport);
        }
        return result;
    }

    private static RoleRelations createRoleRelations(RoleDefinitions definitions, String selfName, List<RoleRelationRule> rules, Report report) throws PuckException {
        RoleRelations result = new RoleRelations();
        result.selfName = selfName;
        result.setOriginalDefinitions(definitions);
        result.updateGenderConfigs(definitions);
        StringList subReport = new StringList();
        subReport.appendln("Read role definitions");
        subReport.appendln();
        for (RoleDefinition definition : definitions.toSortedList()) {
            if (!definition.getSelfTerm().hasName(selfName) && result.getGenderConfigs().get(definition.getSelfTerm()) == null) {
                throw PuckExceptions.INVALID_PARAMETER.create(null, "Undefined reference term: " + definition.getSelfTerm() + "\t in " + definition, new Object[0]);
            }
            if (!definition.getAlter().hasName(selfName) && result.getGenderConfigs().get(definition.getAlterTerm()) == null) {
                throw PuckExceptions.INVALID_PARAMETER.create(null, "Undefined alter term: " + definition.getAlterTerm() + "\t in " + definition, new Object[0]);
            }
            RoleRelationMaker.putRoleRelation(result, definition.getPair(result, RoleActorPair.Adjustable.SELF), true, subReport);
        }
        logger.debug("Definitions read");
        if (rules != null) {
            Collections.sort(rules);
            for (RoleRelationRule rule : rules) {
                RoleRelationMaker.composeRelations(result, rule.getAlterRoleName(), rule.getMediusRoleName(), rule.getMediusAlterRoleName(), subReport);
            }
        }
        report.outputs().appendln("Configurating definitions");
        report.outputs().appendln();
        for (String basicDefinition : result.getBasicRoleDefinitions().toSortedStringList()) {
            report.outputs().appendln(basicDefinition);
        }
        report.outputs().appendln();
        report.outputs().append(subReport);
        return result;
    }

    private static boolean removeRoleDefinition(RoleRelations relations, RoleActorPair pair, boolean withReciprocal, RoleDefinitions immortals, StringList report) {
        boolean result = false;
        if (pair.isValid()) {
            RoleActor self = pair.getSelf();
            RoleActor alter = pair.getAlter();
            RoleRelation relation = relations.getSelfRelation(self);
            if (immortals == null || !immortals.contains(new RoleDefinition(self.getIndividual(), alter))) {
                if (relation != null && relation.hasActor(alter)) {
                    if (relation.getActors().remove(alter)) {
                        report.appendln("Removed" + RoleRelationMaker.reciprocal(withReciprocal) + "role:\t" + alter.getIndividual() + "\t" + self.getIndividual() + "\t" + alter.getRole());
                    }
                    result = true;
                }
                if (withReciprocal && !self.equalsAbsolute(alter)) {
                    RoleRelationMaker.removeRoleDefinition(relations, pair.reciprocal(relations), false, immortals, report);
                }
            }
        }
        return result;
    }

    private static boolean neutralizeEgoGender(RoleRelations relations, RoleActorPair pair, boolean withReciprocal, StringList report) {
        boolean result;
        block1: {
            RoleActor alter;
            RoleActor self;
            block2: {
                block3: {
                    result = false;
                    if (!pair.isValid()) break block1;
                    self = pair.getSelf();
                    alter = pair.getAlter();
                    if (self.getEgoGender().isUnknown()) break block2;
                    RoleRelation egoNeutralSelfRelation = relations.getSelfRelation(self.egoGenderNeutral());
                    if (egoNeutralSelfRelation == null || !egoNeutralSelfRelation.hasActor(alter.egoGenderNeutral())) break block3;
                    result = true;
                    break block1;
                }
                if (!RoleRelationMaker.removeRoleDefinition(relations, new RoleActorPair(relations, self.egoGenderComplement(), alter.egoGenderComplement(), pair.getAdjustable()), true, null, report)) break block1;
                RoleRelationMaker.putRoleRelation(relations, new RoleActorPair(relations, self.egoGenderNeutral(), alter.egoGenderNeutral(), pair.getAdjustable()), withReciprocal, report);
                result = true;
                break block1;
            }
            for (Gender egoGender : Gender.valuesNotUnknown()) {
                RoleRelationMaker.removeRoleDefinition(relations, new RoleActorPair(relations, self.withEgoGender(egoGender), alter.withEgoGender(egoGender), pair.getAdjustable()), true, null, report);
            }
        }
        return result;
    }

    private static String reciprocal(boolean withReciprocal) {
        String result = " ";
        if (!withReciprocal) {
            result = " reciprocal ";
        }
        return result;
    }

    private static void putRoleRelation(RoleRelations relations, RoleActorPair pair, boolean withReciprocal, StringList report) {
        if (pair.isValid()) {
            RoleActor self = pair.getSelf();
            RoleActor alter = pair.getAlter();
            if (!RoleRelationMaker.neutralizeEgoGender(relations, pair, withReciprocal, report)) {
                RoleRelation relation = relations.getSelfRelation(self);
                if (relation == null) {
                    relation = new RoleRelation(relations.size() + 1);
                    relation.getActors().addNonRedundant(self);
                    relations.addAndUpdate(relation);
                }
                if (relation.getActors().addNonRedundant(alter)) {
                    if (relations.updateGenderConfigs(alter)) {
                        report.appendln("Updated configuration\t" + alter + "\t" + relations.getGenderConfigs().get(alter.getIndividual()));
                    }
                    report.appendln("Defined" + RoleRelationMaker.reciprocal(withReciprocal) + "role:\t" + alter.getIndividual() + "\t" + self.getIndividual() + "\t" + alter.getRole());
                    if (withReciprocal) {
                        RoleRelationMaker.putRoleRelation(relations, pair.reciprocal(relations), false, report);
                    }
                }
            }
        }
    }

    private static boolean isEgoLinked(RoleRelations relations, RoleActor actor, Map<Role, Roles> genderConfigs) {
        boolean result = false;
        RoleRelation selfRelation = relations.getSelfRelation(actor);
        if (selfRelation != null) {
            for (RoleActor alter : selfRelation.getActorsByRoleNameWithUnspecific(null, relations)) {
                if (!alter.hasSelfName()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static boolean isClassificatory(RoleRelations relations, RoleActor actor) {
        boolean result = false;
        for (RoleActor alter : actor.getActorsByRoleNameWithUnspecific("SIBLING", relations)) {
            if (!alter.getName().equals(actor.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isIndividualizable(RoleRelations relations, RoleActor actor) {
        boolean result = actor.isPersonal(relations) && !RoleRelationMaker.isClassificatory(relations, actor);
        return result;
    }

    private static void composeRelations(RoleRelations relations, String alterRoleName, String mediusRoleName, String mediusAlterRoleName, StringList report) {
        report.appendln("Added " + alterRoleName + " links (mediated as " + mediusAlterRoleName + " of " + mediusRoleName + ")");
        report.appendln();
        for (RoleActor medius : relations.getSortedSelfs()) {
            StringList subReport = new StringList();
            RoleRelation mediusRelation = relations.getSelfRelation(medius);
            List<RoleActor> alters = mediusRelation.getActorsByRoleNameWithUnspecific(mediusAlterRoleName, relations).toListSortedByDistances(relations);
            List<RoleActor> selfs = mediusRelation.getActorsByRoleNameWithUnspecific(MetaRole.invertName(mediusRoleName), relations).toListSortedByDistances(relations);
            for (RoleActor self : selfs) {
                for (RoleActor alter : alters) {
                    if (!RoleRelationMaker.isComposable(relations, medius, alter, self, alterRoleName, mediusRoleName, mediusAlterRoleName)) continue;
                    RoleRelationMaker.putRoleRelation(relations, new RoleActorPair(relations, self, alter.cloneAs(alterRoleName), RoleActorPair.Adjustable.SELF), true, subReport);
                }
            }
            if (subReport.isEmpty()) continue;
            report.appendln("Added " + alterRoleName + " link between " + MetaRole.invertName(mediusRoleName) + " and " + mediusAlterRoleName + " of " + medius);
            report.append(subReport);
            report.appendln();
        }
        logger.debug("Relations composed: " + alterRoleName + "-" + mediusRoleName + "-" + mediusAlterRoleName);
    }

    private static RoleActors getCommonParents(RoleRelations relations, RoleActor self, RoleActor alter, RoleActor medius) {
        RoleActors result = new RoleActors();
        for (RoleActor parent : relations.getSortedActors()) {
            RoleActors children = parent.getActorsByRoleNameWithUnspecific("CHILD", relations);
            if (!children.containsAbsolute(self) || !children.containsAbsolute(alter) || !children.containsAbsolute(medius)) continue;
            result.addNew(parent);
        }
        return result;
    }

    private static boolean haveCommonParent(RoleRelations relations, RoleActor self, RoleActor alter, RoleActor medius) {
        boolean result = false;
        for (RoleRelation relation : relations) {
            RoleActors children = relation.getActorsByRoleNameWithUnspecific("CHILD", relations);
            if (!children.containsAbsolute(self) || !children.containsAbsolute(alter) || !children.containsAbsolute(medius)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isComposable(RoleRelations relations, RoleActor medius, RoleActor alter, RoleActor self, String alterRoleName, String mediusRoleName, String mediusAlterRoleName) {
        boolean result = true;
        if (relations.getEgoGenderScope(self) != relations.getEgoGenderScope(alter)) {
            result = false;
        } else if (self.hasSelfName() || alter.hasSelfName()) {
            result = false;
        } else if (alterRoleName.equals("SPOUSE") && self.equalsAbsolute(alter)) {
            result = false;
        } else if (alterRoleName.equals("SPOUSE") && relations.heteroMarriage() && self.getAlterGender() != alter.getAlterGender().invert()) {
            result = false;
        } else if (mediusAlterRoleName.equals("SIBLING") && mediusRoleName.equals("SIBLING")) {
            result = RoleRelationMaker.haveCommonParent(relations, self, alter, medius) && !RoleRelationMaker.isIndividualizable(relations, alter) && !RoleRelationMaker.isIndividualizable(relations, self);
        } else {
            RoleRelation alterRelation;
            RoleRelation mediusRelation = relations.getSelfRelation(medius);
            for (RoleActor otherSelf : mediusRelation.getActorsByRoleNameWithUnspecific(MetaRole.invertName(mediusRoleName), relations)) {
                if (otherSelf.matchesAbsolute(self) || !otherSelf.getEgoGender().matchs(self.getEgoGender()) || !otherSelf.getAlterGender().matchs(self.getAlterGender())) continue;
                result = false;
                break;
            }
            if (result && (alterRelation = relations.getSelfRelation(alter)) != null) {
                for (RoleActor otherSelf : alterRelation.getActorsByRoleNameWithUnspecific(MetaRole.invertName(alterRoleName), relations)) {
                    if (otherSelf.matchesAbsolute(self) || !otherSelf.getEgoGender().matchs(self.getEgoGender()) || !otherSelf.getAlterGender().matchs(self.getAlterGender())) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    private static void fixCommonParent(RoleRelations relations, RoleActor self, RoleActor alter, RoleActor medius, RoleDefinitions immortals) {
        RoleDefinitions minimalDefinitions = null;
        RoleActor selfChild = self.cloneAs("CHILD");
        RoleActor alterChild = alter.cloneAs("CHILD");
        RoleActor mediusChild = medius.cloneAs("CHILD");
        for (RoleActor parent : RoleRelationMaker.getCommonParents(relations, self, alter, medius).toListSortedByDistances(relations)) {
            RoleDefinitions missingDefinitions = new RoleDefinitions();
            Role parentTerm = parent.getIndividual();
            boolean hasSelf = false;
            boolean hasAlter = false;
            boolean hasMedius = false;
            for (RoleDefinition definition : immortals.getBySelfTerm(parentTerm).toSortedList()) {
                if (definition.getAlter().equals(selfChild)) {
                    hasSelf = true;
                }
                if (definition.getAlter().equals(alterChild)) {
                    hasAlter = true;
                }
                if (!definition.getAlter().equals(mediusChild)) continue;
                hasMedius = true;
            }
            if (!hasSelf) {
                missingDefinitions.add(relations.getStandardRoleDefinition(parent, selfChild));
            }
            if (!hasAlter) {
                missingDefinitions.add(relations.getStandardRoleDefinition(parent, alterChild));
            }
            if (!hasMedius) {
                missingDefinitions.add(relations.getStandardRoleDefinition(parent, mediusChild));
            }
            if ((minimalDefinitions == null || missingDefinitions.size() < minimalDefinitions.size()) && (minimalDefinitions = missingDefinitions).size() == 0) break;
        }
        for (RoleDefinition minimalDefinition : minimalDefinitions.toSortedList()) {
            immortals.addNew(minimalDefinition);
        }
        immortals.addAll(minimalDefinitions);
    }

    private static void decomposeRelations(RoleRelations relations, String alterRoleName, String mediusRoleName, String mediusAlterRoleName, RoleDefinitions immortals, Report report) {
        report.outputs().appendln("Removed " + alterRoleName + " links (mediated as " + mediusAlterRoleName + " of " + mediusRoleName + ")");
        report.outputs().appendln();
        RoleDefinitions tempImmortals = new RoleDefinitions();
        for (RoleActor medius : relations.getSortedSelfs()) {
            StringList subReport = new StringList();
            RoleRelation mediusRelation = relations.getSelfRelation(medius);
            List<RoleActor> alters = mediusRelation.getActorsByRoleNameWithUnspecific(mediusAlterRoleName, relations).toListSortedByDistances(relations);
            List<RoleActor> selfs = mediusRelation.getActorsByRoleNameWithUnspecific(MetaRole.invertName(mediusRoleName), relations).toListSortedByDistances(relations);
            for (RoleActor self : selfs) {
                if (medius.matchesAbsolute(self)) continue;
                for (RoleActor alter : alters) {
                    RoleActorPair pair;
                    if (medius.matchesAbsolute(alter) || !(pair = new RoleActorPair(relations, self, alter.cloneAs(alterRoleName), RoleActorPair.Adjustable.NONE)).isValid()) continue;
                    RoleActor adjustedSelf = pair.getSelf();
                    RoleActor adjustedAlter = pair.getAlter();
                    RoleRelation selfRelation = relations.getSelfRelation(adjustedSelf);
                    if (selfRelation == null || !selfRelation.hasActor(adjustedAlter) || !RoleRelationMaker.isComposable(relations, medius, adjustedAlter, self, alterRoleName, mediusRoleName, mediusAlterRoleName) || immortals.contains(new RoleDefinition(self.getIndividual(), adjustedAlter)) || tempImmortals.contains(new RoleDefinition(self.getIndividual(), adjustedAlter))) continue;
                    if (alterRoleName.equals("SIBLING") && mediusRoleName.equals("SIBLING") && mediusAlterRoleName.equals("SIBLING")) {
                        if (self.isPersonal(relations) && self.matchesAbsolute(adjustedAlter)) continue;
                        RoleRelationMaker.fixCommonParent(relations, self, alter, medius, immortals);
                    }
                    tempImmortals.addNew(new RoleDefinition(medius.getIndividual(), self));
                    tempImmortals.addNew(new RoleDefinition(medius.getIndividual(), alter));
                    tempImmortals.addNew(new RoleDefinition(self.getIndividual(), medius.asReciprocalOf(self, relations)));
                    tempImmortals.addNew(new RoleDefinition(alter.getIndividual(), medius.asReciprocalOf(alter, relations)));
                    RoleRelationMaker.removeRoleDefinition(relations, pair, true, immortals, subReport);
                }
            }
            if (subReport.isEmpty()) continue;
            report.outputs().appendln("Removed " + alterRoleName + " link between " + MetaRole.invertName(mediusRoleName) + " and " + mediusAlterRoleName + " of " + medius);
            report.outputs().append(subReport);
            report.outputs().appendln();
        }
        report.outputs().appendln();
    }

    public static MetaRole getUniqueGenderConfig(Role role, Roles genderConfig) {
        MetaRole result;
        if (genderConfig == null) {
            result = new MetaRole(null, Gender.UNKNOWN, Gender.UNKNOWN, AlterAge.UNKNOWN);
        } else {
            result = null;
            for (Role metaRole : genderConfig) {
                MetaRole absolute = ((MetaRole)metaRole).absolute();
                if (result == null) {
                    result = absolute;
                    continue;
                }
                if (result.equals(absolute)) continue;
                if (result.isCross() && absolute.isCross()) {
                    result.setEgoGender(null);
                    result.setAlterGender(null);
                    result.setCross(true);
                    continue;
                }
                result = null;
                break;
            }
        }
        return result;
    }

    public static Map<Role, MetaRole> getUniqueGenderConfigs(RoleRelations relations) {
        HashMap<Role, MetaRole> result = new HashMap<Role, MetaRole>();
        Map<Role, Roles> genderConfigs = relations.getGenderConfigs();
        for (Role role : relations.getRoles()) {
            result.put(role, RoleRelationMaker.getUniqueGenderConfig(role, genderConfigs.get(role)));
        }
        return result;
    }

    public static void compareDefinitions(RoleDefinitions alpha, RoleDefinitions beta, RoleRelations relations, Report report) {
        if (alpha != null && beta != null) {
            StringList maintained = new StringList();
            StringList removed = new StringList();
            StringList added = new StringList();
            StringList inverted = new StringList();
            for (RoleDefinition definition : alpha) {
                if (!beta.contains(definition)) {
                    if (beta.contains(definition.inverse(relations))) {
                        inverted.appendln(definition.toString());
                        continue;
                    }
                    removed.appendln(definition.toString());
                    continue;
                }
                maintained.appendln(definition.toString());
            }
            for (RoleDefinition definition : beta) {
                if (alpha.contains(definition) || alpha.contains(definition.inverse(relations))) continue;
                added.appendln(definition.toString());
            }
            report.outputs().appendln("Comparison with original definitions:");
            report.outputs().appendln();
            report.outputs().appendln(String.valueOf(maintained.size() / 2) + " definitions maintained");
            report.outputs().append(maintained);
            report.outputs().appendln();
            report.outputs().appendln(String.valueOf(removed.size() / 2) + " definitions removed");
            report.outputs().append(removed);
            report.outputs().appendln();
            report.outputs().appendln(String.valueOf(added.size() / 2) + " definitions added");
            report.outputs().append(added);
            report.outputs().appendln();
            report.outputs().appendln(String.valueOf(inverted.size() / 2) + " definitions inverted");
            report.outputs().append(inverted);
            report.outputs().appendln();
        }
    }

    public static RoleDefinitions createRoleDefinitions(RoleRelations source, List<RoleRelationRule> rules, Report report) {
        RoleDefinitions result = new RoleDefinitions();
        RoleRelations relations = source.clone();
        RoleDefinitions basicDefinitions = relations.getBasicRoleDefinitions();
        report.outputs().appendln("Configurating definitions");
        report.outputs().appendln();
        for (String basicDefinition : basicDefinitions.toSortedStringList()) {
            report.outputs().appendln(basicDefinition);
        }
        report.outputs().appendln();
        if (rules == null) {
            rules = RoleRelationMaker.getDefaultRules();
        }
        Collections.sort(rules, Collections.reverseOrder());
        for (RoleRelationRule rule : rules) {
            RoleRelationMaker.decomposeRelations(relations, rule.getAlterRoleName(), rule.getMediusRoleName(), rule.getMediusAlterRoleName(), basicDefinitions, report);
        }
        RoleRelationMaker.removeReciprocalRelations(relations, basicDefinitions, report);
        for (RoleRelation relation : relations.toSortedList()) {
            for (RoleActor actor : relation.getActors().toListSortedByRoles()) {
                if (actor.isSelf()) continue;
                if (!actor.getRole().isCross()) {
                    result.put(new RoleDefinition(relation.getSelfTerm(), actor));
                    continue;
                }
                for (RoleActor crossActor : actor.crossExtension()) {
                    result.put(new RoleDefinition(relation.getSelfTerm(), crossActor));
                }
            }
        }
        result = result.compress();
        for (RoleActor roleActor : relations.getSortedSelfs()) {
        }
        return result;
    }

    private static void removeReciprocalRelations(RoleRelations relations, RoleDefinitions immortals, Report report) {
        report.outputs().appendln("Remove reciprocal relations");
        report.outputs().appendln();
        StringList subReport = new StringList();
        for (RoleActor self : relations.getSortedSelfs()) {
            for (RoleActor alter : relations.getSelfRelation(self).getActors().toListSortedByDistances(relations)) {
                if (alter.equalsAbsolute(self)) continue;
                RoleActorPair pair = new RoleActorPair(relations, self, alter, RoleActorPair.Adjustable.NONE);
                RoleActorPair reciprocalPair = pair.reciprocal(relations);
                boolean removed = false;
                if (pair.isStandardPosition(relations)) {
                    removed = RoleRelationMaker.removeRoleDefinition(relations, reciprocalPair, false, immortals, subReport);
                }
                if (removed) continue;
                removed = RoleRelationMaker.removeRoleDefinition(relations, pair, false, immortals, subReport);
                immortals.addNew(reciprocalPair.getRoleDefinition());
            }
        }
        if (!subReport.isEmpty()) {
            report.outputs().append(subReport);
            report.outputs().appendln();
        }
    }

    public static void applyModel(Net net, Segmentation segmentation, RelationModel model, int maxIterations) {
        maxIterations = 1;
        RoleRelations roleRelations = model.getRoleRelations();
        for (Individual ego : segmentation.getCurrentIndividuals()) {
            HashMap<Individual, Integer> distances = new HashMap<Individual, Integer>();
            distances.put(ego, 0);
            LinkedList<ExtendedActor> queue = new LinkedList<ExtendedActor>();
            Relation relation = net.createRelation(ego.getId(), String.valueOf(model.getRoleRelations().getSelfName()) + " = " + ego, model);
            RoleActor self = model.getRoleRelations().getSelf(ego.getGender());
            relation.addActor(ego, self.getIndividual());
            queue.add(new ExtendedActor(ego, self));
            while (!queue.isEmpty()) {
                RoleRelationMaker.expand(relation, roleRelations, maxIterations, queue, distances);
            }
        }
    }

    private static void expand(Relation relation, RoleRelations roleRelations, int maxIterations, Queue<ExtendedActor> queue, Map<Individual, Integer> distances) {
        ExtendedActor extendedActor = queue.poll();
        Individual self = extendedActor.getIndividual();
        RoleActor selfActor = extendedActor.getRoleActor();
        Integer distance = distances.get(self);
        for (KinType kinType : KinType.basicTypesWithSiblings()) {
            for (Gender alterGender : Gender.valuesNotUnknown()) {
                Individuals alters = self.getKin(kinType, alterGender);
                RoleActors alterActors = roleRelations.getAlters(selfActor, kinType, alterGender);
                for (Individual alter : alters) {
                    if (distances.get(alter) != null) continue;
                    distances.put(alter, distance + 1);
                    for (RoleActor alterActor : alterActors) {
                        if (RoleRelationMaker.isEgoLinked(roleRelations, alterActor, roleRelations.getGenderConfigs()) && distance != 0 || !relation.addNewActor(alter, alterActor.getIndividual()) || distance >= maxIterations) continue;
                        alterActor = alterActor.withEgoGender(selfActor.getEgoGender());
                        queue.add(new ExtendedActor(alter, alterActor));
                    }
                }
            }
        }
    }

    private static boolean noSameSexSpouse(Individual selfIndi, Gender alterGender, KinType kinType) {
        return !kinType.equals((Object)KinType.SPOUSE) || selfIndi.getGender().invert() == alterGender;
    }

    private static boolean noDoubleParent(Individual selfIndi, Gender alterGender, KinType kinType) {
        return !kinType.equals((Object)KinType.PARENT) || selfIndi.getParent(alterGender) == null;
    }

    private static void expand(Net net, RoleRelations relations, Queue<ExtendedActor> queue, int maxIterations, Map<Individual, Integer> distances) throws PuckException {
        ExtendedActor extendedActor = queue.poll();
        Individual selfIndi = extendedActor.getIndividual();
        RoleActor self = extendedActor.getRoleActor();
        int distance = distances.get(selfIndi);
        for (KinType kinType : KinType.basicTypesWithSiblings()) {
            for (Gender alterGender : Gender.valuesNotUnknown()) {
                if (!RoleRelationMaker.noSameSexSpouse(selfIndi, alterGender, kinType) || !RoleRelationMaker.noDoubleParent(selfIndi, alterGender, kinType)) continue;
                for (RoleActor alter : relations.getAlters(self, kinType, alterGender)) {
                    if (alter.hasSelfName() || !self.hasSelfName() && alter.isPersonal(relations)) continue;
                    Individuals potentialKin = selfIndi.getPotentialKin(kinType);
                    Individual alterIndi = potentialKin.getFirstCorresponding(alter.getName(), alterGender, self.getEgoGender());
                    if (alterIndi == null) {
                        if (kinType == KinType.PARENT && potentialKin.hasGender(alterGender)) continue;
                        alterIndi = net.createIndividual(alter.getName(), alterGender);
                        alterIndi.setAttribute("EGOGENDER", "" + (Object)((Object)alter.getEgoGender()));
                    }
                    NetUtils.setKin(net, alterIndi, selfIndi, kinType);
                    if (distance >= maxIterations || distances.containsKey(alterIndi)) continue;
                    alter = alter.withEgoGender(self.getEgoGender());
                    distances.put(alterIndi, distance + 1);
                    queue.add(new ExtendedActor(alterIndi, alter));
                }
            }
        }
    }

    static boolean concatenable(RoleActor alpha, RoleActor beta) {
        boolean result = alpha == null ? true : !(alpha.isSibling() && beta.isParent() || alpha.isChild() && beta.isSibling() || alpha.isSibling() && beta.isSibling() || alpha.isChild() && beta.isParent() || alpha.isParent() && beta.isChild() || alpha.isSpouse() && beta.isSpouse());
        return result;
    }

    public static Net createNet(RelationModel model, int maxIterations) throws PuckException {
        RoleRelations relations = model.getRoleRelations();
        Net result = new Net();
        result.setLabel(model.getName());
        result.relationModels().add(new RelationModel("SIBLING"));
        for (Gender egoGender : Gender.valuesNotUnknown()) {
            RoleActor self = model.getRoleRelations().getSelf(egoGender);
            Individual ego = result.createIndividual(model.getRoleRelations().getSelfName(), egoGender);
            ego.setAttribute("EGOGENDER", "" + (Object)((Object)egoGender));
            HashMap<Individual, Integer> distances = new HashMap<Individual, Integer>();
            distances.put(ego, 0);
            LinkedList<ExtendedActor> queue = new LinkedList<ExtendedActor>();
            queue.add(new ExtendedActor(ego, self));
            while (!queue.isEmpty()) {
                RoleRelationMaker.expand(result, relations, queue, maxIterations, distances);
            }
        }
        for (Individual ego : result.individuals().toSortedList()) {
            for (Individual sibling : ego.getRelated("SIBLING")) {
                RoleActor siblingActor = new RoleActor(new Role(sibling.getName()), new MetaRole("SIBLING", Gender.valueOf(sibling.getAttributeValue("EGOGENDER")), sibling.getGender(), AlterAge.UNKNOWN), relations.getSelfName());
                block4: for (Individual parent : ego.getParents()) {
                    if (sibling.getParent(parent.getGender()) != null) continue;
                    for (RoleActor siblingsParentActor : siblingActor.getActorsByRoleNameWithUnspecific("PARENT", relations)) {
                        if (siblingsParentActor.getAlterGender() != parent.getGender() || !siblingsParentActor.getName().equals(parent.getName())) continue;
                        NetUtils.setKin(result, parent, sibling, KinType.PARENT);
                        continue block4;
                    }
                }
            }
        }
        for (Individual ego : result.individuals().toSortedList()) {
            if (ego.spouses().size() != 1) continue;
            Individual spouse = (Individual)ego.spouses().getFirst();
            Family mainFamily = result.families().getBySpouses(ego, spouse);
            for (Family otherFamily : ego.getPersonalFamilies()) {
                if (otherFamily.equals(mainFamily)) continue;
                block8: for (Individual child : otherFamily.getChildren()) {
                    RoleActor childActor = new RoleActor(new Role(child.getName()), new MetaRole("CHILD", Gender.valueOf(child.getAttributeValue("EGOGENDER")), child.getGender(), AlterAge.UNKNOWN), relations.getSelfName());
                    for (RoleActor childsParentActor : childActor.getActorsByRoleNameWithUnspecific("PARENT", relations)) {
                        if (childsParentActor.getAlterGender() != spouse.getGender() || !childsParentActor.getName().equals(spouse.getName())) continue;
                        mainFamily.getChildren().add(child);
                        child.setOriginFamily(mainFamily);
                        continue block8;
                    }
                }
            }
        }
        for (Individual isolate : result.individuals().toSortedList()) {
            if (!isolate.isIsolate()) continue;
            for (Relation relation : isolate.relations().toList()) {
                for (Individual sibling : relation.getIndividuals()) {
                    sibling.relations().remove(relation);
                }
                result.remove(relation);
            }
            result.individuals().removeById(isolate.getId());
        }
        for (Family family : result.families().toSortedList()) {
            if (family.hasMarried()) continue;
            family.setMarried();
        }
        return result;
    }

    public static enum RoleRelationRule {
        CHILD_CHILD_SIBLING("CHILD", "CHILD", "SIBLING"),
        SIBLING_SIBLING_SIBLING("SIBLING", "SIBLING", "SIBLING"),
        SPOUSE_CHILD_PARENT("SPOUSE", "CHILD", "PARENT"),
        CHILD_SPOUSE_CHILD("CHILD", "SPOUSE", "CHILD"),
        SIBLING_PARENT_CHILD("SIBLING", "PARENT", "CHILD");

        String alterRoleName;
        String mediusRoleName;
        String mediusAlterRoleName;

        private RoleRelationRule(String alterRoleName, String mediusRoleName, String mediusAlterRoleName) {
            this.alterRoleName = alterRoleName;
            this.mediusRoleName = mediusRoleName;
            this.mediusAlterRoleName = mediusAlterRoleName;
        }

        public String getAlterRoleName() {
            return this.alterRoleName;
        }

        public String getMediusRoleName() {
            return this.mediusRoleName;
        }

        public String getMediusAlterRoleName() {
            return this.mediusAlterRoleName;
        }
    }
}

