/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import org.tip.puck.net.AlterAge;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActorPair;
import org.tip.puck.net.relations.roles.RoleActors;
import org.tip.puck.net.relations.roles.RoleRelation;
import org.tip.puck.net.relations.roles.RoleRelations;
import org.tip.puck.util.Numberable;

public class RoleActor
implements Comparable<RoleActor>,
Numberable {
    private Role individual;
    private MetaRole role;
    private int id;
    String selfName;
    private Attributes attributes;

    public RoleActor clone() {
        RoleActor result = new RoleActor(this.individual, this.role.clone(), this.selfName);
        return result;
    }

    public RoleActor cloneAs(String roleName) {
        RoleActor result = this.clone();
        result.getRole().setName(roleName);
        return result;
    }

    public RoleActor(Role individual, MetaRole role, String selfName) {
        this.individual = individual;
        this.selfName = selfName;
        this.individual.setSelfName(selfName);
        this.role = role;
        this.attributes = new Attributes();
    }

    public boolean equals(Object actor) {
        return this.role.equals(((RoleActor)actor).role) && this.individual.equals(((RoleActor)actor).individual);
    }

    boolean specifies(RoleActor other) {
        boolean result = this.individual.equals(other.getIndividual()) && this.role.specifies(other.role);
        return result;
    }

    boolean specifiesEgoGender(RoleActor other) {
        boolean result = this.individual.equals(other.getIndividual()) && this.role.getEgoGender().specifies(other.role.getEgoGender());
        return result;
    }

    boolean specifiesAbsolute(RoleActor other) {
        boolean result = this.individual.equals(other.getIndividual()) && this.role.specifiesAbsolute(other.role);
        return result;
    }

    boolean matchesAbsolute(RoleActor other) {
        boolean result = this.individual.equals(other.getIndividual()) && this.role.matchesAbsolute(other.role);
        return result;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public Role getIndividual() {
        return this.individual;
    }

    public String getName() {
        String result = this.individual.getName();
        return result;
    }

    public MetaRole getRole() {
        return this.role;
    }

    public void setIndividual(Role individual) {
        this.individual = individual;
    }

    public void setRole(MetaRole role) {
        this.role = role;
    }

    public Attributes attributes() {
        Attributes result = this.attributes;
        return result;
    }

    public void setAttribute(String label, String value) {
        this.attributes.put(label, value);
    }

    public String toString() {
        return this.individual + " [" + this.role + "]";
    }

    public String getAttributeValue(String label) {
        Attribute attribute = (Attribute)this.attributes().get(label);
        String result = attribute == null ? null : attribute.getValue();
        return result;
    }

    @Override
    public int compareTo(RoleActor other) {
        int result;
        if (this.hasSelfName() && !other.hasSelfName()) {
            result = -1;
        } else if (!this.hasSelfName() && other.hasSelfName()) {
            result = 1;
        } else {
            result = this.individual.compareTo(other.individual);
            if (result == 0) {
                result = this.role.compareTo(other.role);
            }
        }
        return result;
    }

    public boolean equalsAbsolute(RoleActor other) {
        boolean result = this.absolute().equals(other.absolute());
        return result;
    }

    public RoleActor absolute() {
        RoleActor result = new RoleActor(this.individual, this.role.absolute(), this.selfName);
        return result;
    }

    RoleActor withEgoGender(Gender egoGender) {
        RoleActor result;
        if (!this.getEgoGender().isUnknown() || egoGender.isUnknown()) {
            result = this;
        } else {
            result = this.clone();
            result.getRole().setEgoGender(egoGender);
            if (this.role.isCross()) {
                result.getRole().setAlterGender(egoGender.invert());
            }
            if (result.hasSelfName()) {
                result.getRole().setAlterGender(egoGender);
            }
        }
        return result;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String hashKey() {
        return this.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    boolean isHiddenCross() {
        boolean result = this.role.isCross() && this.getEgoGender().isUnknown() && this.getAlterGender().isUnknown();
        return result;
    }

    boolean hasCorrectGender(RoleActor self, RoleRelations relations) {
        boolean result = !(this.hasSelfName() && this.getEgoGender() != this.getAlterGender() || relations.heteroMarriage() && this.isSpouse() && !this.getAlterGender().matchs(self.getAlterGender().invert()));
        return result;
    }

    public Gender getEgoGender() {
        return this.role.getEgoGender();
    }

    public Gender getAlterGender() {
        return this.role.getAlterGender();
    }

    public AlterAge getAlterAge() {
        return this.role.getAlterAge();
    }

    RoleActor egoGenderNeutral() {
        RoleActor result = this.clone();
        result.getRole().setEgoGender(Gender.UNKNOWN);
        return result;
    }

    RoleActor egoGenderComplement() {
        RoleActor result;
        MetaRole egoGenderComplement = this.role.egoGenderComplement();
        if (egoGenderComplement == null) {
            result = null;
        } else {
            result = this.clone();
            result.setRole(egoGenderComplement);
        }
        return result;
    }

    RoleActor asSiblingOf(RoleActor alter, RoleRelations relations) {
        RoleActor result = this.clone();
        if (!alter.isPersonal(relations)) {
            AlterAge alterAge = RoleActor.getUniqueAlterAge(relations.getGenderConfigs().get(alter.getIndividual()), "SIBLING", this.getEgoGender());
            if (!this.isPersonal(relations)) {
                AlterAge selfAge = RoleActor.getUniqueAlterAge(relations.getGenderConfigs().get(result.getIndividual()), "SIBLING", this.getEgoGender());
                if (selfAge == alterAge.invert()) {
                    result.getRole().setAlterAge(selfAge);
                } else {
                    result.getRole().setAlterAge(AlterAge.UNKNOWN);
                }
            } else {
                result.getRole().setAlterAge(alterAge.invert());
            }
        }
        return result;
    }

    RoleActor withAlterGender(RoleRelations relations) {
        RoleActor result;
        if (this.getAlterGender() != null) {
            result = this;
        } else {
            result = this.clone();
            if (this.hasSelfName()) {
                result.setAlterGender(Gender.UNKNOWN);
            } else {
                Roles configs = relations.getGenderConfigs().get(this.individual);
                if (RoleActor.isUniqueCross(configs)) {
                    result.setAlterGender(this.getEgoGender().invert());
                    if (this.getEgoGender().isUnknown()) {
                        result.getRole().setCross(true);
                    }
                } else {
                    result.setAlterGender(RoleActor.getUniqueAlterGender(configs, this.role.getName(), this.getEgoGender()));
                }
            }
        }
        return result;
    }

    RoleActor withAlterGender(Gender alterGender) {
        RoleActor result = this.clone();
        result.getRole().setAlterGender(alterGender);
        Gender egoGender = Gender.UNKNOWN;
        if (result.getRole().isCross()) {
            egoGender = alterGender.invert();
        }
        if (result.hasSelfName()) {
            egoGender = alterGender;
        }
        if (!egoGender.matchs(result.getEgoGender())) {
            result = null;
        } else if (!egoGender.isUnknown()) {
            result.getRole().setEgoGender(egoGender);
        }
        return result;
    }

    RoleActor asSelf(RoleRelations relations) {
        RoleActor result;
        if (this.isSelf()) {
            result = this;
        } else {
            result = this.cloneAs("SELF");
            result.setAlterAge(AlterAge.UNKNOWN);
            if (result.getAlterGender() == null) {
                if (this.hasSelfName()) {
                    result.setAlterGender(result.getEgoGender());
                } else if (result.getRole().isCross()) {
                    result.setAlterGender(result.getEgoGender());
                } else {
                    result = result.withAlterGender(relations);
                }
            }
        }
        return result;
    }

    static boolean isUniqueCross(Roles configs) {
        boolean cross = true;
        for (Role standardRole : configs) {
            if (((MetaRole)standardRole).isCross()) continue;
            cross = false;
            break;
        }
        return cross;
    }

    static AlterAge getUniqueAlterAge(Roles configs, String name, Gender egoGender) {
        MetaRole metaRole;
        AlterAge result = null;
        if (name != null && configs != null) {
            for (Role role : configs) {
                metaRole = (MetaRole)role;
                if (!metaRole.getName().equals(name) || !egoGender.specifies(metaRole.getEgoGender())) continue;
                if (result == null) {
                    result = metaRole.getAlterAge();
                    continue;
                }
                if (result.equals((Object)metaRole.getAlterAge())) continue;
                result = null;
                break;
            }
        }
        if (result == null && configs != null) {
            for (Role role : configs) {
                metaRole = (MetaRole)role;
                if (result == null) {
                    result = metaRole.getAlterAge();
                    continue;
                }
                if (result.equals((Object)metaRole.getAlterAge())) continue;
                result = null;
                break;
            }
        }
        if (result == null) {
            result = AlterAge.UNKNOWN;
        }
        return result;
    }

    static Gender getUniqueAlterGender(Roles configs, String name, Gender egoGender) {
        Gender result = null;
        if (name != null && configs != null) {
            for (Role role : configs) {
                MetaRole metaRole = (MetaRole)role;
                if (!metaRole.getName().equals(name) || !egoGender.specifies(metaRole.getEgoGender())) continue;
                if (result == null) {
                    result = metaRole.getAlterGender();
                    continue;
                }
                if (result.equals((Object)metaRole.getAlterGender())) continue;
                result = null;
                break;
            }
        }
        if (result == null && configs != null) {
            boolean cross = true;
            for (Role role : configs) {
                MetaRole metaRole = (MetaRole)role;
                if (!metaRole.isCross()) {
                    cross = false;
                }
                if (result == null) {
                    result = metaRole.getAlterGender();
                    continue;
                }
                if (result.equals((Object)metaRole.getAlterGender())) continue;
                if (cross) {
                    result = egoGender.invert();
                    continue;
                }
                result = null;
                break;
            }
        }
        if (result == null) {
            result = Gender.UNKNOWN;
        }
        return result;
    }

    RoleActor withAge(RoleRelations relations) {
        RoleActor result = this.clone();
        result.setAlterAge(RoleActor.getUniqueAlterAge(relations.getGenderConfigs().get(this.individual), this.role.getName(), this.getEgoGender()));
        return result;
    }

    RoleActor withCrossness(RoleRelations relations) {
        RoleActor result;
        if (this.hasSelfName() || this.getRole().isCross() || !RoleActor.isUniqueCross(relations.getGenderConfigs().get(this.individual))) {
            result = this;
        } else {
            result = this.clone();
            if (!result.getEgoGender().isUnknown() && (result.getAlterGender() == null || result.getAlterGender().isUnknown())) {
                result.setAlterGender(result.getEgoGender().invert());
            } else if (result.getAlterGender() != null && !result.getAlterGender().isUnknown() && result.getEgoGender().isUnknown()) {
                result.setEgoGender(result.getAlterGender().invert());
            } else if (result.getEgoGender().isUnknown() && result.getAlterGender() == null || result.getAlterGender().isUnknown()) {
                result.getRole().setCross(true);
            } else {
                result = null;
            }
        }
        return result;
    }

    RoleActor asAlterOf(RoleActor self, RoleRelations relations) {
        RoleActor result = new RoleActorPair(relations, self, this, RoleActorPair.Adjustable.NONE).getAlter();
        return result;
    }

    RoleActor asReciprocalOf(RoleActor alter, RoleRelations relations) {
        RoleActor result = this.cloneAs(alter.getRole().invertName()).asAlterOf(alter, relations);
        return result;
    }

    boolean isPersonal(RoleRelations relations) {
        boolean result = false;
        for (RoleActor alter : this.getActorsByRoleNameWithUnspecific(null, relations)) {
            if (!alter.hasSelfName() || !alter.isSelf() && !alter.isSpouse() && !alter.isChild()) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean hasSelfName() {
        return this.hasName(this.selfName);
    }

    public boolean isParent() {
        return this.role.isParent();
    }

    public boolean isChild() {
        return this.role.isChild();
    }

    public boolean isSpouse() {
        return this.role.isSpouse();
    }

    public boolean isSibling() {
        return this.role.isSibling();
    }

    public boolean isSelf() {
        return this.role.isSelf();
    }

    public RoleActors getActorsByRoleNameWithUnspecific(String roleName, RoleRelations relations) {
        RoleActors result = new RoleActors();
        for (RoleRelation selfRelation : relations.getBySelf(this)) {
            for (RoleActor actor : selfRelation.getActorsByRoleName(roleName)) {
                result.addNew(actor.clone());
            }
        }
        return result;
    }

    public void setEgoGender(Gender egoGender) {
        this.role.setEgoGender(egoGender);
    }

    public void setAlterGender(Gender alterGender) {
        this.role.setAlterGender(alterGender);
    }

    public void setAlterAge(AlterAge alterAge) {
        this.role.setAlterAge(alterAge);
    }

    RoleActors crossExtension() {
        RoleActors result = new RoleActors();
        if (this.role.isCross()) {
            if (!this.getAlterGender().isUnknown()) {
                result.add(this);
            } else {
                result.add(this.withEgoGender(Gender.FEMALE));
                result.add(this.withEgoGender(Gender.MALE));
            }
        }
        return result;
    }

    public boolean hasName(String name) {
        return this.getName().equals(name);
    }

    boolean isFirstAlter(RoleRelation relation) {
        return relation != null && relation.getActors().indexOf(this) == 1;
    }

    public String getSelfName() {
        return this.selfName;
    }

    public void setSelfName(String selfName) {
        this.selfName = selfName;
    }
}

