/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.ged;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.ged.GEDBlock;
import org.tip.puck.io.ged.GEDLine;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;

public class GEDFile {
    private static final Logger logger = LoggerFactory.getLogger(GEDFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 4096;
    public static final String FAM_EVENT_LABELS = "ANUL|CENS|DIV|DIVF|ENGA|MARB|MARC|MARR|MARL|MARS|RESI|EVEN|POSITION";
    public static final String INDI_EVENT_LABELS = "BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI|EVEN";
    public static final Pattern GEDLINE_PATTERN = Pattern.compile("^\ufeff?(\\d|[1-9]\\d+) (@(\\D*)(\\d*)(\\D*)@)? ?(\\w+) *((@(\\D*)(\\d*)(\\D*)@)|(.*))$");

    public static void addSubmitterData(Net net, GEDBlock source) {
        boolean ended = false;
        int index = 1;
        while (!ended) {
            if (index < source.size()) {
                switch (((GEDLine)source.get(index)).getLevel()) {
                    case 1: {
                        net.attributes().put("SUBM_" + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).trimmedValue());
                        break;
                    }
                    default: {
                        if (((GEDLine)source.get(index)).tag().equals("CONT")) {
                            String prefix = "SUBM_" + GEDFile.buildPrefix(source, index);
                            String label = prefix.substring(0, prefix.length() - 1);
                            Attribute attribute = (Attribute)net.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(index)).trimmedValue());
                            break;
                        }
                        net.attributes().put("SUBM_" + GEDFile.buildPrefix(source, index) + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).trimmedValue());
                    }
                }
                ++index;
                continue;
            }
            ended = true;
        }
    }

    public static void buildFamily(Net net, GEDBlock source) throws PuckException {
        Family currentFamily = null;
        String tagLevel1 = null;
        String typeLevel1 = null;
        String tagLevel2 = null;
        Relation currentRelation = null;
        Individual alter = null;
        boolean ended = false;
        int currentLineIndex = 0;
        while (!ended) {
            if (currentLineIndex < source.size()) {
                GEDLine currentLine = (GEDLine)source.get(currentLineIndex);
                switch (((GEDLine)source.get(currentLineIndex)).getLevel()) {
                    case 0: {
                        currentFamily = null;
                        tagLevel1 = null;
                        typeLevel1 = null;
                        tagLevel2 = null;
                        alter = null;
                        currentRelation = null;
                        currentFamily = (Family)net.families().getById(((GEDLine)source.get(0)).getRefId());
                        if (currentFamily != null) break;
                        currentFamily = new Family(((GEDLine)source.get(0)).getRefId());
                        net.families().add(currentFamily);
                        break;
                    }
                    case 1: {
                        Individual spouse;
                        tagLevel1 = currentLine.tag();
                        typeLevel1 = null;
                        tagLevel2 = null;
                        alter = null;
                        currentRelation = null;
                        if (currentLine.tag().equals("HUSB")) {
                            spouse = (Individual)net.individuals().getById(((GEDLine)source.get(currentLineIndex)).valueId());
                            if (spouse == null) {
                                spouse = new Individual(((GEDLine)source.get(currentLineIndex)).valueId());
                                net.individuals().add(spouse);
                            }
                            currentFamily.setHusband(spouse);
                            currentFamily.setMarried(true);
                            spouse.getPersonalFamilies().add(currentFamily);
                            break;
                        }
                        if (currentLine.tag().equals("WIFE")) {
                            spouse = (Individual)net.individuals().getById(((GEDLine)source.get(currentLineIndex)).valueId());
                            if (spouse == null) {
                                spouse = new Individual(((GEDLine)source.get(currentLineIndex)).valueId());
                                net.individuals().add(spouse);
                            }
                            currentFamily.setWife(spouse);
                            currentFamily.setMarried(true);
                            spouse.getPersonalFamilies().add(currentFamily);
                            break;
                        }
                        if (currentLine.tag().equals("CHIL")) break;
                        if (currentLine.tag().matches(FAM_EVENT_LABELS)) {
                            if (!StringUtils.equals((CharSequence)currentLine.tag(), (CharSequence)"EVEN")) break;
                            typeLevel1 = StringUtils.defaultString((String)currentLine.trimmedValue(), (String)"EVEN");
                            break;
                        }
                        if (((GEDLine)source.get(currentLineIndex)).hasValue()) {
                            currentFamily.attributes().put(((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).trimmedValue());
                            break;
                        }
                        if (!((GEDLine)source.get(currentLineIndex)).hasTag()) break;
                        currentFamily.attributes().put(((GEDLine)source.get(currentLineIndex)).tag(), "");
                        break;
                    }
                    case 2: {
                        tagLevel2 = currentLine.tag();
                        if (tagLevel1.matches(FAM_EVENT_LABELS)) {
                            if (currentLine.tag().equals("ASSO")) {
                                alter = (Individual)net.individuals().getById(currentLine.valueId());
                                if (alter != null) break;
                                alter = net.createIndividual(currentLine.valueId());
                                break;
                            }
                            currentFamily.attributes().put(String.valueOf(GEDFile.buildPrefix(source, currentLineIndex)) + ((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).trimmedValue());
                            if (currentRelation == null) break;
                            currentRelation.attributes().put(currentLine.tag(), currentLine.trimmedValue());
                            break;
                        }
                        currentFamily.attributes().put(String.valueOf(GEDFile.buildPrefix(source, currentLineIndex)) + ((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).trimmedValue());
                        break;
                    }
                    case 3: {
                        Attribute attribute;
                        String label;
                        String prefix;
                        if (StringUtils.equals((CharSequence)tagLevel2, (CharSequence)"ASSO")) {
                            if (currentLine.tag().equals("TYPE")) break;
                            if (currentLine.tag().equals("RELA")) {
                                Role alterRole;
                                if (currentRelation == null) {
                                    Role wifeRole;
                                    String relationName;
                                    Role husbandRole;
                                    String relationModelName = StringUtils.defaultString(typeLevel1, (String)tagLevel1);
                                    RelationModel relationModel = net.relationModels().getByName(relationModelName);
                                    if (relationModel == null) {
                                        relationModel = net.createRelationModel(relationModelName);
                                    }
                                    if ((husbandRole = (currentRelation = net.createRelation(relationName = " [" + StringUtils.defaultString(typeLevel1, (String)tagLevel1) + "] " + currentFamily.getId(), relationModel, new Actor[0])).getModel().roles().getByName("husband")) == null) {
                                        husbandRole = new Role("husband");
                                        currentRelation.getModel().roles().add(husbandRole);
                                    }
                                    if (currentFamily.getHusband() != null) {
                                        net.addRelationActors(currentRelation, new Actor(currentFamily.getHusband(), husbandRole));
                                    }
                                    if ((wifeRole = currentRelation.getModel().roles().getByName("wife")) == null) {
                                        wifeRole = new Role("wife");
                                        currentRelation.getModel().roles().add(wifeRole);
                                    }
                                    if (currentFamily.getWife() != null) {
                                        net.addRelationActors(currentRelation, new Actor(currentFamily.getWife(), wifeRole));
                                    }
                                }
                                if ((alterRole = currentRelation.getModel().roles().getByName(currentLine.trimmedValue())) == null) {
                                    alterRole = new Role(currentLine.trimmedValue());
                                    currentRelation.getModel().roles().add(alterRole);
                                }
                                net.addRelationActors(currentRelation, new Actor(alter, alterRole));
                                break;
                            }
                            if (currentLine.tag().equals("SOUR")) {
                                if (currentRelation == null) {
                                    throw PuckExceptions.BAD_FILE_FORMAT.create("SOURC must follow RELA in ASSO block.", new Object[0]);
                                }
                                String postfix = GEDFile.buildPostfix(currentRelation.attributes(), "SOURC");
                                currentRelation.attributes().add(new Attribute("SOURC" + postfix, String.valueOf(currentLine.getRefId())));
                                break;
                            }
                            currentRelation.attributes().add(new Attribute(currentLine.tag(), currentLine.trimmedValue()));
                            break;
                        }
                        if (((GEDLine)source.get(currentLineIndex)).tag().equals("CONT")) {
                            Attribute relationAttribute;
                            prefix = GEDFile.buildPrefix(source, currentLineIndex);
                            label = prefix.substring(0, prefix.length() - 1);
                            attribute = (Attribute)currentFamily.attributes().get(label);
                            if (attribute != null) {
                                attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(currentLineIndex)).value());
                            }
                            if (currentRelation == null || (relationAttribute = (Attribute)currentRelation.attributes().get(tagLevel2)) == null) break;
                            relationAttribute.setValue(String.valueOf(relationAttribute.getValue()) + currentLine.trimmedValue());
                            break;
                        }
                        currentFamily.attributes().put(String.valueOf(GEDFile.buildPrefix(source, currentLineIndex)) + ((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).value());
                        break;
                    }
                    default: {
                        Attribute attribute;
                        String label;
                        String prefix;
                        if (((GEDLine)source.get(currentLineIndex)).tag().equals("CONT")) {
                            prefix = GEDFile.buildPrefix(source, currentLineIndex);
                            label = prefix.substring(0, prefix.length() - 1);
                            attribute = (Attribute)currentFamily.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(currentLineIndex)).value());
                            break;
                        }
                        currentFamily.attributes().put(String.valueOf(GEDFile.buildPrefix(source, currentLineIndex)) + ((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).value());
                    }
                }
                ++currentLineIndex;
                continue;
            }
            ended = true;
        }
    }

    public static void buildHeader(Net net, GEDBlock source) {
        boolean ended = false;
        int index = 1;
        while (!ended) {
            if (index < source.size()) {
                switch (((GEDLine)source.get(index)).getLevel()) {
                    case 1: {
                        net.attributes().put(((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                        break;
                    }
                    default: {
                        if (((GEDLine)source.get(index)).tag().equals("CONT")) {
                            String prefix = GEDFile.buildPrefix(source, index);
                            String label = prefix.substring(0, prefix.length() - 1);
                            Attribute attribute = (Attribute)net.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(index)).value());
                            break;
                        }
                        net.attributes().put(String.valueOf(GEDFile.buildPrefix(source, index)) + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                    }
                }
                ++index;
                continue;
            }
            ended = true;
        }
    }

    public static void buildIndividual(Net net, GEDBlock source) throws PuckException {
        Individual ego = null;
        boolean ended = false;
        int currentLineIndex = 0;
        String tagLevel1 = null;
        String tagLevel2 = null;
        String typeLevel2 = null;
        String tagLevel3 = null;
        Relation currentRelation = null;
        Individual alter = null;
        while (!ended) {
            if (currentLineIndex < source.size()) {
                GEDLine currentLine = (GEDLine)source.get(currentLineIndex);
                switch (((GEDLine)source.get(currentLineIndex)).getLevel()) {
                    case 0: {
                        ego = null;
                        alter = null;
                        currentRelation = null;
                        tagLevel1 = null;
                        tagLevel2 = null;
                        typeLevel2 = null;
                        tagLevel3 = null;
                        ego = (Individual)net.individuals().getById(((GEDLine)source.get(0)).getRefId());
                        if (ego != null) break;
                        ego = new Individual(((GEDLine)source.get(0)).getRefId());
                        net.individuals().add(ego);
                        break;
                    }
                    case 1: {
                        tagLevel1 = currentLine.tag();
                        tagLevel2 = null;
                        typeLevel2 = null;
                        tagLevel3 = null;
                        currentRelation = null;
                        if (((GEDLine)source.get(currentLineIndex)).tag().equals("NAME")) {
                            ego.setName(((GEDLine)source.get(currentLineIndex)).value());
                            break;
                        }
                        if (((GEDLine)source.get(currentLineIndex)).tag().equals("SEX")) {
                            if (StringUtils.isBlank((CharSequence)((GEDLine)source.get(currentLineIndex)).value())) {
                                ego.setGender(Gender.UNKNOWN);
                                break;
                            }
                            ego.setGender(Gender.valueOf(((GEDLine)source.get(currentLineIndex)).value().charAt(0)));
                            break;
                        }
                        if (((GEDLine)source.get(currentLineIndex)).tag().equals("FAMS")) break;
                        if (((GEDLine)source.get(currentLineIndex)).tag().equals("FAMC")) {
                            GEDLine nextLine;
                            boolean computeThisLink = currentLineIndex < source.size() - 1 ? (nextLine = (GEDLine)source.get(currentLineIndex + 1)).getLevel() != 2 || !nextLine.tag().equals("PEDI") || !nextLine.hasValue() || nextLine.value().equals("birth") : true;
                            if (!computeThisLink) break;
                            Family currentFamily = (Family)net.families().getById(((GEDLine)source.get(currentLineIndex)).valueId());
                            if (currentFamily == null) {
                                currentFamily = new Family(((GEDLine)source.get(currentLineIndex)).valueId());
                                net.families().add(currentFamily);
                            }
                            if (ego.getOriginFamily() != null && ego.getOriginFamily().getId() != currentFamily.getId()) {
                                logger.warn("Individual orginal family defined twice " + ego.getId());
                                String adoptionName = String.valueOf(ego.getName()) + " " + ego.getId();
                                Relation adoption = net.createRelation(adoptionName, net.relationModels().getByName("Adoption"), new Actor[0]);
                                net.createRelationActor(adoption, ego.getId(), "child");
                                adoption.attributes().put("adoptive_family", String.valueOf(((GEDLine)source.get(currentLineIndex)).valueId()));
                                adoption.attributes().put("pedigree", "duplicate");
                                break;
                            }
                            if (ego.getOriginFamily() != null) break;
                            currentFamily.getChildren().add(ego);
                            ego.setOriginFamily(currentFamily);
                            break;
                        }
                        if (currentLine.tag().equals("ASSO")) {
                            alter = (Individual)net.individuals().getById(currentLine.valueId());
                            if (alter != null) break;
                            alter = net.createIndividual(currentLine.valueId());
                            break;
                        }
                        if (currentLine.tag().matches(INDI_EVENT_LABELS)) {
                            if (currentLine.value() == null || !StringUtils.isNotBlank((CharSequence)currentLine.trimmedValue())) break;
                            ego.attributes().put(((GEDLine)source.get(currentLineIndex)).tag(), currentLine.trimmedValue());
                            break;
                        }
                        if (((GEDLine)source.get(currentLineIndex)).hasValue()) {
                            ego.attributes().put(((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).trimmedValue());
                            break;
                        }
                        if (!((GEDLine)source.get(currentLineIndex)).hasTag()) break;
                        ego.attributes().put(((GEDLine)source.get(currentLineIndex)).tag(), "");
                        break;
                    }
                    case 2: {
                        RelationModel relationModel;
                        Attribute attribute;
                        String label;
                        tagLevel2 = currentLine.tag();
                        tagLevel3 = null;
                        if (StringUtils.equals((CharSequence)tagLevel1, (CharSequence)"ADOP") && ((GEDLine)source.get(currentLineIndex)).tag().equals("FAMC")) {
                            String adoptionName = String.valueOf(ego.getName()) + " " + ego.getId();
                            Relation adoption = net.createRelation(adoptionName, net.relationModels().getByName("Adoption"), new Actor[0]);
                            net.createRelationActor(adoption, ego.getId(), "child");
                            adoption.attributes().put("adoptive_family", String.valueOf(((GEDLine)source.get(currentLineIndex)).valueId()));
                            adoption.attributes().put("pedigree", "Adoption");
                            break;
                        }
                        if (currentLine.tag().equals("CONT")) {
                            String prefix = GEDFile.buildPrefix(source, currentLineIndex);
                            label = prefix.substring(0, prefix.length() - 1);
                            attribute = (Attribute)ego.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(currentLineIndex)).value());
                            break;
                        }
                        if (StringUtils.equals((CharSequence)tagLevel1, (CharSequence)"ASSO")) {
                            if (currentLine.tag().equals("TYPE")) break;
                            if (currentLine.tag().equals("RELA")) {
                                Role alterRole;
                                Role egoRole;
                                String relationModelName = currentLine.trimmedValue();
                                relationModel = net.relationModels().getByName(relationModelName);
                                if (relationModel == null) {
                                    relationModel = net.createRelationModel(relationModelName);
                                }
                                if ((egoRole = relationModel.roles().getByName("ego")) == null) {
                                    egoRole = new Role("ego");
                                    relationModel.roles().add(egoRole);
                                }
                                if ((alterRole = relationModel.roles().getByName("alter")) == null) {
                                    alterRole = new Role("alter");
                                    relationModel.roles().add(alterRole);
                                }
                                String relationName = String.valueOf(ego.getId()) + " [R] " + alter.getId();
                                currentRelation = net.createRelation(relationName, relationModel, new Actor(ego, egoRole), new Actor(alter, alterRole));
                                break;
                            }
                            if (!currentLine.tag().equals("SOUR")) break;
                            if (currentRelation == null) {
                                throw PuckExceptions.BAD_FILE_FORMAT.create("SOURC must follow RELA in ASSO block.", new Object[0]);
                            }
                            String postfix = GEDFile.buildPostfix(currentRelation.attributes(), "SOURC");
                            currentRelation.attributes().add(new Attribute("SOURC" + postfix, String.valueOf(currentLine.getRefId())));
                            break;
                        }
                        if (tagLevel1.matches(INDI_EVENT_LABELS)) {
                            if (StringUtils.equals((CharSequence)tagLevel1, (CharSequence)"EVEN") && currentLine.tag().equals("TYPE")) {
                                typeLevel2 = currentLine.trimmedValue();
                                break;
                            }
                            if (currentLine.tag().equals("ASSO")) {
                                alter = (Individual)net.individuals().getById(currentLine.valueId());
                                if (alter != null) break;
                                alter = net.createIndividual(currentLine.valueId());
                                break;
                            }
                            ego.attributes().put(String.valueOf(GEDFile.buildPrefix(source, currentLineIndex)) + ((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).value());
                            if (currentRelation == null) break;
                            currentRelation.attributes().put(currentLine.tag(), currentLine.trimmedValue());
                            break;
                        }
                        if (StringUtils.equals((CharSequence)tagLevel1, (CharSequence)"OBJE")) break;
                        ego.attributes().put(String.valueOf(GEDFile.buildPrefix(source, currentLineIndex)) + ((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).value());
                        break;
                    }
                    case 3: {
                        RelationModel relationModel;
                        Attribute attribute;
                        String label;
                        tagLevel3 = currentLine.tag();
                        if (StringUtils.equals((CharSequence)tagLevel1, (CharSequence)"OBJE")) break;
                        if (StringUtils.equals((CharSequence)tagLevel2, (CharSequence)"ASSO")) {
                            if (currentLine.tag().equals("TYPE")) break;
                            if (currentLine.tag().equals("RELA")) {
                                Role alterRole;
                                if (currentRelation == null) {
                                    String relationName;
                                    Role egoRole;
                                    String relationModelName = StringUtils.defaultString(typeLevel2, (String)tagLevel1);
                                    relationModel = net.relationModels().getByName(relationModelName);
                                    if (relationModel == null) {
                                        relationModel = net.createRelationModel(relationModelName);
                                    }
                                    if ((egoRole = (currentRelation = net.createRelation(relationName = " [" + StringUtils.defaultString((String)typeLevel2, (String)tagLevel1) + "] " + ego.getId(), relationModel, new Actor[0])).getModel().roles().getByName("ego")) == null) {
                                        egoRole = new Role("ego");
                                        currentRelation.getModel().roles().add(egoRole);
                                    }
                                    net.addRelationActors(currentRelation, new Actor(ego, egoRole));
                                }
                                if ((alterRole = currentRelation.getModel().roles().getByName(currentLine.trimmedValue())) == null) {
                                    alterRole = new Role(currentLine.trimmedValue());
                                    currentRelation.getModel().roles().add(alterRole);
                                }
                                net.addRelationActors(currentRelation, new Actor(alter, alterRole));
                                break;
                            }
                            if (currentLine.tag().equals("SOUR")) {
                                if (currentRelation == null) {
                                    throw PuckExceptions.BAD_FILE_FORMAT.create("SOURC must follow RELA in ASSO block.", new Object[0]);
                                }
                                String postfix = GEDFile.buildPostfix(currentRelation.attributes(), "SOURC");
                                currentRelation.attributes().add(new Attribute("SOURC" + postfix, String.valueOf(currentLine.getRefId())));
                                break;
                            }
                            currentRelation.attributes().add(new Attribute(currentLine.tag(), currentLine.trimmedValue()));
                            break;
                        }
                        if (((GEDLine)source.get(currentLineIndex)).tag().equals("CONT")) {
                            Attribute relationAttribute;
                            String prefix = GEDFile.buildPrefix(source, currentLineIndex);
                            label = prefix.substring(0, prefix.length() - 1);
                            attribute = (Attribute)ego.attributes().get(label);
                            if (attribute != null) {
                                attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(currentLineIndex)).value());
                            }
                            if (currentRelation == null || (relationAttribute = (Attribute)currentRelation.attributes().get(tagLevel2)) == null) break;
                            relationAttribute.setValue(String.valueOf(relationAttribute.getValue()) + currentLine.trimmedValue());
                            break;
                        }
                        ego.attributes().put(String.valueOf(GEDFile.buildPrefix(source, currentLineIndex)) + ((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).value());
                        break;
                    }
                    default: {
                        Attribute attribute;
                        String label;
                        if (((GEDLine)source.get(currentLineIndex)).tag().equals("CONT")) {
                            String prefix = GEDFile.buildPrefix(source, currentLineIndex);
                            label = prefix.substring(0, prefix.length() - 1);
                            attribute = (Attribute)ego.attributes().get(label);
                            if (attribute == null) break;
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(currentLineIndex)).value());
                            break;
                        }
                        ego.attributes().put(String.valueOf(GEDFile.buildPrefix(source, currentLineIndex)) + ((GEDLine)source.get(currentLineIndex)).tag(), ((GEDLine)source.get(currentLineIndex)).value());
                    }
                }
                ++currentLineIndex;
                continue;
            }
            ended = true;
        }
    }

    public static String buildPostfix(Attributes attributes, String label) {
        String result;
        if (attributes == null || StringUtils.isBlank((CharSequence)label)) {
            result = null;
        } else {
            boolean ended = false;
            int index = 0;
            result = null;
            while (!ended) {
                if (index == 0 && attributes.getValue(label) == null) {
                    ended = true;
                    result = "";
                    continue;
                }
                if (index > 0 && attributes.getValue(String.valueOf(label) + index) == null) {
                    ended = true;
                    result = String.valueOf(ended);
                    continue;
                }
                ++index;
            }
        }
        return result;
    }

    public static String buildPrefix(GEDBlock source, int currentIndex) {
        boolean ended = false;
        String result = "";
        int lastGoodIndex = currentIndex;
        int index = currentIndex - 1;
        while (!ended) {
            if (((GEDLine)source.get(index)).getLevel() > 0) {
                if (((GEDLine)source.get(index)).getLevel() < ((GEDLine)source.get(lastGoodIndex)).getLevel() && !((GEDLine)source.get(index)).tag().equals(source.get(lastGoodIndex))) {
                    result = String.valueOf(((GEDLine)source.get(index)).tag()) + "_" + result;
                    lastGoodIndex = index;
                }
                --index;
                continue;
            }
            ended = true;
        }
        return result;
    }

    public static Net load(File file) throws PuckException {
        Net result = GEDFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = GEDFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        RelationModel adoptionModel = result.createRelationModel("Adoption");
        result.createRelationRole(adoptionModel, "child");
        result.createRelationRole(adoptionModel, "adoptive parent");
        result.createRelationRole(adoptionModel, "birth parent");
        logger.debug("Read.");
        boolean ended = false;
        while (!ended) {
            GEDBlock source = GEDFile.readGEDBlock(in);
            if (source == null) {
                throw PuckExceptions.BAD_FILE_FORMAT.create("File ends too early.", new Object[0]);
            }
            if (((GEDLine)source.get(0)).tag().equals("INDI")) {
                GEDFile.buildIndividual(result, source);
                continue;
            }
            if (((GEDLine)source.get(0)).tag().equals("FAM")) {
                GEDFile.buildFamily(result, source);
                continue;
            }
            if (((GEDLine)source.get(0)).tag().equals("HEAD")) {
                GEDFile.buildHeader(result, source);
                continue;
            }
            if (((GEDLine)source.get(0)).tag().equals("TRLR")) {
                ended = true;
                continue;
            }
            if (((GEDLine)source.get(0)).tag().equals("CSTA") || ((GEDLine)source.get(0)).tag().equals("SOURC") || ((GEDLine)source.get(0)).tag().equals("REPO") || ((GEDLine)source.get(0)).tag().equals("NOTE") || ((GEDLine)source.get(0)).tag().equals("OBJE")) continue;
            if (((GEDLine)source.get(0)).tag().equals("SUBM")) {
                GEDFile.addSubmitterData(result, source);
                continue;
            }
            logger.warn("IGNORING zero level tag [" + ((GEDLine)source.get(0)).tag() + "]");
        }
        if (result.relations().getByModel(adoptionModel).isEmpty()) {
            result.remove(adoptionModel);
        } else {
            Relations adoptions = result.relations().getByModel(adoptionModel);
            for (Relation adoption : adoptions) {
                Individual child = ((Actor)adoption.actors().getByRole("child").get(0)).getIndividual();
                for (Individual parent : child.getParents()) {
                    result.createRelationActor(adoption, parent.getId(), "birth parent");
                }
                String birthFamilyId = child.getOriginFamily() == null ? "" : String.valueOf(child.getOriginFamily().getId());
                adoption.attributes().put("birth_family", birthFamilyId);
                String adoptiveFamilyIdString = adoption.attributes().getValue("adoptive_family");
                if (!NumberUtils.isDigits((String)adoptiveFamilyIdString)) continue;
                int adoptiveFamilyId = Integer.parseInt(adoptiveFamilyIdString);
                Family adoptiveFamily = (Family)result.families().getById(adoptiveFamilyId);
                for (Individual parent : adoptiveFamily.getParents()) {
                    result.createRelationActor(adoption, parent.getId(), "adoptive parent");
                }
            }
        }
        logger.debug("Done.");
        return result;
    }

    public static GEDBlock readGEDBlock(BufferedReader in) throws PuckException {
        GEDBlock result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                in.mark(4096);
                GEDLine source = GEDFile.readGEDLine(in);
                if (source == null) {
                    ended = true;
                    continue;
                }
                if (result == null) {
                    result = new GEDBlock();
                    result.add(source);
                    continue;
                }
                if (source.getLevel() == 0) {
                    ended = true;
                    in.reset();
                    continue;
                }
                result.add(source);
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading GEDCOM line.", new Object[0]);
        }
        return result;
    }

    public static GEDLine readGEDLine(BufferedReader in) throws PuckException {
        GEDLine result;
        block10: {
            try {
                String line = in.readLine();
                if (line != null) {
                    line = line.trim();
                }
                if (line == null) {
                    result = null;
                    break block10;
                }
                if (line.length() == 0) {
                    result = null;
                    break block10;
                }
                Matcher matcher = GEDLINE_PATTERN.matcher(line);
                if (matcher.find() && matcher.groupCount() == 12) {
                    String valuePostfix;
                    Integer valueId;
                    String valuePrefix;
                    String refPostfix;
                    Integer refId;
                    String refPrefix;
                    int level = Integer.parseInt(matcher.group(1));
                    String ref = matcher.group(2);
                    if (ref == null) {
                        refPrefix = null;
                        refId = null;
                        refPostfix = null;
                    } else {
                        refPrefix = matcher.group(3);
                        refId = StringUtils.isBlank((CharSequence)matcher.group(4)) ? null : Integer.valueOf(matcher.group(4));
                        refPostfix = matcher.group(5);
                    }
                    String tag = matcher.group(6);
                    String value = StringUtils.isBlank((CharSequence)matcher.group(7)) ? null : matcher.group(7);
                    if (value != null && matcher.group(12) == null) {
                        valuePrefix = matcher.group(9);
                        valueId = StringUtils.isBlank((CharSequence)matcher.group(10)) ? null : Integer.valueOf(matcher.group(10));
                        valuePostfix = matcher.group(11);
                    } else {
                        valuePrefix = null;
                        valueId = null;
                        valuePostfix = null;
                    }
                    result = matcher.group(12) == null ? new GEDLine(level, refPrefix, refId, refPostfix, tag, valuePrefix, valueId, valuePostfix) : new GEDLine(level, refPrefix, refId, refPostfix, tag, value);
                    break block10;
                }
                throw PuckExceptions.BAD_FILE_FORMAT.create("Bad line format: [" + line + "].", new Object[0]);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
            }
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                GEDFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void write(PrintWriter out, GEDLine source) {
        StringBuffer line = new StringBuffer(1024);
        line.append(source.getLevel()).append(" ");
        if (source.getRef() != null) {
            line.append(source.getRef()).append(" ");
        }
        line.append(source.tag());
        if (source.hasValue()) {
            line.append(" ").append(source.value());
        }
        out.println(line.toString());
    }

    public static void write(PrintWriter out, Net net) {
        GEDFile.write(out, new GEDLine(0, null, null, null, "HEAD", null));
        for (Attribute attribute : net.attributes().toList()) {
            GEDFile.write(out, new GEDLine(1, null, null, null, attribute.getLabel(), attribute.getValue()));
        }
        for (Individual individual : net.individuals().toSortedList()) {
            GEDFile.write(out, new GEDLine(0, "I", (Integer)individual.getId(), "", "INDI", null));
            GEDFile.write(out, new GEDLine(1, null, null, null, "NAME", individual.getName()));
            GEDFile.write(out, new GEDLine(1, null, null, null, "SEX", individual.getGender().toGedChar()));
            if (individual.getOriginFamily() != null) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "FAMC", "F", individual.getOriginFamily().getId(), ""));
            }
            for (Family family : individual.getPersonalFamilies()) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "FAMS", "F", family.getId(), ""));
            }
            for (Attribute attribute : individual.attributes().toList()) {
                GEDFile.write(out, new GEDLine(1, null, null, null, attribute.getLabel(), attribute.getValue()));
            }
        }
        for (Family family : net.families().toSortedList()) {
            GEDFile.write(out, new GEDLine(0, "F", (Integer)family.getId(), "", "FAM", null));
            if (family.getHusband() != null) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "HUSB", "I", family.getHusband().getId(), ""));
            }
            if (family.getWife() != null) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "WIFE", "I", family.getWife().getId(), ""));
            }
            for (Individual child : family.getChildren()) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "CHIL", "I", child.getId(), ""));
            }
            for (Attribute attribute : family.attributes().toList()) {
                GEDFile.write(out, new GEDLine(1, null, null, null, attribute.getLabel(), attribute.getValue()));
            }
        }
        GEDFile.write(out, new GEDLine(0, null, null, null, "TRLR", null));
    }
}

