package org.tip.puck.geo;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 *
 *
 */
public enum GeoLevel {

	INTERCONTINENTAL,
	CONTINENT,
	COUNTRY,
	DEPARTMENT,
	TOWNSHIP,
	TOWN,
	QUARTER,
	SUBQUARTER,
	HOMONYM,
	TRANSNATIONAL,
	TRANSREGIONAL,
	REGIONAL,
	LOCAL;

	/**
	 * 
	 * @return
	 */
	public GeoLevel dynamic() {
		GeoLevel result;

		if (this == INTERCONTINENTAL || this == CONTINENT) {
			result = TRANSNATIONAL;
		} else if (this == COUNTRY) {
			result = TRANSREGIONAL;
		} else if (this == DEPARTMENT || this == TOWNSHIP) {
			result = REGIONAL;
		} else {
			result = LOCAL;
		}
		//
		return result;
	}

	/**
	 * 
	 * This method builds a string list of enums.
	 * 
	 * @return a string list containing enum labels.
	 */
	public static List<String> toStringList() {
		List<String> result;

		//
		result = new ArrayList<String>();

		//
		for (GeoLevel geoLevel : values()) {
			//
			result.add(geoLevel.name());
		}

		//
		return result;
	}
}