/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.style.implementations;

import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.layout.api.LayoutController;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.visualization.layouts.sugiyama.SugiyamaLayout;
import org.tip.puck.visualization.style.Style;
import org.tip.puck.visualization.style.attributes.AttributeMap;
import org.tip.puck.visualization.style.attributes.GraphStyle;

public class PGraph
implements Style {
    public static final String EDGE_DASHED_PROP = "dashed";
    private final AttributeMap map = new AttributeMap(){

        @Override
        public void setAttributes(org.gephi.graph.api.Node gephiNode, Node<?> graphNode) {
        }

        @Override
        public void setAttributes(Edge gephiEdge, Link<?> graphEdge) {
            int weightAsInt = graphEdge.getWeightAsInt();
            if (weightAsInt == -1) {
                gephiEdge.getEdgeData().getAttributes().setValue(PGraph.EDGE_DASHED_PROP.toLowerCase(), (Object)Boolean.TRUE);
            } else {
                gephiEdge.getEdgeData().getAttributes().setValue(PGraph.EDGE_DASHED_PROP.toLowerCase(), (Object)Boolean.FALSE);
            }
        }

        @Override
        public void registerAttributes(AttributeModel attributeModel) {
            AttributeTable table = attributeModel.getEdgeTable();
            table.addColumn(PGraph.EDGE_DASHED_PROP.toLowerCase(), PGraph.EDGE_DASHED_PROP, AttributeType.BOOLEAN, AttributeOrigin.DATA, (Object)Boolean.FALSE);
        }
    };

    @Override
    public GraphStyle graphStyle() {
        return GraphStyle.directed;
    }

    @Override
    public AttributeMap styleMapping() {
        return this.map;
    }

    @Override
    public void applyStyle(Workspace workspace) {
        this.layout(workspace);
        PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        PreviewModel previewModel = previewController.getModel(workspace);
        previewModel.getProperties().putValue("node.label.show", (Object)Boolean.FALSE);
        previewModel.getProperties().putValue("directed", (Object)Boolean.TRUE);
        previewModel.getProperties().putValue("edge.curved", (Object)Boolean.FALSE);
        previewModel.getProperties().putValue("DashedEdgeRenderer.property.enabled", (Object)Boolean.TRUE);
        previewController.refreshPreview(workspace);
    }

    private void layout(Workspace workspace) {
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
        LayoutController lookup = (LayoutController)Lookup.getDefault().lookup(LayoutController.class);
        SugiyamaLayout buildLayout = new SugiyamaLayout(null);
        buildLayout.setGraphModel(graphModel);
        buildLayout.resetPropertiesValues();
        buildLayout.initAlgo();
        buildLayout.goAlgo();
        buildLayout.endAlgo();
    }
}

