/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs.chain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gephi.graph.api.Node;
import org.tip.puck.visualization.layouts.GraphSource;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.BorderContainer;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.ChainContainer;

public class Triad {
    private BorderContainer source;
    private BorderContainer target;
    private Set<Node> children = new HashSet<Node>();
    private Set<ChainContainer> clusters = null;

    public Triad(BorderContainer source, BorderContainer target) {
        this.source = source;
        this.target = target;
    }

    public BorderContainer getSource() {
        return this.source;
    }

    public BorderContainer getTarget() {
        return this.target;
    }

    public void setTarget(BorderContainer target) {
        if (this.target != null) {
            System.out.println("Overwriting target");
        }
        this.target = target;
    }

    private void swap() {
        BorderContainer tmp = this.source;
        this.source = this.target;
        this.target = tmp;
    }

    public boolean isOn(BorderContainer cc) {
        return cc.equals(this.source);
    }

    public boolean isBuilt() {
        return this.clusters != null;
    }

    public boolean isInternal() {
        return this.source.getRootCluster() == this.target.getRootCluster();
    }

    public boolean addChildren(Node e) {
        if (this.clusters != null) {
            System.out.println("Triad cannot be modified after buildCluster is called");
        }
        return this.children.add(e);
    }

    public Set<Node> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    public void buildClusters(GraphSource graphSource) {
        if (this.clusters != null) {
            System.out.println("clusters already created");
            return;
        }
        this.clusters = new HashSet<ChainContainer>(this.children.size());
        for (Node child : this.children) {
            ChainContainer container = ChainContainer.getContainer(child, graphSource);
            container.setRootCluster(this.source.getRootCluster());
            container.setOrigin(this.source.getOrigin() + this.source.getChain().getHeight() + 1);
            if (container instanceof BorderContainer) {
                this.source.getRootCluster().addBorder((BorderContainer)container);
            }
            this.clusters.add(container);
        }
        for (ChainContainer container : this.clusters) {
            container.populateChildren(graphSource);
        }
    }

    public Set<ChainContainer> getClusters() {
        return this.clusters;
    }

    public BorderContainer getOtherBorder(BorderContainer cc) {
        if (cc.equals(this.source)) {
            return this.target;
        }
        if (cc.equals(this.target)) {
            return this.source;
        }
        return null;
    }
}

