/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences.workers;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.graphs.GeoNetworkUtils;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.workers.GeocodingWorker;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphMaker;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individualizable;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.Populatable;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationEnvironment;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionCriteriaList;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.partitions.PartitionSequence;
import org.tip.puck.report.ChartReport;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportList;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.EgoSequence;
import org.tip.puck.sequences.EgoSequences;
import org.tip.puck.sequences.EventTriangle;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequence;
import org.tip.puck.sequences.Sequenceable;
import org.tip.puck.sequences.Sequenceables;
import org.tip.puck.sequences.Sequences;
import org.tip.puck.sequences.ValueSequence;
import org.tip.puck.sequences.workers.MissingTestimoniesCriteria;
import org.tip.puck.sequences.workers.SequenceCriteria;
import org.tip.puck.sequences.workers.SequenceMaker;
import org.tip.puck.sequences.workers.SequenceNetworkStatistics;
import org.tip.puck.sequences.workers.SequenceStatistics;
import org.tip.puck.sequences.workers.SequenceValuator;
import org.tip.puck.sequences.workers.SequenceWorker;
import org.tip.puck.sequences.workers.UnknownPlacesCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class SequenceReporter {
    private static final Logger logger = LoggerFactory.getLogger(SequenceReporter.class);

    private static StringList getStories(Relation event) {
        StringList result = new StringList();
        for (Attribute attribute : event.attributes()) {
            String story = "";
            if (!attribute.getLabel().contains("NOTE")) continue;
            String[] label = attribute.getLabel().split("_");
            if (label.length > 1 && StringUtils.isNumeric((CharSequence)label[1])) {
                int id = Integer.parseInt(label[1]);
                Individual indi = (Individual)event.getIndividuals().getById(id);
                story = String.valueOf(story) + indi.signature() + ": ";
            }
            story = String.valueOf(story) + attribute.getValue();
            result.appendln(story);
        }
        return result;
    }

    public static Report reportDiscontinuousItineraries(Segmentation segmentation, SequenceCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Discontinuous Itineraries");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (EgoSequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
            EgoSequences partials = SequenceWorker.split(itinerary);
            if (partials.size() <= 1) continue;
            ++errorCount;
            errors.appendln(itinerary.getEgo().signature());
            int j = 0;
            for (EgoSequence partial : partials) {
                if (partial.getStations().size() != 0 && j > 0) {
                    errors.appendln(partial.getFirstTime() + "\t" + partial.getStations().get(partial.getFirstTime()));
                }
                ++j;
            }
            errors.appendln();
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUnknownRelations(Segmentation segmentation, SequenceCriteria criteria, ResourceBundle bundle) throws PuckException {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Unknown Relations");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        TreeMap<Individual, Individuals> unknownRelations = new TreeMap<Individual, Individuals>();
        for (EgoSequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
            RelationEnvironment egoEnvironment = new RelationEnvironment(itinerary.getStations().values(), itinerary.getEgo(), criteria.getEgoRoleName(), (List<String>)criteria.getRoleNames(), criteria.getRelationModelNames());
            egoEnvironment.setAlterRelations(itinerary.getStations().values(), itinerary.getEgo(), criteria.getEgoRoleName(), "ALL", criteria.getRelationModelNames(), criteria.getPattern(), criteria.getChainClassification());
            for (Individual alter : egoEnvironment.getAllAlters()) {
                if (egoEnvironment.getRelationsByAlter().get(alter).size() != 0) continue;
                Individuals unknowns = (Individuals)unknownRelations.get(itinerary.getEgo());
                if (unknowns == null) {
                    unknowns = new Individuals();
                    unknownRelations.put(itinerary.getEgo(), unknowns);
                }
                unknowns.put(alter);
                ++errorCount;
            }
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Unknown Relations") + "\n"));
        for (Individual ego : unknownRelations.keySet()) {
            for (Individual alter : ((Individuals)unknownRelations.get(ego)).toSortedList()) {
                errors.add((Object)(ego + "\t" + alter + "\n"));
            }
        }
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportDiscontinuousBiographies(Net net, Segmentation segmentation, SequenceCriteria criteria, ResourceBundle bundle) throws PuckException {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Discontinuous Itineraries");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (EgoSequence itinerary : SequenceMaker.createBiographies(net, segmentation, criteria).toSortedList()) {
            EgoSequences partials = SequenceWorker.split(itinerary);
            if (partials.size() <= 1) continue;
            ++errorCount;
            errors.appendln(itinerary.getEgo().signature());
            int j = 0;
            for (EgoSequence partial : partials) {
                if (partial.getStations().size() != 0 && j > 0) {
                    errors.appendln(partial.getFirstTime() + "\t" + partial.getStations().get(partial.getFirstTime()));
                }
                ++j;
            }
            errors.appendln();
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMissingTestimonies(Segmentation segmentation, MissingTestimoniesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Missing Testimonies");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (Relation event : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())) {
            for (Individual witness : event.getIndividuals(criteria.getEgoRoleName())) {
                if (!segmentation.getCurrentIndividuals().contains(witness)) continue;
                boolean missing = true;
                for (Attribute attribute : event.attributes()) {
                    if (!attribute.getLabel().contains("NOTE")) continue;
                    String signature = String.valueOf(witness.getId()) + ":";
                    if (!attribute.getValue().contains(signature)) continue;
                    missing = false;
                    break;
                }
                if (!missing) continue;
                ++errorCount;
                errors.appendln(String.valueOf(witness.signature()) + "\t" + event.getTypedId() + "\t" + event.getName());
            }
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Missing Testimonies") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> void createReports(Report totalReport, List<String> titles, Map<String, Report> reports, Segmentation segmentation, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria, Map<String, StringList> pajekBuffers, int width) throws PuckException {
        for (String title : titles) {
            if (title.equals("SURVEY")) {
                reports.put(title, SequenceReporter.reportSurvey("Survey", sequenceStatistics, sequenceCriteria));
                continue;
            }
            if (title.equals("DIAGRAMS")) {
                reports.put(title, SequenceReporter.reportDiagramsSequenceValues("Diagrams", sequenceStatistics, sequenceCriteria, segmentation, 3));
                continue;
            }
            if (title.equals("DIAGRAMS_DATED")) {
                reports.put(title, SequenceReporter.reportDiagramsValueSequences("Diagrams", sequenceStatistics, sequenceCriteria, segmentation, 3));
                continue;
            }
            if (title.equals("DETAILS")) {
                reports.put(title, SequenceReporter.reportDetailsSequenceValues("Details", sequenceStatistics, sequenceCriteria, sequenceCriteria.getSequenceValueCriteriaList().getLabels()));
                continue;
            }
            if (title.equals("DETAILS_DATED")) {
                reports.put(title, SequenceReporter.reportDetailsValueSequences("Details", sequenceStatistics, sequenceCriteria, sequenceCriteria.getValueSequenceCriteriaList().getLabels(), pajekBuffers));
                for (PartitionCriteria valueSequenceCriteria : sequenceCriteria.getValueSequenceCriteriaList()) {
                    String label = valueSequenceCriteria.getLabel();
                    List<?> mapKeys = sequenceStatistics.getPartitionSequence(label).getMapKeys();
                    if (mapKeys == null) continue;
                    ArrayList<String> fineLabels = new ArrayList<String>();
                    for (Object key : mapKeys) {
                        fineLabels.add(String.valueOf(label) + "$" + key);
                    }
                    reports.put("DETAILS_DATED_" + label, SequenceReporter.reportDetailsValueSequences("Details_" + label, sequenceStatistics, sequenceCriteria, fineLabels, pajekBuffers));
                }
                continue;
            }
            if (title.equals("CENSUS")) {
                reports.put(title, SequenceReporter.reportCensuses("Censuses", sequenceStatistics, sequenceCriteria));
                continue;
            }
            if (title.equals("MATRICES")) {
                reports.put(title, SequenceReporter.reportMatrices("Matrices", sequenceStatistics, sequenceCriteria, pajekBuffers));
                continue;
            }
            if (title.equals("FLOWS")) {
                reports.put(title, SequenceReporter.reportFlows("Flows", sequenceStatistics, sequenceCriteria));
                continue;
            }
            if (title.equals("TREES")) {
                reports.put(title, SequenceReporter.reportSequenceTree("Ramification trees", sequenceStatistics));
                continue;
            }
            if (!title.equals("COMPONENTS")) continue;
            reports.put(title, SequenceReporter.reportComponents("Components", sequenceStatistics, sequenceCriteria));
        }
        for (Report report : reports.values()) {
            if (report instanceof ChartReport) {
                ((ChartReport)report).arrangeChartsAndTables(width);
            }
            if (!report.hasOutput()) continue;
            totalReport.outputs().append(report);
        }
    }

    private static <S> int gender(S sequence) {
        int gender = 0;
        if (sequence instanceof Individualizable) {
            gender = ((Individualizable)sequence).getEgo().getGender().toInt();
        }
        return gender;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> void createComponentCharts(ChartReport chartReport, String networkTitle, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria) throws PuckException {
        Map<S, Partition<Node<Individual>>> componentsMap = sequenceStatistics.getComponents(networkTitle);
        if (componentsMap != null) {
            TreeMap<Value, Double[]> componentChartMap = new TreeMap<Value, Double[]>();
            TreeMap<Value, Double[]> componentChartSizeMap = new TreeMap<Value, Double[]>();
            for (Sequenceable sequence : componentsMap.keySet()) {
                Partition<Node<Individual>> components = componentsMap.get(sequence);
                for (Value value : components.getValues()) {
                    Double[] map = (Double[])componentChartMap.get(value);
                    Double[] map2 = (Double[])componentChartSizeMap.get(value);
                    if (map == null) {
                        map = new Double[]{0.0, 0.0, 0.0};
                        componentChartMap.put(value, map);
                        map2 = new Double[]{0.0, 0.0, 0.0};
                        componentChartSizeMap.put(value, map2);
                    }
                    int n = SequenceReporter.gender(sequence);
                    map[n] = map[n] + 1.0;
                    map[2] = map[2] + 1.0;
                    int n2 = SequenceReporter.gender(sequence);
                    map2[n2] = map2[n2] + (double)components.getCluster(value).size();
                    map2[2] = map2[2] + (double)components.getCluster(value).size();
                }
            }
            for (Value value : componentChartMap.keySet()) {
                Double[] sums = (Double[])componentChartSizeMap.get(value);
                int i = 0;
                while (i < 3) {
                    sums[i] = new Double(sums[i] / ((Double[])componentChartMap.get(value))[i]);
                    ++i;
                }
            }
            ReportChart componentChart = StatisticsReporter.createMapChart(componentChartMap, "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            chartReport.addChartWithTables(componentChart, "Components " + networkTitle);
            ReportChart componentSizeChart = StatisticsReporter.createMapChart(componentChartSizeMap, "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            chartReport.addChartWithTables(componentSizeChart, "Components Size " + networkTitle);
            SequenceNetworkStatistics<S, E> componentConnections = sequenceStatistics.getRelationConnectionMatrix();
            if (componentConnections != null) {
                for (ReportChart chart : componentConnections.getCharts()) {
                    chartReport.addChart(chart);
                }
                chartReport.addTable(componentConnections.getTable("Component Connections " + networkTitle));
            }
        }
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportComponents(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria) {
        Report componentReport = new Report(title);
        for (String networkTitle : sequenceCriteria.getNetworkTitles()) {
            Map<S, Partition<Node<Individual>>> componentsMap = sequenceStatistics.getComponents(networkTitle);
            if (componentsMap == null) continue;
            for (Sequenceable sequence : componentsMap.keySet()) {
                Partition<Node<Individual>> components = componentsMap.get(sequence);
                componentReport.outputs().appendln("Components " + networkTitle);
                componentReport.outputs().appendln(sequence + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
            }
        }
        return componentReport;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> void getRData(Report result, SequenceStatistics<S, E> sequenceStatistics, Segmentation segmentation, SequenceCriteria sequenceCriteria) throws PuckException {
        TreeMap<String, StringList> rStateBuffers = new TreeMap<String, StringList>();
        TreeMap<String, StringList> rEventBuffers = new TreeMap<String, StringList>();
        TreeMap<String, Integer> rSizes = new TreeMap<String, Integer>();
        for (String partitionLabel : sequenceCriteria.getSequenceValueLabels()) {
            if (!partitionLabel.contains("PROFILE#")) continue;
            String label = partitionLabel.substring(8);
            rStateBuffers.put(label, new StringList());
            rSizes.put(label, 0);
            StringList rEventBuffer = new StringList();
            rEventBuffer.appendln("Id\tStep\tDate\tAge\t" + label);
            rEventBuffers.put(label, rEventBuffer);
        }
        for (Sequenceable sequence : sequenceStatistics.sequences.toSortedList()) {
            if (sequenceStatistics.getValues("NREVENTS").get(sequence.getId()) == null) continue;
            ValueSequence ageSequence = sequenceStatistics.getValueSequence("AGE", sequence);
            ValueSequence dateSequence = sequenceStatistics.getValueSequence(sequenceCriteria.getDateLabel(), sequence);
            for (String label : rStateBuffers.keySet()) {
                StringList rStateBuffer = (StringList)rStateBuffers.get(label);
                Iterator rEventBuffer = (StringList)rEventBuffers.get(label);
                String genderString = "";
                if (sequence instanceof Individualizable) {
                    genderString = ((Individualizable)((Object)sequence)).getEgo().getGender().toString();
                }
                String rStateLine = String.valueOf(sequence.getId()) + "\t" + sequence + "\t" + genderString;
                ValueSequence valueSequence = sequenceStatistics.getValueSequence(label, sequence);
                if (valueSequence.getNrStations() > (Integer)rSizes.get(label)) {
                    rSizes.put(label, valueSequence.getNrStations());
                }
                int step = 0;
                for (Ordinal time : sequence.getTimes()) {
                    Value rItem = (Value)valueSequence.getStation(time);
                    rStateLine = String.valueOf(rStateLine) + "\t" + rItem;
                    rEventBuffer.appendln(String.valueOf(sequence.getId()) + "\t" + step + "\t" + dateSequence.getStation(time) + "\t" + ageSequence.getStation(time) + "\t" + rItem);
                }
                ++step;
                rStateBuffer.append(rStateLine);
            }
        }
        for (String title : rStateBuffers.keySet()) {
            StringList rEventBuffer;
            StringList rStateBuffer = (StringList)rStateBuffers.get(title);
            StringList rStateBufferCompleted = new StringList();
            int rSize = (Integer)rSizes.get(title);
            String rStateHeadLine = "Id\tName\tGender";
            int i = 0;
            while (i < rSize) {
                rStateHeadLine = String.valueOf(rStateHeadLine) + "\t" + title + i;
                ++i;
            }
            rStateBufferCompleted.appendln(rStateHeadLine);
            for (String rStateLine : rStateBuffer) {
                String rStateLineCompleted = "";
                String[] rStateItems = rStateLine.split("\t");
                int i2 = 0;
                while (i2 < 3 + rSize) {
                    rStateLineCompleted = i2 < rStateItems.length ? String.valueOf(rStateLineCompleted) + rStateItems[i2] + "\t" : String.valueOf(rStateLineCompleted) + "NA\t";
                    ++i2;
                }
                rStateBufferCompleted.appendln(rStateLineCompleted);
            }
            if (rStateBuffer.length() != 0) {
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-States-" + title), ".txt");
                ReportRawData rawData = new ReportRawData("Export " + title + " State Sequences to RData", "Text", "txt", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(rStateBufferCompleted.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
            if ((rEventBuffer = (StringList)rEventBuffers.get(title)).length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Events-" + title), ".txt");
            ReportRawData rawData = new ReportRawData("Export " + title + " Event Sequences to RData", "Text", "txt", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(rEventBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
    }

    public static Graph<Place2> getTrajectoryGraph2(Geography2 geography, Segmentation segmentation, SequenceCriteria censusCriteria) throws PuckException {
        Graph<Place2> result = null;
        ArrayList charts = new ArrayList();
        ArrayList tables = new ArrayList();
        EgoSequences sequences = new EgoSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequenceStatistics<EgoSequence, Relation> census = new SequenceStatistics<EgoSequence, Relation>(segmentation, sequences, censusCriteria);
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SequenceCriteria.TrajectoriesOperation.DRAW)) {
            SequenceNetworkStatistics<EgoSequence, Relation> eventSequenceMatrix = census.getEventSequenceMatrix("PLACE");
            Graph drawGraph = eventSequenceMatrix.getSequenceNetwork("PLACE", Gender.UNKNOWN);
            Graph<String> placeNameGraph = GeoNetworkUtils.createGeoNetwork2(drawGraph, censusCriteria.getLevel());
            result = GeocodingWorker.geocodeGraph(geography, placeNameGraph);
        }
        return result;
    }

    public static Report reportSequences(Net net, Segmentation segmentation, SequenceCriteria censusCriteria) throws PuckException {
        Relation event;
        Individual ego;
        String spouseFilterLabel = "INTERV";
        Chronometer chrono = new Chronometer();
        Report result = new Report("Sequence Report");
        result.setOrigin("Sequence reporter");
        Report surveyReport = null;
        Report detailedReport = null;
        Report actorEventTableReport = null;
        Report interactionTableReport = null;
        Report biographyReport = null;
        Report extendedBiographyReport = null;
        ArrayList<Report> reports = new ArrayList<Report>();
        if (censusCriteria.getSequenceReportTypes().contains((Object)SequenceCriteria.SequenceReportType.ITINERARIES_SURVEY)) {
            surveyReport = new Report("Survey");
            reports.add(surveyReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SequenceCriteria.SequenceReportType.ITINERARIES_DETAILS)) {
            detailedReport = new Report("Details");
            reports.add(detailedReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SequenceCriteria.SequenceReportType.ACTOR_EVENT_TABLES)) {
            actorEventTableReport = new Report("Actor-Event tables");
            reports.add(actorEventTableReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SequenceCriteria.SequenceReportType.INTERACTION_TABLES)) {
            interactionTableReport = new Report("Interaction tables");
            reports.add(interactionTableReport);
        }
        Geography geography = censusCriteria.getGeography();
        EgoSequences sequences = new EgoSequences();
        for (Individual ego2 : segmentation.getCurrentIndividuals().toSortedList()) {
            if (surveyReport != null) {
                surveyReport.outputs().appendln(ego2.signature());
                surveyReport.outputs().appendln();
            }
            if (detailedReport != null) {
                detailedReport.outputs().appendln(ego2.signature());
                detailedReport.outputs().appendln();
            }
            EgoSequence sequence = SequenceMaker.createPersonalEventSequence(ego2, censusCriteria);
            sequences.add(sequence);
            for (Individual spouse : ego2.spouses()) {
                spouse.getAttributeValue(spouseFilterLabel);
            }
            if (actorEventTableReport != null) {
                actorEventTableReport.outputs().append(SequenceWorker.roleTable(sequence));
            }
            if (interactionTableReport != null) {
                interactionTableReport.outputs().append(SequenceWorker.interactionTable(sequence));
            }
            EgoSequences subSequences = SequenceWorker.split(sequence);
            for (Iterator<Ordinal> subSequence : subSequences) {
                if (subSequences.size() > 1) {
                    if (surveyReport != null) {
                        surveyReport.outputs().appendln(((Sequence)((Object)subSequence)).getId());
                    }
                    if (detailedReport != null) {
                        detailedReport.outputs().appendln(((Sequence)((Object)subSequence)).getId());
                    }
                }
                for (Ordinal key : ((Sequence)((Object)subSequence)).getStations().keySet()) {
                    Relation event2 = (Relation)((Sequence)((Object)subSequence)).getStations().get(key);
                    Place start = geography.getByHomonym(event2.getAttributeValue("START_PLACE"));
                    Place end = geography.getByHomonym(event2.getAttributeValue("END_PLACE"));
                    Place ancestor = geography.getCommonAncestor(start, end);
                    GeoLevel commonLevel = null;
                    String commonPlaceName = null;
                    String startPlaceLabel = censusCriteria.getStartPlaceLabel();
                    String endPlaceLabel = censusCriteria.getEndPlaceLabel();
                    if (ancestor != null) {
                        commonLevel = ancestor.getLevel();
                        commonPlaceName = ancestor.getName();
                    }
                    String order = SequenceWorker.order(event2, ego2);
                    if (surveyReport != null) {
                        surveyReport.outputs().appendln(key + "\t" + order + "\t" + key.getYear() + "\t(" + ((EgoSequence)((Object)subSequence)).getEgoAge(key.getYear()) + ")\t" + event2.getTypedId() + "\t" + event2.getAttributeValue(startPlaceLabel) + "\t" + event2.getAttributeValue(endPlaceLabel) + "\t" + (Object)((Object)commonLevel) + "\t(" + commonPlaceName + ")\t");
                    }
                    if (detailedReport == null) continue;
                    detailedReport.outputs().appendln(key + "\t" + order + "\t" + key.getYear() + "\t(" + ((EgoSequence)((Object)subSequence)).getEgoAge(key.getYear()) + ")\t" + event2.getTypedId() + "\t" + event2.getAttributeValue(startPlaceLabel) + "\t" + event2.getAttributeValue(endPlaceLabel) + "\t" + (Object)((Object)commonLevel) + "\t(" + commonPlaceName + ")\t");
                    detailedReport.outputs().appendln();
                    detailedReport.outputs().appendln(SequenceReporter.getStories(event2));
                }
                for (Report report : reports) {
                    report.outputs().appendln();
                }
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SequenceCriteria.SequenceReportType.BIOGRAPHIES)) {
            biographyReport = new Report("Biographies");
            reports.add(biographyReport);
            for (EgoSequence biography : SequenceMaker.createBiographies(net, segmentation, censusCriteria).toSortedList()) {
                ego = (Individual)segmentation.getCurrentIndividuals().getById(biography.getId());
                biographyReport.outputs().appendln(ego.signature());
                for (Ordinal key : biography.getStations().keySet()) {
                    event = (Relation)biography.getStation(key);
                    biographyReport.outputs().appendln(key + "\t" + event.getRoles(ego).toString() + " (" + biography.getEgoAge(key.getYear()) + ")\t" + event.getName() + "\t" + RelationValuator.getEgoRolePartners(event, ego, censusCriteria.getRelationModelName(), censusCriteria.getEgoRoleName()));
                }
                biographyReport.outputs().appendln();
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SequenceCriteria.SequenceReportType.EXTENDED_BIOGRAPHIES)) {
            extendedBiographyReport = new Report("Extended biographies");
            reports.add(extendedBiographyReport);
            for (EgoSequence extendedBiography : SequenceMaker.createExtendedBiographies(net, segmentation, censusCriteria).toSortedList()) {
                ego = (Individual)segmentation.getCurrentIndividuals().getById(extendedBiography.getId());
                extendedBiographyReport.outputs().appendln(ego.signature());
                for (Ordinal key : extendedBiography.getStations().keySet()) {
                    event = (Relation)extendedBiography.getStation(key);
                    extendedBiographyReport.outputs().appendln(key + "\t" + event.getRoles(ego).toString() + " (" + extendedBiography.getEgoAge(key.getYear()) + ")\t" + event.getName() + " " + RelationValuator.getEgoRolePartners(event, ego, censusCriteria.getRelationModelName(), censusCriteria.getEgoRoleName()));
                }
                extendedBiographyReport.outputs().appendln();
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SequenceCriteria.SequenceReportType.EXPORT_RELATION_GRAPH)) {
            Graph<Individual> graph = NetUtils.createRelationGraph(segmentation, censusCriteria.getRelationModelName());
            ArrayList<String> partitionLabels = new ArrayList<String>();
            StringList pajekBuffer = new StringList();
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph, partitionLabels));
            pajekBuffer.appendln();
            if (pajekBuffer.length() != 0) {
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Relation Network"), ".paj");
                ReportRawData rawData = new ReportRawData("Export Relation Network to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
        }
        for (Report report : reports) {
            result.outputs().append(report);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportSequenceTree(String title, SequenceStatistics<S, E> sequenceStatistics) {
        Report report = new Report(title);
        for (String value : sequenceStatistics.getSequenceNetworkLabels()) {
            report.outputs().appendln("Sequence Tree " + value);
            Graph<Cluster<String>> sequenceTypeNetwork = sequenceStatistics.getSubSequenceMatrix(value).getSequenceNetworks()[2];
            Node<Cluster<String>> start = sequenceTypeNetwork.getNode(1);
            Stack stack = new Stack();
            report.outputs().appendln(start.getReferent() + "\t" + start.getReferent().size());
            stack.push(start);
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                for (Node next : node.getOutNodes().toListSortedByLabel()) {
                    report.outputs().appendln(next.getReferent() + "\t" + ((Cluster)next.getReferent()).size());
                    stack.push(next);
                }
            }
            report.outputs().appendln();
        }
        report.outputs().appendln();
        return report;
    }

    private static void reportTriangles(Report report, Segmentation segmentation) throws PuckException {
        HashMap<Integer, Partition<EventTriangle>> trianglesMap = new HashMap<Integer, Partition<EventTriangle>>();
        Partition<EventTriangle> allTriangles = new Partition<EventTriangle>();
        Partition<Individual> triangleTypes = new Partition<Individual>();
        for (Individual ego : segmentation.getCurrentIndividuals()) {
            Individuals individuals = ego.getRelated("Migevent");
            individuals.add(ego);
            Partition<EventTriangle> triangles = SequenceWorker.getTriangles(individuals, "Migevent");
            allTriangles.add(triangles);
            trianglesMap.put(ego.getId(), triangles);
            for (Cluster<EventTriangle> cluster : triangles.getClusters()) {
                triangleTypes.put(ego, cluster.getValue());
            }
        }
        Report trianglesReport = new Report("Triangles");
        trianglesReport.outputs().appendln("Type\tnrTriangles\tnrEgoNetworks");
        for (Cluster cluster : allTriangles.getClusters().toListSortedByValue()) {
            trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + triangleTypes.getCluster(cluster.getValue()).size());
        }
        trianglesReport.outputs().appendln();
        PartitionCriteria partitionCriteria = new PartitionCriteria("Triangles");
        ReportChart chart5 = StatisticsReporter.createPartitionChart(allTriangles, partitionCriteria, null);
        trianglesReport.outputs().appendln(chart5);
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            Partition triangles = (Partition)trianglesMap.get(ego.getId());
            trianglesReport.outputs().appendln(ego + "\t" + triangles.size() + " types");
            for (Cluster cluster : triangles.getClusters().toListSortedByValue()) {
                trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size());
                for (EventTriangle triangle : cluster.getItems()) {
                    trianglesReport.outputs().appendln(triangle.getEventPattern());
                }
                trianglesReport.outputs().appendln();
            }
            trianglesReport.outputs().appendln();
        }
    }

    public static Report reportUnknownPlaces(Segmentation segmentation, ResourceBundle bundle) {
        UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
        criteria.setIncludedIndividual(true);
        criteria.setIncludedAllRelations(true);
        Report result = SequenceReporter.reportUnknownPlaces(segmentation, criteria, bundle);
        return result;
    }

    public static Report reportUncodedPlaces(Segmentation segmentation, ResourceBundle bundle) {
        UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
        criteria.setIncludedIndividual(true);
        criteria.setIncludedAllRelations(true);
        Report result = SequenceReporter.reportUncodedPlaces(segmentation, criteria, bundle);
        return result;
    }

    public static Report reportUnknownPlaces(Segmentation segmentation, UnknownPlacesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        Geography geography = Geography.getInstance();
        Partition<String> unknownPlaces = new Partition<String>();
        int errorCount = 0;
        StringList errors = new StringList();
        if (criteria.isIncludedIndividual()) {
            for (Individual individual : segmentation.getCurrentIndividuals()) {
                for (Attribute attribute : individual.attributes()) {
                    if (!attribute.getLabel().contains("PLAC") || geography.getByHomonym(attribute.getValue()) != null) continue;
                    unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
                    ++errorCount;
                }
            }
        }
        Relations relations = criteria.isIncludedAllRelations() ? segmentation.getCurrentRelations() : (criteria.getRelationNames().isEmpty() ? new Relations() : segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames()));
        for (Relation relation : relations) {
            for (Attribute attribute : relation.attributes()) {
                if (!attribute.getLabel().contains("PLAC") || geography.getByHomonym(attribute.getValue()) != null) continue;
                unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
                ++errorCount;
            }
        }
        for (Cluster cluster : unknownPlaces.getClusters()) {
            errors.appendln(cluster.getValue().toString());
            for (String placeName : cluster.getItems()) {
                errors.appendln("\t" + placeName);
            }
            errors.appendln();
        }
        Report result = new Report();
        result.setTitle("Unknown Places");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Unknown Places") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static Report reportUncodedPlaces(Segmentation segmentation, UnknownPlacesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        Geography geography = Geography.getInstance();
        Partition<Place> uncodedPlaces = new Partition<Place>();
        int errorCount = 0;
        StringList errors = new StringList();
        if (criteria.isIncludedIndividual()) {
            for (Individual individual : segmentation.getCurrentIndividuals()) {
                for (Attribute attribute : individual.attributes()) {
                    if (!attribute.getLabel().contains("PLAC")) continue;
                    geography.putUncodedPlaces(uncodedPlaces, attribute.getValue());
                }
            }
        }
        Relations relations = criteria.isIncludedAllRelations() ? segmentation.getCurrentRelations() : (criteria.getRelationNames().isEmpty() ? new Relations() : segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames()));
        for (Relation relation : relations) {
            for (Attribute attribute : relation.attributes()) {
                Place place;
                if (!attribute.getLabel().contains("PLAC") || (place = geography.getByHomonym(attribute.getValue())) == null || place.getCoordinate() != null) continue;
                uncodedPlaces.put(place, new Value(place.getLevel()));
                Place sup = place.getSup();
                while (sup.getCoordinate() == null) {
                    uncodedPlaces.put(sup, new Value(sup.getLevel()));
                    sup = sup.getSup();
                }
            }
        }
        for (Cluster cluster : uncodedPlaces.getClusters().toListSortedByValue()) {
            errors.appendln(String.valueOf(cluster.getValue().toString()) + " " + cluster.size());
            errorCount += cluster.size();
            ArrayList<String> toponyms = new ArrayList<String>();
            for (Place place : cluster.getItems()) {
                toponyms.add(place.getToponym());
            }
            Collections.sort(toponyms);
            for (String toponym : toponyms) {
                errors.appendln("\t" + toponym);
            }
            errors.appendln();
        }
        Report result = new Report();
        result.setTitle("Uncoded Places");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Uncoded Places") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static int sequenceNumber(Cluster<String> cluster) {
        HashSet<String> set = new HashSet<String>();
        for (String string : cluster.getItems()) {
            set.add(string.split("\\s")[0]);
        }
        int result = set.size();
        return result;
    }

    public static <S extends Sequenceable<E>, E extends Populatable> Report reportMembers(Sequenceables<S, E> slices, SequenceCriteria criteria) throws PuckException {
        Report result = new Report(String.valueOf(criteria.getRelationModelName()) + " Slices");
        StringList list = new StringList();
        if (slices.isPopulatable()) {
            for (Sequenceable sequence : slices.toSortedList()) {
                list.appendln(sequence.getId());
                list.appendln();
                List<Individual> members = ((Populatable)((Object)sequence)).getIndividuals().toSortedList(IndividualComparator.Sorting.BIRT_YEAR);
                for (Individual member : members) {
                    list.append(String.valueOf(member.signature()) + " (" + IndividualValuator.lifeStatusAtYear(member, criteria.getReferenceYear()) + ")\t");
                    for (Ordinal time : Ordinal.getOrdinals(criteria.getDates())) {
                        String status = SequenceWorker.getStatus(slices, member, time, criteria);
                        if (status != null) {
                            list.append(String.valueOf(status) + "\t");
                            continue;
                        }
                        Integer deathYear = IndividualValuator.getDeathYear(member);
                        Integer birthYear = IndividualValuator.getBirthYear(member);
                        if (deathYear != null && deathYear <= time.getYear()) {
                            list.append("+" + deathYear + "\t\t");
                            continue;
                        }
                        if (birthYear != null && birthYear >= time.getYear()) {
                            list.append("*" + birthYear + "\t\t");
                            continue;
                        }
                        list.append("?\t\t");
                    }
                    list.appendln();
                }
                list.appendln();
            }
        } else {
            throw PuckExceptions.INVALID_PARAMETER.create(slices + "has no members.", new Object[0]);
        }
        result.outputs().append(list);
        logger.debug("Member report created for " + slices);
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> void reportDiagramsValueSequences(ChartReport report, PartitionSequence<E> partitionSequence, PartitionCriteria partitionCriteria, PartitionCriteria splitCriteria, String label) throws PuckException {
        for (Ordinal time : partitionSequence.getTimes()) {
            Partition partition = (Partition)partitionSequence.getStation(time);
            Partition regroupedPartition = PartitionMaker.create(partition, partitionCriteria);
            ReportChart chart = StatisticsReporter.createPartitionChart(regroupedPartition, partitionCriteria, splitCriteria);
            report.addChartWithTables(chart, String.valueOf(label) + " " + time);
        }
    }

    private static <S extends Sequenceable<E>, E extends Numberable, V extends Numberable> ChartReport reportDiagramsValueSequences(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria, Segmentation segmentation, int width) throws PuckException {
        ChartReport result = new ChartReport(title);
        for (PartitionCriteria partitionCriteria : sequenceCriteria.getValueSequenceCriteriaList()) {
            String label = partitionCriteria.getLabel();
            if (partitionCriteria.isWithDiagram()) {
                PartitionSequence<Object> partitionSequence = null;
                if (sequenceStatistics.getAggregatePartitionSequence(label) == null) {
                    partitionSequence = sequenceStatistics.getPartitionSequence(label).unpack(partitionCriteria.getValueCode());
                } else {
                    partitionSequence = sequenceStatistics.getAggregatePartitionSequence(label).unpack(partitionCriteria.getValueCode());
                    label = String.valueOf(label) + " TOTAL";
                }
                PartitionCriteria splitCriteria = null;
                if (partitionSequence.hasIndividualizableItems()) {
                    splitCriteria = new PartitionCriteria("GENDER");
                }
                SequenceReporter.reportDiagramsValueSequences(result, partitionSequence, partitionCriteria, splitCriteria, label);
            }
            if (!partitionCriteria.isWithFlow()) continue;
            PartitionCriteria splitCriteria = new PartitionCriteria("GENDER");
            Map<String, PartitionSequence<Individual>> partitionSequences = sequenceStatistics.getMigrations(sequenceCriteria, partitionCriteria);
            for (String key : partitionSequences.keySet()) {
                SequenceReporter.reportDiagramsValueSequences(result, partitionSequences.get(key), partitionCriteria.cloneChangeLabel(String.valueOf(key) + "_" + label), splitCriteria, String.valueOf(key) + "_" + label);
            }
        }
        logger.debug("Diagrams (dated) created for " + sequenceStatistics);
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> ChartReport reportDiagramsSequenceValues(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria, Segmentation segmentation, int width) throws PuckException {
        ChartReport result = new ChartReport(title);
        for (PartitionCriteria partitionCriteria : sequenceCriteria.getSequenceValueCriteriaList()) {
            String label = partitionCriteria.getLabel();
            if (partitionCriteria.isWithDiagram()) {
                ReportChart chart = null;
                if (label.equals("MEAN_NR_MOVES")) {
                    Map<Value, Double[]> map = sequenceStatistics.getMeanNrMoves();
                    chart = StatisticsReporter.createMapChart(map, label, new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
                } else {
                    PartitionCriteria splitCriteria = new PartitionCriteria("GENDER");
                    Partition<S> sequencePartition = sequenceStatistics.getSequencePartition(label);
                    Partition<S> regroupedSequencePartition = PartitionMaker.create(sequencePartition, partitionCriteria);
                    chart = StatisticsReporter.createPartitionChart(regroupedSequencePartition, partitionCriteria, splitCriteria);
                    if (label.substring(0, 3).equals("AGE")) {
                        if (sequencePartition.maxValue() != null) {
                            ReportChart survivalChart = StatisticsReporter.createSurvivalChart(sequencePartition, splitCriteria);
                            result.addChartWithTables(survivalChart, String.valueOf(label) + "_Survival");
                        } else {
                            System.err.println(String.valueOf(label) + " no max value");
                        }
                    }
                }
                result.addChartWithTables(chart, label);
            }
            if (!label.contains("SIMILARITY")) continue;
            SequenceCriteria.ValueSequenceLabel relationClassificationType = SequenceCriteria.ValueSequenceLabel.valueOf(label.substring(label.lastIndexOf("_") + 1));
            Map<Value, Double[]> similaritiesMap = sequenceStatistics.getSimilaritiesMap(relationClassificationType);
            ReportChart chart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[]{"HH", "FH", "HF", "FF", "All"}, ReportChart.GraphType.LINES);
            result.addChartWithTables(chart, label);
        }
        for (String label : sequenceStatistics.getSequenceNetworkLabels()) {
            SequenceNetworkStatistics<S, E> eventSequenceMatrix = sequenceStatistics.getEventSequenceMatrix(label);
            if (eventSequenceMatrix == null) continue;
            for (ReportChart chart : eventSequenceMatrix.getCharts()) {
                result.addChart(chart);
            }
            result.addTable(eventSequenceMatrix.getTable("Event Type Sequences"));
        }
        for (String label : sequenceStatistics.getSequenceTreeLabels()) {
            SequenceNetworkStatistics<S, E> subSequenceMatrix = sequenceStatistics.getSubSequenceMatrix(label);
            if (subSequenceMatrix == null) continue;
            result.addChart(subSequenceMatrix.getRamificationChart());
        }
        for (String networkTitle : sequenceCriteria.getNetworkTitles()) {
            SequenceReporter.createComponentCharts(result, networkTitle, sequenceStatistics, sequenceCriteria);
        }
        logger.debug("Diagrams created for " + sequenceStatistics);
        return result;
    }

    private static <V> void reportCensus(Report result, PartitionSequence<V> partitionSequence, String indicator, Partition.ValueCode valueCode, SequenceCriteria criteria) {
        partitionSequence = partitionSequence.unpack(valueCode);
        Partition<V> valueSequencePartition = partitionSequence.getValueSequencePartition();
        result.outputs().appendln(String.valueOf(indicator) + " Position Census");
        result.outputs().appendln();
        String headLine0 = "Position\t";
        Integer[] integerArray = criteria.getDates();
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer year = integerArray[n2];
            headLine0 = String.valueOf(headLine0) + year + "\t\t\t";
            ++n2;
        }
        result.outputs().appendln(headLine0);
        for (Value value : partitionSequence.getValuesAsSortedList()) {
            String valueLine = "" + value;
            for (Ordinal time : partitionSequence.getTimes()) {
                valueLine = String.valueOf(valueLine) + "\t" + partitionSequence.getClusterSize(time, value) + "\t" + partitionSequence.getClusterShare(time, value) + "\t" + partitionSequence.getClusterItemsAsString(time, value);
            }
            result.outputs().appendln(valueLine);
        }
        result.outputs().appendln();
        result.outputs().appendln(String.valueOf(indicator) + " Sequence Census");
        result.outputs().appendln();
        result.outputs().appendln("Sequence");
        int sequenceCount = valueSequencePartition.itemsCount();
        for (Cluster<V> cluster : valueSequencePartition.getClusters().toListSortedByValue()) {
            result.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + MathUtils.percent(cluster.size(), sequenceCount));
        }
        result.outputs().appendln();
    }

    private static <S extends Sequenceable<E>, E> void reportMatrix(Report report, PartitionSequence<S> partitionSequence, String indicator, Partition.ValueCode valueCode, StringList pajekBuffer, SequenceCriteria criteria) throws PuckException {
        partitionSequence = partitionSequence.unpack(valueCode);
        Matrix matrix = partitionSequence.getTransitionMatrix();
        Map<Value, Double> meanValueFrequencies = partitionSequence.getMeanValueFrequencies();
        report.outputs().appendln("Transition Matrix " + indicator);
        report.outputs().appendln();
        String headLine = "\t";
        int col = 0;
        while (col < matrix.getRowDim()) {
            headLine = String.valueOf(headLine) + matrix.getColLabel(col) + "\t";
            ++col;
        }
        report.outputs().appendln(headLine);
        int row = 0;
        while (row < matrix.getRowDim()) {
            String rowLine = String.valueOf(matrix.getRowLabel(row)) + "\t";
            int col2 = 0;
            while (col2 < matrix.getRowDim()) {
                rowLine = String.valueOf(rowLine) + matrix.getAsRowPercentage(row, col2) + "\t";
                ++col2;
            }
            report.outputs().appendln(rowLine);
            ++row;
        }
        report.outputs().appendln();
        if (pajekBuffer != null) {
            Graph<Node<String>> transitionGraph = GraphMaker.createGraph("Transition Graph " + criteria.getRelationModelName() + " " + indicator, matrix, meanValueFrequencies, "MEAN");
            ArrayList<String> partitionLabels = new ArrayList<String>();
            partitionLabels.add("MEAN");
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(transitionGraph, partitionLabels));
            pajekBuffer.appendln();
            report.outputs().append(GraphReporter.reportStrengthsByTags(transitionGraph));
            report.outputs().appendln();
        }
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportFlows(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria) {
        Report result = new Report(title);
        Partition<String> flows = new Partition<String>();
        flows.add(sequenceStatistics.getFlows("IN", sequenceCriteria));
        flows.add(sequenceStatistics.getFlows("OUT", sequenceCriteria));
        for (Cluster cluster : flows.getClusters().toListSortedByValue()) {
            result.outputs().appendln(cluster.getValue());
            for (String item : cluster.getItems()) {
                result.outputs().appendln("\t" + item);
            }
        }
        result.outputs().appendln();
        logger.debug("Flow report created for " + sequenceStatistics);
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportSurvey(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria) {
        Report result = new Report(title);
        String headLine = "INDICATOR";
        List<String> genderLabels = Arrays.asList("MALE", "FEMALE", "ALL");
        List<String> measureLabels = Arrays.asList("AVERAGE", "AVERAGE_POSITIVE", "MEDIAN", "MAX", "SUM");
        for (String genderLabel : genderLabels) {
            for (String measureLabel : measureLabels) {
                headLine = String.valueOf(headLine) + "\t" + measureLabel + " (" + genderLabel + ")";
            }
        }
        result.outputs().appendln(headLine);
        for (PartitionCriteria partitionCriteria : sequenceCriteria.getSequenceValueCriteriaList()) {
            String label = partitionCriteria.getLabel();
            Partition<S> partition = sequenceStatistics.getSequencePartition(label);
            if (partition.isNumeric()) {
                try {
                    NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(partition);
                    String measureLine = String.valueOf(label) + "\t";
                    int gender = 0;
                    while (gender < 3) {
                        for (String string : measureLabels) {
                            measureLine = String.valueOf(measureLine) + genderedValues[gender].getValueAsString(string) + "\t";
                        }
                        ++gender;
                    }
                    result.outputs().appendln(measureLine);
                }
                catch (ClassCastException e) {
                    System.err.println(partition + " is not individualizable");
                    continue;
                }
            }
            if (!label.contains("SIMILARITY")) continue;
            SequenceCriteria.ValueSequenceLabel relationClassificationType = SequenceCriteria.ValueSequenceLabel.valueOf(label.substring(label.lastIndexOf("_") + 1));
            Map<Value, Double[]> similaritiesMap = sequenceStatistics.getSimilaritiesMap(relationClassificationType);
            for (Value key : similaritiesMap.keySet()) {
                result.outputs().appendln(String.valueOf(label) + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100.0));
            }
        }
        result.outputs().appendln();
        logger.debug("Survey report created for " + sequenceStatistics);
        for (String label : sequenceStatistics.getSequenceNetworkLabels()) {
            SequenceNetworkStatistics<S, E> eventSequenceMatrix = sequenceStatistics.getEventSequenceMatrix(label);
            result.outputs().appendln();
            result.outputs().appendln("Sequence Network Statistics " + label);
            result.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
            Gender[] key = Gender.values();
            int n = key.length;
            int relationClassificationType = 0;
            while (relationClassificationType < n) {
                Gender gender = key[relationClassificationType];
                GraphProfile<Cluster<String>> graphProfile = eventSequenceMatrix.getProfile(gender);
                String centralReferents = "";
                for (Cluster<String> centralReferent : graphProfile.getCentralReferents()) {
                    centralReferents = String.valueOf(centralReferents) + centralReferent.getValue() + " ";
                }
                double maxBetweenness = graphProfile.getMaxBetweenness();
                double density = graphProfile.density();
                double endo = MathUtils.round(graphProfile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                double endoExp = MathUtils.round(graphProfile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                double conc = MathUtils.round(graphProfile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                double concExp = MathUtils.round(graphProfile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                double sym = MathUtils.round(graphProfile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                double symExp = MathUtils.round(graphProfile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                result.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + maxBetweenness + ") betweenness centrality");
                ++relationClassificationType;
            }
            result.outputs().appendln();
        }
        result.outputs().appendln();
        Map<String, Map<String, Map<String, Value>>> parcoursNetworkStatistics = sequenceStatistics.getParcoursNetworkStatistics();
        if (parcoursNetworkStatistics != null) {
            result.outputs().appendln("Parcours Network Statistics");
            String pnHeadline = null;
            boolean first = true;
            ArrayList<String> clusterValues = new ArrayList<String>(parcoursNetworkStatistics.keySet());
            Iterator<String> iterator = parcoursNetworkStatistics.get("Total").keySet().iterator();
            while (iterator.hasNext()) {
                String nodeLabel;
                String pnLine = nodeLabel = iterator.next();
                pnHeadline = "Node";
                for (String string : clusterValues) {
                    Map<String, Value> statistics = parcoursNetworkStatistics.get(string).get(nodeLabel);
                    for (String statisticsLabel : sequenceCriteria.getNodeStatisticsLabels()) {
                        if (first) {
                            pnHeadline = String.valueOf(pnHeadline) + "\t" + statisticsLabel + " (" + string + ")";
                        }
                        pnLine = statistics != null ? String.valueOf(pnLine) + "\t" + statistics.get(statisticsLabel) : String.valueOf(pnLine) + "\t";
                    }
                }
                if (first) {
                    result.outputs().appendln(pnHeadline);
                    first = false;
                }
                result.outputs().appendln(pnLine);
            }
        }
        logger.debug("Sequence network statistis created for " + sequenceStatistics);
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportDetailsValueSequences(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria, List<String> labels, Map<String, StringList> pajekBuffers) throws PuckException {
        Report result = new Report(title);
        List<String> constantLabels = Arrays.asList("ID", "NAME", "GENDER");
        PartitionCriteriaList valueSequenceCriteriaList = sequenceCriteria.getValueSequenceCriteriaList();
        StringList pajekBuffer = pajekBuffers.get("Referent Networks");
        if (pajekBuffer == null) {
            pajekBuffer = new StringList();
            pajekBuffers.put("Referent Networks", pajekBuffer);
        }
        String headLine = "";
        String dateLine = "";
        for (String constantLabel : constantLabels) {
            headLine = String.valueOf(headLine) + constantLabel + "\t";
            dateLine = String.valueOf(dateLine) + "\t";
        }
        for (String label : labels) {
            headLine = String.valueOf(headLine) + label;
            Integer[] integerArray = sequenceCriteria.getDates();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year = integerArray[n2];
                headLine = String.valueOf(headLine) + "\t";
                dateLine = String.valueOf(dateLine) + year + "\t";
                ++n2;
            }
            if (sequenceStatistics.getPartitionSequence(label) == null || !sequenceStatistics.getPartitionSequence(label).isNumeric().booleanValue()) continue;
            headLine = String.valueOf(headLine) + "\t";
            dateLine = String.valueOf(dateLine) + "TREND\t";
        }
        result.outputs().appendln(headLine);
        result.outputs().appendln(dateLine);
        for (Sequenceable sequence : sequenceStatistics.sequences.toSortedList()) {
            String memberLine = "";
            for (String constantLabel : constantLabels) {
                memberLine = String.valueOf(memberLine) + SequenceValuator.get(sequence, constantLabel) + "\t";
            }
            for (String label : labels) {
                Integer[] integerArray = sequenceCriteria.getDates();
                int n = integerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Integer year = integerArray[n3];
                    Ordinal time = new Ordinal(year);
                    Value value = sequenceStatistics.getValue(sequence, time, label);
                    if (value == null) {
                        memberLine = String.valueOf(memberLine) + "\t";
                    } else if (value.isGraph()) {
                        memberLine = String.valueOf(memberLine) + "\t";
                        pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(value.graphValue(), new ArrayList<String>()));
                        pajekBuffer.appendln();
                    } else {
                        Partition.ValueCode valueCode = null;
                        if (valueSequenceCriteriaList != null && valueSequenceCriteriaList.getByLabel(label) != null) {
                            valueCode = valueSequenceCriteriaList.getByLabel(label).getValueCode();
                        }
                        memberLine = String.valueOf(memberLine) + value.unpack(valueCode) + "\t";
                    }
                    ++n3;
                }
                if (sequenceStatistics.getPartitionSequence(label) == null || !sequenceStatistics.getPartitionSequence(label).isNumeric().booleanValue()) continue;
                memberLine = String.valueOf(memberLine) + sequenceStatistics.getTrend(sequence, label) + "\t";
            }
            result.outputs().appendln(memberLine);
        }
        String endLine = "TOTAL\t";
        for (String constantLabel : constantLabels) {
            endLine = String.valueOf(endLine) + "\t";
        }
        for (String label : labels) {
            for (Ordinal time : Ordinal.getOrdinals(sequenceCriteria.getDates())) {
                Double mean = null;
                Partition<S> partition = sequenceStatistics.getStation(time, label);
                if (partition != null) {
                    mean = partition.valueMeanByItems();
                }
                endLine = mean == null ? String.valueOf(endLine) + "\t" : String.valueOf(endLine) + mean + "\t";
            }
            endLine = String.valueOf(endLine) + sequenceStatistics.getMeanTrend(label) + "\t";
        }
        result.outputs().appendln(endLine);
        logger.debug("Details report (dated) created for " + sequenceStatistics);
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportCensuses(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria) throws PuckException {
        Report result = new Report(title);
        for (PartitionCriteria valueSequenceCriteria : sequenceCriteria.getValueSequenceCriteriaList()) {
            String label = valueSequenceCriteria.getLabel();
            Partition.ValueCode valueCode = valueSequenceCriteria.getValueCode();
            if (!valueSequenceCriteria.isWithCensus()) continue;
            SequenceReporter.reportCensus(result, sequenceStatistics.getPartitionSequence(label), label, valueCode, sequenceCriteria);
            if (sequenceStatistics.getAggregatePartitionSequence(label) == null) continue;
            SequenceReporter.reportCensus(result, sequenceStatistics.getAggregatePartitionSequence(label), String.valueOf(label) + "_TOTAL", null, sequenceCriteria);
        }
        result.outputs().appendln();
        logger.debug("Census report created for " + sequenceStatistics);
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportMatrices(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria, Map<String, StringList> pajekBuffers) throws PuckException {
        Report result = new Report(title);
        StringList pajekBuffer = pajekBuffers.get("Transition Graphs");
        if (pajekBuffer == null) {
            pajekBuffer = new StringList();
            pajekBuffers.put("Transition Graphs", pajekBuffer);
        }
        for (PartitionCriteria valueSequenceCriteria : sequenceCriteria.getValueSequenceCriteriaList()) {
            String label = valueSequenceCriteria.getLabel();
            Partition.ValueCode valueCode = valueSequenceCriteria.getValueCode();
            if (!valueSequenceCriteria.isWithMatrix()) continue;
            if (valueSequenceCriteria.isWithGraph()) {
                SequenceReporter.reportMatrix(result, sequenceStatistics.getPartitionSequence(label), label, valueCode, pajekBuffer, sequenceCriteria);
                continue;
            }
            SequenceReporter.reportMatrix(result, sequenceStatistics.getPartitionSequence(label), label, valueCode, null, sequenceCriteria);
        }
        logger.debug("Graphs and matrices created for " + sequenceStatistics);
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportDetailsSequenceValues(String title, SequenceStatistics<S, E> sequenceStatistics, SequenceCriteria sequenceCriteria, List<String> labels) throws PuckException {
        Report result = new Report(title);
        List<String> constantLabels = Arrays.asList("ID", "NAME", "GENDER");
        PartitionCriteriaList sequenceValueCriteriaList = sequenceCriteria.getSequenceValueCriteriaList();
        String headLine = "";
        for (String constantLabel : constantLabels) {
            headLine = String.valueOf(headLine) + constantLabel + "\t";
        }
        for (String label : labels) {
            if (label.contains("SIMILARITY")) {
                String subLabel = label.substring(label.lastIndexOf("_") + 1);
                headLine = String.valueOf(headLine) + "\tSIMILARITY_PARENT_" + subLabel + "\tSIMILARITY_CHILD_" + subLabel + "\tSIMILARITY_SIBLING_" + subLabel + "\tSIMILARITY_SPOUSE_" + subLabel;
                continue;
            }
            headLine = String.valueOf(headLine) + label + "\t";
        }
        result.outputs().appendln(headLine);
        for (Sequenceable sequence : sequenceStatistics.sequences.toSortedList()) {
            String memberLine = "";
            for (String constantLabel : constantLabels) {
                memberLine = String.valueOf(memberLine) + SequenceValuator.get(sequence, constantLabel) + "\t";
            }
            for (String label : labels) {
                Value value = sequenceStatistics.getValue(sequence, label);
                if (value == null) {
                    memberLine = String.valueOf(memberLine) + "\t";
                    continue;
                }
                if (label.contains("SIMILARITY")) {
                    String[] keys;
                    Map indiSimilaritiesMap = value.mapValue();
                    String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                        if (sim != null) {
                            memberLine = String.valueOf(memberLine) + MathUtils.round(sim[4], 2) + "\t";
                        }
                        ++n2;
                    }
                    System.out.println("SIMILARITY " + memberLine);
                    continue;
                }
                Partition.ValueCode valueCode = null;
                if (sequenceValueCriteriaList != null && sequenceValueCriteriaList.getByLabel(label) != null) {
                    valueCode = sequenceValueCriteriaList.getByLabel(label).getValueCode();
                }
                memberLine = String.valueOf(memberLine) + value.unpack(valueCode) + "\t";
            }
            result.outputs().appendln(memberLine);
        }
        result.outputs().appendln();
        logger.debug("Details report created for " + sequenceStatistics);
        return result;
    }

    private static <S extends Sequenceable<E>, E extends Numberable> Report reportSequenceAnalysis(String title, Segmentation segmentation, Sequenceables<S, E> sequences, SequenceCriteria sequenceCriteria) throws PuckException {
        if (sequences == null || segmentation == null || sequenceCriteria.getRelationModelName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report(String.valueOf(title) + " " + sequenceCriteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Sequence reporter");
        SequenceStatistics<S, E> sequenceStatistics = null;
        ArrayList<String> reportTitles = new ArrayList<String>();
        if (ArrayUtils.isEmpty((Object[])sequenceCriteria.getDates())) {
            sequenceStatistics = new SequenceStatistics<S, E>(segmentation, sequences, sequenceCriteria);
            reportTitles.addAll(Arrays.asList("SURVEY", "DIAGRAMS", "DETAILS"));
        } else {
            sequenceStatistics = new SequenceStatistics<S, E>(segmentation, sequences, sequenceCriteria);
            reportTitles.addAll(Arrays.asList("CENSUS", "DIAGRAMS_DATED", "DETAILS_DATED", "MATRICES", "FLOWS"));
        }
        if (sequenceCriteria.getEgoNetworksOperations().contains((Object)SequenceCriteria.EgoNetworksOperation.COHESION) || sequenceCriteria.getParcoursNetworksOperations().contains((Object)SequenceCriteria.EgoNetworksOperation.COHESION)) {
            reportTitles.add("COMPONENTS");
        }
        if (sequenceCriteria.getTrajectoriesOperations().contains((Object)SequenceCriteria.TrajectoriesOperation.LIST_TREES)) {
            reportTitles.add("TREES");
        }
        Map<String, StringList> pajekBuffers = sequenceStatistics.getPajekBuffers();
        HashMap<String, Report> reports = new HashMap<String, Report>();
        SequenceReporter.createReports(result, reportTitles, reports, segmentation, sequenceStatistics, sequenceCriteria, pajekBuffers, 3);
        SequenceReporter.getRData(result, sequenceStatistics, segmentation, sequenceCriteria);
        for (String bufferTitle : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(bufferTitle);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + bufferTitle), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + bufferTitle + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static void reportDatedCircuitCensus(ReportList reportList, Segmentation segmentation, SequenceCriteria criteria) throws PuckException {
        if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.CIRCUITS)) {
            for (Report report3 : CensusReporter.reportRelationCensus(segmentation, criteria)) {
                reportList.add(report3);
            }
        }
        CensusCriteria censusCriteria = new CensusCriteria();
        censusCriteria.setPattern(criteria.getPattern());
        censusCriteria.setChainClassification(criteria.getChainClassification());
        censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
        Integer[] dates = criteria.getDates();
        if (dates == null) {
            Report report = CensusReporter.reportDifferentialCensus(segmentation, criteria, null, censusCriteria);
            reportList.add(report);
        } else {
            Integer[] integerArray = dates;
            int n = dates.length;
            int n2 = 0;
            while (n2 < n) {
                Integer date = integerArray[n2];
                Report report = CensusReporter.reportDifferentialCensus(segmentation, criteria, date, censusCriteria);
                reportList.add(report);
                ++n2;
            }
        }
    }

    public static ReportList reportSequenceAnalysis(Net net, Segmentation segmentation, SequenceCriteria criteria, ResourceBundle bundle) throws PuckException {
        ReportList result = new ReportList();
        if (criteria != null) {
            criteria.setPartitionCriteria();
            ArrayList<String> reportTitles = new ArrayList<String>();
            if (!criteria.getSequenceGeneralStatistics().isEmpty()) {
                reportTitles.add("General");
            }
            if (!criteria.getEgoNetworksOperations().isEmpty()) {
                reportTitles.add("Ego Networks");
            }
            if (!criteria.getParcoursNetworksOperations().isEmpty()) {
                reportTitles.add("Parcours Networks");
            }
            if (!criteria.getTrajectoriesOperations().isEmpty()) {
                reportTitles.add("Trajectories");
            }
            if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.POPULATION)) {
                reportTitles.add("Population");
            }
            if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.POSITIONS)) {
                reportTitles.add("Referents");
            }
            if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.METRICS)) {
                reportTitles.add("Groups");
            }
            if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.MORPHOLOGY)) {
                reportTitles.add("Group Composition");
            }
            if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.DYNAMICS)) {
                reportTitles.add("Dynamics");
            }
            Sequences sequences = null;
            if (criteria.hasVariableIntervals()) {
                sequences = SequenceWorker.getCoherentItineraries(segmentation, criteria);
            } else {
                sequences = SequenceMaker.createRelationSequences(segmentation, criteria);
                if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.POSITIONS) || !criteria.getEgoNetworksOperations().isEmpty()) {
                    sequences = sequences.getIndividualStateSequences(segmentation, criteria);
                }
            }
            for (String reportTitle : reportTitles) {
                result.add(SequenceReporter.reportSequenceAnalysis(reportTitle, segmentation, sequences, criteria));
            }
            if (!criteria.getSequenceReportTypes().isEmpty()) {
                result.add(SequenceReporter.reportSequences(net, segmentation, criteria));
            }
            if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.CIRCUITS)) {
                SequenceReporter.reportDatedCircuitCensus(result, segmentation, criteria);
            }
        }
        return result;
    }
}

