/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import fr.devinsy.util.StringList;
import java.util.HashMap;
import java.util.Map;
import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.report.Report;

public class HairCutWorker {
    public static Net copyShave(Net net, Report report) {
        Net result = new Net(net);
        HairCutWorker.shave(result, report);
        return result;
    }

    public static int shave(Net source, Report report) {
        int result = 0;
        Map<Individual, Integer> colors = HairCutWorker.getTreeColors(source);
        StringList list = new StringList();
        for (Individual individual : colors.keySet()) {
            if (colors.get(individual) != -1) continue;
            source.remove(individual);
            list.appendln(individual.toString());
            ++result;
        }
        report.outputs().appendln(String.valueOf(result) + " Individuals removed:");
        report.outputs().appendln();
        report.outputs().append(list);
        return result;
    }

    public static Integer getTreeColor(Map<Individual, Integer> colors, Individual ego, Individual root) {
        Integer result = colors.get(ego);
        if (result == null) {
            colors.put(ego, 1);
            int nrOfLinks = 0;
            if (root != null) {
                nrOfLinks = 1;
            }
            KinType[] kinTypeArray = KinType.values();
            int n = kinTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                KinType kinType = kinTypeArray[n2];
                for (Individual relative : ego.getKin(kinType)) {
                    if (relative != root && HairCutWorker.getTreeColor(colors, relative, ego) > -1 && ++nrOfLinks == 2) break;
                }
                if (nrOfLinks == 2) break;
                ++n2;
            }
            if (nrOfLinks < 2) {
                colors.put(ego, -1);
            }
            result = colors.get(ego);
        }
        return result;
    }

    public static int getTreeColorExcludingStructuralChildren(Map<Individual, Integer> colors, Individual ego, Individual root, KinType foo) {
        if (colors.get(ego) != 0) {
            return colors.get(ego);
        }
        colors.put(ego, 1);
        if (ego.isSterile() && ego.isSingle()) {
            colors.put(ego, -1);
            return colors.get(ego);
        }
        int k = 0;
        int h = 0;
        KinType[] kinTypeArray = KinType.values();
        int n = kinTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KinType kinType = kinTypeArray[n2];
            for (Individual v : ego.getKin(kinType)) {
                if (HairCutWorker.getTreeColorExcludingStructuralChildren(colors, v, ego, kinType) != -1) {
                    ++k;
                    if (kinType != KinType.CHILD) {
                        ++h;
                    }
                }
                if (k <= 1 || h <= 0) continue;
                colors.put(ego, 2);
                return colors.get(ego);
            }
            ++n2;
        }
        colors.put(ego, -1);
        return colors.get(ego);
    }

    private static Map<Individual, Integer> getTreeColors(Net net) {
        HashMap<Individual, Integer> result = new HashMap<Individual, Integer>();
        for (Individual v : net.individuals()) {
            HairCutWorker.getTreeColor(result, v, null);
        }
        return result;
    }

    private static Map<Individual, Integer> getTreeColorsExcludingStructuralChildren(Net net) {
        HashMap<Individual, Integer> result = new HashMap<Individual, Integer>();
        for (Individual v : net.individuals()) {
            HairCutWorker.getTreeColorExcludingStructuralChildren(result, v, null, KinType.CHILD);
        }
        return result;
    }
}

