/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles.io;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.net.relations.roles.RoleRelationRules;

public class IOTermsTools {
    private static Logger logger = LoggerFactory.getLogger(IOTermsTools.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;

    private IOTermsTools() {
    }

    public static RoleRelationRules extractRelationRoleRules(Attributes attributes) throws PuckException {
        Attribute rulesField;
        RoleRelationRules result = new RoleRelationRules();
        Attributes rulesFields = attributes.searchByLabel("[Rr][Oo][Ll][Ee][_ ]?[Rr][Ee][Ll][Aa][Tt][Ii][Oo][Nn][_ ]?[Rr][Uu][Ll][Ee][Ss]");
        logger.debug("rulesFields count=[{}]", (Object)rulesFields.size());
        if (!rulesFields.isEmpty() && StringUtils.isNotBlank((CharSequence)(rulesField = rulesFields.toList().get(0)).getValue())) {
            String[] labels;
            String[] stringArray = labels = rulesField.getValue().split("[,;]");
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                if (StringUtils.isNotBlank((CharSequence)label)) {
                    RoleRelationMaker.RoleRelationRule rule = RoleRelationMaker.RoleRelationRule.valueOf(label.trim());
                    logger.debug("rule valueof=[{}]", (Object)rule);
                    if (rule == null) {
                        throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown rule label [" + label + "]", new Object[0]);
                    }
                    result.add(rule);
                }
                ++n2;
            }
        }
        return result;
    }

    public static String extractSelfName(Attributes attributes) {
        Attribute selfNameAttribute;
        Attributes selfNameAttributes = attributes.searchByLabel("[Ss][Ee][Ll][Ff][_ ]?[Nn][Aa][Mm][Ee]");
        String result = selfNameAttributes.isEmpty() ? "[self]" : (StringUtils.isBlank((CharSequence)(selfNameAttribute = selfNameAttributes.toList().get(0)).getValue()) ? "[self]" : selfNameAttribute.getValue());
        return result;
    }

    public static String getBaseName(File source, String extension) {
        if (source == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        if (!source.isFile()) {
            throw new IllegalArgumentException("Parameter is not a file.");
        }
        String fileName = source.getName();
        int extensionStartIndex = fileName.lastIndexOf(extension);
        String result = extensionStartIndex == -1 ? fileName : fileName.substring(0, extensionStartIndex);
        return result;
    }

    public static void readAttributesVertically(Attributes target, BufferedReader in) throws PuckException {
        try {
            in.mark(2048);
            String line = IOTermsTools.readNotEmptyLine(in);
            if (line != null) {
                if (line.split("\\\t").length == 2) {
                    boolean ended = false;
                    while (!ended) {
                        line = in.readLine();
                        if (StringUtils.isBlank((CharSequence)line)) {
                            ended = true;
                            continue;
                        }
                        String[] tokens = line.split("\\\t");
                        String label = tokens[0];
                        String value = tokens[1];
                        if (!StringUtils.isNotBlank((CharSequence)label)) continue;
                        target.put(label, value);
                        logger.debug("add attribute [{}][{}]", (Object)label, (Object)value);
                    }
                } else {
                    in.reset();
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading attribute lines.", new Object[0]);
        }
    }

    public static StringList readLines(BufferedReader in) throws PuckException {
        StringList result = new StringList();
        boolean ended = false;
        while (!ended) {
            String source = IOTermsTools.readNotEmptyLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            result.append(source);
        }
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }

    public static StringList readTermRuleLines(BufferedReader in) throws PuckException {
        StringList result;
        try {
            result = new StringList();
            in.mark(2048);
            String source = IOTermsTools.readNotEmptyLine(in);
            if (source.toUpperCase().startsWith("TERM")) {
                logger.debug("header line detected");
            } else {
                in.reset();
                logger.debug("header line missing (optional)");
            }
            result = IOTermsTools.readLines(in);
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading attribute lines.", new Object[0]);
        }
        return result;
    }
}

