/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleActorComparator;
import org.tip.puck.net.relations.roles.RoleDefinition;
import org.tip.puck.net.relations.roles.RoleRelations;

public class RoleActorPair {
    RoleActor self;
    RoleActor alter;
    Adjustable adjustable;

    RoleActorPair(RoleActor self, RoleActor alter) {
        this.self = self;
        this.alter = alter;
    }

    RoleActorPair(RoleRelations relations, RoleActor alpha, RoleActor beta, Adjustable adjustable) {
        if (alpha != null && beta != null) {
            this.self = alpha.clone();
            this.alter = beta.clone();
            this.adjustable = adjustable;
            if (this.self.getEgoGender().matchs(this.alter.getEgoGender())) {
                this.self = this.self.withCrossness(relations);
                this.alter = this.alter.withCrossness(relations);
                if (this.self != null && this.alter != null) {
                    this.self = this.self.withEgoGender(this.alter.getEgoGender());
                    this.alter = this.alter.withEgoGender(this.self.getEgoGender());
                    this.self = this.self.cloneAs(beta.getRole().invertName()).withAlterGender(relations);
                    this.self = this.self.asSelf(relations);
                    this.alter = this.alter.withAlterGender(relations);
                    this.alter = this.alter.withAge(relations);
                    if (this.alter.isSibling()) {
                        this.alter = this.alter.asSiblingOf(this.self, relations);
                    }
                    if (this.alter.isSpouse() && relations.heteroMarriage()) {
                        this.adjustCouple();
                    }
                }
            } else {
                this.self = null;
                this.alter = null;
            }
        }
    }

    private void adjustCouple() {
        Gender selfGender = this.self.getAlterGender();
        Gender alterGender = this.alter.getAlterGender();
        if (!selfGender.isUnknown() || !alterGender.isUnknown()) {
            if (!selfGender.isUnknown() && (alterGender.isUnknown() || this.adjustable == Adjustable.ALTER)) {
                this.alter = this.alter.withAlterGender(selfGender.invert());
            } else if (!alterGender.isUnknown() && (selfGender.isUnknown() || this.adjustable == Adjustable.SELF)) {
                this.self = this.self.withAlterGender(alterGender.invert());
            } else if (alterGender != selfGender.invert()) {
                this.self = null;
                this.alter = null;
            }
        }
    }

    RoleActorPair reciprocal(RoleRelations relations) {
        RoleActor reciprocal = this.self.cloneAs(this.alter.getRole().invertName());
        reciprocal.setAlterGender(null);
        RoleActorPair result = new RoleActorPair(relations, this.alter, reciprocal, this.adjustable.invert());
        return result;
    }

    boolean isValid() {
        return this.self != null && this.alter != null;
    }

    RoleActor getSelf() {
        return this.self;
    }

    RoleActor getAlter() {
        return this.alter;
    }

    RoleDefinition getRoleDefinition() {
        RoleDefinition result = this.isValid() ? new RoleDefinition(this.self.getIndividual(), this.alter) : null;
        return result;
    }

    RoleDefinition getStandardRoleDefinition(RoleRelations relations) {
        RoleDefinition result = this.isStandardPosition(relations) ? this.getRoleDefinition() : this.reciprocal(relations).getRoleDefinition();
        return result;
    }

    boolean isStandardPosition(RoleRelations relations) {
        boolean result = new RoleActorComparator(relations).compare(this.alter, this.self) >= 0 || this.self.isHiddenCross() || this.self.hasSelfName();
        return result;
    }

    public String toString() {
        return "[" + this.self + " ; " + this.alter + "]";
    }

    Adjustable getAdjustable() {
        return this.adjustable;
    }

    public void setSelf(RoleActor self) {
        this.self = self;
    }

    public void setAlter(RoleActor alter) {
        this.alter = alter;
    }

    static enum Adjustable {
        SELF,
        ALTER,
        NONE;


        Adjustable invert() {
            Adjustable result;
            switch (this) {
                case SELF: {
                    result = ALTER;
                    break;
                }
                case ALTER: {
                    result = SELF;
                    break;
                }
                default: {
                    result = NONE;
                }
            }
            return result;
        }
    }
}

