/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.permutation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.ods.ODSBufferedReader;
import org.tip.puck.io.permutation.PermutationTable;
import org.tip.puck.io.xls.XLSBufferedReader;

public class PermutationFile {
    private static final Logger logger = LoggerFactory.getLogger(PermutationFile.class);
    public static final Pattern LINE_PATTERN = Pattern.compile("(\\d+)\\s*[\\s,;|]\\s*(\\d+)");

    public static PermutationTable load(File file) throws PuckException {
        PermutationTable result;
        if (file == null) {
            result = new PermutationTable();
        } else {
            if (!file.exists()) {
                throw PuckExceptions.FILE_NOT_FOUND.create("File=[" + file + "].", new Object[0]);
            }
            if (!file.isFile()) {
                throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
            }
            if (file.getName().toLowerCase().endsWith(".txt")) {
                result = PermutationFile.loadTXTFile(file);
            } else if (file.getName().toLowerCase().endsWith(".ods")) {
                result = PermutationFile.loadODSFile(file);
            } else if (file.getName().toLowerCase().endsWith(".xls")) {
                result = PermutationFile.loadXLSFile(file);
            } else {
                throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
            }
        }
        return result;
    }

    public static PermutationTable loadODSFile(File file) throws PuckException {
        PermutationTable result;
        ODSBufferedReader in = null;
        try {
            try {
                in = new ODSBufferedReader(file);
                result = PermutationFile.read(in);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw PuckExceptions.IO_ERROR.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((BufferedReader)in).close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static PermutationTable loadTXTFile(File file) throws PuckException {
        PermutationTable result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                result = PermutationFile.read(in);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static PermutationTable loadXLSFile(File file) throws PuckException {
        PermutationTable result;
        XLSBufferedReader in = null;
        try {
            try {
                in = new XLSBufferedReader(file);
                result = PermutationFile.read(in);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((BufferedReader)in).close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static PermutationTable read(BufferedReader in) throws PuckException {
        PermutationTable result;
        try {
            result = new PermutationTable();
            boolean lineCount = false;
            boolean ended = false;
            while (!ended) {
                String line = in.readLine();
                if (StringUtils.isBlank((CharSequence)line)) {
                    ended = true;
                    continue;
                }
                Matcher matcher = LINE_PATTERN.matcher(line);
                if (matcher.find() && matcher.groupCount() == 2) {
                    int source = Integer.parseInt(matcher.group(1));
                    int target = Integer.parseInt(matcher.group(2));
                    result.add(source, target);
                    continue;
                }
                throw PuckExceptions.BAD_FILE_FORMAT.create("Bad line format: [" + line + "]", new Object[0]);
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        logger.debug("Done.");
        return result;
    }
}

