/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.workers;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;

public class NodeValuator<E> {
    public static <E> Values get(Graph<E> source, String label) {
        Values result;
        if (source == null || label == null) {
            result = new Values();
        } else if (label.equals("BETWEENNESS") && source.nodeCount() > 0 && source.getNode(1).getAttributeValue("BETWEENNESS") == null) {
            result = new Values(source.nodeCount());
            double[] betweenness = GraphUtils.betweenness(source);
            int index = 0;
            while (index < source.nodeCount()) {
                result.add(new Value(betweenness[index]));
                ++index;
            }
        } else {
            result = new Values(source.nodeCount());
            for (Node<E> node : source.getNodes().toListSortedById()) {
                result.add(NodeValuator.get(node, label));
            }
        }
        return result;
    }

    public static <E> Value get(Node<E> source, String label) {
        Value result;
        String attributeValue = source.getAttributeValue(label);
        if (attributeValue != null) {
            result = new Value(attributeValue);
        } else {
            EndogenousLabel endogenousLabel;
            try {
                endogenousLabel = EndogenousLabel.valueOf(label.replace(" ", "_"));
            }
            catch (IllegalArgumentException exception) {
                endogenousLabel = null;
            }
            if (endogenousLabel == null) {
                result = null;
            } else {
                switch (endogenousLabel) {
                    case ID: {
                        result = new Value(source.getId());
                        break;
                    }
                    case DEGREE: {
                        result = new Value(source.getDegree());
                        break;
                    }
                    case INDEGREE: {
                        result = new Value(source.getInDegree());
                        break;
                    }
                    case OUTDEGREE: {
                        result = new Value(source.getOutDegree());
                        break;
                    }
                    case EDGEDEGREE: {
                        result = new Value(source.getEdgeDegree());
                        break;
                    }
                    case STRENGTH: {
                        result = new Value(source.getForce());
                        break;
                    }
                    case INSTRENGTH: {
                        result = new Value(source.getInForce());
                        break;
                    }
                    case OUTSTRENGTH: {
                        result = new Value(source.getOutForce());
                        break;
                    }
                    case EDGESTRENGTH: {
                        result = new Value(source.getEdgeForce());
                        break;
                    }
                    case LOOPDEGREE: {
                        result = new Value(source.getLoopDegree());
                        break;
                    }
                    case LOOPSTRENGTH: {
                        result = new Value(source.getLoopForce());
                        break;
                    }
                    case ORIENTATION: {
                        result = new Value(source.getOrientation());
                        break;
                    }
                    case MAXPREDECESSOR: {
                        result = new Value(source.getMaxPredecessors());
                        break;
                    }
                    case MAXSUCCESSOR: {
                        result = new Value(source.getMaxSuccessors());
                        break;
                    }
                    case MAXINWEIGHT: {
                        result = new Value(source.getMaxInWeight());
                        break;
                    }
                    case MAXOUTWEIGHT: {
                        result = new Value(source.getMaxOutWeight());
                        break;
                    }
                    default: {
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    public static List<String> getAttributeLabels() {
        EndogenousLabel[] enumEntries = EndogenousLabel.values();
        ArrayList<String> result = new ArrayList<String>();
        EndogenousLabel[] endogenousLabelArray = enumEntries;
        int n = enumEntries.length;
        int n2 = 0;
        while (n2 < n) {
            EndogenousLabel enumEntry = endogenousLabelArray[n2];
            result.add(enumEntry.name());
            ++n2;
        }
        return result;
    }

    public static List<String> getMatchingLabels(List<String> sourceLabels) {
        ArrayList<String> result;
        if (sourceLabels == null) {
            result = new ArrayList();
        } else {
            result = new ArrayList<String>(sourceLabels);
            result.retainAll(NodeValuator.getAttributeLabels());
        }
        return result;
    }

    public static List<String> getNotMatchingLabels(List<String> sourceLabels) {
        ArrayList<String> result;
        if (sourceLabels == null) {
            result = new ArrayList();
        } else {
            result = new ArrayList<String>(sourceLabels);
            result.removeAll(NodeValuator.getAttributeLabels());
        }
        return result;
    }

    public static enum EndogenousLabel {
        ID,
        LABEL,
        DEGREE,
        INDEGREE,
        OUTDEGREE,
        EDGEDEGREE,
        STRENGTH,
        INSTRENGTH,
        OUTSTRENGTH,
        EDGESTRENGTH,
        LOOPDEGREE,
        LOOPSTRENGTH,
        BETWEENNESS,
        ORIENTATION,
        MAXPREDECESSOR,
        MAXSUCCESSOR,
        MAXINWEIGHT,
        MAXOUTWEIGHT;

    }
}

