/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.random;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.random.DistributionType;
import org.tip.puck.graphs.random.RandomCriteria;
import org.tip.puck.graphs.random.RandomGraphMaker;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.graphs.RandomAllianceNetworkByAgentSimulationVariationsCriteria;
import org.tip.puck.partitions.graphs.RandomAllianceNetworkByRandomDistributionCriteria;
import org.tip.puck.partitions.graphs.VirtualFieldworkVariationsCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportTable;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.ToolBox;

public class RandomGraphReporter {
    private static final Logger logger = LoggerFactory.getLogger(RandomGraphReporter.class);

    public static ReportChart buildChartFromMatrixStatisticsTable(String chartTitle, ReportChart.GraphType chartType, MatrixStatistics[][] source, double initialValue, double intervalFactor, MatrixStatistics.Indicator indicator, MatrixStatistics.Mode mode) {
        ReportChart result = new ReportChart(chartTitle, chartType);
        int iMax = source.length;
        int jMax = source.length == 0 ? 0 : source[0].length;
        double v1 = initialValue;
        int i = 0;
        while (i < iMax) {
            result.setLineTitle(String.valueOf(MathUtils.round(v1, 8)), i);
            result.setHeader(String.valueOf(v1), i);
            int j = 0;
            while (j < jMax) {
                result.setValue(MathUtils.round(source[i][j].get(indicator, mode), 4), i, j);
                ++j;
            }
            v1 *= intervalFactor;
            ++i;
        }
        return result;
    }

    public static ReportChart createDistributionChart(String title, String legend, Map<Double, Double> source) {
        ReportChart result = new ReportChart(title, ReportChart.GraphType.LINES);
        result.setHeadersLegend("Distribution");
        result.setLinesLegend(legend);
        result.setLineTitle(legend, 0);
        Double[] keys = ToolBox.sort(source.keySet());
        int keyIndex = 0;
        while (keyIndex < keys.length) {
            Double key = keys[keyIndex];
            result.setHeader(MathUtils.toString(key), keyIndex);
            result.addValue(key, source.get(key), 0);
            ++keyIndex;
        }
        return result;
    }

    public static ReportTable createDistributionTable(String title, String legend, Map<Double, Double> source) {
        ReportTable result = new ReportTable(2, source.size() + 1);
        result.setTitle(title);
        result.set(0, 0, " ");
        result.set(1, 0, legend);
        Double[] keys = ToolBox.sort(source.keySet());
        int keyIndex = 0;
        while (keyIndex < keys.length) {
            Double key = keys[keyIndex];
            result.set(0, keyIndex + 1, key);
            result.set(1, keyIndex + 1, MathUtils.round(source.get(key), 4));
            ++keyIndex;
        }
        return result;
    }

    public static <E> MatrixStatistics createRandomGraphStatisticsByRandomDistribution(Graph<E> source, int runs) {
        RandomAllianceNetworkByRandomDistributionCriteria criteria = new RandomAllianceNetworkByRandomDistributionCriteria();
        criteria.setNumberOfNodes(source.nodeCount());
        criteria.setNumberOfArcs((int)source.getArcWeightSum());
        criteria.setDistributionType(DistributionType.FREE);
        criteria.setNumberOfRuns(runs);
        MatrixStatistics result = RandomGraphReporter.createRandomGraphStatisticsByRandomDistribution(criteria);
        return result;
    }

    public static <E> MatrixStatistics createRandomGraphStatisticsByRandomDistribution(RandomAllianceNetworkByRandomDistributionCriteria criteria) {
        RandomGraphMaker randomGraphMaker = new RandomGraphMaker(new RandomCriteria());
        List graphs = randomGraphMaker.createRandomGraphsByRandomDistribution(criteria.getDistributionType(), criteria.getNumberOfNodes(), criteria.getNumberOfArcs(), criteria.getPowerFactor(), criteria.getNumberOfRuns());
        MatrixStatistics result = GraphReporter.getMatrixStatistics(graphs);
        return result;
    }

    public static <E> MatrixStatistics createRandomGraphStatisticsByRandomPermutation(Graph<E> source, int runCount) {
        RandomGraphMaker<E> randomGraphMaker = new RandomGraphMaker<E>(new RandomCriteria());
        List graphs = randomGraphMaker.createRandomGraphsByPermutation(source, runCount);
        MatrixStatistics result = GraphReporter.getMatrixStatistics(graphs);
        return result;
    }

    public static <E> MatrixStatistics createRandomGraphStatisticsByReshuffling(Graph<E> source, int runCount) {
        RandomGraphMaker<E> randomGraphMaker = new RandomGraphMaker<E>(new RandomCriteria());
        List graphs = randomGraphMaker.createRandomGraphsByReshuffling(source, runCount);
        MatrixStatistics result = GraphReporter.getMatrixStatistics(graphs);
        return result;
    }

    public static <E> Report reportRandomAllianceNetworkByAgentSimulation(RandomCriteria criteria, MatrixStatistics stats, double[][] probaEvolution) {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Agent-based generated Random Graph.");
        result.setOrigin("RandomGraphMaker.reportStatisticsRandomGraphByAgentSimulation()");
        result.setTarget("Statistics about Random Alliance Network by Agent simulation");
        result.inputs().add("Inertia Pattern", criteria.getInertiaPattern());
        result.inputs().add("Number of Nodes", criteria.getNodeCount());
        result.inputs().add("Maximal Number of Arcs", criteria.getArcWeightSum());
        result.inputs().add("Maximal Number of Runs", criteria.getRunCount());
        result.inputs().add("Probability of Outward Direction", criteria.getOutPreference());
        result.inputs().add("Ego distribution", criteria.getDistributionType().toString());
        result.inputs().add("Show probability evolution", criteria.isShowProbabilityEvolution());
        result.outputs().append(MatrixStatistics.statisticsRandom(stats, null));
        Map<Double, Double> weightsDistribution = MatrixStatistics.getRandomDistribution(MatrixStatistics.DistributionObject.WEIGHTS, null, criteria, 1, criteria.getRunCount());
        result.outputs().appendln("Weights Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln();
        Map<Double, Double> forcesDistribution = MatrixStatistics.getRandomDistribution(MatrixStatistics.DistributionObject.STRENGTHS, null, criteria, 1, criteria.getRunCount());
        result.outputs().appendln("Forces Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln();
        if (criteria.isShowProbabilityEvolution()) {
            result.outputs().appendln("Probability Evolution");
            ReportChart chart = StatisticsReporter.createArrayChart("Probability Evolution", probaEvolution, new String[]{"inertia0", "inertia1", "inertia2"});
            if (chart != null) {
                result.outputs().appendln(chart);
                result.outputs().appendln(chart.createReportTable());
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static <E> Report reportRandomAllianceNetworkByAgentSimulationVariations(RandomAllianceNetworkByAgentSimulationVariationsCriteria criteria) {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Random Graph Variation by agent");
        result.setOrigin("RandomGraphReporter.reportAgentStatistics()");
        result.setTarget("Random Alliance Network Statistics");
        result.inputs().add("Number Of Loops", criteria.isNumberOfLoopsChecked());
        result.inputs().add("Number of circuits", criteria.isNumberOfCircuitsChecked());
        result.inputs().add("Number of triangles", criteria.isNumberOfTrianglesChecked());
        result.inputs().add("Concentration", criteria.isConcentrationChecked());
        result.inputs().add("weight distribution", criteria.isWeightDistributionChecked());
        result.inputs().add("Strength distributionChecked", criteria.isStrengthDistributionChecked());
        result.inputs().add("Number of Nodes", criteria.getNumberOfNodes());
        result.inputs().add("Number of arcs", criteria.getArcWeightSum());
        result.inputs().add("Out preference", criteria.getOutPreference());
        result.inputs().add("Number of runs", criteria.getNumberOfRuns());
        result.inputs().add("Ego Distribution", criteria.getDistributionType().toString());
        result.inputs().add("First variable index", criteria.getFirstVariableIndex());
        result.inputs().add("First variable initial value", criteria.getFirstVariableInitialValue());
        result.inputs().add("First variable interval factor", criteria.getFirstVariableIntervalFactor());
        result.inputs().add("First variable number of steps", criteria.getFirstVariableNumberOfIntervals());
        result.inputs().add("Second variable index", criteria.getSecondVariableIndex());
        result.inputs().add("Second variable initial value", criteria.getSecondVariableInitialValue());
        result.inputs().add("Second variable interval factor", criteria.getSecondVariableIntervalFactor());
        result.inputs().add("Second variable number of steps", criteria.getSecondVariableNumberOfIntervals());
        result.inputs().add("Variation of variable 1", "i" + criteria.getFirstVariableIndex());
        result.inputs().add("Variation of variable 2", "i" + criteria.getSecondVariableIndex());
        if (criteria.isNumberOfLoopsChecked() || criteria.isNumberOfCircuitsChecked() || criteria.isNumberOfTrianglesChecked() || criteria.isConcentrationChecked() || criteria.isSymmetryChecked()) {
            int n1 = 1 + 2 * criteria.getFirstVariableNumberOfIntervals();
            int n2 = 1 + 2 * criteria.getSecondVariableNumberOfIntervals();
            MatrixStatistics[][] statistics = new MatrixStatistics[n1][n2];
            RandomCriteria agentCriteria = new RandomCriteria();
            agentCriteria.setArcWeightSum(criteria.getArcWeightSum());
            agentCriteria.setNodeCount(criteria.getNumberOfNodes());
            agentCriteria.setDistributionType(criteria.getDistributionType());
            agentCriteria.getInertia()[criteria.getFirstVariableIndex()] = criteria.getFirstVariableInitialValue();
            int i = 0;
            while (i < n1) {
                agentCriteria.getInertia()[criteria.getSecondVariableIndex()] = criteria.getSecondVariableInitialValue();
                int j = 0;
                while (j < n2) {
                    System.out.println(String.valueOf(agentCriteria.getInertia()[criteria.getFirstVariableIndex()]) + " " + agentCriteria.getInertia()[criteria.getSecondVariableIndex()]);
                    RandomGraphMaker randomGraphMaker = new RandomGraphMaker(agentCriteria);
                    statistics[i][j] = GraphReporter.getMatrixStatistics(randomGraphMaker.createRandomGraphsByAgentSimulation(criteria.getNumberOfRuns()));
                    agentCriteria.getInertia()[criteria.getSecondVariableIndex()] = agentCriteria.getInertia()[criteria.getSecondVariableIndex()] * (double)criteria.getSecondVariableIntervalFactor();
                    ++j;
                }
                agentCriteria.getInertia()[criteria.getFirstVariableIndex()] = agentCriteria.getInertia()[criteria.getFirstVariableIndex()] * (double)criteria.getFirstVariableIntervalFactor();
                ++i;
            }
            if (criteria.isNumberOfLoopsChecked()) {
                result.outputs().appendln("Number of loops");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Number of loops", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Number of loops", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
            }
            if (criteria.isNumberOfCircuitsChecked()) {
                result.outputs().appendln("Number of circuits");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Number of circuits", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.DUAL_CIRCUITS, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Number of circuits", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.DUAL_CIRCUITS, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
            }
            if (criteria.isNumberOfTrianglesChecked()) {
                result.outputs().appendln("Number of triangles");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Number of triangles", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.TRIANGLES, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Number of triangles", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.TRIANGLES, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
            }
            if (criteria.isConcentrationChecked()) {
                result.outputs().appendln("Concentration Index");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Concentration Index", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Concentration Index", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
            }
            if (criteria.isSymmetryChecked()) {
                result.outputs().appendln("Symmetry Index");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Symmetry Index", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Symmetry Index", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
            }
        }
        if (criteria.isWeightDistributionChecked() || criteria.isStrengthDistributionChecked()) {
            Double value;
            int i;
            ReportTable table;
            Double value2;
            Double key;
            int j;
            Double[] keys;
            ReportChart chart;
            RandomCriteria agentCriteria = new RandomCriteria();
            agentCriteria.setArcWeightSum(criteria.getArcWeightSum());
            agentCriteria.setNodeCount(criteria.getNumberOfNodes());
            agentCriteria.getInertia()[criteria.getFirstVariableIndex()] = criteria.getFirstVariableInitialValue();
            int nrSeries = 11;
            if (criteria.isWeightDistributionChecked()) {
                Map<Double, Double[]> weightDistributions = MatrixStatistics.getRandomDistributions(MatrixStatistics.DistributionObject.WEIGHTS, null, agentCriteria, criteria.getNumberOfRuns(), nrSeries, criteria.getFirstVariableIndex(), criteria.getFirstVariableIntervalFactor());
                result.outputs().appendln("Weight distributions");
                chart = new ReportChart("Weight distributions", ReportChart.GraphType.LINES);
                chart.setLogarithmType(ReportChart.LogarithmType.VERTICAL);
                double v1 = criteria.getFirstVariableInitialValue();
                keys = ToolBox.sort(weightDistributions.keySet());
                int i2 = 0;
                while (i2 < nrSeries) {
                    chart.setLineTitle(String.valueOf(MathUtils.round(v1, 8)), i2);
                    j = 0;
                    while (j < keys.length) {
                        key = keys[j];
                        value2 = weightDistributions.get(key)[i2];
                        if (value2 != null && value2 > 0.0) {
                            chart.addValue(key, value2, i2);
                        }
                        ++j;
                    }
                    v1 *= (double)criteria.getFirstVariableIntervalFactor();
                    ++i2;
                }
                result.outputs().appendln(chart);
                table = new ReportTable(weightDistributions.size() + 1, nrSeries + 1);
                table.set(0, 0, " ");
                Double v = criteria.getFirstVariableInitialValue();
                int i3 = 0;
                while (i3 < nrSeries) {
                    table.set(0, i3 + 1, String.valueOf(v));
                    v = v * (double)criteria.getFirstVariableIntervalFactor();
                    ++i3;
                }
                Double[] keys2 = ToolBox.sort(weightDistributions.keySet());
                int j2 = 0;
                while (j2 < keys2.length) {
                    Double key2 = keys2[j2];
                    table.set(j2 + 1, 0, key2);
                    i = 0;
                    while (i < nrSeries) {
                        value = weightDistributions.get(key2)[i];
                        if (value == null) {
                            table.set(j2 + 1, i + 1, " ");
                        } else {
                            table.set(j2 + 1, i + 1, MathUtils.round(value, 4));
                        }
                        ++i;
                    }
                    ++j2;
                }
                result.outputs().appendln(table);
                result.outputs().appendln();
            }
            if (criteria.isStrengthDistributionChecked()) {
                Map<Double, Double[]> forceDistributions = MatrixStatistics.getRandomDistributions(MatrixStatistics.DistributionObject.STRENGTHS, null, agentCriteria, criteria.getNumberOfRuns(), nrSeries, criteria.getFirstVariableIndex(), criteria.getFirstVariableIntervalFactor());
                result.outputs().appendln("Forces Distributions");
                chart = new ReportChart("Forces Distributions", ReportChart.GraphType.LINES);
                double v1 = criteria.getFirstVariableInitialValue();
                keys = ToolBox.sort(forceDistributions.keySet());
                int i4 = 0;
                while (i4 < nrSeries) {
                    chart.setLineTitle(String.valueOf(MathUtils.round(v1, 8)), i4);
                    j = 0;
                    while (j < keys.length) {
                        key = keys[j];
                        value2 = forceDistributions.get(key)[i4];
                        if (value2 != null && value2 > 0.0) {
                            chart.addValue(key, value2, i4);
                        }
                        ++j;
                    }
                    v1 *= (double)criteria.getFirstVariableIntervalFactor();
                    ++i4;
                }
                result.outputs().appendln(chart);
                table = new ReportTable(forceDistributions.size() + 1, nrSeries + 1);
                table.set(0, 0, " ");
                Double v = criteria.getFirstVariableInitialValue();
                int i5 = 0;
                while (i5 < nrSeries) {
                    table.set(0, i5 + 1, String.valueOf(v));
                    v = v * (double)criteria.getFirstVariableIntervalFactor();
                    ++i5;
                }
                Double[] keys3 = ToolBox.sort(forceDistributions.keySet());
                int j3 = 0;
                while (j3 < keys3.length) {
                    Double key3 = keys3[j3];
                    table.set(j3 + 1, 0, key3);
                    i = 0;
                    while (i < nrSeries) {
                        value = forceDistributions.get(key3)[i];
                        if (value == null) {
                            table.set(j3 + 1, i + 1, " ");
                        } else {
                            table.set(j3 + 1, i + 1, MathUtils.round(value, 4));
                        }
                        ++i;
                    }
                    ++j3;
                }
                result.outputs().appendln(table);
                result.outputs().appendln();
            }
            result.inputs().add("Number of Nodes", criteria.getNumberOfNodes());
            result.inputs().add("Number of Arcs", criteria.getArcWeightSum());
            result.inputs().add("Variation of variable", "i" + criteria.getFirstVariableIndex());
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static <E> Report reportRandomAllianceNetworkByRandomDistribution(RandomAllianceNetworkByRandomDistributionCriteria criteria, MatrixStatistics source) {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Random Distibution generated Random Graph.");
        result.setOrigin("RandomGraphMaker.reportRandomAllianceNetworkByRandomDistribution()");
        result.setTarget("Statistics about Random Alliance Network by Random Distribution");
        result.inputs().add("Number of nodes", criteria.getNumberOfNodes());
        result.inputs().add("Number of arcs", criteria.getNumberOfArcs());
        result.inputs().add("Distribution type", criteria.getDistributionType().toString());
        result.inputs().add("Power factor", criteria.getPowerFactor());
        result.inputs().add("Number of runs", criteria.getNumberOfRuns());
        result.inputs().add("Extract representative", criteria.isExtractRepresentative());
        result.outputs().append(MatrixStatistics.statisticsRandom(source, null));
        Map<Double, Double> weightsDistribution = MatrixStatistics.getDistribution(MatrixStatistics.DistributionObject.WEIGHTS, source.getGraph());
        result.outputs().appendln("Weights Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln();
        Map<Double, Double> forcesDistribution = MatrixStatistics.getDistribution(MatrixStatistics.DistributionObject.STRENGTHS, source.getGraph());
        result.outputs().appendln("Forces Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static <E> Report reportRandomAllianceNetworkByRandomPermutation(int runCount, MatrixStatistics randStats, MatrixStatistics sourceStats) {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Random Distibution generated Random Permutation.");
        result.setOrigin("RandomGraphMaker.reportRandomAllianceNetworkByRandomPermutation()");
        result.setTarget("Statistics about Random Alliance Network by Random Permutation");
        result.inputs().add("Number of runs", runCount);
        result.outputs().append(MatrixStatistics.statisticsRandom(randStats, sourceStats));
        Map<Double, Double> weightsDistribution = MatrixStatistics.getDistribution(MatrixStatistics.DistributionObject.WEIGHTS, randStats.getGraph());
        result.outputs().appendln("Weights Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln();
        Map<Double, Double> forcesDistribution = MatrixStatistics.getDistribution(MatrixStatistics.DistributionObject.STRENGTHS, randStats.getGraph());
        result.outputs().appendln("Forces Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static <E> Report reportRandomAllianceNetworkByReshuffling(int runCount, MatrixStatistics randStats, MatrixStatistics sourceStats) {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Random Distibution generated Reshuffling");
        result.setOrigin("RandomGraphMaker.reportRandomAllianceNetworkByReshuffling()");
        result.setTarget("Statistics about Random Alliance Network by Reshuffling");
        result.inputs().add("Number of runs", runCount);
        result.outputs().append(MatrixStatistics.statisticsRandom(randStats, sourceStats));
        Map<Double, Double> weightsDistribution = MatrixStatistics.getDistribution(MatrixStatistics.DistributionObject.WEIGHTS, randStats.getGraph());
        result.outputs().appendln("Weights Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln();
        Map<Double, Double> forcesDistribution = MatrixStatistics.getDistribution(MatrixStatistics.DistributionObject.STRENGTHS, randStats.getGraph());
        result.outputs().appendln("Forces Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static <E> Report reportVirtualFieldwork(RandomCriteria criteria, MatrixStatistics randStats, MatrixStatistics sourceStats, double[][] probaEvolution) {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Observer-based generated Random Graph.");
        result.setOrigin("RandomGraphMaker.reportStatisticsRandomGraphByObserverSimulation()");
        result.setTarget("Statistics about Random Alliance Network by Observer simulation");
        result.inputs().add("Inertia Pattern", criteria.getInertiaPattern());
        result.inputs().add("Number of Nodes", criteria.getNodeCount());
        result.inputs().add("Maximal Number of Arcs", criteria.getArcWeightSum());
        result.inputs().add("Maximal Number of Runs", criteria.getRunCount());
        result.inputs().add("Probability of Outward Direction", criteria.getOutPreference());
        result.inputs().add("Show probability evolution", criteria.isShowProbabilityEvolution());
        result.outputs().append(MatrixStatistics.statisticsRandom(randStats, sourceStats));
        if (criteria.isShowProbabilityEvolution()) {
            result.outputs().appendln("Probability Evolution");
            ReportChart chart = StatisticsReporter.createArrayChart("Probability Evolution", probaEvolution, new String[]{"inertia0", "inertia1", "inertia2"});
            if (chart != null) {
                result.outputs().appendln(chart);
                result.outputs().appendln(chart.createReportTable());
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static <E> Report reportVirtualFieldworkVariations(Graph<Cluster<Individual>> source, VirtualFieldworkVariationsCriteria criteria) {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Random Graph Variation by observer");
        result.setOrigin("RandomGraphReporter.reportObserverStatistics()");
        result.setTarget(source.getLabel());
        result.inputs().add("Number Of Loops", criteria.isNumberOfLoopsChecked());
        result.inputs().add("Number of circuits", criteria.isNumberOfCircuitsChecked());
        result.inputs().add("Number of triangles", criteria.isNumberOfTrianglesChecked());
        result.inputs().add("Concentration", criteria.isConcentrationChecked());
        result.inputs().add("weight distribution", criteria.isWeightDistributionChecked());
        result.inputs().add("Strength distributionChecked", criteria.isStrengthDistributionChecked());
        criteria.nominalizeValues(source.nodeCount(), source.getArcWeightSum());
        result.inputs().add("Fraction of Nodes", criteria.getFractionOfNodes());
        result.inputs().add("Number of Nodes", criteria.getFractionOfNodes());
        result.inputs().add("Fraction of arc weights", criteria.getArcWeightFraction());
        result.inputs().add("Sum of arc weights", criteria.getArcWeightSum());
        result.inputs().add("Out preference", criteria.getOutPreference());
        result.inputs().add("Number of runs", criteria.getNumberOfRuns());
        result.inputs().add("First variable index", criteria.getFirstVariableIndex());
        result.inputs().add("First variable initial value", criteria.getFirstVariableInitialValue());
        result.inputs().add("First variable interval factor", criteria.getFirstVariableIntervalFactor());
        result.inputs().add("Second variable index", criteria.getSecondVariableIndex());
        result.inputs().add("Second variable initial value", criteria.getSecondVariableInitialValue());
        result.inputs().add("Second variable interval factor", criteria.getSecondVariableIntervalFactor());
        result.inputs().add("Variation of variable 1", "i" + criteria.getFirstVariableIndex());
        result.inputs().add("Variation of variable 2", "i" + criteria.getSecondVariableIndex());
        if (criteria.isNumberOfLoopsChecked() || criteria.isNumberOfCircuitsChecked() || criteria.isNumberOfTrianglesChecked() || criteria.isConcentrationChecked() || criteria.isSymmetryChecked()) {
            ReportTable table1;
            ReportChart chart1;
            ReportTable table1a;
            ReportChart chart1a;
            MatrixStatistics sourceStatistics = GraphReporter.getMatrixStatistics(source);
            int n1 = 1 + criteria.getFirstVariableNumberOfIntervals() * 2;
            int n2 = 1 + criteria.getSecondVariableNumberOfIntervals() * 2;
            MatrixStatistics[][] statistics = new MatrixStatistics[n1][n2];
            RandomCriteria observerCriteria = new RandomCriteria();
            observerCriteria.setArcWeightSum(criteria.getArcWeightSum());
            observerCriteria.setNodeCount(criteria.getNumberOfNodes());
            observerCriteria.getInertia()[criteria.getFirstVariableIndex()] = criteria.getFirstVariableInitialValue();
            observerCriteria.getInertia()[criteria.getSecondVariableIndex()] = criteria.getSecondVariableInitialValue();
            int i = 0;
            while (i < n1) {
                int j = 0;
                while (j < n2) {
                    System.out.println(String.valueOf(observerCriteria.getInertia()[criteria.getFirstVariableIndex()]) + " " + observerCriteria.getInertia()[criteria.getSecondVariableIndex()]);
                    RandomGraphMaker<Cluster<Individual>> observerRandomGraphMaker = new RandomGraphMaker<Cluster<Individual>>(observerCriteria);
                    statistics[i][j] = GraphReporter.getMatrixStatistics(observerRandomGraphMaker.createRandomGraphsByObserverSimulation(source, criteria.getNumberOfRuns()));
                    statistics[i][j].compareValues(sourceStatistics);
                    observerCriteria.getInertia()[criteria.getSecondVariableIndex()] = observerCriteria.getInertia()[criteria.getSecondVariableIndex()] * (double)criteria.getSecondVariableIntervalFactor();
                    ++j;
                }
                observerCriteria.getInertia()[criteria.getFirstVariableIndex()] = observerCriteria.getInertia()[criteria.getFirstVariableIndex()] * (double)criteria.getFirstVariableIntervalFactor();
                observerCriteria.getInertia()[criteria.getSecondVariableIndex()] = criteria.getSecondVariableInitialValue();
                ++i;
            }
            System.out.println("arcs: " + criteria.getArcWeightSum() + "\tnodes:" + criteria.getNumberOfNodes());
            if (criteria.isNumberOfLoopsChecked()) {
                result.outputs().appendln("Loop Overestimation");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Loop Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Loop Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
                result.outputs().appendln("Expected Loops Overestimation");
                chart1a = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Expected Loops Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.OVERESTIMATION_EXPECTED);
                result.outputs().append(chart1a);
                chart1a = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Expected Loops Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.OVERESTIMATION_EXPECTED);
                result.outputs().append(chart1a);
                table1a = chart1a.createReportTable();
                table1a.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table1a);
                result.outputs().appendln("Loop Divergence Overestimation");
                chart1 = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Loop Divergence Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.OVERESTIMATION_DIVERGENCE);
                result.outputs().append(chart1);
                chart1 = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Loop Divergence Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.OVERESTIMATION_DIVERGENCE);
                result.outputs().append(chart1);
                table1 = chart1.createReportTable();
                table1.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table1);
            }
            if (criteria.isNumberOfCircuitsChecked()) {
                result.outputs().appendln("Circuit Overestimation");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Circuit Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.DUAL_CIRCUITS, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Circuit Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.DUAL_CIRCUITS, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
                result.outputs().appendln("Expected Circuits Overestimation");
                chart1a = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Expected Circuits Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.DUAL_CIRCUITS, MatrixStatistics.Mode.OVERESTIMATION_EXPECTED);
                result.outputs().append(chart1a);
                chart1a = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Expected Circuits Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.DUAL_CIRCUITS, MatrixStatistics.Mode.OVERESTIMATION_EXPECTED);
                result.outputs().append(chart1a);
                table1a = chart1a.createReportTable();
                table1a.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table1a);
                result.outputs().appendln("Circuit Divergence Overestimation");
                chart1 = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Circuit Divergence Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.DUAL_CIRCUITS, MatrixStatistics.Mode.OVERESTIMATION_DIVERGENCE);
                result.outputs().append(chart1);
                chart1 = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Circuit Divergence Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.DUAL_CIRCUITS, MatrixStatistics.Mode.OVERESTIMATION_DIVERGENCE);
                result.outputs().append(chart1);
                table1 = chart1.createReportTable();
                table1.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table1);
            }
            if (criteria.isNumberOfTrianglesChecked()) {
                result.outputs().appendln("Triangle Overestimation");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Triangle Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.TRIANGLES, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Triangle Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.TRIANGLES, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
            }
            if (criteria.isConcentrationChecked()) {
                result.outputs().appendln("Concentration Overestimation");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Concentration Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Concentration Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
                result.outputs().appendln("Expected Concentration Overestimation");
                chart1a = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Expected Concentration Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.OVERESTIMATION_EXPECTED);
                result.outputs().append(chart1a);
                chart1a = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Expected Concentration Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.OVERESTIMATION_EXPECTED);
                result.outputs().append(chart1a);
                table1a = chart1a.createReportTable();
                table1a.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table1a);
                result.outputs().appendln("Concentration Divergence Overestimation");
                chart1 = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Concentration Divergence Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.OVERESTIMATION_DIVERGENCE);
                result.outputs().append(chart1);
                chart1 = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Concentration Divergence Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.OVERESTIMATION_DIVERGENCE);
                result.outputs().append(chart1);
                table1 = chart1.createReportTable();
                table1.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table1);
            }
            if (criteria.isSymmetryChecked()) {
                result.outputs().appendln("Symmetry Overestimation");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Symmetry Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Symmetry Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
                result.outputs().appendln("Symmetry Divergence Overestimation");
                ReportChart chart12 = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Symmetry Divergence Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.OVERESTIMATION_DIVERGENCE);
                result.outputs().append(chart12);
                chart12 = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Symmetry Divergence Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.OVERESTIMATION_DIVERGENCE);
                result.outputs().append(chart12);
                ReportTable table12 = chart12.createReportTable();
                table12.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table12);
            }
            if (criteria.isStrengthConcentrationChecked()) {
                result.outputs().appendln("Strength Concentration Overestimation");
                ReportChart chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Strength Concentration Overestimation", ReportChart.GraphType.SURFACE, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.STRENGTH_CONCENTRATION, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                chart = RandomGraphReporter.buildChartFromMatrixStatisticsTable("Strength Concentration Overestimation", ReportChart.GraphType.LINES, statistics, criteria.getFirstVariableInitialValue(), criteria.getFirstVariableIntervalFactor(), MatrixStatistics.Indicator.STRENGTH_CONCENTRATION, MatrixStatistics.Mode.OVERESTIMATION);
                result.outputs().append(chart);
                ReportTable table = chart.createReportTable();
                table.set(0, 0, "i" + criteria.getFirstVariableIndex() + "/i" + criteria.getSecondVariableIndex());
                result.outputs().appendln(table);
            }
        }
        if (criteria.isWeightDistributionChecked() || criteria.isStrengthDistributionChecked()) {
            Double value;
            ReportTable table;
            Double value2;
            Double key;
            ReportChart chart;
            int nrSeries = 12;
            if (criteria.isWeightDistributionChecked()) {
                RandomCriteria observerCriteria = new RandomCriteria();
                observerCriteria.setArcWeightSum(criteria.getArcWeightSum());
                observerCriteria.setNodeCount(criteria.getNumberOfNodes());
                observerCriteria.getInertia()[criteria.getFirstVariableIndex()] = criteria.getFirstVariableInitialValue();
                Map<Double, Double[]> weightDistributions = MatrixStatistics.getRandomDistributions(MatrixStatistics.DistributionObject.WEIGHTS, source, observerCriteria, criteria.getNumberOfRuns(), nrSeries, criteria.getFirstVariableIndex(), criteria.getFirstVariableIntervalFactor());
                result.outputs().appendln("Weight distributions");
                chart = new ReportChart("Weight distributions", ReportChart.GraphType.LINES);
                chart.setLogarithmType(ReportChart.LogarithmType.VERTICAL);
                double v1 = criteria.getFirstVariableInitialValue();
                Double[] keys = ToolBox.sort(weightDistributions.keySet());
                int i = 0;
                while (i < nrSeries) {
                    if (i == 0) {
                        chart.setLineTitle("Orig.", i);
                    } else {
                        chart.setLineTitle(String.valueOf(MathUtils.round(v1, 8)), i);
                    }
                    int j = 0;
                    while (j < keys.length) {
                        key = keys[j];
                        value2 = weightDistributions.get(key)[i];
                        if (value2 != null && value2 > 0.0) {
                            chart.addValue(key, value2, i);
                        }
                        ++j;
                    }
                    v1 *= (double)criteria.getFirstVariableIntervalFactor();
                    ++i;
                }
                result.outputs().appendln(chart);
                table = new ReportTable(weightDistributions.size() + 1, nrSeries + 2);
                table.set(0, 0, " ");
                table.set(0, 1, "Orig.");
                Double v = criteria.getFirstVariableInitialValue();
                int i2 = 1;
                while (i2 < nrSeries) {
                    table.set(0, i2 + 2, String.valueOf(MathUtils.round(v, 8)));
                    v = v * (double)criteria.getFirstVariableIntervalFactor();
                    ++i2;
                }
                Double[] keys2 = ToolBox.sort(weightDistributions.keySet());
                int j = 0;
                while (j < keys2.length) {
                    Double key2 = keys2[j];
                    table.set(j + 1, 0, key2);
                    int i3 = 0;
                    while (i3 < nrSeries) {
                        value = weightDistributions.get(key2)[i3];
                        if (value == null) {
                            table.set(j + 1, i3 + 1, " ");
                        } else {
                            table.set(j + 1, i3 + 1, MathUtils.round(value, 4));
                        }
                        ++i3;
                    }
                    ++j;
                }
                result.outputs().appendln(table);
                result.outputs().appendln();
            }
            if (criteria.isStrengthDistributionChecked()) {
                RandomCriteria observerCriteria = new RandomCriteria();
                observerCriteria.setArcWeightSum(criteria.getArcWeightSum());
                observerCriteria.setNodeCount(criteria.getNumberOfNodes());
                observerCriteria.getInertia()[criteria.getFirstVariableIndex()] = criteria.getFirstVariableInitialValue();
                Map<Double, Double[]> strengthDistributions = MatrixStatistics.getRandomDistributions(MatrixStatistics.DistributionObject.STRENGTHS, source, observerCriteria, criteria.getNumberOfRuns(), nrSeries, criteria.getFirstVariableIndex(), criteria.getFirstVariableIntervalFactor());
                result.outputs().appendln("Force distributions");
                chart = new ReportChart("Force distributions", ReportChart.GraphType.LINES);
                double v1 = criteria.getFirstVariableInitialValue();
                Double[] keys = ToolBox.sort(strengthDistributions.keySet());
                int i = 0;
                while (i < nrSeries) {
                    if (i == 0) {
                        chart.setLineTitle("Orig.", i);
                    } else {
                        chart.setLineTitle(String.valueOf(MathUtils.round(v1, 8)), i);
                    }
                    int j = 0;
                    while (j < keys.length) {
                        key = keys[j];
                        value2 = strengthDistributions.get(key)[i];
                        if (value2 != null && value2 > 0.0) {
                            chart.addValue(key, value2, i);
                        }
                        ++j;
                    }
                    v1 *= (double)criteria.getFirstVariableIntervalFactor();
                    ++i;
                }
                result.outputs().appendln(chart);
                table = new ReportTable(strengthDistributions.size() + 1, nrSeries + 2);
                table.set(0, 0, " ");
                table.set(0, 1, "Orig.");
                Double v = criteria.getFirstVariableInitialValue();
                int i4 = 1;
                while (i4 < nrSeries) {
                    table.set(0, i4 + 2, String.valueOf(MathUtils.round(v, 8)));
                    v = v * (double)criteria.getFirstVariableIntervalFactor();
                    ++i4;
                }
                Double[] keys3 = ToolBox.sort(strengthDistributions.keySet());
                int j = 0;
                while (j < keys3.length) {
                    Double key3 = keys3[j];
                    table.set(j + 1, 0, key3);
                    int i5 = 0;
                    while (i5 < nrSeries) {
                        value = strengthDistributions.get(key3)[i5];
                        if (value == null) {
                            table.set(j + 1, i5 + 1, " ");
                        } else {
                            table.set(j + 1, i5 + 1, MathUtils.round(value, 4));
                        }
                        ++i5;
                    }
                    ++j;
                }
                result.outputs().appendln(table);
                result.outputs().appendln();
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

