/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.evo;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.tip.puck.evo.GPTree;
import org.tip.puck.util.RandomGenerator;

public class ProgSet {
    public int progcount;
    public GPTree[] progs;
    public Vector<String> prognames;
    public Vector<Vector<Integer>> funsets;
    public Vector<Integer> varcounts;
    private Vector<String> variableNames;
    private Map<String, Integer> variableIndices;

    public ProgSet(int progcount, Vector<String> variableNames) {
        this.progcount = progcount;
        this.variableNames = variableNames;
        this.variableIndices = new HashMap<String, Integer>();
        int i = 0;
        while (i < variableNames.size()) {
            this.variableIndices.put(variableNames.get(i), i);
            ++i;
        }
        this.prognames = new Vector();
        this.funsets = new Vector();
        this.varcounts = new Vector();
        this.progs = new GPTree[progcount];
        i = 0;
        while (i < progcount) {
            this.progs[i] = null;
            this.prognames.add("?");
            this.funsets.add(null);
            this.varcounts.add(0);
            ++i;
        }
    }

    public void init() {
        int i = 0;
        while (i < this.progcount) {
            this.progs[i] = new GPTree(this.varcounts.get(i), this.funsets.get(i));
            ++i;
        }
    }

    public void initRandom() {
        this.init();
        double termProb = 0.4;
        int mdl = 2;
        int mdh = 5;
        int i = 0;
        while (i < this.progcount) {
            this.progs[i].initRandom(termProb, mdl, mdh);
            ++i;
        }
    }

    public ProgSet recombine(ProgSet parent2) {
        ProgSet ps = this.clone(false);
        int rprog = RandomGenerator.instance().random.nextInt(this.progcount);
        int i = 0;
        while (i < this.progcount) {
            ps.progs[i] = i == rprog ? this.progs[i].recombine(parent2.progs[i]) : this.progs[i].clone();
            ++i;
        }
        return ps;
    }

    public ProgSet clone(boolean clone_progs) {
        ProgSet ps = new ProgSet(this.progcount, this.variableNames);
        int i = 0;
        while (i < this.progcount) {
            ps.prognames.set(i, this.prognames.get(i));
            ps.funsets.set(i, this.funsets.get(i));
            ps.varcounts.set(i, this.varcounts.get(i));
            ++i;
        }
        if (clone_progs) {
            i = 0;
            while (i < this.progcount) {
                ps.progs[i] = this.progs[i].clone();
                ++i;
            }
        }
        return ps;
    }

    public int size() {
        int psize = 0;
        int i = 0;
        while (i < this.progcount) {
            psize += this.progs[i].size();
            ++i;
        }
        return psize;
    }

    public void write(OutputStreamWriter out, boolean evalStats) throws IOException {
        int i = 0;
        while (i < this.progcount) {
            out.write("# " + this.prognames.get(i));
            this.progs[i].write(out, this, evalStats);
            out.write("\n\n");
            ++i;
        }
    }

    public void write(String filePath) {
        try {
            FileOutputStream fstream = new FileOutputStream(filePath);
            OutputStreamWriter out = new OutputStreamWriter(fstream);
            this.write(out, false);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print(boolean evalStats) {
        try {
            this.write(new OutputStreamWriter(System.out), evalStats);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void load(String filePath) throws IOException {
        this.init();
        fstream = new FileInputStream(filePath);
        in = new DataInputStream(fstream);
        br = new BufferedReader(new InputStreamReader(in));
        line = br.readLine();
        i = 0;
        ** GOTO lbl19
        {
            line = br.readLine();
            do {
                if (line.equals("") || line.charAt(0) == '\n' || line.charAt(0) == '#') continue block0;
                prog = "";
                while (!line.equals("") && line.charAt(0) != '\n' && line.charAt(0) != '#') {
                    prog = String.valueOf(prog) + line;
                    line = br.readLine();
                }
                this.progs[i].parse(prog, this);
                in.close();
                ++i;
lbl19:
                // 2 sources

            } while (i < this.progcount);
        }
    }

    public void clearBranching() {
        int i = 0;
        while (i < this.progcount) {
            this.progs[i].clearBranching();
            ++i;
        }
    }

    public boolean compareBranching(ProgSet ps) {
        int i = 0;
        while (i < this.progcount) {
            if (this.progs[i].branchingDistance(ps.progs[i]) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void clearEvalStats() {
        int i = 0;
        while (i < this.progcount) {
            this.progs[i].clearEvalStats();
            ++i;
        }
    }

    public void dynPruning() {
        int i = 0;
        while (i < this.progcount) {
            this.progs[i].dynPruning();
            ++i;
        }
    }

    public int branchingDistance(ProgSet ps) {
        int distance = 0;
        int i = 0;
        while (i < this.progcount) {
            if (this.progs[i].branchingDistance(ps.progs[i]) != 0) {
                ++distance;
            }
            ++i;
        }
        return distance;
    }

    public Vector<String> getVariableNames() {
        return this.variableNames;
    }

    public Map<String, Integer> getVariableIndices() {
        return this.variableIndices;
    }
}

