/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.alliancenets;

import org.tip.puck.alliancenets.Alliance;
import org.tip.puck.alliancenets.AllianceNet;
import org.tip.puck.alliancenets.AllianceNetFile;

public class TopologicalIndices {
    private double[][] matrix;
    private double[][] matrixExo;
    private int m;
    private double n;
    private double nExo;
    private double endogamousPercentage;
    private double networkConcentration;
    private double endogamicNetworkConcentration;
    private double networkSymmetry;
    private double parallels;
    private double crosses;
    private double loopTri;
    private double tranTri;

    public TopologicalIndices(AllianceNet allianceNet) {
        int j;
        this.m = allianceNet.getNodeCount();
        this.n = 0.0;
        this.nExo = 0.0;
        this.matrix = new double[this.m][this.m];
        this.matrixExo = new double[this.m][this.m];
        int i = 0;
        while (i < this.m) {
            j = 0;
            while (j < this.m) {
                Alliance alliance = allianceNet.getEdge(allianceNet.getNodes().get(i), allianceNet.getNodes().get(j));
                double x = 0.0;
                if (alliance != null) {
                    x = alliance.getWeight();
                    this.n += x;
                    if (i != j) {
                        this.nExo += x;
                    }
                }
                this.matrix[i][j] = x;
                if (i != j) {
                    this.matrixExo[i][j] = x;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m) {
            j = 0;
            while (j < this.m) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] / this.n;
                double[] dArray2 = this.matrixExo[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] / this.nExo;
            }
            ++i;
        }
        this.calcEndogamousPercentage();
        this.calcNetworkConcentration();
        this.calcEndogamicNetworkConcentration();
        this.calcNetworkSymmetry();
        this.calcParallelsAndCrosses(allianceNet);
        this.calcTriadicCounts();
        this.matrix = null;
    }

    private void calcEndogamousPercentage() {
        this.endogamousPercentage = 0.0;
        int i = 0;
        while (i < this.m) {
            this.endogamousPercentage += this.matrix[i][i];
            ++i;
        }
    }

    private void calcNetworkConcentration() {
        this.networkConcentration = 0.0;
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.m) {
                this.networkConcentration += this.matrix[i][j] * this.matrix[i][j];
                ++j;
            }
            ++i;
        }
    }

    private void calcEndogamicNetworkConcentration() {
        this.endogamicNetworkConcentration = 0.0;
        if (this.endogamousPercentage == 0.0) {
            return;
        }
        double endogamicN = this.endogamousPercentage;
        int i = 0;
        while (i < this.m) {
            double x = this.matrix[i][i] / endogamicN;
            this.endogamicNetworkConcentration += x * x;
            ++i;
        }
    }

    private void calcNetworkSymmetry() {
        this.networkSymmetry = 0.0;
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.m) {
                this.networkSymmetry += this.matrix[i][j] * this.matrix[j][i];
                ++j;
            }
            ++i;
        }
        this.networkSymmetry /= this.networkConcentration;
    }

    private void calcTriadicCounts() {
        int j;
        double[][] matrix2 = new double[this.m][this.m];
        int i = 0;
        while (i < this.m) {
            j = 0;
            while (j < this.m) {
                matrix2[i][j] = 0.0;
                int k = 0;
                while (k < this.m) {
                    double[] dArray = matrix2[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.matrixExo[i][k] * this.matrixExo[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.loopTri = 0.0;
        i = 0;
        while (i < this.m) {
            j = 0;
            while (j < this.m) {
                this.loopTri += this.matrixExo[j][i] * matrix2[i][j];
                ++j;
            }
            ++i;
        }
        this.loopTri *= this.nExo * this.nExo * this.nExo;
        this.loopTri /= 3.0;
        this.tranTri = 0.0;
        i = 0;
        while (i < this.m) {
            j = 0;
            while (j < this.m) {
                this.tranTri += this.matrixExo[i][j] * matrix2[i][j];
                ++j;
            }
            ++i;
        }
        this.tranTri *= this.nExo * this.nExo * this.nExo;
        this.tranTri /= 3.0;
    }

    private void calcParallelsAndCrosses(AllianceNet allianceNet) {
        this.parallels = 0.0;
        this.crosses = 0.0;
        for (Alliance alliance : allianceNet.getEdges()) {
            double w2;
            if (alliance.getWeight() > 1.0) {
                this.parallels += alliance.getWeight();
            }
            if (!allianceNet.edgeExists(alliance.getTarget(), alliance.getOrigin())) continue;
            double w1 = alliance.getWeight();
            if (w1 > (w2 = allianceNet.getInverseEdge(alliance).getWeight())) {
                this.crosses += w2;
                continue;
            }
            this.crosses += w1;
        }
    }

    public double distance(TopologicalIndices ti) {
        double small1 = 1.0E-4;
        double small2 = 1.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double r3 = 0.0;
        double r4 = 0.0;
        double r5 = 0.0;
        double r6 = 0.0;
        double r7 = 0.0;
        double r8 = 0.0;
        r1 = this.endogamousPercentage > 0.0 && ti.getEndogamousPercentage() > 0.0 ? Math.abs(Math.log(this.endogamousPercentage / ti.getEndogamousPercentage())) : Math.abs(Math.log((this.endogamousPercentage + small1) / (ti.getEndogamousPercentage() + small1)));
        if (this.networkConcentration > 0.0 && ti.getNetworkConcentration() > 0.0) {
            r2 = Math.abs(Math.log(this.networkConcentration / ti.getNetworkConcentration()));
        } else {
            r1 = Math.abs(Math.log((this.networkConcentration + small1) / (ti.getNetworkConcentration() + small1)));
        }
        if (this.endogamicNetworkConcentration > 0.0 && ti.getEndogamicNetworkConcentration() > 0.0) {
            r3 = Math.abs(Math.log(this.endogamicNetworkConcentration / ti.getEndogamicNetworkConcentration()));
        } else {
            r1 = Math.abs(Math.log((this.endogamicNetworkConcentration + small1) / (ti.getEndogamicNetworkConcentration() + small1)));
        }
        if (this.networkSymmetry > 0.0 && ti.getNetworkSymmetry() > 0.0) {
            r4 = Math.abs(Math.log(this.networkSymmetry / ti.getNetworkSymmetry()));
        } else {
            r1 = Math.abs(Math.log((this.networkSymmetry + small1) / (ti.getNetworkSymmetry() + small1)));
        }
        if (this.parallels > 0.0 && ti.getParallels() > 0.0) {
            r5 = Math.abs(Math.log(this.parallels / ti.getParallels()));
        } else {
            r1 = Math.abs(Math.log((this.parallels + small2) / (ti.getParallels() + small2)));
        }
        if (this.crosses > 0.0 && ti.getCrosses() > 0.0) {
            r6 = Math.abs(Math.log(this.crosses / ti.getCrosses()));
        } else {
            r1 = Math.abs(Math.log((this.crosses + small2) / (ti.getCrosses() + small2)));
        }
        if (this.loopTri > 0.0 && ti.getLoopTri() > 0.0) {
            r7 = Math.abs(Math.log(this.loopTri / ti.getLoopTri()));
        } else {
            r1 = Math.abs(Math.log((this.loopTri + small2) / (ti.getLoopTri() + small2)));
        }
        if (this.tranTri > 0.0 && ti.getTranTri() > 0.0) {
            r8 = Math.abs(Math.log(this.tranTri / ti.getTranTri()));
        } else {
            r1 = Math.abs(Math.log((this.tranTri + small2) / (ti.getTranTri() + small2)));
        }
        return (r1 + r2 + r3 + r4 + r5 + r6 + r7 + r8) / 8.0;
    }

    public double getEndogamousPercentage() {
        return this.endogamousPercentage;
    }

    public double getNetworkConcentration() {
        return this.networkConcentration;
    }

    public double getEndogamicNetworkConcentration() {
        return this.endogamicNetworkConcentration;
    }

    public double getNetworkSymmetry() {
        return this.networkSymmetry;
    }

    public String toString() {
        return "TopologicalIndices [m=" + this.m + ", n=" + this.n + ", endogamousPercentage=" + this.endogamousPercentage + ", networkConcentration=" + this.networkConcentration + ", endogamicNetworkConcentration=" + this.endogamicNetworkConcentration + ", networkSymmetry=" + this.networkSymmetry + ", parallels=" + this.parallels + ", crosses=" + this.crosses + ", loopTri=" + this.loopTri + ", tranTri=" + this.tranTri + "]";
    }

    public double getN() {
        return this.n;
    }

    public double getLoopTri() {
        return this.loopTri;
    }

    public double getParallels() {
        return this.parallels;
    }

    public double getCrosses() {
        return this.crosses;
    }

    public double getTranTri() {
        return this.tranTri;
    }

    public static void main(String[] args) {
        AllianceNetFile mf = new AllianceNetFile();
        AllianceNet allianceNet = mf.load("datAllLinks/Ancien_Regime_DYNASTIES.dat");
        TopologicalIndices ti = new TopologicalIndices(allianceNet);
        System.out.println(ti);
    }
}

