/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.workers.TransmitAttributeValueCriteria;

public class TransmitAttributeValueInputDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private final JPanel contentPanel = new JPanel();
    private TransmitAttributeValueCriteria dialogCriteria;
    private static TransmitAttributeValueCriteria lastCriteria = new TransmitAttributeValueCriteria();
    private JComboBox cmbbxAttributeLabel;
    private JRadioButton rdbtnAgnatic;
    private final ButtonGroup buttonGroupFiliationType = new ButtonGroup();
    private JRadioButton rdbtnCognatic;
    private JRadioButton rdbtnUterine;
    private JSpinner spnrMaxGenerations;

    public TransmitAttributeValueInputDialog(List<String> labels) {
        Collections.sort(labels);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Transmit Attribute Value Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(TransmitAttributeValueInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TransmitAttributeValueInputDialog.this.dialogCriteria = null;
                TransmitAttributeValueInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 225);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblTarget = new JLabel("Label:");
        this.contentPanel.add((Component)lblTarget, "2, 2, right, default");
        this.cmbbxAttributeLabel = new JComboBox<Object>(labels.toArray());
        this.contentPanel.add((Component)this.cmbbxAttributeLabel, "4, 2, fill, default");
        JLabel lblLabel = new JLabel("FiliationType:");
        this.contentPanel.add((Component)lblLabel, "2, 4, right, default");
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "4, 4, fill, fill");
        panel.setLayout(new BoxLayout(panel, 1));
        this.rdbtnAgnatic = new JRadioButton("Agnatic");
        this.buttonGroupFiliationType.add(this.rdbtnAgnatic);
        panel.add(this.rdbtnAgnatic);
        this.rdbtnCognatic = new JRadioButton("Cognatic");
        this.buttonGroupFiliationType.add(this.rdbtnCognatic);
        panel.add(this.rdbtnCognatic);
        this.rdbtnUterine = new JRadioButton("Uterine");
        this.buttonGroupFiliationType.add(this.rdbtnUterine);
        panel.add(this.rdbtnUterine);
        JLabel lblNewLabel = new JLabel("<html>Max generations:<br/>(0 = no limit)</html>");
        this.contentPanel.add((Component)lblNewLabel, "2, 6, right, default");
        this.spnrMaxGenerations = new JSpinner();
        this.spnrMaxGenerations.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.contentPanel.add((Component)this.spnrMaxGenerations, "4, 6");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransmitAttributeValueInputDialog.this.dialogCriteria = null;
                TransmitAttributeValueInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Transmit");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransmitAttributeValueCriteria criteria = TransmitAttributeValueInputDialog.this.getCriteria();
                if (StringUtils.isBlank((CharSequence)criteria.getAttributeLabel())) {
                    String title = "Invalid input";
                    String message = "Please, enter an attribute label not empty.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    TransmitAttributeValueInputDialog.this.dialogCriteria = criteria;
                    TransmitAttributeValueInputDialog.this.setVisible(false);
                }
            }
        });
        JButton btnDefault = new JButton("Reset");
        btnDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransmitAttributeValueInputDialog.this.setCriteria(new TransmitAttributeValueCriteria());
            }
        });
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        buttonPane.add(btnDefault);
        Component horizontalStrut2 = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut2);
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public TransmitAttributeValueCriteria getCriteria() {
        TransmitAttributeValueCriteria result = new TransmitAttributeValueCriteria();
        result.setAttributeLabel((String)this.cmbbxAttributeLabel.getSelectedItem());
        FiliationType filiationType = this.rdbtnAgnatic.isSelected() ? FiliationType.AGNATIC : (this.rdbtnCognatic.isSelected() ? FiliationType.COGNATIC : (this.rdbtnUterine.isSelected() ? FiliationType.UTERINE : null));
        result.setFiliationType(filiationType);
        Integer max = this.spnrMaxGenerations.getValue() == null || (Integer)this.spnrMaxGenerations.getValue() == 0 ? null : (Integer)this.spnrMaxGenerations.getValue();
        result.setMaxGenerations(max);
        return result;
    }

    public TransmitAttributeValueCriteria getDialogCriteria() {
        TransmitAttributeValueCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(TransmitAttributeValueCriteria source) {
        if (source != null) {
            this.cmbbxAttributeLabel.setSelectedItem(source.getAttributeLabel());
            switch (source.getFiliationType()) {
                case AGNATIC: {
                    this.rdbtnAgnatic.setSelected(true);
                    this.rdbtnCognatic.setSelected(false);
                    this.rdbtnUterine.setSelected(false);
                    break;
                }
                case COGNATIC: {
                    this.rdbtnAgnatic.setSelected(false);
                    this.rdbtnCognatic.setSelected(false);
                    this.rdbtnUterine.setSelected(true);
                    break;
                }
                case UTERINE: {
                    this.rdbtnAgnatic.setSelected(false);
                    this.rdbtnCognatic.setSelected(false);
                    this.rdbtnUterine.setSelected(true);
                    break;
                }
                default: {
                    this.rdbtnAgnatic.setSelected(false);
                    this.rdbtnCognatic.setSelected(false);
                    this.rdbtnUterine.setSelected(false);
                }
            }
            if (source.getMaxGenerations() == null) {
                this.spnrMaxGenerations.setValue(new Integer(0));
            } else {
                this.spnrMaxGenerations.setValue(source.getMaxGenerations());
            }
        }
    }

    public static void main(String[] args) {
        TransmitAttributeValueInputDialog.showDialog(null);
    }

    public static TransmitAttributeValueCriteria showDialog(List<String> labels) {
        TransmitAttributeValueInputDialog dialog = new TransmitAttributeValueInputDialog(labels);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        TransmitAttributeValueCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

