/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.net.relations.roles.RoleRelationRules;

public class RoleRelationRuleInputDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private RoleRelationRules dialogCriteria;
    private static RoleRelationRules lastCriteria = new RoleRelationRules();
    private JCheckBox chckbxChildChildSibling;
    private JCheckBox chckbxSiblingSiblingSibling;
    private JCheckBox chckbxSpouseChildParent;
    private JCheckBox chckbxChildSpouseChild;
    private JCheckBox chckbxSiblingParentChild;

    public RoleRelationRuleInputDialog() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Role Relation Rules");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(RoleRelationRuleInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RoleRelationRuleInputDialog.this.dialogCriteria = null;
                RoleRelationRuleInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 366, 235);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.chckbxChildChildSibling = new JCheckBox("Child's Sibling = Child");
        this.chckbxChildChildSibling.setSelected(true);
        this.getContentPane().add(this.chckbxChildChildSibling);
        this.chckbxSiblingSiblingSibling = new JCheckBox("Sibling's Sibling = Sibling");
        this.chckbxSiblingSiblingSibling.setSelected(true);
        this.getContentPane().add(this.chckbxSiblingSiblingSibling);
        this.chckbxSpouseChildParent = new JCheckBox("Child's Parent = Spouse");
        this.chckbxSpouseChildParent.setSelected(true);
        this.getContentPane().add(this.chckbxSpouseChildParent);
        this.chckbxChildSpouseChild = new JCheckBox("Spouse's Child = Child");
        this.chckbxChildSpouseChild.setSelected(true);
        this.getContentPane().add(this.chckbxChildSpouseChild);
        this.chckbxSiblingParentChild = new JCheckBox("Parent's Child = Sibling");
        this.getContentPane().add(this.chckbxSiblingParentChild);
        JLabel label = new JLabel("");
        this.getContentPane().add(label);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add(buttonPane);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoleRelationRuleInputDialog.this.dialogCriteria = null;
                RoleRelationRuleInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoleRelationRules criteria = RoleRelationRuleInputDialog.this.getCriteria();
                lastCriteria = criteria;
                RoleRelationRuleInputDialog.this.dialogCriteria = criteria;
                RoleRelationRuleInputDialog.this.setVisible(false);
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public RoleRelationRules getCriteria() {
        RoleRelationRules result = new RoleRelationRules();
        if (this.chckbxChildChildSibling.isSelected()) {
            result.add(RoleRelationMaker.RoleRelationRule.CHILD_CHILD_SIBLING);
        }
        if (this.chckbxSiblingSiblingSibling.isSelected()) {
            result.add(RoleRelationMaker.RoleRelationRule.SIBLING_SIBLING_SIBLING);
        }
        if (this.chckbxSpouseChildParent.isSelected()) {
            result.add(RoleRelationMaker.RoleRelationRule.SPOUSE_CHILD_PARENT);
        }
        if (this.chckbxChildSpouseChild.isSelected()) {
            result.add(RoleRelationMaker.RoleRelationRule.CHILD_SPOUSE_CHILD);
        }
        if (this.chckbxSiblingParentChild.isSelected()) {
            result.add(RoleRelationMaker.RoleRelationRule.SIBLING_PARENT_CHILD);
        }
        return result;
    }

    public RoleRelationRules getDialogCriteria() {
        RoleRelationRules result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(List<RoleRelationMaker.RoleRelationRule> source) {
    }

    public static void main(String[] args) {
        RoleRelationRules criteria = RoleRelationRuleInputDialog.showDialog();
    }

    public static RoleRelationRules showDialog() {
        RoleRelationRuleInputDialog dialog = new RoleRelationRuleInputDialog();
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        RoleRelationRules result = dialog.getDialogCriteria();
        return result;
    }
}

