/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.List;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainMaker;
import org.tip.puck.net.FiliationType;
import org.tip.puckgui.views.mas.AgnaticCousinsWeightFactor;
import org.tip.puckgui.views.mas.CousinsWeightFactor;
import org.tip.puckgui.views.mas.Divorce2WeightFactor;
import org.tip.puckgui.views.mas.DivorceWeightFactor;
import org.tip.puckgui.views.mas.NormalAgeDifferenceWeightFactor;
import org.tip.puckgui.views.mas.NormalAgeWeightFactor;
import org.tip.puckgui.views.mas.PregnancyWeightFactor;
import org.tip.puckgui.views.mas.UterineCousinsWeightFactor;
import org.tip.puckgui.views.mas.WeightFactor;

public class RandomCorpusCriteria {
    private int year = 300;
    private int initialPopulation = 500;
    private int maxAge = 50;
    private int minAge = 15;
    private int samples = 10000;
    double meanAgeDifference = 0.0;
    double stdevAgeDifference = 7.0;
    double marriageRate = 0.2;
    double fertilityRate = 2.0;
    double divorceRate = 0.01;
    double polygamyRateMen;
    double polygamyRateWomen;
    FiliationType cousinPreferenceType = FiliationType.COGNATIC;
    double cousinPreferenceWeight = 1.0;
    private double sameMarriageProbability = 0.5;
    private List<WeightFactor> weightFactors = new ArrayList<WeightFactor>();
    private String illegalMarriages = "X(X)\nXX(X)\nX(X)X";
    private boolean mas;

    public FiliationType getCousinPreferenceType() {
        return this.cousinPreferenceType;
    }

    public double getCousinPreferenceWeight() {
        return this.cousinPreferenceWeight;
    }

    public double getDivorceRate() {
        return this.divorceRate;
    }

    public double getFertilityRate() {
        return this.fertilityRate;
    }

    public String getIllegalMarriages() {
        return this.illegalMarriages;
    }

    public int getInitialPopulation() {
        return this.initialPopulation;
    }

    public double getMarriageRate() {
        return this.marriageRate;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public double getMeanAgeDifference() {
        return this.meanAgeDifference;
    }

    public int getMinAge() {
        return this.minAge;
    }

    public double getPolygamyRateMen() {
        return this.polygamyRateMen;
    }

    public double getPolygamyRateWomen() {
        return this.polygamyRateWomen;
    }

    public double getSameMarriageProbability() {
        return this.sameMarriageProbability;
    }

    public int getSamples() {
        return this.samples;
    }

    public double getStdevAgeDifference() {
        return this.stdevAgeDifference;
    }

    public WeightFactor getWeightFactor(WeightFactor.Type type) {
        WeightFactor result = null;
        for (WeightFactor factor : this.weightFactors) {
            if (factor.getType() != type) continue;
            result = factor;
            break;
        }
        return result;
    }

    public int getYear() {
        return this.year;
    }

    public boolean isMas() {
        return this.mas;
    }

    public void setCousinPreferenceType(FiliationType cousinPreferenceType) {
        this.cousinPreferenceType = cousinPreferenceType;
    }

    public void setCousinPreferenceWeight(double cousinPreferenceWeight) {
        this.cousinPreferenceWeight = cousinPreferenceWeight;
    }

    public void setDivorceRate(double divorceRate) {
        this.divorceRate = divorceRate;
    }

    public void setFertilityRate(double fertilityRate) {
        this.fertilityRate = fertilityRate;
    }

    public void setIllegalMarriages(String illegalMarriages) {
        this.illegalMarriages = illegalMarriages;
    }

    public void setInitialPopulation(int initialPopulation) {
        this.initialPopulation = initialPopulation;
    }

    public void setMarriageRate(double marriageRate) {
        this.marriageRate = marriageRate;
    }

    public void setMas(boolean mas) {
        this.mas = mas;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setMeanAgeDifference(double meanAgeDifference) {
        this.meanAgeDifference = meanAgeDifference;
    }

    public void setMinAge(int minAge) {
        this.minAge = minAge;
    }

    public void setPolygamyRateMen(double polygamyRateMen) {
        this.polygamyRateMen = polygamyRateMen;
    }

    public void setPolygamyRateWomen(double polygamyRateWomen) {
        this.polygamyRateWomen = polygamyRateWomen;
    }

    public void setSameMarriageProbability(double sameMarriageProbability) {
        this.sameMarriageProbability = sameMarriageProbability;
    }

    public void setSamples(int samples) {
        this.samples = samples;
    }

    public void setStdevAgeDifference(double stdevAgeDifference) {
        this.stdevAgeDifference = stdevAgeDifference;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String toMASConfig() {
        StringList buffer = new StringList();
        buffer.appendln("# simulation parameters");
        buffer.append("years ").appendln(this.year);
        buffer.append("initialpopulation ").appendln(this.initialPopulation);
        buffer.append("probsamemarriage ").appendln(this.sameMarriageProbability);
        buffer.append("fertilityrate ").appendln(this.fertilityRate);
        buffer.append("maxage ").appendln(this.maxAge);
        buffer.append("samples ").appendln(this.samples);
        buffer.appendln();
        buffer.appendln("# weight factors");
        for (WeightFactor factor : this.weightFactors) {
            switch (factor.getType()) {
                case DIVORCE: {
                    DivorceWeightFactor divorceFactor = (DivorceWeightFactor)factor;
                    buffer.append("factor Divorce(").append(divorceFactor.getProbability()).appendln(")");
                    break;
                }
                case DIVORCE2: {
                    Divorce2WeightFactor divorce2Factor = (Divorce2WeightFactor)factor;
                    buffer.append("factor Divorce2(").append(divorce2Factor.getFemaleProbability()).append(", ").append(divorce2Factor.getMaleProbability()).append(", ").append(divorce2Factor.getBothProbability()).appendln(")");
                    break;
                }
                case NORMAL_AGE: {
                    NormalAgeWeightFactor normalAgeFactor = (NormalAgeWeightFactor)factor;
                    buffer.append("factor NormalAge(").append(normalAgeFactor.getGender().toString()).append(", ").append(normalAgeFactor.getMean()).append(", ").append(normalAgeFactor.getStdev()).appendln(")");
                    break;
                }
                case NORMAL_AGE_DIFFERENCE: {
                    NormalAgeDifferenceWeightFactor differenceFactor = (NormalAgeDifferenceWeightFactor)factor;
                    buffer.append("factor NormalDifferenceAge(").append(differenceFactor.getMean()).append(", ").append(differenceFactor.getStdev()).appendln(")");
                    break;
                }
                case COUSINS: {
                    CousinsWeightFactor cousinsFactor = (CousinsWeightFactor)factor;
                    buffer.append("factor Cousins(").append(cousinsFactor.getFirst()).append(", ").append(cousinsFactor.getSecond()).append(", ").append(cousinsFactor.getThird()).appendln(")");
                    break;
                }
                case AGNATICCOUSINS: {
                    AgnaticCousinsWeightFactor agnaticCousinsFactor = (AgnaticCousinsWeightFactor)factor;
                    buffer.append("factor Cousins(").append(agnaticCousinsFactor.getFirst()).append(", ").append(agnaticCousinsFactor.getSecond()).append(", ").append(agnaticCousinsFactor.getThird()).appendln(")");
                    break;
                }
                case UTERINECOUSINS: {
                    UterineCousinsWeightFactor uterineCousinsFactor = (UterineCousinsWeightFactor)factor;
                    buffer.append("factor Cousins(").append(uterineCousinsFactor.getFirst()).append(", ").append(uterineCousinsFactor.getSecond()).append(", ").append(uterineCousinsFactor.getThird()).appendln(")");
                    break;
                }
                case PREGNANCY: {
                    PregnancyWeightFactor pregnancyFactor = (PregnancyWeightFactor)factor;
                    buffer.append("factor Pregnancy(").append(pregnancyFactor.getFirst()).appendln(")");
                }
            }
        }
        buffer.appendln();
        buffer.appendln(RandomCorpusCriteria.positionalNotationToPrologCode(this.illegalMarriages));
        String result = buffer.toString();
        return result;
    }

    public List<WeightFactor> weightFactors() {
        return this.weightFactors;
    }

    public static String positionalNotationToPrologCode(String formula) {
        String[] kinStrings;
        StringList buffer = new StringList();
        ArrayList<Character> var = new ArrayList<Character>();
        var.add(Character.valueOf(' '));
        char c = 'A';
        while (c <= 'Z') {
            var.add(Character.valueOf(c));
            c = (char)(c + '\u0001');
        }
        buffer.appendln("# illegal marriages");
        buffer.appendln("start prolog");
        buffer.appendln("parent(X, Y) :- mother(X, Y).\nparent(X, Y) :- father(X, Y).");
        String[] stringArray = kinStrings = formula.split("\\s");
        int n = kinStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String kinString = stringArray[n2];
            Chain chain = ChainMaker.fromString(kinString);
            buffer.appendln("illegal(" + var.get(chain.getId(0)) + "," + var.get(chain.getLast().getId()) + ") :- " + chain.getPrologString() + ".");
            ++n2;
        }
        String result = buffer.toString();
        return result;
    }
}

