/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class ButtonTabComponent
extends JPanel {
    private static final long serialVersionUID = 5061553483404794020L;
    public static final int SIZE = 10;
    public static final int DELTA = 1;
    private final JTabbedPane pane;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent event) {
            Component component = event.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            Component component = event.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public ButtonTabComponent(final JTabbedPane pane) {
        super(new FlowLayout(0, 0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        JLabel label = new JLabel(){
            private static final long serialVersionUID = -374253575101128807L;

            @Override
            public String getText() {
                int i = pane.indexOfTabComponent(ButtonTabComponent.this);
                String result = i == -1 ? null : pane.getTitleAt(i);
                return result;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton button = new TabButton();
        this.add(button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 721605711978453878L;

        public TabButton() {
            this.setPreferredSize(new Dimension(10, 10));
            this.setToolTipText("Close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int tabIndex = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (tabIndex != -1) {
                ButtonTabComponent.this.pane.remove(tabIndex);
            }
        }

        @Override
        protected void paintComponent(Graphics sourceGraphic) {
            super.paintComponent(sourceGraphic);
            Graphics2D targetGraphic = (Graphics2D)sourceGraphic.create();
            if (this.getModel().isPressed()) {
                targetGraphic.translate(1, 1);
            }
            targetGraphic.setStroke(new BasicStroke(2.0f));
            targetGraphic.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                targetGraphic.setColor(Color.MAGENTA);
            }
            int delta = 1;
            targetGraphic.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            targetGraphic.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            targetGraphic.dispose();
        }

        @Override
        public void updateUI() {
        }
    }
}

