/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;

public class RolesModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2955121752027361350L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    protected Roles source;
    protected Roles delegation;

    public RolesModel(Roles source) {
        this.setSource(source);
    }

    public Class getColumnClass(int columnIndex) {
        Class<String> result;
        if (this.source == null) {
            result = String.class;
        } else {
            switch (columnIndex) {
                case 0: {
                    result = String.class;
                    break;
                }
                case 1: {
                    result = String.class;
                    break;
                }
                default: {
                    result = String.class;
                }
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 2;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = "Role";
                break;
            }
            case 1: {
                result = "Cardinality";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.delegation.size();
        return result;
    }

    public Roles getSource() {
        Roles result = this.source;
        return result;
    }

    public Roles getTarget() {
        Roles result = this.delegation;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.delegation == null) {
            result = null;
        } else {
            switch (columnIndex) {
                case 0: {
                    result = ((Role)this.delegation.get(rowIndex)).getName();
                    break;
                }
                case 1: {
                    if (StringUtils.isBlank((CharSequence)((Role)this.delegation.get(rowIndex)).getName())) {
                        result = "";
                        break;
                    }
                    result = ((Role)this.delegation.get(rowIndex)).getDefaultCardinality();
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result = true;
        return result;
    }

    public void setSource(Roles source) {
        this.source = source;
        this.delegation = source == null ? new Roles() : source;
        this.delegation.add(new Role("", 0));
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Role currentRole = (Role)this.delegation.get(rowIndex);
        if (columnIndex == 0) {
            currentRole.setName((String)value);
        } else if (columnIndex == 1 && NumberUtils.isDigits((String)((String)value))) {
            currentRole.setDefaultCardinality(Integer.parseInt((String)value));
        }
        if (rowIndex == this.delegation.size() - 1 && StringUtils.isNotBlank((CharSequence)((Role)this.delegation.get(rowIndex)).getName())) {
            this.delegation.add(new Role("", 0));
            this.fireTableDataChanged();
        }
    }
}

