/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puckgui.InputSettings;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.util.ComboBoxIds;

public class IndividualChildrenModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7713941886363202385L;
    private static final Logger logger = LoggerFactory.getLogger(IndividualChildrenModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private static ImageIcon smallFemaleIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/female-16x16.png"));
    private static ImageIcon smallMaleIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/male-16x16.png"));
    private static ImageIcon smallUnknowIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/unknown-16x16.png"));
    private NetGUI netGUI;
    private Individual source;
    private List<Individual> children;

    public IndividualChildrenModel(NetGUI netGUI, Individual source) {
        this.netGUI = netGUI;
        this.source = source;
        this.children = source == null ? new ArrayList<Individual>() : this.source.children().toListSortedByOrder();
    }

    public List<Individual> children() {
        List<Individual> result = this.children;
        return result;
    }

    public void escapeNewEdition() {
        if (this.isNewEditionOn()) {
            logger.debug("ESCAPE d");
            int index = this.children.size() - 1;
            this.children.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public Class getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = Number.class;
                break;
            }
            case 1: {
                result = ImageIcon.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = Number.class;
                break;
            }
            case 4: {
                result = Number.class;
                break;
            }
            case 5: {
                result = String.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 6;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = BUNDLE.getString("MainWindow.individual.id");
                break;
            }
            case 1: {
                result = BUNDLE.getString("MainWindow.individual.gender");
                break;
            }
            case 2: {
                result = BUNDLE.getString("MainWindow.individual.name");
                break;
            }
            case 3: {
                result = BUNDLE.getString("MainWindow.individual.position");
                break;
            }
            case 4: {
                result = BUNDLE.getString("MainWindow.individual.fratry");
                break;
            }
            case 5: {
                result = BUNDLE.getString("MainWindow.individual.otherparent");
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.children.size();
        return result;
    }

    public Individual getSource() {
        Individual result = this.source;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.source == null) {
            result = null;
        } else if (this.isNewEditionOn() && rowIndex == this.children.size() - 1) {
            switch (columnIndex) {
                case 3: {
                    result = this.children.get(rowIndex).getBirthOrder();
                    break;
                }
                case 4: {
                    Family originFamily = this.children.get(rowIndex).getOriginFamily();
                    if (originFamily == null) {
                        result = null;
                        break;
                    }
                    result = originFamily.getId();
                    break;
                }
                case 5: {
                    Individual otherParent = this.children.get(rowIndex).getOtherParent(this.source);
                    if (otherParent == null) {
                        result = null;
                        break;
                    }
                    result = String.format("%c (%d) %s", Character.valueOf(otherParent.getGender().toChar()), otherParent.getId(), otherParent.getName());
                    break;
                }
                default: {
                    result = "";
                    break;
                }
            }
        } else {
            block5 : switch (columnIndex) {
                case 0: {
                    result = this.children.get(rowIndex).getId();
                    break;
                }
                case 1: {
                    switch (this.children.get(rowIndex).getGender()) {
                        case FEMALE: {
                            result = smallFemaleIcon;
                            break block5;
                        }
                        case MALE: {
                            result = smallMaleIcon;
                            break block5;
                        }
                        case UNKNOWN: {
                            result = smallUnknowIcon;
                            break block5;
                        }
                    }
                    result = smallUnknowIcon;
                    break;
                }
                case 2: {
                    result = this.children.get(rowIndex).getName();
                    break;
                }
                case 3: {
                    result = this.children.get(rowIndex).getBirthOrder();
                    break;
                }
                case 4: {
                    Family originFamily = this.children.get(rowIndex).getOriginFamily();
                    if (originFamily == null) {
                        result = null;
                        break;
                    }
                    result = originFamily.getId();
                    break;
                }
                case 5: {
                    Individual otherParent = this.children.get(rowIndex).getOtherParent(this.source);
                    if (otherParent == null) {
                        result = null;
                        break;
                    }
                    result = String.format("%c (%d) %s", Character.valueOf(otherParent.getGender().toChar()), otherParent.getId(), otherParent.getName());
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result;
        switch (col) {
            case 0: 
            case 3: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isNewEditionOn() {
        boolean result = this.source == null ? false : this.children.size() == this.source.children().size() + 1;
        return result;
    }

    public void setNewItem(Family family) {
        Individual newIndividual = new Individual(0, "?", Gender.UNKNOWN);
        newIndividual.setOriginFamily(family);
        this.children.add(newIndividual);
        this.fireTableDataChanged();
    }

    public void setSource(Individual source) {
        this.source = source;
        this.children = source == null ? new ArrayList<Individual>() : this.source.children().toListSortedByOrder();
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        logger.debug("setValueAt(" + rowIndex + ", " + columnIndex + ", " + value + ")");
        if (this.netGUI != null) {
            if (columnIndex == 0) {
                Individual currentIndividual = this.netGUI.selectedIndividual();
                if (this.isNewEditionOn()) {
                    Individual newChild = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
                    Family targetFamily = this.children.get(rowIndex).getOriginFamily();
                    if (newChild == null) {
                        this.children.remove(rowIndex);
                        this.fireTableDataChanged();
                    } else {
                        String errorMessage = IndividualChildrenModel.controlChildKinError(this.source, newChild);
                        if (errorMessage != null) {
                            JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
                        } else if (IndividualChildrenModel.controlChildKinWarningOK(this.source, newChild, targetFamily)) {
                            if (targetFamily == null) {
                                switch (newChild.numberOfParents()) {
                                    case 2: {
                                        this.netGUI.getNet().removeChild(newChild);
                                        if (NetUtils.isRolesFixedByGender(this.source, null)) {
                                            this.netGUI.getNet().createFamily(this.source, null, newChild);
                                            break;
                                        }
                                        this.netGUI.getNet().createFamily(null, this.source, newChild);
                                        break;
                                    }
                                    case 1: {
                                        targetFamily = newChild.getOriginFamily();
                                        if (targetFamily.getFather() == null) {
                                            targetFamily.setFather(this.source);
                                        } else {
                                            targetFamily.setMother(this.source);
                                        }
                                        this.source.addPersonalFamily(targetFamily);
                                        break;
                                    }
                                    case 0: {
                                        if (newChild.getOriginFamily() == null) {
                                            if (NetUtils.isRolesFixedByGender(this.source, null)) {
                                                this.netGUI.getNet().createFamily(this.source, null, newChild);
                                                break;
                                            }
                                            this.netGUI.getNet().createFamily(null, this.source, newChild);
                                            break;
                                        }
                                        if (NetUtils.isRolesFixedByGender(this.source, null)) {
                                            newChild.getOriginFamily().setFather(this.source);
                                        } else {
                                            newChild.getOriginFamily().setMother(this.source);
                                        }
                                        this.source.addPersonalFamily(newChild.getOriginFamily());
                                    }
                                }
                            } else {
                                this.netGUI.getNet().removeChild(newChild);
                                this.netGUI.getNet().addChild(targetFamily, newChild);
                            }
                            this.netGUI.setChanged(true);
                            this.netGUI.updateAll();
                            this.netGUI.selectIndividualsTab(currentIndividual);
                        }
                    }
                } else {
                    Individual oldChild = this.children.get(rowIndex);
                    Individual newChild = ComboBoxIds.getIndividualFromInput(this.netGUI.getNet(), value);
                    if (newChild == null) {
                        this.netGUI.getNet().removeChild(oldChild);
                        this.netGUI.setChanged(true);
                        this.setSource(this.source);
                    } else if (newChild != oldChild) {
                        JOptionPane.showMessageDialog(null, "Operation not permitted.\nPlease, use the family tab to manage family.", "Error", 0);
                    }
                }
            } else if (columnIndex == 3) {
                Integer newBirthOrderValue = value instanceof String ? (NumberUtils.isDigits((String)((String)value)) ? Integer.valueOf(Integer.parseInt((String)value)) : null) : (value instanceof Integer ? (Integer)value : null);
                if (newBirthOrderValue == null || newBirthOrderValue > 0) {
                    Individual currentIndividual = this.netGUI.selectedIndividual();
                    Individual child = this.children.get(rowIndex);
                    child.setBirthOrder(newBirthOrderValue);
                    this.netGUI.setChanged(true);
                    this.netGUI.updateAll();
                    this.netGUI.selectIndividualsTab(currentIndividual);
                }
            }
        }
    }

    public Individual source() {
        Individual result = this.source;
        return result;
    }

    public static String controlChildKinError(Individual ego, Individual newChild) {
        String result = ego == newChild ? "Same parent child detected." : (ego.children().contains(newChild) ? "Already child detected." : (PuckGUI.instance().getPreferences().getInputSettings().getParentChildMarriages() == InputSettings.CheckLevel.ERROR && NetUtils.isParentChildMarriage(ego, newChild) ? "Parent-child marriages detected." : null));
        return result;
    }

    public static boolean controlChildKinWarningOK(Individual ego, Individual newChild, Family targetFamily) {
        int response;
        Object[] buttons;
        boolean result = true;
        if (PuckGUI.instance().getPreferences().getInputSettings().getParentChildMarriages() == InputSettings.CheckLevel.WARNING && NetUtils.isParentChildMarriage(ego, newChild)) {
            buttons = new String[]{"Continue", "Abort"};
            response = JOptionPane.showOptionDialog(null, "Parent-child marriages detected.\nThis new child already is married with this individual.", "Warning", 1, 2, null, buttons, buttons[0]);
            result = response == 0;
        }
        if (result && targetFamily == null && newChild.numberOfParents() != 0) {
            switch (newChild.numberOfParents()) {
                case 1: {
                    buttons = new String[]{"Continue", "Abort"};
                    response = JOptionPane.showOptionDialog(null, "This new child already has a single parent family.\nThe action will fill his family.", "Warning", 1, 2, null, buttons, buttons[0]);
                    if (response == 0) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                case 2: {
                    buttons = new String[]{"Continue", "Abort"};
                    response = JOptionPane.showOptionDialog(null, "This new child already has 2 parents family.\nThe action will remove him of this family.", "Warning", 1, 2, null, buttons, buttons[0]);
                    if (response == 0) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        if (result && targetFamily != null && newChild.getOriginFamily() != null) {
            buttons = new String[]{"Continue", "Abort"};
            response = JOptionPane.showOptionDialog(null, "This new child already has family.\nThe action will remove him of this family.", "Warning", 1, 2, null, buttons, buttons[0]);
            result = response == 0;
        }
        return result;
    }
}

