/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.statistics;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckManager;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.Places2;
import org.tip.puck.graphs.Node;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.net.Family;
import org.tip.puck.net.FamilyComparator;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individualizable;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.AttributeDescriptor;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeValueDescriptor;
import org.tip.puck.net.workers.AttributeValueDescriptorList;
import org.tip.puck.net.workers.AttributeValueDescriptors;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.net.workers.FamilyValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Clusters;
import org.tip.puck.partitions.MultiPartition;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportAttributes;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.statistics.BIASCount;
import org.tip.puck.statistics.BIASCounts;
import org.tip.puck.statistics.FiliationCount;
import org.tip.puck.statistics.FiliationCounts;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Trafo;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;
import org.tip.puck.workers.NodeReferentValuator;

public class StatisticsReporter {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsReporter.class);

    public static <E> ReportChart createArrayChart(String title, double[][] array, String[] lineTitles) {
        ReportChart result = new ReportChart(title, ReportChart.GraphType.LINES);
        int j = 0;
        while (j < array[0].length) {
            result.setLineTitle(lineTitles[j], j);
            int i = 0;
            while (i < array.length) {
                result.setHeader(String.valueOf(i), i);
                result.setValue(array[i][j], j, i);
                ++i;
            }
            ++j;
        }
        return result;
    }

    public static StringList createAttributeDescriptorGroupedList(AttributeDescriptors source) {
        StringList result;
        if (source == null) {
            result = null;
        } else {
            AttributeDescriptor.Scope scope;
            List<String> relationModelNames = source.relationModelNames();
            result = new StringList(relationModelNames.size() + 3 + 1);
            AttributeDescriptor.Scope[] scopeArray = AttributeDescriptor.CanonicalScopes;
            int n = AttributeDescriptor.CanonicalScopes.length;
            int n2 = 0;
            while (n2 < n) {
                scope = scopeArray[n2];
                AttributeDescriptors descriptors = source.findByScope(scope);
                result.append(scope.toString()).append(" (").append(descriptors.size()).append("): ");
                StringList labelList = new StringList(descriptors.size());
                labelList.addAll((Collection)descriptors.labelsSorted());
                String labels = labelList.toStringWithFrenchCommas();
                result.appendln(labels);
                ++n2;
            }
            for (String name : relationModelNames) {
                AttributeDescriptors descriptors = source.findByRelationModelName(name);
                result.append(name).append(" (").append(descriptors.size()).append("): ");
                StringList labelList = new StringList(descriptors.size());
                labelList.addAll((Collection)descriptors.labelsSorted());
                String labels = labelList.toStringWithFrenchCommas();
                result.appendln(labels);
            }
            scope = AttributeDescriptor.Scope.ACTORS;
            AttributeDescriptors descriptors = source.findByScope(scope);
            result.append(scope.toString()).append(" (").append(descriptors.size()).append("): ");
            StringList labelList = new StringList(descriptors.size());
            labelList.addAll((Collection)descriptors.labelsSorted());
            String labels = labelList.toStringWithFrenchCommas();
            result.appendln(labels);
        }
        return result;
    }

    public static ReportTable createAttributeDescriptorGroupedTable(AttributeDescriptors source) {
        ReportTable result;
        if (source == null) {
            result = null;
        } else {
            List<String> relationModelNames = source.relationModelNames();
            result = new ReportTable(relationModelNames.size() + 3 + 1, 3);
            result.setTitle("Descriptors");
            result.set(0, 0, "Scope");
            result.set(0, 1, "Count");
            result.set(0, 2, "Labels");
            int index = 1;
            AttributeDescriptor.Scope[] scopeArray = AttributeDescriptor.CanonicalScopes;
            int n = AttributeDescriptor.CanonicalScopes.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor.Scope scope = scopeArray[n2];
                AttributeDescriptors descriptors = source.findByScope(scope);
                result.set(index, 0, scope.toString());
                result.set(index, 1, descriptors.size());
                StringList labelList = new StringList(descriptors.size());
                labelList.addAll((Collection)descriptors.labelsSorted());
                String labels = labelList.toStringWithFrenchCommas();
                result.set(index, 2, labels);
                ++index;
                ++n2;
            }
            for (String name : relationModelNames) {
                AttributeDescriptors descriptors = source.findByRelationModelName(name);
                result.set(index, 0, name);
                result.set(index, 1, descriptors.size());
                StringList labelList = new StringList(descriptors.size());
                labelList.addAll((Collection)descriptors.labelsSorted());
                String labels = labelList.toStringWithFrenchCommas();
                result.set(index, 2, labels);
                ++index;
            }
        }
        return result;
    }

    public static ReportTable createAttributeDescriptorTable(AttributeDescriptors source) {
        ReportTable result;
        if (source == null) {
            result = null;
        } else {
            result = new ReportTable(source.size() + 1, 11);
            result.setTitle("Descriptors");
            result.set(0, 0, "Scope");
            result.set(0, 1, "Label");
            result.set(0, 2, "Not set");
            result.set(0, 3, " % ");
            result.set(0, 4, "Set blank");
            result.set(0, 5, " % ");
            result.set(0, 6, "Filled");
            result.set(0, 7, " % ");
            result.set(0, 8, "Set");
            result.set(0, 9, "%");
            result.set(0, 10, "Theorical max.");
            int index = 1;
            for (AttributeDescriptor descriptor : source) {
                result.set(index, 0, descriptor.getRelationName());
                result.set(index, 1, descriptor.getLabel());
                result.set(index, 2, String.valueOf(descriptor.getCountOfNotSet()));
                result.set(index, 3, descriptor.getCovegareOfNotSet());
                result.set(index, 4, String.valueOf(descriptor.getCountOfBlank()));
                result.set(index, 5, descriptor.getCoverageOfBlank());
                result.set(index, 6, String.valueOf(descriptor.getCountOfFilled()));
                result.set(index, 7, descriptor.getCoverageOfFilled());
                result.set(index, 8, String.valueOf(descriptor.getCountOfSet()));
                result.set(index, 9, descriptor.getCoverageOfSet());
                result.set(index, 10, String.valueOf(descriptor.getMax()));
                ++index;
            }
        }
        return result;
    }

    public static <E> ReportChart createChart(String title, Map<String, Map<String, Double>> map) throws PuckException {
        ReportChart result;
        if (map == null) {
            result = null;
        } else {
            result = new ReportChart(title, ReportChart.GraphType.STACKED_BARS);
            int clusterIndex = 0;
            HashMap<String, Integer> clusterValueToLineIndex = new HashMap<String, Integer>();
            for (String clusterLabel : map.keySet()) {
                result.setHeader(clusterLabel, clusterIndex);
                for (String splitClusterLabel : map.get(clusterLabel).keySet()) {
                    Integer lineIndex = (Integer)clusterValueToLineIndex.get(splitClusterLabel);
                    if (lineIndex == null) {
                        lineIndex = clusterValueToLineIndex.size();
                        clusterValueToLineIndex.put(splitClusterLabel, lineIndex);
                        result.setLineTitle(splitClusterLabel, lineIndex);
                    }
                    result.addValue(map.get(clusterLabel).get(splitClusterLabel), lineIndex);
                }
                ++clusterIndex;
            }
        }
        return result;
    }

    public static ReportChart createCompletenessChart(FiliationCounts counts) {
        ReportChart result = new ReportChart("Genealogical Completeness", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Generational Level");
        result.setLinesLegend("% ascendants");
        result.setVerticalMax(100.0);
        result.setIntegerHorizontalUnit(true);
        result.setLineTitle("Overall", 0);
        result.setLineTitle("Agnatic", 1);
        result.setLineTitle("Uterine", 2);
        int ascendingIndex = 1;
        while (ascendingIndex < counts.size()) {
            FiliationCount count = counts.get(ascendingIndex);
            if (count.isPositive()) {
                result.addValue(ascendingIndex, count.getCognatic(), 0);
                result.addValue(ascendingIndex, count.getAgnatic(), 1);
                result.addValue(ascendingIndex, count.getUterine(), 2);
            }
            ++ascendingIndex;
        }
        return result;
    }

    public static ReportChart createComponentsChart(Individuals individuals, int resolution) throws PuckException {
        FiliationCounts counts = StatisticsWorker.components(individuals, resolution);
        ReportChart result = new ReportChart("Components", ReportChart.GraphType.LINES);
        result.setLogarithmType(ReportChart.LogarithmType.HORIZONTAL);
        result.setHeadersLegend("% Individuals");
        result.setLinesLegend("% Components");
        result.setLineTitle("Agnatic", 0);
        result.setLineTitle("Uterine", 1);
        int ascendingIndex = 0;
        while (ascendingIndex < resolution) {
            result.addValue(MathUtils.percent(ascendingIndex, resolution), counts.get(ascendingIndex).getAgnatic(), 0);
            result.addValue(MathUtils.percent(ascendingIndex, resolution), counts.get(ascendingIndex).getUterine(), 1);
            ++ascendingIndex;
        }
        return result;
    }

    public static <E> ReportChart createDiversityChart(Partition<Node<E>>[] source, int maxPositions) {
        ReportChart result = new ReportChart("Diversity_" + source[2].getLabel(), ReportChart.GraphType.LINES);
        result.setHeadersLegend("Depth");
        result.setLinesLegend("Diversity");
        result.setVerticalMax(100.0);
        result.setIntegerHorizontalUnit(true);
        result.setLineTitle("All itineraries", 0);
        result.setLineTitle("Male itineraries", 1);
        result.setLineTitle("Female itineraries", 2);
        int gender = 0;
        while (gender < 2) {
            List<Cluster<Node<E>>> clusterList = source[gender].getClusters().toListSortedByValue();
            int i = 1;
            while (i <= clusterList.size()) {
                Cluster<Node<E>> cluster = clusterList.get(i - 1);
                if (cluster != null) {
                    int value = cluster.getValue().intValue();
                    double nodeSizeSum = 0.0;
                    for (Node<E> node : cluster.getItems()) {
                        Value nodeSize = new NodeReferentValuator<E>().get(node, "SIZE");
                        if (nodeSize != null) {
                            nodeSizeSum += (double)nodeSize.intValue();
                            continue;
                        }
                        System.err.println("Null size value for " + node + " " + node.getReferent());
                    }
                    double maxSize = Math.min(Math.pow(maxPositions, value), nodeSizeSum);
                    double diversity = MathUtils.percent((double)(cluster.size() - 1), maxSize - 1.0);
                    result.setHeader(MathUtils.toString(value), value);
                    result.addValue(value, diversity, 0);
                }
                ++i;
            }
            ++gender;
        }
        return result;
    }

    public static ReportChart createFratryDistributionChart(FiliationCounts counts) throws PuckException {
        ReportChart result = new ReportChart("Fratry Distribution", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Size");
        result.setLinesLegend("Number");
        result.setIntegerHorizontalUnit(true);
        result.setLineTitle("Uterine", 0);
        result.setLineTitle("Agnatic", 1);
        int countIndex = 2;
        while (countIndex < counts.size()) {
            result.setHeader(MathUtils.toString(countIndex), countIndex);
            result.addValue(countIndex, counts.get(countIndex).getUterine(), 0);
            result.addValue(countIndex, counts.get(countIndex).getAgnatic(), 1);
            ++countIndex;
        }
        return result;
    }

    public static ReportTable createFratryDistributionTable(FiliationCounts counts) throws PuckException {
        ReportTable result = new ReportTable(counts.size() + 1, 5);
        result.setTitle("Fratry Distribution");
        result.set(0, 0, " ");
        result.set(0, 1, "Uterine");
        result.set(0, 2, "Agnatic");
        result.set(0, 3, "% Agnatic");
        result.set(0, 4, "% Uterine");
        int agnaticSum = counts.agnaticSum();
        int uterineSum = counts.uterineSum();
        int countIndex = 0;
        while (countIndex < counts.size()) {
            result.set(countIndex + 1, 0, countIndex);
            result.set(countIndex + 1, 1, MathUtils.toString(counts.get(countIndex).getUterine()));
            result.set(countIndex + 1, 2, MathUtils.toString(counts.get(countIndex).getAgnatic()));
            result.set(countIndex + 1, 3, MathUtils.percent(counts.get(countIndex).getUterine(), (double)uterineSum));
            result.set(countIndex + 1, 4, MathUtils.percent(counts.get(countIndex).getAgnatic(), (double)agnaticSum));
            ++countIndex;
        }
        return result;
    }

    public static ReportChart createGenderBIASNetWeightChart(BIASCounts counts) {
        ReportChart result = new ReportChart("Gender BIAS (net weight)", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Generational Level");
        result.setLinesLegend("% Individuals");
        result.setVerticalMax(100.0);
        result.setIntegerHorizontalUnit(true);
        result.setLineTitle("Only Uterine Ancestor Known", 0);
        result.setLineTitle("Only Agnatic Ancestor Known", 1);
        int countIndex = 1;
        while (countIndex < counts.size()) {
            BIASCount count = counts.get(countIndex);
            if (count.isPositive()) {
                result.setHeader(MathUtils.toString(countIndex), countIndex);
                result.addValue(countIndex, count.getUterine(), 0);
                result.addValue(countIndex, count.getAgnatic(), 1);
            }
            ++countIndex;
        }
        return result;
    }

    public static ReportTable createGenderBIASNetWeightTable(BIASCounts counts) throws PuckException {
        ReportTable result = new ReportTable(counts.size(), 5);
        result.setTitle("Gender BIAS (net weight)");
        result.set(0, 0, " ");
        result.set(0, 1, "A or U");
        result.set(0, 2, "U not A");
        result.set(0, 3, "A not U");
        result.set(0, 4, "Diff");
        int countIndex = 1;
        while (countIndex < counts.size()) {
            BIASCount count = counts.get(countIndex);
            result.set(countIndex, 0, countIndex);
            result.set(countIndex, 1, count.getCoo());
            result.set(countIndex, 2, count.getUterine());
            result.set(countIndex, 3, count.getAgnatic());
            result.set(countIndex, 4, MathUtils.roundHundredth(count.getUterine() - count.getAgnatic()));
            ++countIndex;
        }
        return result;
    }

    public static ReportChart createGenderBIASWeightChart(BIASCounts counts) {
        ReportChart result = new ReportChart("Gender BIAS (weight)", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Generational Level");
        result.setLinesLegend("% Individuals");
        result.setVerticalMax(100.0);
        result.setIntegerHorizontalUnit(true);
        result.setLineTitle("Uterine Ancestor Known", 0);
        result.setLineTitle("Agnatic Ancestor Known", 1);
        result.setLineTitle("Agn. and Ut. Ancestor Known", 2);
        int countIndex = 1;
        while (countIndex < counts.size()) {
            BIASCount count = counts.get(countIndex);
            if (count.isPositive()) {
                result.setHeader(MathUtils.toString(countIndex), countIndex);
                result.addValue(countIndex, count.getUterine(), 0);
                result.addValue(countIndex, count.getAgnatic(), 1);
                result.addValue(countIndex, count.getCognatic(), 2);
            }
            ++countIndex;
        }
        return result;
    }

    public static ReportTable createGenderBIASWeightTable(BIASCounts counts) throws PuckException {
        ReportTable result = new ReportTable(counts.size(), 6);
        result.setTitle("Gender BIAS (weight)");
        result.set(0, 0, " ");
        result.set(0, 1, "A or U");
        result.set(0, 2, "U");
        result.set(0, 3, "A");
        result.set(0, 4, "A and U");
        result.set(0, 5, "Diff");
        int countIndex = 1;
        while (countIndex < counts.size()) {
            BIASCount count = counts.get(countIndex);
            result.set(countIndex, 0, countIndex);
            result.set(countIndex, 1, count.getCoo());
            result.set(countIndex, 2, count.getUterine());
            result.set(countIndex, 3, count.getAgnatic());
            result.set(countIndex, 4, count.getCognatic());
            result.set(countIndex, 5, MathUtils.roundHundredth(count.getUterine() - count.getAgnatic()));
            ++countIndex;
        }
        return result;
    }

    public static <E> ReportChart createMapChart(Map<Value, Double[]> map, int idx, String label) throws PuckException {
        ReportChart result;
        if (map == null) {
            result = null;
        } else {
            result = new ReportChart(label, ReportChart.GraphType.STACKED_BARS);
            int index = 0;
            for (Value key : map.keySet()) {
                result.setHeader(key.toString(), index);
                result.addValue(map.get(key)[idx], 0);
                ++index;
            }
        }
        return result;
    }

    public static <E> ReportChart createMapChart(Map<Value, Double[]> map, String label, String[] splitLabels, ReportChart.GraphType graphType) throws PuckException {
        ReportChart result;
        if (map == null) {
            result = null;
        } else {
            result = new ReportChart(label, graphType);
            result.setIntegerHorizontalUnit(true);
            int colIndex = 0;
            HashMap<String, Integer> clusterValueToLineIndex = new HashMap<String, Integer>();
            for (Value key : map.keySet()) {
                String header = null;
                if (key != null) {
                    header = key.toString();
                }
                result.setHeader(header, colIndex);
                int i = 0;
                while (i < splitLabels.length) {
                    String genderLabel = splitLabels[i];
                    Integer lineIndex = (Integer)clusterValueToLineIndex.get(genderLabel);
                    if (lineIndex == null) {
                        lineIndex = clusterValueToLineIndex.size();
                        clusterValueToLineIndex.put(genderLabel, lineIndex);
                        result.setLineTitle(genderLabel, lineIndex);
                    }
                    result.setValue(map.get(key)[i], lineIndex, colIndex);
                    ++i;
                }
                ++colIndex;
            }
        }
        return result;
    }

    public static ReportChart createMeanClusterValuesChart(String criteriaString, Map<Cluster<Individual>, Double> source) throws PuckException {
        ReportChart result;
        if (criteriaString == null || source == null) {
            result = null;
        } else {
            result = new ReportChart("Mean Cluster Values (" + criteriaString + ")", ReportChart.GraphType.SCATTER);
            result.setHeadersLegend("Size");
            result.setLinesLegend("Mean Values");
            result.setLineTitle("Clusters", 0);
            int columnIndex = 0;
            for (Cluster<Individual> cluster : source.keySet()) {
                result.setHeader(cluster.getLabel(), columnIndex);
                result.addValue(cluster.size(), (double)source.get(cluster), 0);
                ++columnIndex;
            }
        }
        return result;
    }

    public static ReportTable createMeanClusterValuesTable(String criteriaString, Clusters<Individual> source, Map<Cluster<Individual>, Double> means) throws PuckException {
        ReportTable result;
        if (criteriaString == null || source == null || means == null) {
            result = null;
        } else {
            result = new ReportTable(source.size() + 1, 4);
            result.setTitle("Mean Cluster Values (" + criteriaString + ")");
            result.set(0, 0, "Cluster");
            result.set(0, 1, "Name");
            result.set(0, 2, "Mean Value");
            result.set(0, 3, "Size");
            int rowIndex = 1;
            for (Cluster<Individual> cluster : source.toListSortedByDescendingSize()) {
                result.set(rowIndex, 0, rowIndex);
                result.set(rowIndex, 1, cluster.getLabel());
                result.set(rowIndex, 2, MathUtils.toString(means.get(cluster)));
                result.set(rowIndex, 3, MathUtils.toString(cluster.size()));
                ++rowIndex;
            }
        }
        return result;
    }

    public static <E> ReportChart createMultiPartitionChart(MultiPartition<E> partitions) throws PuckException {
        ReportChart result = new ReportChart(partitions.getLabel(), ReportChart.GraphType.STACKED_BARS);
        int columnIndex = 0;
        for (Value columnValue : partitions.sortedColValues()) {
            result.setLineTitle(columnValue.toString(), columnIndex);
            int rowIndex = 0;
            for (Value rowValue : partitions.rowValuesSortedBySize()) {
                result.setHeader(rowValue.toString(), rowIndex);
                result.setValue(partitions.frequency(rowValue, columnValue), columnIndex, rowIndex);
                ++rowIndex;
            }
            ++columnIndex;
        }
        return result;
    }

    public static <E> ReportChart createPartitionChart(Partition<E> partition) throws PuckException {
        ReportChart result;
        if (partition == null) {
            result = null;
        } else {
            result = new ReportChart(partition.getLabel(), ReportChart.GraphType.STACKED_BARS);
            int clusterIndex = 0;
            for (Cluster<E> cluster : partition.getClusters().toListSortedByValue()) {
                result.setHeader(cluster.getLabel(), clusterIndex);
                result.addValue(cluster.size(), 0);
                ++clusterIndex;
            }
        }
        return result;
    }

    public static <E> ReportChart createPartitionChart(Partition<E> source, PartitionCriteria partitionCriteria, PartitionCriteria splitCriteria) throws PuckException {
        ReportChart result;
        if (source == null || partitionCriteria == null || !partitionCriteria.isValid()) {
            result = null;
        } else {
            Partition<E> partition = source;
            if (partitionCriteria.getSizeFilter() != null && partitionCriteria.getSizeFilter() != PartitionCriteria.SizeFilter.NONE) {
                partition = PartitionMaker.createCleaned(partition, partitionCriteria.getSizeFilter());
            }
            if (partitionCriteria.getValueFilter() != null && partitionCriteria.getValueFilter() != PartitionCriteria.ValueFilter.NONE) {
                partition = PartitionMaker.createCleaned(partition, partitionCriteria.getValueFilter());
            }
            result = new ReportChart(String.valueOf(partition.getLabel()) + " " + partitionCriteria.toShortString(), ReportChart.GraphType.STACKED_BARS);
            if (partitionCriteria.getCumulationType() == PartitionCriteria.CumulationType.ASCENDANT) {
                int clusterIndex = 0;
                int cumulation = 0;
                for (Cluster<E> cluster : partition.getClusters().toListSortedByValue()) {
                    result.setHeader(cluster.getLabel(), clusterIndex);
                    result.addValue(cumulation += cluster.size(), 0);
                    ++clusterIndex;
                }
            } else if (partitionCriteria.getCumulationType() == PartitionCriteria.CumulationType.DESCENDANT) {
                int clusterIndex = partition.size() - 1;
                int cumulation = 0;
                List<Cluster<E>> clusters = partition.getClusters().toListSortedByValue();
                Collections.reverse(clusters);
                for (Cluster<E> cluster : clusters) {
                    result.setHeader(cluster.getLabel(), clusterIndex);
                    result.setValue(cumulation += cluster.size(), 0, clusterIndex);
                    --clusterIndex;
                }
            } else if (splitCriteria != null && splitCriteria.isValid()) {
                if (splitCriteria.getLabel().equals("GENDER")) {
                    splitCriteria.setValues(new Values(Gender.getChartValueList()));
                }
                int clusterIndex = 0;
                HashMap<String, Integer> clusterValueToLineIndex = new HashMap<String, Integer>();
                for (Cluster<E> cluster : partition.getClusters().toListSortedByValue()) {
                    Partition<E> split = PartitionMaker.create("split", cluster, splitCriteria);
                    result.setHeader(cluster.getLabel(), clusterIndex);
                    for (Cluster<E> splitCluster : split.getClusters().toListSortedByValue()) {
                        String splitClusterLabel = splitCluster.getLabel() == null ? "null" : splitCluster.getLabel();
                        Integer lineIndex = (Integer)clusterValueToLineIndex.get(splitClusterLabel);
                        if (lineIndex == null) {
                            lineIndex = clusterValueToLineIndex.size();
                            clusterValueToLineIndex.put(splitClusterLabel, lineIndex);
                            result.setLineTitle(splitClusterLabel, lineIndex);
                        }
                        result.setValue(splitCluster.size(), lineIndex, clusterIndex);
                    }
                    ++clusterIndex;
                }
            } else {
                int clusterIndex = 0;
                for (Cluster<E> cluster : partition.getClusters().toListSortedByValue()) {
                    result.setHeader(cluster.getLabel(), clusterIndex);
                    result.addValue(cluster.size(), 0);
                    ++clusterIndex;
                }
            }
        }
        return result;
    }

    public static <E> ReportChart createPartitionChartBySize(Partition<E> partition, double threshold) throws PuckException {
        ReportChart result;
        if (partition == null) {
            result = null;
        } else {
            result = new ReportChart(partition.getLabel(), ReportChart.GraphType.STACKED_BARS);
            double minSize = (double)partition.itemsCount() * threshold;
            int clusterIndex = 0;
            for (Cluster<E> cluster : partition.getClusters().toListSortedByDescendingSize()) {
                result.setHeader(cluster.getLabel(), clusterIndex);
                if (!((double)cluster.size() > minSize)) break;
                result.addValue(cluster.size(), 0);
                ++clusterIndex;
            }
        }
        return result;
    }

    public static <E> ReportChart createRamificationChart(Partition<Node<Cluster<E>>>[] partition, int[][] totalSums, String label) {
        ReportChart result = new ReportChart("Sequence Tree Ramification " + label, ReportChart.GraphType.LINES);
        result.setHeadersLegend("Steps (events)");
        result.setLinesLegend("Concentration");
        result.setVerticalMax(100.0);
        result.setIntegerHorizontalUnit(true);
        result.setLineTitle("Male", 0);
        result.setLineTitle("Female", 1);
        result.setLineTitle("Overall", 2);
        int gender = 0;
        while (gender < 3) {
            Value maxValue = partition[gender].maxValue();
            if (maxValue != null) {
                int ascendingIndex = 0;
                while (ascendingIndex < maxValue.intValue()) {
                    Cluster<Node<Cluster<E>>> cluster = partition[gender].getCluster(new Value(ascendingIndex));
                    ArrayList<Double> nodeSizes = new ArrayList<Double>();
                    for (Node<Cluster<E>> node : cluster.getItems()) {
                        Cluster<E> referent = node.getReferent();
                        if (referent == null) continue;
                        nodeSizes.add(new Double(referent.size()));
                    }
                    result.addValue(ascendingIndex, MathUtils.herfindahl(nodeSizes, totalSums[ascendingIndex][gender]), gender);
                    ++ascendingIndex;
                }
            }
            ++gender;
        }
        return result;
    }

    public static <E extends Individualizable> ReportChart createSurvivalChart(Partition<E> source, PartitionCriteria splitCriteria) throws PuckException {
        ReportChart result;
        if (source == null || splitCriteria == null || !splitCriteria.isValid()) {
            result = null;
        } else {
            Partition<Individual> partition = PartitionMaker.individualize(source, new PartitionCriteria(source.getLabel()));
            Partition<Individual> splitPartition = PartitionMaker.create("split", new Individuals(partition.getItemsAsList()), splitCriteria);
            result = new ReportChart(String.valueOf(partition.getLabel()) + " Survival Curves", ReportChart.GraphType.LINES);
            result.setIntegerHorizontalUnit(true);
            result.setVerticalMax(100.0);
            HashMap<String, Integer> clusterValueToLineIndex = new HashMap<String, Integer>();
            int nrClusters = partition.maxValue().intValue();
            int nrLines = splitPartition.getClusters().size() + 1;
            double[][] values = new double[nrClusters][nrLines];
            for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()) {
                Partition<Individual> split = PartitionMaker.create("split", new Individuals(cluster.getItems()), splitCriteria);
                int clusterIndex = -1;
                if (cluster.getValue() != null && cluster.getValue().intValue() > -1) {
                    clusterIndex = cluster.getValue().intValue();
                    result.setHeader(cluster.getLabel(), clusterIndex);
                }
                for (Cluster<Individual> splitCluster : split.getClusters().toListSortedByValue()) {
                    String splitClusterLabel = splitCluster.getLabel() == null ? "Null" : splitCluster.getLabel();
                    Integer lineIndex = (Integer)clusterValueToLineIndex.get(splitClusterLabel);
                    if (lineIndex == null) {
                        lineIndex = clusterValueToLineIndex.size();
                        clusterValueToLineIndex.put(splitClusterLabel, lineIndex);
                        result.setLineTitle(splitClusterLabel, lineIndex);
                    }
                    int index = 0;
                    while (index < clusterIndex) {
                        double[] dArray = values[index];
                        int n = lineIndex;
                        dArray[n] = dArray[n] + (double)splitCluster.size();
                        ++index;
                    }
                    if (clusterIndex >= 0) continue;
                    index = 0;
                    while (index < nrClusters) {
                        double[] dArray = values[index];
                        int n = lineIndex;
                        dArray[n] = dArray[n] + (double)splitCluster.size();
                        ++index;
                    }
                }
                int index = 0;
                while (index < clusterIndex) {
                    double[] dArray = values[index];
                    int n = nrLines - 1;
                    dArray[n] = dArray[n] + (double)cluster.size();
                    ++index;
                }
                if (clusterIndex >= 0) continue;
                index = 0;
                while (index < nrClusters) {
                    double[] dArray = values[index];
                    int n = nrLines - 1;
                    dArray[n] = dArray[n] + (double)cluster.size();
                    ++index;
                }
            }
            result.setLineTitle("Total", nrLines - 1);
            double[] sum = new double[nrLines + 1];
            int lineIndex = 0;
            while (lineIndex < nrLines) {
                int n = lineIndex;
                sum[n] = sum[n] + values[0][lineIndex];
                ++lineIndex;
            }
            int clusterIndex = 0;
            while (clusterIndex < nrClusters) {
                int lineIndex2 = 0;
                while (lineIndex2 < nrLines) {
                    values[clusterIndex][lineIndex2] = MathUtils.percent(values[clusterIndex][lineIndex2], sum[lineIndex2]);
                    result.setValue(values[clusterIndex][lineIndex2], lineIndex2, clusterIndex);
                    ++lineIndex2;
                }
                ++clusterIndex;
            }
        }
        return result;
    }

    public static Report reportAttributeAndValueStatistics(Net source) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Attributes");
        result.setOrigin("Statistics reporter");
        if (source == null) {
            result.outputs().appendln("Blank source.");
        } else {
            result.setTarget(source.getLabel());
            result.setInputComment("Net: " + source.getLabel());
            AttributeDescriptors descriptors = AttributeWorker.getExogenousAttributeDescriptors(source, null).sort();
            result.outputs().appendln("Label count: " + descriptors.size());
            result.outputs().appendln("Attribute count: " + descriptors.total());
            result.outputs().appendln();
            StringList groupedList = StatisticsReporter.createAttributeDescriptorGroupedList(descriptors);
            result.outputs().appendln(groupedList);
            ReportTable table = StatisticsReporter.createAttributeDescriptorTable(descriptors);
            result.outputs().appendln(table);
            for (String label : descriptors.labels()) {
                AttributeValueDescriptorList valueDescriptors = AttributeWorker.getExogenousAttributeValueDescriptors(source, label).toList().sortByValue();
                logger.debug("value descriptor count={}", (Object)valueDescriptors.size());
                result.outputs().appendln(String.valueOf(label) + ": " + valueDescriptors.size() + " different values");
                result.outputs().appendln(String.valueOf(valueDescriptors.total()) + " occurences");
                ReportTable valueTable = new ReportTable(valueDescriptors.size() + 1, 3);
                valueTable.set(0, 0, "ID");
                valueTable.set(0, 1, "Value");
                valueTable.set(0, 2, "Count");
                int index = 1;
                for (AttributeValueDescriptor valueDescriptor : valueDescriptors) {
                    valueTable.set(index, 0, index);
                    valueTable.set(index, 1, valueDescriptor.getValue());
                    valueTable.set(index, 2, valueDescriptor.getCount());
                    ++index;
                }
                result.outputs().appendln(valueTable);
            }
            result.outputs().appendln();
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportAttributeStatistics(Net source) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Attributes");
        result.setOrigin("Statistics reporter");
        if (source == null) {
            result.outputs().appendln("Blank source.");
        } else {
            result.setTarget(source.getLabel());
            result.setInputComment("Net: " + source.getLabel());
            AttributeDescriptors descriptors = AttributeWorker.getExogenousAttributeDescriptors(source, null).sort();
            result.outputs().appendln("Label count: " + descriptors.size());
            result.outputs().appendln("Attribute count: " + descriptors.total());
            result.outputs().appendln();
            StringList groupedList = StatisticsReporter.createAttributeDescriptorGroupedList(descriptors);
            result.outputs().appendln(groupedList);
            ReportTable table = StatisticsReporter.createAttributeDescriptorTable(descriptors);
            result.outputs().appendln(table);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportAttributeStatistics(Segmentation source) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Attribute statitics.");
        result.setOrigin("Statistics reporter");
        if (source == null) {
            result.outputs().appendln("Blank source.");
        } else {
            result.setTarget(source.getLabel());
            result.setInputComment("Segmentation: " + source.getSummary());
            AttributeDescriptors descriptors = AttributeWorker.getExogenousAttributeDescriptors(source, null);
            result.outputs().appendln("Label count: " + descriptors.size());
            result.outputs().appendln("Attribute count: " + descriptors.total());
            result.outputs().appendln();
            StringList groupedList = StatisticsReporter.createAttributeDescriptorGroupedList(descriptors);
            result.outputs().appendln(groupedList);
            ReportTable table = StatisticsReporter.createAttributeDescriptorTable(descriptors);
            result.outputs().appendln(table);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportAttributeValueStatistics(Net source) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Attribute value statitics.");
        result.setOrigin("Statistics reporter");
        if (source == null) {
            result.outputs().appendln("Blank source.");
        } else {
            result.setTarget(source.getLabel());
            result.setInputComment("Net: " + source.getLabel());
            AttributeValueDescriptorList valueDescriptors = AttributeWorker.getExogenousAttributeValueDescriptors(source).toList().sortByCount().reverse();
            logger.debug("value descriptor count={}", (Object)valueDescriptors.size());
            result.outputs().appendln("Value count: " + valueDescriptors.size());
            result.outputs().appendln("Attribute value count: " + valueDescriptors.total());
            ReportTable valueTable = new ReportTable(valueDescriptors.size() + 1, 3);
            result.setTitle("Value Descriptors");
            valueTable.set(0, 0, "ID");
            valueTable.set(0, 1, "Value");
            valueTable.set(0, 2, "Count");
            int index = 1;
            for (AttributeValueDescriptor valueDescriptor : valueDescriptors) {
                valueTable.set(index, 0, index);
                valueTable.set(index, 1, valueDescriptor.getValue());
                valueTable.set(index, 2, valueDescriptor.getCount());
                ++index;
            }
            result.outputs().appendln(valueTable);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportAttributeValueStatistics(Segmentation source) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Attribute statitics.");
        result.setOrigin("Statistics reporter");
        if (source == null) {
            result.outputs().appendln("Blank source.");
        } else {
            result.setTarget(source.getLabel());
            result.setInputComment("Segmentation: " + source.getSummary());
            result.setTarget(source.getLabel());
            result.setInputComment("Net: " + source.getLabel());
            AttributeValueDescriptorList valueDescriptors = AttributeWorker.getExogenousAttributeValueDescriptors(source).toList().sortByCount().reverse();
            logger.debug("value descriptor count={}", (Object)valueDescriptors.size());
            result.outputs().appendln("Value count: " + valueDescriptors.size());
            result.outputs().appendln("Attribute value count: " + valueDescriptors.total());
            ReportTable valueTable = new ReportTable(valueDescriptors.size() + 1, 3);
            result.setTitle("Value Descriptors");
            valueTable.set(0, 0, "ID");
            valueTable.set(0, 1, "Value");
            valueTable.set(0, 2, "Count");
            int index = 1;
            for (AttributeValueDescriptor valueDescriptor : valueDescriptors) {
                valueTable.set(index, 0, index);
                valueTable.set(index, 1, valueDescriptor.getValue());
                valueTable.set(index, 2, valueDescriptor.getCount());
                ++index;
            }
            result.outputs().appendln(valueTable);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportBasicInformation(Net net, Segmentation source) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Basics");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        if (source.isOn()) {
            result.setInputComment("Segmentation:\n" + source.getSummary());
        }
        StatisticsWorker worker = new StatisticsWorker(net);
        ReportAttributes items = new ReportAttributes();
        StatisticsWorker.Indicator[] indicatorArray = StatisticsWorker.Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticsWorker.Indicator indicator = indicatorArray[n2];
            if (!indicator.equals((Object)StatisticsWorker.Indicator.MEAN_DEPTH) && !indicator.equals((Object)StatisticsWorker.Indicator.MEAN_SPOUSE_DISTANCE_GEN)) {
                worker.addItem(items, indicator);
            }
            ++n2;
        }
        result.outputs().append(items);
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportCompleteness(Segmentation source) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Completeness statistics about a corpus.");
        result.setOrigin("Statistics reporter");
        result.setTarget(source.getLabel());
        if (source.isOn()) {
            result.setInputComment(source.getSummary());
        }
        FiliationCounts counts = StatisticsWorker.completeness(source.getCurrentIndividuals(), 10);
        ReportChart reportChart = StatisticsReporter.createCompletenessChart(counts);
        result.outputs().append(reportChart);
        result.outputs().appendln();
        result.outputs().append(ReportTable.transpose(reportChart.createReportTableWithSum()));
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportFamiliesByHusband(Net net) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Family Spouse Ids (by Husband).");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        ArrayList<String> strings = new ArrayList<String>();
        for (Family family : net.families().toSortedList(FamilyComparator.Sorting.HUSBAND)) {
            String wifeName;
            int wifeId;
            String husbandName;
            int husbandId;
            if (family.getHusband() == null) {
                husbandId = 0;
                husbandName = "";
            } else {
                husbandId = family.getHusband().getId();
                husbandName = family.getHusband().getName();
            }
            if (family.getWife() == null) {
                wifeId = 0;
                wifeName = "";
            } else {
                wifeId = family.getWife().getId();
                wifeName = family.getWife().getName();
            }
            String string = String.valueOf(husbandId) + "\t" + husbandName + "\t" + wifeId + "\t" + wifeName + "\t" + family.getId();
            strings.add(string);
        }
        result.outputs().appendln("Husband\tWife\tFamily");
        for (String string : strings) {
            result.outputs().appendln(string);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportFamiliesByWife(Net net) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Family Spouse Ids (by Wife).");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        ArrayList<String> strings = new ArrayList<String>();
        for (Family family : net.families().toSortedList(FamilyComparator.Sorting.WIFE)) {
            String wifeName;
            int wifeId;
            String husbandName;
            int husbandId;
            if (family.getHusband() == null) {
                husbandId = 0;
                husbandName = "";
            } else {
                husbandId = family.getHusband().getId();
                husbandName = family.getHusband().getName();
            }
            if (family.getWife() == null) {
                wifeId = 0;
                wifeName = "";
            } else {
                wifeId = family.getWife().getId();
                wifeName = family.getWife().getName();
            }
            String string = String.valueOf(wifeId) + "\t" + wifeName + "\t" + husbandId + "\t" + husbandName + "\t" + family.getId();
            strings.add(string);
        }
        result.outputs().appendln("Wife\tHusband\tFamily");
        for (String string : strings) {
            result.outputs().appendln(string);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportGeographyStatistics(Net source) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Geography Statistics");
        result.setOrigin("Statistics reporter");
        if (source == null || source.getGeography2() == null) {
            result.outputs().appendln("Blank source.");
        } else {
            Geography2 geography = source.getGeography2();
            result.setTarget(source.getLabel());
            result.outputs().appendln("* Corpus Geography Statistics");
            result.outputs().appendln("Places:\t\t" + geography.countOfPlaces());
            result.outputs().appendln("Homonyms:\t" + geography.countOfHomonyms());
            result.outputs().appendln("Toponyms:\t\t" + geography.countOfToponyms() + " (main + alternates)");
            int conflictedCount = geography.countOfConflictedPlaces();
            int nameCount = geography.countOfToponyms();
            String conflictedData = String.format("%d / %d names (%s)", conflictedCount, nameCount, ToolBox.buildReadablePercentage(conflictedCount, nameCount));
            result.outputs().appendln("Conflicted places:\t" + conflictedData);
            int ungeocodedCount = geography.countOfUngeocodedPlaces();
            int placeCount = geography.countOfPlaces();
            String ungeocodedData = String.format("%d / %d places (%s)", ungeocodedCount, placeCount, ToolBox.buildReadablePercentage(ungeocodedCount, placeCount));
            result.outputs().appendln("Ungeocoded places:\t" + ungeocodedData);
            int blankCount = geography.getBlankPlaces().size();
            placeCount = geography.countOfPlaces();
            String blankData = String.format("%d / %d places (%s)", blankCount, placeCount, ToolBox.buildReadablePercentage(blankCount, placeCount));
            result.outputs().appendln("Blank places:\t" + blankData);
            AttributeValueDescriptors valueDescriptors = AttributeWorker.getExogenousAttributeValueDescriptors(source, ".*_PLAC.*");
            Places2 places = new Places2(geography.getPlaces().size());
            for (Place2 place : geography.getPlaces()) {
                if (valueDescriptors.getCountOf(place.getToponyms()) != 0L) continue;
                places.add(place);
            }
            int unusedCount = places.size();
            int placeCount2 = geography.countOfPlaces();
            String unusedData = String.format("%d / %d places (%s)", unusedCount, placeCount2, ToolBox.buildReadablePercentage(unusedCount, placeCount2));
            result.outputs().appendln("Unused places:\t" + unusedData);
            result.outputs().appendln("Status:\t\t" + geography.getStatus().toString());
            result.outputs().appendln();
            result.outputs().appendln("* Missing Places");
            valueDescriptors = AttributeWorker.getExogenousAttributeValueDescriptors(source, ".*_PLAC.*");
            AttributeValueDescriptors target = new AttributeValueDescriptors();
            for (AttributeValueDescriptor valueDescriptor : valueDescriptors) {
                if (geography.searchByToponym(valueDescriptor.getValue()) != null) continue;
                target.put(valueDescriptor);
            }
            if (target.isEmpty()) {
                result.outputs().appendln("No attribute place is missing in geography.");
            } else {
                result.outputs().appendln("Place attribute missing in geography:\t" + target.size());
                ReportTable table = new ReportTable(target.size() + 1, 3);
                table.set(0, 0, "");
                table.set(0, 1, "Attribute value");
                table.set(0, 2, "Count");
                int index = 1;
                for (AttributeValueDescriptor valueDescriptor : target) {
                    table.set(index, 0, index);
                    table.set(index, 1, valueDescriptor.getValue());
                    table.set(index, 2, valueDescriptor.getCount());
                    ++index;
                }
                result.outputs().appendln(table);
            }
            result.outputs().appendln("* Corpus Place Attributes \u2013 Corpus Geography statistics");
            result.outputs().appendln("Coming soon\u2026");
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportGraphicsStatistics(Segmentation segmentation, StatisticsCriteria criteria, File sourceFile) throws PuckException {
        Report result;
        if (segmentation == null || criteria == null) {
            result = null;
        } else {
            double[][] consCount;
            Object partition;
            ReportChart chart;
            ArrayList counts;
            Chronometer chrono = new Chronometer();
            result = new Report();
            result.setTitle("Statistics");
            result.setOrigin("Statistics reporter");
            result.setTarget(segmentation.getLabel());
            if (segmentation.isOn()) {
                result.setInputComment("Segmentation:\n" + segmentation.getSummary());
            }
            ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
            ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
            if (criteria.isGenderBIASWeight()) {
                counts = StatisticsWorker.biasWeights(segmentation.getCurrentIndividuals());
                charts.add(StatisticsReporter.createGenderBIASWeightChart(counts));
                tables.add(StatisticsReporter.createGenderBIASWeightTable(counts));
            }
            if (criteria.isGenderBIASNetWeight()) {
                counts = StatisticsWorker.biasNetWeights(segmentation.getCurrentIndividuals());
                charts.add(StatisticsReporter.createGenderBIASNetWeightChart(counts));
                tables.add(StatisticsReporter.createGenderBIASNetWeightTable(counts));
            }
            if (criteria.isComponents()) {
                charts.add(StatisticsReporter.createComponentsChart(segmentation.getCurrentIndividuals(), 1000));
            }
            if (criteria.isGenealogicalCompleteness()) {
                counts = StatisticsWorker.completeness(segmentation.getCurrentIndividuals(), 10);
                chart = StatisticsReporter.createCompletenessChart((FiliationCounts)counts);
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTable()));
            }
            if (criteria.isFratryDistribution()) {
                counts = StatisticsWorker.fratryDistribution(segmentation.getCurrentIndividuals());
                charts.add(StatisticsReporter.createFratryDistributionChart((FiliationCounts)counts));
                tables.add(StatisticsReporter.createFratryDistributionTable((FiliationCounts)counts));
            }
            if (criteria.isFourCousinMarriages() && (chart = StatisticsReporter.createPartitionChart(partition = CircuitFinder.createFirstCousinMarriages(segmentation))) != null) {
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTableWithSum()));
            }
            if (criteria.isAncestorTypes() && (chart = StatisticsReporter.createMultiPartitionChart(partition = CircuitFinder.createAncestorChains(segmentation, criteria.getAncestorTypesDegree()))) != null) {
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTableWithSum()));
            }
            if (criteria.isConsanguineChains() && (chart = StatisticsReporter.createArrayChart("Consanguines per person", consCount = StatisticsWorker.countConsanguinePairs(segmentation, criteria.getConsanguineDegree()), new String[]{"HH", "FF", "HF", "FH"})) != null) {
                chart.setHeadersLegend("Canonic Degree");
                chart.setLinesLegend("Consanguines");
                chart.setIntegerHorizontalUnit(true);
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTable()));
            }
            StringList pajekBuffer = new StringList();
            for (PartitionCriteria partitionCriteria : criteria.getPartitionCriteriaList()) {
                if (!partitionCriteria.isValid()) continue;
                Partition<Individual> partition2 = PartitionMaker.create(segmentation.getLabel(), segmentation.getCurrentIndividuals(), partitionCriteria);
                ReportChart chart2 = StatisticsReporter.createPartitionChart(partition2, partitionCriteria, criteria.getSplitCriteria());
                if (chart2 != null) {
                    charts.add(chart2);
                    tables.add(ReportTable.transpose(chart2.createReportTableWithSum()));
                    if (criteria.isMeanClusterValues() && criteria.getSplitCriteria() != null) {
                        try {
                            Map<Cluster<Individual>, Double> means = StatisticsWorker.meanClusterValues(partition2.getClusters(), criteria.getSplitCriteria());
                            String criteriaString = String.valueOf(partitionCriteria.toShortString()) + "/" + criteria.getSplitCriteria().getLabel();
                            ReportChart meanChart = StatisticsReporter.createMeanClusterValuesChart(criteriaString, means);
                            charts.add(meanChart);
                            tables.add(StatisticsReporter.createMeanClusterValuesTable(criteriaString, partition2.getClusters(), means));
                        }
                        catch (ClassCastException exception) {
                            logger.debug("ClassCastException => No mean cluster value.");
                        }
                    }
                }
                partition2.setLabel(String.valueOf(partition2.getLabel()) + "_" + partitionCriteria.getLabel());
                pajekBuffer.addAll((Collection)PuckUtils.writePajekPartition(partition2, new IndividualComparator(IndividualComparator.Sorting.ID), null));
            }
            int chartIndex = 0;
            while (chartIndex < charts.size()) {
                result.outputs().append((ReportChart)charts.get(chartIndex));
                if (chartIndex % 4 == 3) {
                    result.outputs().appendln();
                }
                ++chartIndex;
            }
            for (ReportTable table : tables) {
                result.outputs().appendln(table.getTitle());
                result.outputs().appendln(table);
            }
            if (pajekBuffer.length() != 0) {
                File targetFile = ToolBox.setExtension(ToolBox.addToName(sourceFile, "-Partitions"), ".paj");
                ReportRawData rawData = new ReportRawData("Export Partitions to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln("Partitions");
                result.outputs().append(rawData);
            }
            result.setTimeSpent(chrono.stop().interval());
        }
        return result;
    }

    public static Report reportHomonyms(Net net, int nrParts, int minCount) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Homonyms.");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        Report simpleReport = new Report("List");
        Report detailedReport = new Report("Details");
        Report relativesReport = new Report("Relatives");
        TreeMap<String, Individuals> ids = new TreeMap<String, Individuals>();
        TreeMap<String, Integer> count = new TreeMap<String, Integer>();
        for (Individual individual : net.individuals()) {
            String name = individual.getNamePart(nrParts);
            Individuals id = (Individuals)ids.get(name);
            if (id == null) {
                id = new Individuals();
                ids.put(name, id);
                count.put(name, 1);
            } else {
                count.put(name, (Integer)count.get(name) + 1);
            }
            id.put(individual);
        }
        String simpleLabelsLine = "Name\tIds";
        String detailedLabelsLine = "Name\tIds";
        String relativesLabelsLine = "Name\tIds";
        simpleReport.outputs().appendln(simpleLabelsLine);
        StringList labels = IndividualValuator.getAttributeLabels(net.individuals());
        for (String label : labels) {
            detailedLabelsLine = String.valueOf(detailedLabelsLine) + "\t" + label;
        }
        for (KinType kinType : KinType.basicTypes()) {
            relativesLabelsLine = String.valueOf(relativesLabelsLine) + "\t" + (Object)((Object)kinType);
        }
        detailedReport.outputs().appendln(detailedLabelsLine);
        relativesReport.outputs().appendln(relativesLabelsLine);
        for (String name : ids.keySet()) {
            if ((Integer)count.get(name) < minCount) continue;
            String simpleValuesLine = String.valueOf(name) + "\t";
            Individuals indis = (Individuals)ids.get(name);
            detailedReport.outputs().appendln(simpleValuesLine);
            relativesReport.outputs().appendln(simpleValuesLine);
            for (Individual indi : indis.toSortedList()) {
                simpleValuesLine = String.valueOf(simpleValuesLine) + indi.getId() + ";";
                String detailedValuesLine = "\t" + indi.getId();
                String relativesValuesLine = "\t" + indi.getId();
                for (String label : labels) {
                    detailedValuesLine = String.valueOf(detailedValuesLine) + "\t" + Trafo.asNonNull(indi.getAttributeValue(label));
                }
                for (KinType kinType : KinType.basicTypes()) {
                    relativesValuesLine = String.valueOf(relativesValuesLine) + "\t" + indi.getKin(kinType);
                }
                detailedReport.outputs().appendln(detailedValuesLine);
                relativesReport.outputs().appendln(relativesValuesLine);
            }
            simpleReport.outputs().appendln(simpleValuesLine);
        }
        result.outputs().append(simpleReport);
        result.outputs().append(detailedReport);
        result.outputs().append(relativesReport);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividuals(Segmentation segmentation, List<IndividualComparator.Sorting> sorting, List<String> details) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Individual List.");
        result.setOrigin("Statistics reporter");
        result.setTarget(segmentation.getLabel());
        result.inputs().add("Sorting", sorting.toString());
        for (Individual individual : segmentation.getCurrentIndividuals().toSortedList(sorting)) {
            String lastname;
            String signature = null;
            String firstname = individual.getFirstName();
            if (firstname == null) {
                firstname = "-";
            }
            if ((lastname = individual.getLastName()) == null) {
                lastname = "-";
            }
            switch (sorting.get(0)) {
                case ID: {
                    signature = String.valueOf(individual.getId()) + "\t" + firstname + "\t" + lastname;
                    break;
                }
                case FIRSTN: {
                    signature = String.valueOf(firstname) + "\t" + lastname + "\t" + individual.getId();
                    break;
                }
                case LASTN: {
                    signature = String.valueOf(lastname) + "\t" + firstname + "\t" + individual.getId();
                }
            }
            if (details != null) {
                signature = String.valueOf(signature) + "\t";
                for (String label : details) {
                    if (label.equals("PARENTS")) {
                        signature = String.valueOf(signature) + individual.getFather() + "\t" + individual.getMother() + "\t";
                        continue;
                    }
                    if (label.equals("SPOUSES")) {
                        for (Individual spouse : individual.spouses()) {
                            signature = String.valueOf(signature) + spouse + " ";
                        }
                        signature = String.valueOf(signature) + "\t";
                        continue;
                    }
                    if (label.equals("PARTNERS")) {
                        for (Individual spouse : individual.getPartners()) {
                            signature = String.valueOf(signature) + spouse + " ";
                        }
                        signature = String.valueOf(signature) + "\t";
                        continue;
                    }
                    if (label.equals("CHILDREN")) {
                        for (Individual child : individual.children()) {
                            signature = String.valueOf(signature) + child + " ";
                        }
                        signature = String.valueOf(signature) + "\t";
                        continue;
                    }
                    if (label.equals("MARR_DATE")) {
                        for (Family family : individual.getPersonalFamilies()) {
                            signature = String.valueOf(signature) + FamilyValuator.get(family, label) + "\t";
                        }
                        continue;
                    }
                    signature = String.valueOf(signature) + IndividualValuator.get(individual, label) + "\t";
                }
            }
            if (signature == null) continue;
            result.outputs().append(signature);
            result.outputs().appendln();
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividuals(Segmentation segmentation, String partitionLabel, IndividualComparator.Sorting sorting) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Individual List.");
        result.setOrigin("Statistics reporter");
        result.setTarget(segmentation.getLabel());
        result.inputs().add("Partition", partitionLabel);
        result.inputs().add("Sorting", sorting.toString());
        Partition<Individual> partition = PartitionMaker.createRaw(partitionLabel, segmentation.getCurrentIndividuals());
        for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()) {
            if (cluster == null || cluster.getValue() == null) continue;
            result.outputs().append(String.valueOf(cluster.getValue().toString()) + "\t(" + cluster.count() + ")");
            result.outputs().appendln();
            for (Individual individual : new Individuals(cluster.getItems()).toSortedList(sorting)) {
                String signature = null;
                switch (sorting) {
                    case ID: {
                        signature = String.valueOf(individual.getId()) + "\t" + individual.getFirstName() + "\t" + individual.getLastName();
                        break;
                    }
                    case FIRSTN: {
                        signature = String.valueOf(individual.getFirstName()) + "\t" + individual.getLastName() + "\t" + individual.getId();
                        break;
                    }
                    case LASTN: {
                        signature = String.valueOf(individual.getLastName()) + "\t" + individual.getFirstName() + "\t" + individual.getId();
                    }
                }
                if (signature == null) continue;
                result.outputs().append(signature);
                result.outputs().appendln();
            }
            result.outputs().appendln();
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportQuickReview(Net net, Segmentation source, File file) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Quick Review");
        result.setTitle("Quick Review");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        Report controls = ControlReporter.reportControls(source, ResourceBundle.getBundle("org.tip.puckgui.messages"), ControlReporter.getDefaultControls());
        Report basics = StatisticsReporter.reportBasicInformation(net, source);
        Report attributes = StatisticsReporter.reportAttributeAndValueStatistics(net);
        Report statistics = StatisticsReporter.reportGraphicsStatistics(source, StatisticsCriteria.getDefaultCriteria(), file);
        Report census = CensusReporter.reportShortCensus(source, CensusCriteria.getDefaultCriteria());
        result.outputs().append(controls);
        result.outputs().append(basics);
        result.outputs().append(attributes);
        result.outputs().append(statistics);
        result.outputs().append(census);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSynopsis(String directory) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Basic statistics about a corpus");
        result.setOrigin("Statistics reporter");
        StringList listStatistics = new StringList();
        String headline = "General statistics";
        StatisticsWorker.Indicator[] indicatorArray = StatisticsWorker.Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticsWorker.Indicator indicator = indicatorArray[n2];
            headline = String.valueOf(headline) + "\t" + indicator.toString();
            ++n2;
        }
        result.outputs().appendln(headline);
        StringList listBias = new StringList();
        listBias.appendln("Gender bias\tA1\tA2\tA3\tA4\tA5\tU1\tU2\tU3\tU4\tU5");
        StringList listCensus = new StringList();
        listCensus.appendln("First cousin marriages\tParPat\tCross\tParMat");
        String pattern = "XX(X)XX";
        String classificationType = "LINE";
        File folder = new File(directory);
        File[] fileArray = folder.listFiles();
        int n3 = fileArray.length;
        int n4 = 0;
        while (n4 < n3) {
            File file = fileArray[n4];
            try {
                Net net = PuckManager.loadNet(file);
                listStatistics.appendln(StatisticsWorker.getValueString(net));
                listBias.appendln(StatisticsWorker.listBiasWeights(net));
                listCensus.appendln(StatisticsWorker.listCircuitFrequencies(new Segmentation(net), classificationType, pattern));
            }
            catch (PuckException e) {
                System.err.println("Not a corpus file: " + file.getName());
            }
            ++n4;
        }
        result.outputs().append(listStatistics);
        result.outputs().appendln();
        result.outputs().append(listBias);
        result.outputs().appendln();
        result.outputs().append(listCensus);
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportTerms(Segmentation segmentation) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Kin term list");
        result.setOrigin("Statistics reporter");
        TreeMap<String, String> terms = new TreeMap<String, String>();
        for (Individual individual : segmentation.getCurrentIndividuals().toSortedList()) {
            String term = individual.getName();
            if (!StringUtils.isNotEmpty((CharSequence)term) || term.charAt(0) == '[') continue;
            String type = individual.getAttributeValue("Type");
            String types = (String)terms.get(term);
            types = types == null ? type : String.valueOf(types) + ";" + type;
            terms.put(term, types);
        }
        for (String term : terms.keySet()) {
            result.outputs().appendln(String.valueOf(term) + "\t" + (String)terms.get(term));
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUnionHomonyms(Net net, int minCount) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Homonyms.");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        TreeMap<String, String> ids = new TreeMap<String, String>();
        TreeMap<String, Integer> count = new TreeMap<String, Integer>();
        for (Family family : net.families()) {
            if (family.getHusband() == null || family.getWife() == null) continue;
            String name = family.toNameString();
            String id = (String)ids.get(name);
            if (id == null) {
                ids.put(name, String.valueOf(family.getId()));
                count.put(name, 1);
                continue;
            }
            ids.put(name, String.valueOf(id) + ";" + family.getId());
            count.put(name, (Integer)count.get(name) + 1);
        }
        result.outputs().appendln("Name\tIds");
        for (String name : ids.keySet()) {
            if ((Integer)count.get(name) < minCount) continue;
            result.outputs().appendln(String.valueOf(name) + "\t" + (String)ids.get(name));
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

