/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import org.tip.puck.net.Attributes;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleActorComparator;
import org.tip.puck.net.relations.roles.RoleActors;
import org.tip.puck.net.relations.roles.RoleRelations;
import org.tip.puck.util.Numberable;

public class RoleRelation
implements Numberable,
Comparable<RoleRelation> {
    private int id;
    private int typedId;
    private RelationModel model;
    private String name;
    private RoleActors actors;
    private Attributes attributes;

    public RoleRelation(int id) {
        this.id = id;
        this.actors = new RoleActors();
    }

    public RoleRelation clone() {
        RoleRelation result = new RoleRelation(this.id);
        for (RoleActor actor : this.actors) {
            result.getActors().add(actor);
        }
        return result;
    }

    @Override
    public int compareTo(RoleRelation other) {
        int result;
        RoleActor self = this.getSelf();
        RoleActor otherSelf = other.getSelf();
        if (self.hasSelfName() && !otherSelf.hasSelfName()) {
            result = -1;
        } else if (!self.hasSelfName() && otherSelf.hasSelfName()) {
            result = 1;
        } else {
            result = new RoleActorComparator().compare(this.getSelf(), other.getSelf());
            if (result == 0) {
                result = this.actors.compareTo(other.getActors());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = this.actors.equals(((RoleRelation)obj).getActors());
        return result;
    }

    public RoleActors getActors() {
        return this.actors;
    }

    public RoleActors getActors(Role role) {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this.getActors()) {
            if (!actor.getIndividual().equals(role)) continue;
            result.addNew(actor);
        }
        return result;
    }

    public RoleActors getActorsByRole(MetaRole metaRole) {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this.getActors()) {
            if (!actor.getRole().equals(metaRole)) continue;
            result.addNew(actor);
        }
        return result;
    }

    public RoleActors getActorsByRoleName(String roleName) {
        RoleActors result;
        if (roleName == null) {
            result = this.actors;
        } else {
            result = new RoleActors();
            for (RoleActor actor : this.actors) {
                if (!actor.getRole().getName().equals(roleName)) continue;
                result.add(actor);
            }
        }
        return result;
    }

    public RoleActors getActorsByRoleNameWithUnspecific(String roleName, RoleRelations relations) {
        RoleActors result = this.getSelf().getActorsByRoleNameWithUnspecific(roleName, relations);
        return result;
    }

    public Role getByRoleName(String metaRoleName) {
        Role result = null;
        for (RoleActor actor : this.actors) {
            if (!actor.getRole().getName().equals(metaRoleName)) continue;
            result = actor.getIndividual();
            break;
        }
        return result;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public Roles getRoles() {
        Roles result = new Roles();
        for (RoleActor actor : this.getActors()) {
            result.addNew(actor.getRole());
        }
        return result;
    }

    public RoleActor getPrimaryAlter() {
        RoleActor result = this.actors.size() < 2 ? null : (RoleActor)this.actors.get(1);
        return result;
    }

    public RoleActor getSelf() {
        RoleActor result = (RoleActor)this.actors.get(0);
        return result;
    }

    public String getSelfAsString() {
        RoleActor self = this.getSelf();
        String result = self == null ? null : self.toString();
        return result;
    }

    public Role getSelfTerm() {
        RoleActor self = this.getSelf();
        Role result = self == null ? null : this.getSelf().getIndividual();
        return result;
    }

    public boolean hasActor(Role role, MetaRole metaRole) {
        boolean result = false;
        for (RoleActor actor : this.actors) {
            if (!actor.getIndividual().equals(role) || !actor.getRole().equals(metaRole)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasActor(RoleActor actor) {
        boolean result = actor == null ? false : this.hasActor(actor.getIndividual(), actor.getRole());
        return result;
    }

    @Override
    public String hashKey() {
        String result = "" + this.id;
        return result;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        String result = String.valueOf(this.id) + "\t" + this.actors.toListSortedByRoles();
        return result;
    }

    int getActorCount() {
        return this.actors.size();
    }
}

