/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.kinoath;

import java.awt.Rectangle;
import java.io.IOException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.kindata.UnsortablePointsException;
import nl.mpi.kinnate.svg.DiagramSettings;
import nl.mpi.kinnate.svg.EntitySvg;
import nl.mpi.kinnate.svg.OldFormatException;
import nl.mpi.kinnate.svg.SvgDiagram;
import nl.mpi.kinnate.svg.SvgUpdateHandler;
import nl.mpi.kinoath.graph.DefaultSorter;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGDocument;

public class KinOathDiagram {
    private static final Logger logger = LoggerFactory.getLogger(KinOathDiagram.class);
    private SvgDiagram svgDiagram;

    public KinOathDiagram(EntityData[] source) {
        long timer = DateTimeUtils.currentTimeMillis();
        EventListener eventListener = new EventListener(){

            @Override
            public void handleEvent(Event event) {
            }
        };
        EntitySvg entitySvg = new EntitySvg(eventListener);
        this.svgDiagram = new SvgDiagram(new DiagramSettings(){

            public String defaultSymbol() {
                return "rhombus";
            }

            public RelationTypeDefinition[] getRelationTypeDefinitions() {
                return new DataTypes().getReferenceRelations();
            }

            public boolean highlightRelationLines() {
                return true;
            }

            public boolean showDateLabels() {
                return true;
            }

            public boolean showDiagramBorder() {
                return true;
            }

            public boolean showExternalLinks() {
                return true;
            }

            public boolean showIdLabels() {
                return true;
            }

            public boolean showKinTermLines() {
                return true;
            }

            public boolean showKinTypeLabels() {
                return true;
            }

            public boolean showLabels() {
                return true;
            }

            public boolean showSanguineLines() {
                return true;
            }

            public boolean snapToGrid() {
                return true;
            }

            public void storeAllData(SVGDocument doc) {
            }
        }, entitySvg);
        try {
            this.svgDiagram.generateDefaultSvg(eventListener, (GraphSorter)new DefaultSorter());
            SvgUpdateHandler svgUpdateHandler = new SvgUpdateHandler(this.svgDiagram);
            this.svgDiagram.graphData.setEntitys(source);
            svgUpdateHandler.drawEntities(new Rectangle(1000, 600));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (DOMException exception) {
            exception.printStackTrace();
        }
        catch (OldFormatException exception) {
            exception.printStackTrace();
        }
        catch (UnsortablePointsException exception) {
            exception.printStackTrace();
        }
        logger.debug("...done (" + (DateTimeUtils.currentTimeMillis() - timer) + " ms)");
    }

    public Document getDocument() {
        SVGDocument result = this.svgDiagram == null ? null : this.svgDiagram.getDoc();
        return result;
    }

    public void setEntities(EntityData[] source) {
        this.svgDiagram.graphData.setEntitys(source);
    }
}

