/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.onemode;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.tip.puck.graphs.onemode.GraphModeTransformer;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.util.RandomGenerator;

public class SiblingMarriageDistribution {
    private Map<Integer, Vector<Integer>> distribMapMale = new HashMap<Integer, Vector<Integer>>();
    private Map<Integer, Vector<Integer>> distribMapFemale = new HashMap<Integer, Vector<Integer>>();

    public SiblingMarriageDistribution(Net net) {
        for (Individual ind : net.individuals()) {
            Vector<Integer> vec;
            int s = GraphModeTransformer.monogamousSameSexSiblings(ind).size();
            int m = ind.spouses().size();
            int k = m + s;
            if (ind.getGender() == Gender.MALE) {
                if (this.distribMapMale.containsKey(k)) {
                    this.distribMapMale.get(k).add(m);
                    continue;
                }
                vec = new Vector<Integer>();
                vec.add(m);
                this.distribMapMale.put(k, vec);
                continue;
            }
            if (ind.getGender() != Gender.FEMALE) continue;
            if (this.distribMapFemale.containsKey(k)) {
                this.distribMapFemale.get(k).add(m);
                continue;
            }
            vec = new Vector();
            vec.add(m);
            this.distribMapFemale.put(k, vec);
        }
    }

    private boolean isKeyCloser(int key, int bestKey, int k) {
        int deltaBest;
        int deltaKey = key - k;
        if (deltaKey < 0) {
            deltaKey = -deltaKey;
        }
        if ((deltaBest = bestKey - k) < 0) {
            deltaBest = -deltaBest;
        }
        return deltaKey < deltaBest;
    }

    public int howManySpouses(Gender gender, int k) {
        Vector<Integer> distrib = null;
        boolean aprox = false;
        int bestKey = -1;
        if (gender == Gender.MALE) {
            if (this.distribMapMale.containsKey(k)) {
                distrib = this.distribMapMale.get(k);
            } else {
                aprox = true;
                for (int key : this.distribMapMale.keySet()) {
                    if (bestKey >= 0 && !this.isKeyCloser(key, bestKey, k)) continue;
                    bestKey = key;
                }
                distrib = this.distribMapMale.get(bestKey);
            }
        } else if (gender == Gender.FEMALE) {
            if (this.distribMapFemale.containsKey(k)) {
                distrib = this.distribMapFemale.get(k);
            } else {
                aprox = true;
                for (int key : this.distribMapFemale.keySet()) {
                    if (bestKey >= 0 && !this.isKeyCloser(key, bestKey, k)) continue;
                    bestKey = key;
                }
                distrib = this.distribMapFemale.get(bestKey);
            }
        }
        int size = distrib.size();
        int index = RandomGenerator.instance().random.nextInt(size);
        int m = distrib.get(index);
        if (aprox) {
            if (bestKey < 0) {
                return 0;
            }
            double dm = m;
            double dk = k;
            double dbk = bestKey;
            double dres = dm / dbk * dk;
            return (int)dres;
        }
        return m;
    }

    public String toString() {
        Vector<Integer> distrib;
        String str = "";
        str = String.valueOf(str) + "Male Distribution\n";
        for (Integer k : this.distribMapMale.keySet()) {
            distrib = this.distribMapMale.get(k);
            str = String.valueOf(str) + "\tk=" + k + "\n";
            for (Integer m : distrib) {
                str = String.valueOf(str) + "\t\tm=" + m + "; s=" + (k - m) + "\n";
            }
        }
        str = String.valueOf(str) + "\nFemale Distribution\n";
        for (Integer k : this.distribMapFemale.keySet()) {
            distrib = this.distribMapFemale.get(k);
            str = String.valueOf(str) + "\tk=" + k + "\n";
            for (Integer m : distrib) {
                str = String.valueOf(str) + "\t\tm=" + m + "; s=" + (k - m) + "\n";
            }
        }
        return str;
    }
}

