/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.onemode;

import org.tip.puck.graphs.onemode.ShuffleCriteria;
import org.tip.puck.net.Net;
import org.tip.puck.report.Report;
import org.tip.puck.util.Chronometer;

public class ShuffleReporter {
    public static Report reportReshuffling(Net sourceNet, ShuffleCriteria criteria) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Shuffle One Mode Graph.");
        result.setOrigin("Shuffle reporter");
        result.setTarget(sourceNet.getLabel());
        result.inputs().add("Edge permutations per step", criteria.getSwitchesPerIteration());
        result.inputs().add("Maximum generational distance", criteria.getMaxGenerationalDistance());
        result.inputs().add("Minimum shuffle percentage (stop condition)", criteria.getMinShufflePercentage());
        result.inputs().add("Minimum stable iterations (stop condition)", criteria.getMinStableIterations());
        result.inputs().add("Graph mode", criteria.getMode().toString());
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

