/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.census.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainFinder;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.Value;

public class TermCensus {
    Partition<Chain> chains = new Partition();
    Partition<String> consanguinealTerms;
    Partition<String> affinalTerms;
    List<String> terms;
    Individual maleEgo;
    Individual femaleEgo;
    Map<String, boolean[]> termProperties;
    String cousinTerminology;

    public TermCensus(Segmentation segmentation) {
        this.chains.setLabel("ALTERNAME");
        for (Individual ego : segmentation.getCurrentIndividuals()) {
            if (!ego.getName().equals("[Ego]")) continue;
            if (ego.isMale()) {
                this.maleEgo = ego;
                continue;
            }
            if (!ego.isFemale()) continue;
            this.femaleEgo = ego;
        }
        for (Individual alter : segmentation.getCurrentIndividuals()) {
            if (!StringUtils.isNotEmpty((CharSequence)alter.getName()) || alter.getName().equals("[Ego]")) continue;
            HashSet<Individual> visited = new HashSet<Individual>();
            visited.add(this.maleEgo);
            ChainFinder.expandShortest(this.chains, new Chain(this.maleEgo), alter, 1000, 100, visited);
            visited = new HashSet();
            visited.add(this.femaleEgo);
            ChainFinder.expandShortest(this.chains, new Chain(this.femaleEgo), alter, 1000, 100, visited);
        }
    }

    public void analyze() {
        this.consanguinealTerms = new Partition();
        this.affinalTerms = new Partition();
        this.terms = new ArrayList<String>();
        this.termProperties = new TreeMap<String, boolean[]>();
        this.cousinTerminology = "";
        for (Cluster<Chain> cluster : this.chains.getClusters()) {
            this.terms.add(cluster.getValue().toString());
            boolean[] properties = new boolean[4];
            boolean parallelCousinTerm = false;
            boolean crossCousinTerm = false;
            boolean siblingTerm = false;
            HashSet<Gender> gender = new HashSet<Gender>();
            HashSet<Value> generation = new HashSet<Value>();
            HashSet<Integer> length = new HashSet<Integer>();
            HashSet<Value> bifurcation = new HashSet<Value>();
            for (Chain chain : cluster.getItems()) {
                if (chain.dim() == 1) {
                    this.consanguinealTerms.put(cluster.getValue().toString(), ChainValuator.get(chain, "SKEW"));
                } else {
                    this.affinalTerms.put(cluster.getValue().toString(), ChainValuator.get(chain, "SKEW"));
                }
                gender.add(chain.getLast().getGender());
                generation.add(ChainValuator.get(chain, "SKEWSUM"));
                length.add(chain.size());
                bifurcation.add(ChainValuator.get(chain, "LINE"));
                if (!ChainValuator.get(chain, "SKEW").equals(new Value(0))) continue;
                if (ChainValuator.get(chain, "DEGREE_ROM").equals(new Value(2))) {
                    siblingTerm = true;
                    continue;
                }
                if (ChainValuator.get(chain, "LINE").equals(new Value(FiliationType.COGNATIC))) {
                    crossCousinTerm = true;
                    continue;
                }
                parallelCousinTerm = true;
            }
            if (gender.size() == 1) {
                properties[0] = true;
            }
            if (generation.size() == 1) {
                properties[1] = true;
            }
            if (bifurcation.size() == 1 || bifurcation.contains(new Value(FiliationType.COGNATIC))) {
                properties[2] = true;
            }
            if (length.size() > 1) {
                properties[3] = true;
            }
            this.termProperties.put(cluster.getValue().toString(), properties);
            if (parallelCousinTerm && crossCousinTerm && siblingTerm) {
                this.cousinTerminology = "GENERATIONAL";
                continue;
            }
            if (parallelCousinTerm && crossCousinTerm) {
                if (this.cousinTerminology.equals("GENERATIONAL")) continue;
                this.cousinTerminology = "LINEAL";
                continue;
            }
            if (parallelCousinTerm && siblingTerm) {
                if (this.cousinTerminology.equals("GENERATIONAL")) continue;
                this.cousinTerminology = "BIFURCATE-MERGING";
                continue;
            }
            if (!this.cousinTerminology.equals("")) continue;
            this.cousinTerminology = "DESCRIPTIVE";
        }
        Collections.sort(this.terms);
    }

    public Partition<String> findReciprocalTerms() {
        Partition<String> result = new Partition<String>();
        for (Chain chain : this.chains.getItems()) {
            Chain inverseChain = chain.reflect();
            Individual ego = null;
            if (inverseChain.getFirst().isMale()) {
                ego = this.maleEgo;
            } else if (inverseChain.getFirst().isFemale()) {
                ego = this.femaleEgo;
            }
            Partition<Chain> reciprocalChains = ChainFinder.getKin(ego, inverseChain.signature(Notation.POSITIONAL));
            for (Chain reciprocalChain : reciprocalChains.getItems()) {
                result.put(reciprocalChain.getLast().getName(), new Value(chain.getLast().getName()));
            }
        }
        return result;
    }

    public Partition<String> findTermProducts() {
        Partition<String> result = new Partition<String>();
        for (Chain chain1 : this.chains.getItems()) {
            for (Chain chain2 : this.chains.getItems()) {
                String[] terms = new String[]{chain1.getLast().getName(), chain2.getLast().getName()};
                Partition<Chain> productChains = ChainFinder.getKin(chain1.getLast(), chain2.signature(Notation.POSITIONAL));
                for (Chain productChain : productChains.getItems()) {
                    result.put(productChain.getLast().getName(), new Value(terms));
                }
            }
        }
        return result;
    }

    public List<String> getTerms() {
        return this.terms;
    }

    public Map<String, boolean[]> getTermProperties() {
        return this.termProperties;
    }

    public Partition<String> getConsanguinealTerms() {
        return this.consanguinealTerms;
    }

    public Partition<String> getAffinalTerms() {
        return this.affinalTerms;
    }

    public String getCousinTerminology() {
        return this.cousinTerminology;
    }

    public Partition<Chain> getChains() {
        return this.chains;
    }
}

