/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.alliancenets;

import java.util.HashSet;
import java.util.Set;
import org.tip.puck.alliancenets.Alliance;

public class Group
implements Cloneable {
    private int id;
    private Set<Alliance> inEdges;
    private Set<Alliance> outEdges;
    private int inDegree;
    private int outDegree;
    private int birth;
    private double prIn;
    private double prInLast;
    private double prOut;
    private double prOutLast;
    private double genweight;
    private boolean flag;

    public Group(int id) {
        this.id = id;
        this.inDegree = 0;
        this.outDegree = 0;
        this.birth = -1;
        this.inEdges = new HashSet<Alliance>();
        this.outEdges = new HashSet<Alliance>();
    }

    public Group clone() {
        Group clonedNode = new Group(this.id);
        return clonedNode;
    }

    public int getId() {
        return this.id;
    }

    public Set<Alliance> getInEdges() {
        return this.inEdges;
    }

    public Set<Alliance> getOutEdges() {
        return this.outEdges;
    }

    public int getInDegree() {
        return this.inDegree;
    }

    public int getOutDegree() {
        return this.outDegree;
    }

    public int getBirth() {
        return this.birth;
    }

    public void setBirth(int birth) {
        this.birth = birth;
    }

    public double getPrIn() {
        return this.prIn;
    }

    public void setPrIn(double prIn) {
        this.prIn = prIn;
    }

    double getPrInLast() {
        return this.prInLast;
    }

    void setPrInLast(double prInLast) {
        this.prInLast = prInLast;
    }

    public double getPrOut() {
        return this.prOut;
    }

    public void setPrOut(double prOut) {
        this.prOut = prOut;
    }

    double getPrOutLast() {
        return this.prOutLast;
    }

    void setPrOutLast(double prOutLast) {
        this.prOutLast = prOutLast;
    }

    public double getGenweight() {
        return this.genweight;
    }

    public void setGenweight(double genweight) {
        this.genweight = genweight;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    void addInEdge(Alliance alliance) {
        this.inEdges.add(alliance);
        ++this.inDegree;
    }

    void addOutEdge(Alliance alliance) {
        this.outEdges.add(alliance);
        ++this.outDegree;
    }

    public double getTotalInputWeight() {
        double total = 0.0;
        for (Alliance alliance : this.inEdges) {
            total += alliance.getWeight();
        }
        return total;
    }

    public double getTotalOutputWeight() {
        double total = 0.0;
        for (Alliance alliance : this.outEdges) {
            total += alliance.getWeight();
        }
        return total;
    }

    public void removeInput(Alliance alliance) {
        this.inEdges.remove(alliance);
        --this.inDegree;
    }

    public void removeOutput(Alliance alliance) {
        this.outEdges.remove(alliance);
        --this.outDegree;
    }
}

