package org.tip.puck.net.workers;

import org.apache.commons.lang3.StringUtils;

/**
 * 
 * @author TIP
 */
public class NetNodeType {

	public enum Scope {
		INDIVIDUALS,
		FAMILIES,
		RELATIONS,
	}

	private Scope scope;
	private String relationModelName;

	/**
	 * 
	 */
	public NetNodeType(final Scope scope) {
		//
		this.scope = scope;
		this.relationModelName = null;
	}

	/**
	 * 
	 */
	public NetNodeType(final String relationModelName) {

		if (StringUtils.isBlank(relationModelName)) {
			//
			throw new IllegalArgumentException("Relation Model Name is missing.");

		} else {
			//
			this.scope = Scope.RELATIONS;
			this.relationModelName = relationModelName;
		}
	}

	public String getRelationModelName() {
		return this.relationModelName;
	}

	public Scope getScope() {
		return this.scope;
	}

	public void setRelationModelName(final String relationModelName) {
		this.relationModelName = relationModelName;
	}

	public void setScope(final Scope scope) {
		this.scope = scope;
	}

	/**
	 * 
	 * @return
	 */
	public static boolean isCanonical(final NetNodeType source) {
		boolean result;

		if ((source == null) || (source.getScope() == Scope.RELATIONS)) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public static boolean isFamilies(final NetNodeType source) {
		boolean result;

		if ((source == null) || (source.getScope() == Scope.FAMILIES)) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public static boolean isIndividuals(final NetNodeType source) {
		boolean result;

		if ((source == null) || (source.getScope() == Scope.INDIVIDUALS)) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}
}
