package org.tip.puck.net.relations.workers;

import java.util.List;

import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.report.Report;

public class RelationModelReporter {

	RelationModelStatistics statistics;
	RelationModel model;
	
	public RelationModelReporter (RelationModel model){
		
		this.model = model;
		statistics = new RelationModelStatistics(model);
		
	}
	
	public Report reportModel(int maxIterations){
		Report result;
				
		result = new Report("Model "+model.getName());
		
		result.outputs().append(reportDefinitions());
		result.outputs().append(reportStatistics(maxIterations));
		result.outputs().append(reportReciprocals(maxIterations));
		result.outputs().append(reportCompositions(maxIterations));
		result.outputs().append(reportProblems());
		
		//
		return result;
	}
	
	public Report reportDefinitions(){
		Report result;
		
		result = new Report("Definitions");
		
		result.outputs().appendln("Relation Model "+model.getName());
		result.outputs().appendln();
		
		for (RoleDefinition definition : model.roleDefinitions().toSortedList()){ // .neutralize().toSortedList()){
			result.outputs().appendln(definition);
		}
		
		//
		return result;
		
	}
	
/*	public Report reportNetwork(){
		Report result;
		
		result = new Report("Network");
		
		result.outputs().appendln("Relation Model "+model.getName());
		result.outputs().appendln();
		
		//
		return result;
		
	}*/
	
	public Report reportProblems(){
		Report result;
		
		result = new Report("Problems");
		
		result.outputs().appendln("Relation Model "+model.getName());
		result.outputs().appendln();
		
		boolean noProblems = true;

		Roles undefinedRoles = statistics.undefinedRoles();
		
		if (undefinedRoles.size()>0){
			noProblems = false;
			result.outputs().appendln("Undefined roles: ");
			for (Role role : undefinedRoles){
				result.outputs().appendln(role);
			}
			result.outputs().appendln();
		}
		
		Roles uncomposableRoles = statistics.uncomposableRoles();
		
		if (uncomposableRoles.size()>0){
			noProblems = false;
			result.outputs().appendln("Uncomposable roles: ");
			for (Role role : uncomposableRoles){
				result.outputs().appendln(role);
			}
			result.outputs().appendln();
		}
		
		RoleDefinitions recursiveDefinitions = statistics.recursiveDefinitions();
		
		if (recursiveDefinitions.size()>0){
			noProblems = false;
			result.outputs().appendln("Recursively defined roles: ");
			for (RoleDefinition definition : recursiveDefinitions.toSortedList()){
				result.outputs().appendln(definition);
			}
			result.outputs().appendln();
		}
		
		List<String> nullFactors = statistics.nullFactors();
		
		if (nullFactors.size()>0){
			noProblems = false;
			result.outputs().appendln("Null factors: ");
			for (String nullfactor : nullFactors){
				result.outputs().appendln(nullfactor);
			}
			result.outputs().appendln();
		}
		
		if (noProblems){
			result.outputs().appendln("No problems found");
		}
		
		//
		return result;
		
	}
	

	
	public Report reportStatistics (int maxIterations){
		Report result;
				
		result = new Report("Statistics");
		
		result.outputs().appendln("Relation Model "+model.getName());
		result.outputs().appendln();
		result.outputs().appendln("Nr of Terms: "+statistics.termCount());
		result.outputs().appendln("Cousin Classification: "+statistics.cousinClassification());
		
		result.outputs().appendln();
		result.outputs().appendln();
		for (Role role : statistics.sortedRoles()){
			result.outputs().appendln(role.getName()+"\t"+statistics.generations(role)+"\t"+statistics.genders(role)+"\t"+statistics.links(role,maxIterations));
		}
		
		//
		return result;
	}
	
	
	public Report reportCompositions (int maxIterations){
		Report result;
				
		result = new Report("Compositions");
		
		result.outputs().appendln("Compositions: Relation Model "+model.getName());
		result.outputs().appendln();
		
		for (Role alpha : statistics.roles){
			for (Role beta : statistics.roles){
				Roles alphaBeta = statistics.roleDefinitions.getCompositeRoles(alpha,beta,0,maxIterations);
				if (alphaBeta.size()>0){
					String composition = alpha+"  "+beta+" = ";
					for (Role gamma : alphaBeta){
						composition+=gamma+", ";
					}
					result.outputs().appendln(composition);
				} else {
//					result.outputs().appendln(alpha+"  "+beta+" [undefined] ");
				}
			}
		}
		//
		return result;
	}
	
	public Report reportReciprocals (int maxIterations){
		Report result;
				
		result = new Report("Reciprocals");
		
		result.outputs().appendln("Reciprocals: Relation Model "+model.getName());
		result.outputs().appendln();
		
		for (Role alpha : statistics.roles){
			Roles inverseAlpha = statistics.roleDefinitions.getReciprocalRoles(alpha,0,maxIterations);
			if (inverseAlpha.size()>0){
				String reciprocal = alpha+" = ";
				for (Role beta : inverseAlpha){
					if (reciprocal.equals(alpha+" = ")){
						reciprocal+="-"+beta;
					} else {
						reciprocal+=", -"+beta;
					}
				}
				result.outputs().appendln(reciprocal);
			} else {
				result.outputs().appendln(alpha+" [no reciprocal term]");
			}
		}
		//
		return result;
	}
	
	
}
