/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class RandomUtils {
    public static int alea(double proba) {
        if (RandomUtils.event(proba)) {
            return 0;
        }
        return 1;
    }

    public static boolean event(double proba) {
        boolean result = proba == 0.0 ? false : (proba == 1.0 ? true : Math.random() <= proba);
        return result;
    }

    public static boolean event(double proba, Random randGen) {
        boolean result = proba == 0.0 ? false : (proba == 1.0 ? true : randGen.nextDouble() <= proba);
        return result;
    }

    private static List<Integer> distIndex(int max) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < max) {
            int j = 0;
            while (j < i) {
                result.add(i);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static <E> E draw(Map<E, Double> weights, Random randGen) {
        E result = null;
        double totalWeight = 0.0;
        for (E item : weights.keySet()) {
            totalWeight += weights.get(item).doubleValue();
        }
        double pos = randGen.nextDouble() * totalWeight;
        totalWeight = 0.0;
        for (E item : weights.keySet()) {
            if (!((totalWeight += weights.get(item).doubleValue()) > pos)) continue;
            result = item;
            break;
        }
        return result;
    }

    public static int randomRound(double d, Random randGen) {
        double floor = Math.floor(d);
        double fract = d - floor;
        int result = (int)floor;
        if (fract > 0.0 && randGen.nextDouble() <= fract || fract > 1.0) {
            ++result;
        }
        return result;
    }

    public static <E> E draw(Collection<E> allItems, Set<E> weightedItems, Random randGen, double weight) {
        E result = null;
        double totalWeight = 0.0;
        for (E item : allItems) {
            if (weightedItems.contains(item)) {
                totalWeight += weight;
                continue;
            }
            totalWeight += 1.0;
        }
        double pos = randGen.nextDouble() * totalWeight;
        totalWeight = 0.0;
        for (E item : allItems) {
            totalWeight = weightedItems.contains(item) ? (totalWeight += weight) : (totalWeight += 1.0);
            if (!(totalWeight > pos)) continue;
            result = item;
            break;
        }
        return result;
    }

    public static <E> TreeMap<Double, E> getChoiceMap(Map<E, Double> weights) {
        TreeMap<Double, E> result = new TreeMap<Double, E>();
        double maxValue = 0.0;
        for (E item : weights.keySet()) {
            if (!(weights.get(item) > 0.0)) continue;
            result.put(maxValue += weights.get(item).doubleValue(), item);
        }
        return result;
    }

    private static double draw(double max) {
        return Math.random() * max;
    }

    private static int draw(int max) {
        return (int)(Math.random() * (double)max);
    }

    public static <E> E draw(List<E> source) {
        E result = source == null || source.size() == 0 ? null : (E)source.get(RandomUtils.draw(source.size()));
        return result;
    }
}

