/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionCriteriaList;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.ToolBox;

public class SequenceCriteria {
    private String relationModelName;
    private String dateLabel;
    private String startDateLabel;
    private String endDateLabel;
    private String placeLabel;
    private String startPlaceLabel;
    private String endPlaceLabel;
    private String localUnitLabel;
    private String groupAffiliationLabel;
    private String egoRoleName;
    private String defaultReferentRoleName;
    private StringList roleNames;
    private int maxAge;
    private int minAge;
    private int threshold;
    private Integer[] dates;
    private int referenceYear;
    private Geography geography;
    private GeoLevel level;
    private StringList minimalPlaceNames;
    private ExpansionMode expansionMode;
    private FiliationType filiationType;
    private CensusType censusType;
    private String pattern;
    private String chainClassification;
    private List<String> relationModelNames;
    private String individualClassificationType;
    private List<ValueSequenceLabel> valueSequenceLabels;
    private List<ValueSequenceLabel> mainValueSequenceLabels;
    private List<ValueSequenceLabel> trajectoriesRelationClassificationTypes;
    private List<String> sequenceValueLabels;
    private List<String> networkTitles;
    private Map<String, List<String>> partitionLabels;
    private PartitionCriteriaList valueSequenceCriteriaList;
    private PartitionCriteriaList sequenceValueCriteriaList;
    private List<String> nodeStatisticsLabels;
    private String alterFilterRoleName;
    private String alterFilterAttributeLabel;
    private String alterFilterAttributeValue;
    private List<SequenceReportType> sequenceReportTypes = new ArrayList<SequenceReportType>();
    private List<SliceReportType> sliceReportTypes = new ArrayList<SliceReportType>();
    private List<SequenceGeneralStatistics> sequenceGeneralStatistics = new ArrayList<SequenceGeneralStatistics>();
    private List<SliceGeneralStatistics> sliceGeneralStatistics = new ArrayList<SliceGeneralStatistics>();
    private List<EgoNetworksOperation> egoNetworksOperations = new ArrayList<EgoNetworksOperation>();
    private List<TrajectoriesOperation> trajectoriesOperations;
    private List<ParcoursNetworksOperation> parcoursNetworkdsOperations;
    private List<ParcoursIntersectionNetworksOperation> parcoursIntersectionNetworksOperations;
    private List<ParcoursSimilarityNetworksOperation> parcoursSimilarityNetworksOperations;

    public SequenceCriteria() {
        this.trajectoriesRelationClassificationTypes = new ArrayList<ValueSequenceLabel>();
        this.trajectoriesOperations = new ArrayList<TrajectoriesOperation>();
        this.parcoursNetworkdsOperations = new ArrayList<ParcoursNetworksOperation>();
        this.parcoursIntersectionNetworksOperations = new ArrayList<ParcoursIntersectionNetworksOperation>();
        this.parcoursSimilarityNetworksOperations = new ArrayList<ParcoursSimilarityNetworksOperation>();
        this.valueSequenceCriteriaList = new PartitionCriteriaList();
        this.sequenceValueCriteriaList = new PartitionCriteriaList();
        this.setDefaultCriteria();
    }

    public void setCensusParameters() {
        this.sequenceValueLabels = new ArrayList<String>();
        this.sequenceValueLabels.add("NREVENTS");
        if (!this.getSequenceGeneralStatistics().isEmpty()) {
            if (!this.valueSequenceLabels.contains((Object)ValueSequenceLabel.PLACE)) {
                this.valueSequenceLabels.add(ValueSequenceLabel.PLACE);
            }
            if (!this.valueSequenceLabels.contains((Object)ValueSequenceLabel.DISTANCE)) {
                this.valueSequenceLabels.add(ValueSequenceLabel.DISTANCE);
            }
        }
        if (this.getSequenceGeneralStatistics().contains((Object)SequenceGeneralStatistics.EVENTS)) {
            this.sequenceValueLabels.add("NREXTERNALMOVES#PLACE_" + (Object)((Object)this.level));
            this.sequenceValueLabels.add("MAX_DISTANCE");
            this.sequenceValueLabels.add("MEAN_NR_MOVES");
            for (ValueSequenceLabel type : this.valueSequenceLabels) {
                if (type == ValueSequenceLabel.PLACE) {
                    this.sequenceValueLabels.add("SUPPORT#" + this.placeLabel + "_" + (Object)((Object)this.level));
                    this.sequenceValueLabels.add("PROFILE#" + this.placeLabel + "_" + (Object)((Object)this.level));
                    continue;
                }
                this.sequenceValueLabels.add("SUPPORT#" + (Object)((Object)type));
            }
        }
        if (this.getSequenceGeneralStatistics().contains((Object)SequenceGeneralStatistics.AGE)) {
            this.sequenceValueLabels.add("AGEFIRST_DISTANCE");
            this.sequenceValueLabels.add("AGEFIRST_CHILDMIGRATIONTYPE_NOPARENTS");
            this.sequenceValueLabels.add("AGEFIRST_DISTANCEDYNAMIC_TRANSNATIONAL");
        }
        if (this.getSequenceGeneralStatistics().contains((Object)SequenceGeneralStatistics.RELATIONS)) {
            this.sequenceValueLabels.add("SAMESEXALTERS_ALL");
            this.sequenceValueLabels.add("SAMEPLACEALTERS_ALL");
            for (String roleName : this.roleNames) {
                this.sequenceValueLabels.add("NRALTERS_" + roleName);
                this.sequenceValueLabels.add("NRALTERSPEREVENT_" + roleName);
            }
            this.sequenceValueLabels.add("MEAN_COVERAGE");
            this.sequenceValueLabels.add("MAX_COVERAGE");
            for (String roleName : this.roleNames) {
                this.sequenceValueLabels.add("RELATIONS_" + roleName);
            }
            this.sequenceValueLabels.add("MAIN_ALTERS");
            this.sequenceValueLabels.add("MAIN_RELATIONS");
        }
        if (this.getEgoNetworksOperations().contains((Object)EgoNetworksOperation.GENERAL)) {
            this.sequenceValueLabels.add("SIZE");
            this.sequenceValueLabels.add("TIES");
            this.sequenceValueLabels.add("DENSITY");
            this.sequenceValueLabels.add("DENSITY_NOLOOPS");
            this.sequenceValueLabels.add("MEANDEGREE");
            this.sequenceValueLabels.add("MEANDEGREE_NOLOOPS");
            this.sequenceValueLabels.add("MEANDEGREE_NOLOOPS_NORM");
        }
        if (this.getEgoNetworksOperations().contains((Object)EgoNetworksOperation.CENTRALITY)) {
            this.sequenceValueLabels.add("EGO-BETWEENNESS");
            this.sequenceValueLabels.add("MEAN_BETWEENNESS");
            this.sequenceValueLabels.add("MAX_BETWEENNESS");
            this.sequenceValueLabels.add("ECCENTRICITY");
        }
        if (this.getEgoNetworksOperations().contains((Object)EgoNetworksOperation.COHESION)) {
            this.sequenceValueLabels.add("NRCOMPONENTS");
            this.sequenceValueLabels.add("NRISOLATES");
            this.sequenceValueLabels.add("MAXCOMPONENT");
            this.sequenceValueLabels.add("NRCOMPONENTS_NORM");
            this.sequenceValueLabels.add("NRISOLATES_NORM");
            this.sequenceValueLabels.add("MAXCOMPONENT_NORM");
            this.sequenceValueLabels.add("CONCENTRATION");
            this.sequenceValueLabels.add("BROKERAGE");
            this.sequenceValueLabels.add("EFFICIENT_SIZE");
            this.sequenceValueLabels.add("EFFICIENCY");
        }
        if (this.getEgoNetworksOperations().contains((Object)EgoNetworksOperation.RELATIONS)) {
            this.sequenceValueLabels.add("NETWORK_RELATIONS");
            this.sequenceValueLabels.add("CONNECTED_NETWORK_RELATIONS");
            this.sequenceValueLabels.add("CENTRAL_ALTERS");
            this.sequenceValueLabels.add("CENTRAL_RELATIONS");
            this.sequenceValueLabels.add("SDENSITY_PARENT-CHILD");
            this.sequenceValueLabels.add("SDENSITY_SPOUSE");
            this.sequenceValueLabels.add("SDENSITY_SIBLING");
            this.sequenceValueLabels.add("SDENSITY_RELATIVE");
            this.sequenceValueLabels.add("SDENSITY_AFFINE");
        }
        for (ValueSequenceLabel valueSequenceLabel : this.mainValueSequenceLabels) {
            if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.GENERAL)) {
                this.sequenceValueLabels.add("SIZE#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("TIES#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("DENSITY#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("DENSITY_NOLOOPS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MEANDEGREE#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MEANDEGREE_NOLOOPS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MEANDEGREE_NOLOOPS_NORM#" + (Object)((Object)valueSequenceLabel));
            }
            if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.CENTRALITY)) {
                this.sequenceValueLabels.add("MEAN_BETWEENNESS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MAX_BETWEENNESS#" + (Object)((Object)valueSequenceLabel));
            }
            if (!this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.RELATIONS)) continue;
            this.sequenceValueLabels.add("CENTRAL_ALTERS#" + (Object)((Object)valueSequenceLabel));
        }
        for (ValueSequenceLabel valueSequenceLabel : this.mainValueSequenceLabels) {
            if (this.getParcoursIntersectionNetworksOperations().contains((Object)ParcoursIntersectionNetworksOperation.GENERAL)) {
                this.sequenceValueLabels.add("SIZE#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("TIES#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("DENSITY#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("DENSITY_NOLOOPS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MEANDEGREE#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MEANDEGREE_NOLOOPS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MEANDEGREE_NOLOOPS_NORM#" + (Object)((Object)valueSequenceLabel));
            }
            if (this.getParcoursIntersectionNetworksOperations().contains((Object)ParcoursIntersectionNetworksOperation.CENTRALITY)) {
                this.sequenceValueLabels.add("EGO-BETWEENNESS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MEAN_BETWEENNESS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MAX_BETWEENNESS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("ECCENTRICITY#" + (Object)((Object)valueSequenceLabel));
            }
            if (this.getParcoursIntersectionNetworksOperations().contains((Object)ParcoursIntersectionNetworksOperation.COHESION)) {
                this.sequenceValueLabels.add("NRCOMPONENTS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRISOLATES#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MAXCOMPONENT#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRCOMPONENTS_NORM#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRISOLATES_NORM#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("MAXCOMPONENT_NORM#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("CONCENTRATION#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("BROKERAGE#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("EFFICIENT_SIZE#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("EFFICIENCY#" + (Object)((Object)valueSequenceLabel));
            }
            if (!this.getParcoursIntersectionNetworksOperations().contains((Object)ParcoursIntersectionNetworksOperation.GENERAL)) continue;
            this.sequenceValueLabels.add("NETWORK_RELATIONS#" + (Object)((Object)valueSequenceLabel));
            this.sequenceValueLabels.add("CONNECTED_NETWORK#RELATIONS#" + (Object)((Object)valueSequenceLabel));
            this.sequenceValueLabels.add("SIMILARITY#" + (Object)((Object)valueSequenceLabel));
        }
        if (!this.getTrajectoriesOperations().isEmpty()) {
            if (!this.valueSequenceLabels.contains((Object)ValueSequenceLabel.PLACE)) {
                this.valueSequenceLabels.add(ValueSequenceLabel.PLACE);
            }
            if (!this.valueSequenceLabels.contains((Object)ValueSequenceLabel.DISTANCE)) {
                this.valueSequenceLabels.add(ValueSequenceLabel.DISTANCE);
            }
            if (this.getTrajectoriesOperations().contains((Object)TrajectoriesOperation.DRAW)) {
                this.trajectoriesRelationClassificationTypes.add(ValueSequenceLabel.PLACE);
            }
            this.sequenceValueLabels.add("NREVENTS");
            this.sequenceValueLabels.add("NREXTERNALMOVES#PLACE_" + (Object)((Object)this.level));
            for (ValueSequenceLabel valueSequenceLabel : this.trajectoriesRelationClassificationTypes) {
                this.sequenceValueLabels.add("PROFILE#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("SUPPORT#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRSTATIONS#" + (Object)((Object)valueSequenceLabel));
                if (valueSequenceLabel != ValueSequenceLabel.PLACE) continue;
                this.sequenceValueLabels.add("CENTERS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("CENTERSNOSTART#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRCENTERS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRCENTERSNOSTART#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRINTERNALMOVES#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRDIRECTRETURNS#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRCYCLES#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRDIRECTRETURNS_NORM#" + (Object)((Object)valueSequenceLabel));
                this.sequenceValueLabels.add("NRCYCLES_NORM#" + (Object)((Object)valueSequenceLabel));
            }
        }
        for (ValueSequenceLabel mainEventType : this.mainValueSequenceLabels) {
            if (this.valueSequenceLabels.contains((Object)mainEventType)) continue;
            this.valueSequenceLabels.add(mainEventType);
        }
        for (ValueSequenceLabel mainEventType : this.trajectoriesRelationClassificationTypes) {
            if (this.valueSequenceLabels.contains((Object)mainEventType)) continue;
            this.valueSequenceLabels.add(mainEventType);
        }
        this.networkTitles = new ArrayList<String>();
        if (!this.getEgoNetworksOperations().isEmpty()) {
            this.addNetworkTitle("Ego Network");
            this.addNetworkTitle("Nonmediated Ego Network");
            this.partitionLabels.get("Ego Network").add("EGO-RELATION");
            this.partitionLabels.get("Ego Network").add("DEGREE");
            this.partitionLabels.get("Nonmediated Ego Network").add("BETWEENNESS");
            this.partitionLabels.get("Nonmediated Ego Network").add("EGO-RELATION");
            this.partitionLabels.get("Nonmediated Ego Network").add("DEGREE");
            this.partitionLabels.get("Nonmediated Ego Network").add("COMPONENT");
            this.addNetworkTitle("Parcours Intersection Network");
            this.partitionLabels.get("Parcours Intersection Network").add("EGO-RELATION");
            this.partitionLabels.get("Parcours Intersection Network").add("NREVENTS");
            for (ValueSequenceLabel mainEventType : this.mainValueSequenceLabels) {
                this.addNetworkTitle("Parcours Similarity Network#" + (Object)((Object)mainEventType));
                this.partitionLabels.get("Parcours Similarity Network#" + (Object)((Object)mainEventType)).add("EGO-RELATION");
                this.partitionLabels.get("Parcours Similarity Network#" + (Object)((Object)mainEventType)).add("NRTRANSITIONS");
            }
        }
        if (!this.getParcoursIntersectionNetworksOperations().isEmpty()) {
            this.addNetworkTitle("Parcours Intersection Network");
            this.partitionLabels.get("Parcours Intersection Network").add("EGO-RELATION");
            this.partitionLabels.get("Parcours Intersection Network").add("NREVENTS");
        }
        if (!this.getParcoursSimilarityNetworksOperations().isEmpty()) {
            this.addNetworkTitle("Parcours Similarity Network");
            this.partitionLabels.get("Parcours Similarity Network").add("EGO-RELATION");
            this.partitionLabels.get("Parcours Similarity Network").add("NREVENTS");
        }
        if (!this.getParcoursNetworksOperations().isEmpty()) {
            for (ValueSequenceLabel mainEventType : this.mainValueSequenceLabels) {
                this.addNetworkTitle("Parcours Network#" + (Object)((Object)mainEventType));
                this.addNetworkTitle("Parcours Similarity Tree#" + (Object)((Object)mainEventType));
                this.addNetworkTitle("Parcours Network Fused#" + (Object)((Object)mainEventType));
                this.partitionLabels.get("Parcours Network#" + (Object)((Object)mainEventType)).add("DEGREE");
            }
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_PARCOURS)) {
            this.addNetworkTitle("Parcours");
            this.partitionLabels.get("Parcours").add("DATE");
            this.partitionLabels.get("Parcours").add("DISTANCE");
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_EXTENDED_PARCOURS)) {
            this.addNetworkTitle("Extended Parcours");
            this.partitionLabels.get("Extended Parcours").add("ORDER");
            this.partitionLabels.get("Extended Parcours").add("TYPE");
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_MULTIPLE_PARCOURS)) {
            this.addNetworkTitle("Multiple Parcours");
            this.partitionLabels.get("Multiple Parcours").add("DATE");
            this.partitionLabels.get("Multiple Parcours").add("DISTANCE");
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_SIMILARY_TREES)) {
            for (ValueSequenceLabel mainEventType : this.mainValueSequenceLabels) {
                this.addNetworkTitle("Parcours Similarity Tree#" + (Object)((Object)mainEventType));
            }
        }
        if (!this.getTrajectoriesOperations().isEmpty()) {
            this.addNetworkTitle("Event Type Network");
            this.addNetworkTitle("Sequence Type Network");
        }
        if (!this.getParcoursNetworksOperations().isEmpty()) {
            this.nodeStatisticsLabels = new ArrayList<String>();
            this.nodeStatisticsLabels.add("NUMBER");
            this.nodeStatisticsLabels.add("INDEGREE");
            this.nodeStatisticsLabels.add("OUTDEGREE");
            this.nodeStatisticsLabels.add("INSTRENGTH");
            this.nodeStatisticsLabels.add("OUTSTRENGTH");
            this.nodeStatisticsLabels.add("ORIENTATION");
            this.nodeStatisticsLabels.add("BETWEENNESS");
            this.nodeStatisticsLabels.add("MAXINWEIGHT");
            this.nodeStatisticsLabels.add("MAXOUTWEIGHT");
            this.nodeStatisticsLabels.add("MAXPREDECESSOR");
            this.nodeStatisticsLabels.add("MAXSUCCESSOR");
        }
    }

    public void setPartitionCriteria() {
        List<String> withMatrix;
        List<String> labels;
        for (String label : this.getSequenceValueLabels()) {
            this.addSequenceValueCriteria(new PartitionCriteria(label));
        }
        this.addSequenceValueCriteria(new PartitionCriteria("PROFILE#AGE"));
        this.addSequenceValueCriteria(new PartitionCriteria("PROFILE#" + this.dateLabel));
        for (String label : this.getSequenceValueCriteriaList().getLabels()) {
            String[] labels2 = ToolBox.splitLastPart(label, "#");
            if (labels2[1] == null) continue;
            this.addValueSequenceCriteria(new PartitionCriteria(labels2[1]));
        }
        for (PartitionCriteria sequenceValueCriteria : this.getSequenceValueCriteriaList()) {
            String label = sequenceValueCriteria.getLabel();
            if (label.equals("NREVENTS") || label.contains("NRSTATIONS")) {
                sequenceValueCriteria.setType(PartitionCriteria.PartitionType.FREE_GROUPING);
                sequenceValueCriteria.setIntervals(PartitionMaker.getIntervals("1 5 10 15 20 25"));
            } else if (label.contains("AGEFIRST")) {
                sequenceValueCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                sequenceValueCriteria.setStart(0.0);
                sequenceValueCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                sequenceValueCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                sequenceValueCriteria.setStart(-100.0);
                sequenceValueCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                sequenceValueCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                sequenceValueCriteria.setStart(0.0);
                sequenceValueCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                sequenceValueCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                sequenceValueCriteria.setStart(0.0);
                sequenceValueCriteria.setSize(1.0);
            } else if (label.substring(0, 3).equals("AGE")) {
                sequenceValueCriteria.setType(PartitionCriteria.PartitionType.RAW);
                sequenceValueCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                sequenceValueCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
            } else {
                sequenceValueCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            if (label.contains("ALTERS") || label.contains("PROFILE") || label.contains("SUPPORT") || label.contains("RELATIONS")) continue;
            sequenceValueCriteria.setWithDiagram(true);
        }
        if (this.getSliceGeneralStatistics().contains((Object)SliceGeneralStatistics.POPULATION)) {
            labels = Arrays.asList("NRINDIVIDUALS", "GENDER_RATIO", "GENDER", "BIRT_PLACE", "QUARTER", "QUARTER_POPULATION", "PATRIL", "OCCUPATION", "MATRISTATUS", "AGE");
            this.setValueSequenceCriteria(labels, labels, null, null, labels);
            this.getValueSequenceCriteriaByLabel("BIRT_PLACE").setLabelParameter("Bas-Mono");
            this.getValueSequenceCriteriaByLabel("AGE").setSizedGrouping(0.0, 20.0, null);
            this.getValueSequenceCriteriaByLabel("NRINDIVIDUALS").setSizedGrouping(0.0, 10.0, null);
            this.getValueSequenceCriteriaByLabel("GENDER_RATIO").setSizedGrouping(0.0, 0.1, null);
            this.setRoleNames(Arrays.asList("REFERENT"));
        }
        if (this.getSliceGeneralStatistics().contains((Object)SliceGeneralStatistics.POSITIONS)) {
            labels = Arrays.asList("PLACE", "REFERENT_CHAIN", "REFERENT_CHAIN_TYPE", "REFERENT_KIN", "REFERENT_KIN_TYPE", "REFERENT");
            withMatrix = Arrays.asList("REFERENT_CHAIN", "REFERENT_KIN");
            this.setValueSequenceCriteria(labels, withMatrix, withMatrix, withMatrix, null);
            this.setRoleNames(Arrays.asList("REFERENT"));
        }
        if (this.getSliceGeneralStatistics().contains((Object)SliceGeneralStatistics.METRICS)) {
            labels = Arrays.asList("SIZE", "MAXDEPTH", "MEANDEPTH", "MEANINDEGREE", "DIAMETER", "NRCOMPONENTS", "MAXCOMPONENT", "CONCENTRATION");
            this.setValueSequenceCriteria(labels, labels, null, null, null);
            this.setRoleNames(Arrays.asList("REFERENT"));
        }
        if (this.getSliceGeneralStatistics().contains((Object)SliceGeneralStatistics.MORPHOLOGY)) {
            labels = Arrays.asList("TREES_BY_ID", "TREES_BY_GENDER", "TREES_BY_KIN", "REFERENT_CHAIN", "REFERENT_KIN", "ALL_KIN");
            withMatrix = Arrays.asList("REFERENT_CHAIN", "REFERENT_KIN");
            this.setValueSequenceCriteria(labels, labels, withMatrix, withMatrix, null);
            this.setRoleNames(Arrays.asList("REFERENT"));
        }
        if (this.getSliceGeneralStatistics().contains((Object)SliceGeneralStatistics.DYNAMICS)) {
            labels = Arrays.asList("PLACE");
            this.setValueSequenceCriteria(labels, null, null, null, null);
            this.getValueSequenceCriteriaByLabel("PLACE").setLabelParameter("Bas-Mono");
            this.getValueSequenceCriteriaByLabel("PLACE").setWithFlow(true);
            this.setRoleNames(Arrays.asList("REFERENT"));
        }
    }

    private void addNetworkTitle(String networkTitle) {
        this.networkTitles.add(networkTitle);
        this.partitionLabels.put(networkTitle, new ArrayList());
    }

    public String getAlterFilterAttributeLabel() {
        return this.alterFilterAttributeLabel;
    }

    public String getAlterFilterAttributeValue() {
        return this.alterFilterAttributeValue;
    }

    public String getAlterFilterRoleName() {
        return this.alterFilterRoleName;
    }

    public List<String> getSequenceValueLabels() {
        return this.sequenceValueLabels;
    }

    public CensusType getCensusType() {
        return this.censusType;
    }

    public String getChainClassification() {
        return this.chainClassification;
    }

    public String getDateLabel() {
        return this.dateLabel;
    }

    public Integer[] getDates() {
        return this.dates;
    }

    public String getDefaultReferentRoleName() {
        return this.defaultReferentRoleName;
    }

    public List<EgoNetworksOperation> getEgoNetworksOperations() {
        return this.egoNetworksOperations;
    }

    public String getEgoRoleName() {
        return this.egoRoleName;
    }

    public String getEndDateLabel() {
        return this.endDateLabel;
    }

    public String getEndPlaceLabel() {
        return this.endPlaceLabel;
    }

    public List<ValueSequenceLabel> getEventTypes() {
        return this.valueSequenceLabels;
    }

    public ExpansionMode getExpansionMode() {
        return this.expansionMode;
    }

    public FiliationType getFiliationType() {
        return this.filiationType;
    }

    public Geography getGeography() {
        return this.geography;
    }

    public GeoLevel getLevel() {
        return this.level;
    }

    public String getLocalUnitLabel() {
        return this.localUnitLabel;
    }

    public List<ValueSequenceLabel> getMainValueSequenceLabels() {
        return this.mainValueSequenceLabels;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int getMinAge() {
        return this.minAge;
    }

    public StringList getMinimalPlaceNames() {
        return this.minimalPlaceNames;
    }

    public List<String> getNetworkTitles() {
        return this.networkTitles;
    }

    public List<ParcoursNetworksOperation> getParcoursNetworksOperations() {
        return this.parcoursNetworkdsOperations;
    }

    public List<ParcoursIntersectionNetworksOperation> getParcoursIntersectionNetworksOperations() {
        return this.parcoursIntersectionNetworksOperations;
    }

    public List<ParcoursSimilarityNetworksOperation> getParcoursSimilarityNetworksOperations() {
        return this.parcoursSimilarityNetworksOperations;
    }

    public String getPartitionLabel() {
        return this.individualClassificationType;
    }

    public Map<String, List<String>> getPartitionLabels() {
        return this.partitionLabels;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getPlaceLabel() {
        return this.placeLabel;
    }

    public List<ValueSequenceLabel> getValueSequenceLabels() {
        return this.valueSequenceLabels;
    }

    public String getRelationModelName() {
        return this.relationModelName;
    }

    public List<String> getRelationModelNames() {
        return this.relationModelNames;
    }

    public StringList getRoleNames() {
        return this.roleNames;
    }

    public List<SequenceGeneralStatistics> getSequenceGeneralStatistics() {
        return this.sequenceGeneralStatistics;
    }

    public List<SequenceReportType> getSequenceReportTypes() {
        return this.sequenceReportTypes;
    }

    public List<SliceGeneralStatistics> getSliceGeneralStatistics() {
        return this.sliceGeneralStatistics;
    }

    public List<SliceReportType> getSliceReportTypes() {
        return this.sliceReportTypes;
    }

    public String getStartDateLabel() {
        return this.startDateLabel;
    }

    public String getStartPlaceLabel() {
        return this.startPlaceLabel;
    }

    public List<TrajectoriesOperation> getTrajectoriesOperations() {
        return this.trajectoriesOperations;
    }

    public List<ValueSequenceLabel> getTrajectoriesRelationClassificationTypes() {
        return this.trajectoriesRelationClassificationTypes;
    }

    public List<ValueSequenceLabel> getTypes() {
        return this.valueSequenceLabels;
    }

    boolean hasVariableIntervals() {
        boolean result = this.dates.length == 0 && StringUtils.isBlank((CharSequence)this.localUnitLabel);
        return result;
    }

    public void setAlterAttributeLabel(String alterAttributeLabel) {
        this.alterFilterAttributeLabel = alterAttributeLabel;
    }

    public void setAlterAttributeValue(String alterAttributeValue) {
        this.alterFilterAttributeValue = alterAttributeValue;
    }

    public void setAlterFilterRoleName(String alterFilterRoleName) {
        this.alterFilterRoleName = alterFilterRoleName;
    }

    public void setChainClassification(String chainClassification) {
        this.chainClassification = chainClassification;
    }

    public void setDateLabel(String dateLabel) {
        this.dateLabel = dateLabel;
    }

    public void setDates(Integer[] dates) {
        this.dates = dates;
    }

    private void setDefaultCriteria() {
        this.dateLabel = "DATE";
        this.startDateLabel = "START_DATE";
        this.endDateLabel = "END_DATE";
        this.placeLabel = "PLACE";
        this.startPlaceLabel = "START_PLACE";
        this.endPlaceLabel = "END_PLACE";
        this.alterFilterRoleName = "ALL";
        this.roleNames = new StringList();
        this.roleNames.add((Object)"ALL");
        this.defaultReferentRoleName = "HOST";
        this.minAge = 0;
        this.maxAge = 1000;
        this.relationModelNames = new ArrayList<String>();
        this.valueSequenceLabels = new ArrayList<ValueSequenceLabel>();
        this.mainValueSequenceLabels = new ArrayList<ValueSequenceLabel>();
        for (ValueSequenceLabel mainEventType : this.mainValueSequenceLabels) {
            if (this.valueSequenceLabels.contains((Object)mainEventType)) continue;
            this.valueSequenceLabels.add(mainEventType);
        }
        this.geography = Geography.getInstance();
        this.level = GeoLevel.TOWN;
        this.minimalPlaceNames = this.censusType == CensusType.GENERAL ? new StringList(Arrays.asList("Afagnan", "Lom\ufffd", "Bas-Mono", "Togo", "B\ufffdnin", "Ghana", "Nig\ufffdria", "C\ufffdte d'Ivoire", "Afrique")) : new StringList();
        this.pattern = "4 1";
        this.chainClassification = "LINE";
        this.individualClassificationType = "GENDER";
        this.networkTitles = new ArrayList<String>();
        this.partitionLabels = new HashMap<String, List<String>>();
        for (String networkTitle : this.networkTitles) {
            this.partitionLabels.put(networkTitle, new ArrayList());
        }
        this.sequenceValueLabels = new ArrayList<String>();
        this.expansionMode = ExpansionMode.RELATED;
        this.filiationType = FiliationType.COGNATIC;
    }

    public void setDefaultReferentRoleName(String defaultReferentRoleName) {
        this.defaultReferentRoleName = defaultReferentRoleName;
    }

    public void setEgoRoleName(String egoRoleName) {
        this.egoRoleName = egoRoleName;
    }

    public void setEndDateLabel(String endDateLabel) {
        this.endDateLabel = endDateLabel;
    }

    public void setEndPlaceLabel(String endPlaceLabel) {
        this.endPlaceLabel = endPlaceLabel;
    }

    public void setEventTypes(List<ValueSequenceLabel> relationClassificationTypes) {
        this.valueSequenceLabels = relationClassificationTypes;
    }

    public void setExpansionMode(ExpansionMode expansionMode) {
        this.expansionMode = expansionMode;
    }

    public void setFiliationType(FiliationType filiationType) {
        this.filiationType = filiationType;
    }

    public void setGeography(Geography geography) {
        this.geography = geography;
    }

    public void setLabels(List<String> labels) {
        this.sequenceValueLabels = labels;
    }

    public void setLevel(GeoLevel level) {
        this.level = level;
    }

    public void setLocalUnitLabel(String constantAttributeFilterLabel) {
        this.localUnitLabel = constantAttributeFilterLabel;
    }

    public void setMainEventType(List<ValueSequenceLabel> mainEventTypes) {
        this.mainValueSequenceLabels = mainEventTypes;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setMinAge(int minAge) {
        this.minAge = minAge;
    }

    public void setPartitionLabel(String partitionLabel) {
        this.individualClassificationType = partitionLabel;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setPlaceLabel(String placeLabel) {
        this.placeLabel = placeLabel;
    }

    public void setValueSequenceLabels(List<ValueSequenceLabel> relationClassificationTypes) {
        this.valueSequenceLabels = relationClassificationTypes;
    }

    public void setRelationModelName(String relationModelName) {
        this.relationModelName = relationModelName;
    }

    public void setRelationModelNames(List<String> relationModelNames) {
        this.relationModelNames = relationModelNames;
    }

    public void setRoleNames(List<String> alterRoleNames) {
        this.roleNames = new StringList(alterRoleNames);
    }

    public void setStartDateLabel(String startDateLabel) {
        this.startDateLabel = startDateLabel;
    }

    public void setStartPlaceLabel(String startPlaceLabel) {
        this.startPlaceLabel = startPlaceLabel;
    }

    public void setTypes(List<ValueSequenceLabel> types) {
        this.valueSequenceLabels = types;
    }

    public List<String> getNodeStatisticsLabels() {
        return this.nodeStatisticsLabels;
    }

    public String getGroupAffiliationLabel() {
        return this.groupAffiliationLabel;
    }

    public void setGroupAffiliationLabel(String groupAffiliationLabel) {
        this.groupAffiliationLabel = groupAffiliationLabel;
    }

    public int getReferenceYear() {
        return this.referenceYear;
    }

    public void setReferenceYear(int referenceYear) {
        this.referenceYear = referenceYear;
    }

    public PartitionCriteriaList getValueSequenceCriteriaList() {
        return this.valueSequenceCriteriaList;
    }

    public void setValueSequenceCriteriaList(PartitionCriteriaList valueSequenceCriteriaList) {
        this.valueSequenceCriteriaList = valueSequenceCriteriaList;
    }

    boolean addSequenceValueCriteria(PartitionCriteria criteria) {
        boolean result = this.sequenceValueCriteriaList.contains(criteria) ? false : this.sequenceValueCriteriaList.add(criteria);
        return result;
    }

    boolean addValueSequenceCriteria(PartitionCriteria criteria) {
        boolean result = this.valueSequenceCriteriaList.contains(criteria) ? false : this.valueSequenceCriteriaList.add(criteria);
        return result;
    }

    public PartitionCriteriaList getSequenceValueCriteriaList() {
        return this.sequenceValueCriteriaList;
    }

    public void setSequenceValueCriteriaList(PartitionCriteriaList sequenceValueCriteriaList) {
        this.sequenceValueCriteriaList = sequenceValueCriteriaList;
    }

    public void setValueSequenceCriteria(List<String> labels, List<String> withCensus, List<String> withMatrix, List<String> withGraph, List<String> withDiagram) {
        if (this.valueSequenceCriteriaList == null) {
            this.valueSequenceCriteriaList = new PartitionCriteriaList();
        }
        for (String label : labels) {
            PartitionCriteria criteria = new PartitionCriteria(label);
            if (withCensus != null && withCensus.contains(label)) {
                criteria.setWithCensus(true);
            }
            if (withMatrix != null && withMatrix.contains(label)) {
                criteria.setWithMatrix(true);
            }
            if (withGraph != null && withGraph.contains(label)) {
                criteria.setWithGraph(true);
            }
            if (withDiagram != null && withDiagram.contains(label)) {
                criteria.setWithDiagram(true);
            }
            this.valueSequenceCriteriaList.add(criteria);
        }
    }

    public PartitionCriteria getValueSequenceCriteriaByLabel(String label) {
        PartitionCriteria result = null;
        if (this.valueSequenceCriteriaList != null) {
            for (PartitionCriteria partitionCriteria : this.valueSequenceCriteriaList) {
                if (!partitionCriteria.getLabel().equals(label)) continue;
                result = partitionCriteria;
                break;
            }
        }
        return result;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public static enum CensusType {
        GENERAL,
        EGONETWORKS,
        PARCOURSNETWORKS,
        PARCOURSSIMILARITYNETWORKS,
        PARCOURSINTERSECTIONNETWORKS,
        PARCOURS;


        public String toString() {
            String result;
            switch (this) {
                case GENERAL: {
                    result = "General";
                    break;
                }
                case EGONETWORKS: {
                    result = "Ego Networks";
                    break;
                }
                case PARCOURSNETWORKS: {
                    result = "Parcours Networks";
                    break;
                }
                case PARCOURSINTERSECTIONNETWORKS: {
                    result = "Parcours Intersection Networks";
                    break;
                }
                case PARCOURSSIMILARITYNETWORKS: {
                    result = "Parcours Similarity Networks";
                    break;
                }
                case PARCOURS: {
                    result = "Parcours";
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }
    }

    public static enum EgoNetworksOperation {
        GENERAL,
        CENTRALITY,
        COHESION,
        RELATIONS,
        EXPORT_EGO_NETWORKS;

    }

    public static enum ParcoursIntersectionNetworksOperation {
        GENERAL,
        CENTRALITY,
        COHESION,
        RELATIONS,
        EXPORT_PARCOURS_INTERSECTION_NETWORKS,
        EXPORT_SIMILARY_TREES;

    }

    public static enum ParcoursNetworksOperation {
        GENERAL,
        CENTRALITY,
        COHESION,
        RELATIONS,
        EXPORT_PARCOURS,
        EXPORT_EXTENDED_PARCOURS,
        EXPORT_MULTIPLE_PARCOURS,
        EXPORT_PARCOURS_NETWORKS,
        EXPORT_SIMILARY_TREES;

    }

    public static enum ParcoursSimilarityNetworksOperation {
        GENERAL,
        CENTRALITY,
        COHESION,
        RELATIONS,
        EXPORT_PARCOURS_SIMILARITY_NETWORKS,
        EXPORT_SIMILARY_TREES;

    }

    public static enum SequenceGeneralStatistics {
        EVENTS,
        AGE,
        RELATIONS;

    }

    public static enum SequenceReportType {
        ITINERARIES_SURVEY,
        ITINERARIES_DETAILS,
        BIOGRAPHIES,
        EXTENDED_BIOGRAPHIES,
        ACTOR_EVENT_TABLES,
        INTERACTION_TABLES,
        EXPORT_RELATION_GRAPH;

    }

    public static enum SliceGeneralStatistics {
        METRICS,
        MORPHOLOGY,
        POPULATION,
        POSITIONS,
        DYNAMICS,
        CIRCUITS;

    }

    public static enum SliceReportType {
        MEMBERSHIP;

    }

    public static enum TrajectoriesOperation {
        GENERAL,
        LIST_TREES,
        EXPORT_EVENT_TYPE_NETWORK,
        EXPORT_SEQUENCE_TYPE_NETWORK,
        DRAW;

    }

    public static enum ValueSequenceLabel {
        TYPEDID,
        HOST,
        MIG,
        HOSTMIG,
        MIGRATIONTYPE,
        CHILDMIGRATIONTYPE,
        TREES,
        DISTANCE,
        PLACE,
        REGION,
        MOVEMENT,
        TURNOVER,
        COMPONENTS,
        DATE,
        AGE;

    }
}

