/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.kinoath;

import java.util.Comparator;
import org.tip.puck.kinoath.IndividualGroup;
import org.tip.puck.util.MathUtils;

public class IndividualGroupComparator
implements Comparator<IndividualGroup> {
    private Sorting sorting;

    public IndividualGroupComparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(IndividualGroup alpha, IndividualGroup bravo) {
        int result = IndividualGroupComparator.compare(alpha, bravo, this.sorting);
        return result;
    }

    public static int compare(IndividualGroup alpha, IndividualGroup bravo, Sorting sorting) {
        int result;
        if (sorting == null) {
            result = 0;
        } else {
            switch (sorting) {
                case ID: {
                    result = MathUtils.compare(IndividualGroupComparator.getId(alpha), IndividualGroupComparator.getId(bravo));
                    break;
                }
                case REVERSED_SIZE: {
                    result = -1 * MathUtils.compare(IndividualGroupComparator.getSize(alpha), IndividualGroupComparator.getSize(bravo));
                    break;
                }
                default: {
                    result = MathUtils.compare(IndividualGroupComparator.getSize(alpha), IndividualGroupComparator.getSize(bravo));
                }
            }
        }
        return result;
    }

    public static Long getId(IndividualGroup source) {
        Long result = source == null ? null : Long.valueOf(source.getLongId());
        return result;
    }

    public static Integer getSize(IndividualGroup source) {
        Integer result = source == null ? null : Integer.valueOf(source.size());
        return result;
    }

    public static enum Sorting {
        ID,
        SIZE,
        REVERSED_SIZE;

    }
}

