/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.partitions.Partition;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Value;

public class GraphValuator {
    public static <E> Value get(Graph<E> graph, String label) {
        Value result = null;
        if (label.equals("GRAPH")) {
            result = Value.valueOf(graph);
        } else if (label.equals("SIZE")) {
            result = Value.valueOf(graph.nodeCount());
        } else if (label.equals("MAXDEPTH")) {
            result = Value.valueOf(GraphUtils.getMaxDepth(graph));
        } else if (label.equals("MEANDEPTH")) {
            result = Value.valueOf(MathUtils.round(GraphUtils.getMeanDepth(graph), 2));
        } else if (label.equals("MEANINDEGREE")) {
            result = Value.valueOf(MathUtils.round(GraphUtils.meanInDegree(graph), 2));
        } else if (label.equals("DIAMETER")) {
            result = Value.valueOf(GraphUtils.getTreeDiameter(graph));
        } else if (label.contains("COMPONENT") || label.equals("CONCENTRATION")) {
            Partition<Node<E>> components = GraphUtils.components(graph);
            if (label.equals("NRCOMPONENTS")) {
                result = Value.valueOf(components.size());
            } else if (label.equals("MAXCOMPONENT")) {
                result = Value.valueOf(components.maxClusterSize());
            } else if (label.equals("CONCENTRATION")) {
                result = Value.valueOf(components.concentration());
            }
        }
        return result;
    }

    public static List<String> getAttributeLabels() {
        ArrayList<String> result = new ArrayList<String>(20);
        EndogenousLabel[] endogenousLabelArray = EndogenousLabel.values();
        int n = endogenousLabelArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndogenousLabel label = endogenousLabelArray[n2];
            result.add(label.toString());
            ++n2;
        }
        Collections.sort(result);
        return result;
    }

    public static enum EndogenousLabel {
        GRAPH,
        SIZE,
        MAXDEPTH,
        MEANDEPTH,
        MEANINDEGREE,
        DIAMETER,
        CONCENTRATION,
        NRCOMPONENTS,
        MAXCOMPONENT;

    }
}

