/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import org.tip.puck.graphs.Node;

public class Link<E> {
    private LinkType type;
    private Node<E> sourceNode;
    private Node<E> targetNode;
    private double weight;
    private String tag;
    private E referent;

    public Link(Node<E> source, Node<E> target, LinkType type) {
        if (source == null || target == null || type == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        this.type = type;
        this.sourceNode = source;
        this.targetNode = target;
        this.weight = 0.0;
    }

    public Link(Node<E> source, Node<E> target, LinkType type, double weight) {
        if (source == null || target == null || type == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        this.sourceNode = source;
        this.targetNode = target;
        this.weight = weight;
        this.type = type;
    }

    public double addWeight(double value) {
        this.weight += value;
        double result = this.weight;
        return result;
    }

    public Node<E> getOtherNode(Node<E> node) {
        Node<E> result = node == null ? null : (node == this.sourceNode ? this.targetNode : (node == this.targetNode ? this.sourceNode : null));
        return result;
    }

    public Node<E> getSourceNode() {
        return this.sourceNode;
    }

    public String getTag() {
        return this.tag;
    }

    public Node<E> getTargetNode() {
        return this.targetNode;
    }

    public int getSourceId() {
        int result = this.sourceNode != null ? this.sourceNode.getId() : 0;
        return result;
    }

    public int getTargetId() {
        int result = this.targetNode != null ? this.targetNode.getId() : 0;
        return result;
    }

    public LinkType getType() {
        return this.type;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getWeightAsInt() {
        return new Double(this.weight).intValue();
    }

    public void incWeight() {
        this.weight += 1.0;
    }

    public boolean isArc() {
        boolean result = this.type.isArc();
        return result;
    }

    public boolean isEdge() {
        boolean result = this.type.isEdge();
        return result;
    }

    public boolean isLoop() {
        boolean result = this.sourceNode == this.targetNode;
        return result;
    }

    public void setSourceNode(Node<E> sourceNode) {
        if (sourceNode == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        this.sourceNode = sourceNode;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setTargetNode(Node<E> targetNode) {
        if (this.sourceNode == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        this.targetNode = targetNode;
    }

    public void setType(LinkType type) {
        if (type == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        this.type = type;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public E getReferent() {
        return this.referent;
    }

    public void setReferent(E referent) {
        this.referent = referent;
    }

    public String toString() {
        String result = this.sourceNode + " > " + this.targetNode + " " + this.weight;
        if (this.tag != null) {
            result = String.valueOf(result) + " " + this.tag;
        }
        return result;
    }

    public E getSourceReferent() {
        E result = this.sourceNode == null ? null : (E)this.sourceNode.getReferent();
        return result;
    }

    public E getTargetReferent() {
        E result = this.targetNode == null ? null : (E)this.targetNode.getReferent();
        return result;
    }

    public static enum LinkType {
        ARC,
        EDGE;


        public boolean isArc() {
            return this == ARC;
        }

        public boolean isEdge() {
            return this == EDGE;
        }
    }
}

