/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.NodeValuator;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;

public class GraphMaker {
    public static Graph<Node<String>> createGraph(String name, Matrix matrix, Map<Value, Double> vector, String vectorLabel) {
        Graph<Node<String>> result = new Graph<Node<String>>(name);
        int row = 0;
        while (row < matrix.getRowDim()) {
            Node<String> node = new Node<String>(row, matrix.getRowLabel(row));
            Double value = vector.get(new Value(matrix.getRowLabel(row)));
            if (value == null) {
                node.setAttribute(vectorLabel, "0.");
            } else {
                node.setAttribute(vectorLabel, "" + value);
            }
            result.addNode(row, node);
            ++row;
        }
        row = 0;
        while (row < matrix.getRowDim()) {
            int col = 0;
            while (col < matrix.getRowDim()) {
                if (matrix.get(row, col) > 0) {
                    result.addArcWeight(row, col, (double)matrix.get(row, col));
                }
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static <E> Map<String, Map<Value, Integer>> getPartitionNumbersMaps(List<String> labels, Graph<E> model) {
        HashMap<String, Map<Value, Integer>> result = new HashMap<String, Map<Value, Integer>>();
        for (String label : labels) {
            Values values = NodeValuator.get(model, label);
            if (values.isNumeric()) continue;
            Partition<Value> partition = PartitionMaker.create(label, values);
            result.put(label, PartitionMaker.getPartitionNumbersMap(partition));
        }
        return result;
    }
}

