/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.partitions.ClusterComparatorByValue;
import org.tip.puck.util.Value;

public class Cluster<E>
implements Comparable<Cluster<E>> {
    private Value value;
    private List<E> items;

    public Cluster(Value value) {
        this.value = value;
        this.items = new ArrayList();
    }

    public Cluster<E> clone() {
        Cluster<E> result = new Cluster<E>(this.value);
        result.items.addAll(this.getItems());
        return result;
    }

    @Override
    public int compareTo(Cluster<E> other) {
        int result = new ClusterComparatorByValue().compare(this, other);
        return result;
    }

    public int count() {
        int result = this.size();
        return result;
    }

    public E getFirstItem() {
        E result = this.items == null || this.items.size() == 0 ? null : (E)this.items.get(0);
        return result;
    }

    public List<E> getItems() {
        return this.items;
    }

    public String getLabel() {
        String result = this.value == null ? null : this.value.toString();
        return result;
    }

    public Value getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.value == null ? 0 : this.value.hashCode();
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.size() == 0;
        return result;
    }

    public boolean isNotEmpty() {
        boolean result = !this.isEmpty();
        return result;
    }

    public boolean isNull() {
        boolean result = this.value == null || this.getLabel() == null;
        return result;
    }

    public boolean isNullOrZero() {
        boolean result = this.value == null || this.value.isNumber() && this.value.intValue() == 0 || this.getLabel() == null;
        return result;
    }

    public void put(E item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
        }
    }

    public void remove(E item) {
        this.items.remove(item);
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public int size() {
        int result = this.items.size();
        return result;
    }

    public String toString() {
        String result = this.getLabel();
        return result;
    }

    public String getItemsAsString() {
        String result = "";
        for (E item : this.getItems()) {
            if (result.length() > 0) {
                result = String.valueOf(result) + ";";
            }
            if (item == null) continue;
            result = String.valueOf(result) + item.toString();
        }
        return result;
    }
}

